/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamRecordReader;
import com.ibm.jzos.ZFileException;

class BsamFbRecordReader
extends BsamRecordReader {
    private int lrecl;
    private byte[] block;
    private int currentBlockLength;
    private int currentOffset;

    BsamFbRecordReader(Bsam bsam) throws ZFileException {
        super(bsam);
        this.lrecl = bsam.getLrecl();
        this.block = new byte[bsam.getBlksize()];
        this.currentOffset = 0;
        this.currentBlockLength = 0;
    }

    @Override
    public synchronized int read(byte[] buf, int offset, int len) throws ZFileException {
        if (this.currentOffset >= this.currentBlockLength && !this.readNextBlock()) {
            return -1;
        }
        if (len > this.lrecl) {
            len = this.lrecl;
        }
        System.arraycopy(this.block, this.currentOffset, buf, offset, len);
        this.currentOffset += this.lrecl;
        return this.lrecl;
    }

    private boolean readNextBlock() throws ZFileException {
        this.currentBlockLength = this.bsam.readBlock(this.block);
        this.currentOffset = 0;
        if (this.currentBlockLength == -1) {
            return false;
        }
        if (this.currentBlockLength % this.lrecl != 0) {
            throw this.bsam.newZFileException("BSAM blocklength: " + this.currentBlockLength + " is not a multiple of LRECL " + this.lrecl, 139);
        }
        return true;
    }
}

