/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.tools;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.CrtToken;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.DSAHWKeyParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.WrapperKey;
import com.ibm.crypto.hdwrCCA.tools.THIKM;
import com.ibm.crypto.hdwrCCA.tools.hikmNativeInteger;
import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.PKCS12PFX;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.tools.CertAndKeyGen;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.Password;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public final class KeyTool {
    private static boolean debug = false;
    private String command = null;
    private String sigAlgName = null;
    private String keyAlgName = null;
    private boolean verbose = false;
    private int keysize = -1;
    private boolean rfc = false;
    private long validity = 90L;
    private String alias = null;
    private String aliasRange = null;
    private String dname = null;
    private String keyAlias = "mykey";
    private String defaultAlias = "mykey";
    private String dest = null;
    private String filename = null;
    private String srcksfname = null;
    private Vector providers = null;
    private final HashMap providerArgs = new HashMap();
    private String storetype = null;
    private String srcstoretype = null;
    private char[] storePass = null;
    private char[] storePassNew = null;
    private char[] srcstorePass = null;
    private char[] keyPass = null;
    private char[] keyPassNew = null;
    private boolean doAll = false;
    private char[] oldPass = null;
    private char[] newPass = null;
    private char[] destKeyPass = null;
    private char[] srckeyPass = null;
    private String ksfname = null;
    private URL urlFile = null;
    private URL src_urlFile = null;
    boolean isRACFkeystore = false;
    boolean src_isRACFkeystore = false;
    private InputStream ksStream = null;
    private InputStream inStream = null;
    private KeyStore keyStore = null;
    private boolean token = false;
    private boolean nullStream = false;
    private boolean kssave = false;
    private boolean noprompt = false;
    private boolean trustcacerts = false;
    private boolean protectedPath = false;
    private boolean srcprotectedPath = false;
    private boolean validitySpecified = false;
    private CertificateFactory cf = null;
    private KeyStore caks = null;
    private String providerName = null;
    private String srcProviderName = null;
    private boolean pkcs12 = false;
    private Set<char[]> passwords = new HashSet<char[]>();
    private String importSecFile = null;
    private String exportSecFile = null;
    private String keyLabel = null;
    private String existingLabel = null;
    private String hwType = null;
    private String hwTypeSecDefault = "CLEAR";
    private String hwTypeRSADefault = "CLEAR";
    private String hwTypeDSADefault = "PKDS";
    private String hwTypeECDefault = "CLEAR";
    private String hwUsage = null;
    private String hwUsageRSADefault = "KEYMANAGEMENT";
    private String hwUsageDSADefault = "SIGNATURE";
    private boolean hwKey = false;
    private String wrappingMode = null;
    private hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private THIKM thikm = null;
    private byte[] exitData = new byte[0];
    private hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
    private static final Class[] PARAM_STRING = new Class[]{String.class};
    private static final String JKS = "jks";
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE1 = "PKCS11";
    private static final String P11KEYSTORE2 = "PKCS11IMPLKS";
    private static final String P12KEYSTORE = "PKCS12";
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.ibm.crypto.hdwrCCA.tools.HwKeyToolResources");
    private static final Collator collator = Collator.getInstance();
    static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static String delim = "-";

    private KeyTool() {
    }

    public static void main(String[] args) {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.4") < 0) {
            System.err.println("Old Java Version");
            return;
        }
        KeyTool kt = new KeyTool();
        kt.run(args, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args, PrintStream out) {
        try {
            this.parseArgs(args);
            this.doCommands(out);
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("java.lang.Exception")) {
                System.out.println(rb.getString("hwkeytool error: ") + e);
            } else if (debug) {
                System.out.println("hwkeytool error (likely untranslated): ");
                System.out.println(rb.getString("hwkeytool error: ") + e);
            } else {
                System.out.println(rb.getString("hwkeytool error (likely untranslated): ") + e);
            }
            if (debug) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        finally {
            if (this.storePass != null) {
                Arrays.fill(this.storePass, ' ');
                this.storePass = null;
            }
            if (this.storePassNew != null) {
                Arrays.fill(this.storePassNew, ' ');
                this.storePassNew = null;
            }
            if (this.keyPass != null) {
                Arrays.fill(this.keyPass, ' ');
                this.keyPass = null;
            }
            if (this.keyPassNew != null) {
                Arrays.fill(this.keyPassNew, ' ');
                this.keyPassNew = null;
            }
            if (this.oldPass != null) {
                Arrays.fill(this.oldPass, ' ');
                this.oldPass = null;
            }
            if (this.newPass != null) {
                Arrays.fill(this.newPass, ' ');
                this.newPass = null;
            }
            if (this.destKeyPass != null) {
                Arrays.fill(this.destKeyPass, ' ');
                this.destKeyPass = null;
            }
            if (this.srcstorePass != null) {
                Arrays.fill(this.srcstorePass, ' ');
                this.srcstorePass = null;
            }
            if (this.srckeyPass != null) {
                Arrays.fill(this.srckeyPass, ' ');
                this.srckeyPass = null;
            }
        }
    }

    void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage();
        }
        int i = 0;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            String flags = args[i];
            if (collator.compare(flags, "-certreq") == 0) {
                this.command = "certreq";
                continue;
            }
            if (collator.compare(flags, "-delete") == 0) {
                this.command = "delete";
                continue;
            }
            if (collator.compare(flags, "-export") == 0 || collator.compare(flags, "-exportcert") == 0) {
                this.command = "export";
                continue;
            }
            if (collator.compare(flags, "-genkey") == 0 || collator.compare(flags, "-genkeypair") == 0) {
                this.command = "genkey";
                continue;
            }
            if (collator.compare(flags, "-help") == 0) {
                this.usage();
                return;
            }
            if (collator.compare(flags, "-identitydb") == 0) {
                this.command = "identitydb";
                continue;
            }
            if (collator.compare(flags, "-import") == 0 || collator.compare(flags, "-importcert") == 0) {
                this.command = "import";
                continue;
            }
            if (collator.compare(flags, "-keyclone") == 0) {
                this.command = "keyclone";
                continue;
            }
            if (collator.compare(flags, "-changealias") == 0) {
                this.command = "changealias";
                continue;
            }
            if (collator.compare(flags, "-keypasswd") == 0) {
                this.command = "keypasswd";
                continue;
            }
            if (collator.compare(flags, "-list") == 0) {
                this.command = "list";
                continue;
            }
            if (collator.compare(flags, "-printcert") == 0) {
                this.command = "printcert";
                continue;
            }
            if (collator.compare(flags, "-selfcert") == 0) {
                this.command = "selfcert";
                continue;
            }
            if (collator.compare(flags, "-storepasswd") == 0) {
                this.command = "storepasswd";
                continue;
            }
            if (collator.compare(flags, "-importkeystore") == 0) {
                this.command = "importkeystore";
                continue;
            }
            if (collator.compare(flags, "-genseckey") == 0) {
                this.command = "genseckey";
                continue;
            }
            if (collator.compare(flags, "-importseckey") == 0) {
                this.command = "importseckey";
                continue;
            }
            if (collator.compare(flags, "-exportseckey") == 0) {
                this.command = "exportseckey";
                continue;
            }
            if (collator.compare(flags, "-refreshkeystore") == 0) {
                this.command = "refreshkeystore";
                continue;
            }
            if (collator.compare(flags, "-keystore") == 0 || collator.compare(flags, "-destkeystore") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.ksfname = args[i];
                continue;
            }
            if (collator.compare(flags, "-srckeystore") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.srcksfname = args[i];
                continue;
            }
            if (collator.compare(flags, "-storepass") == 0 || collator.compare(flags, "-deststorepass") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.storePass = args[i].toCharArray();
                continue;
            }
            if (collator.compare(flags, "-srcstorepass") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.srcstorePass = args[i].toCharArray();
                this.passwords.add(this.srcstorePass);
                continue;
            }
            if (collator.compare(flags, "-storetype") == 0 || collator.compare(flags, "-deststoretype") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.storetype = args[i];
                continue;
            }
            if (collator.compare(flags, "-srcstoretype") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.srcstoretype = args[i];
                continue;
            }
            if (collator.compare(flags, "-providerName") == 0 || collator.compare(flags, "-destprovidername") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.providerName = args[i];
                continue;
            }
            if (collator.compare(flags, "-srcprovidername") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.srcProviderName = args[i];
                continue;
            }
            if (collator.compare(flags, "-keypass") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.keyPass = args[i].toCharArray();
                continue;
            }
            if (collator.compare(flags, "-destkeypass") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.destKeyPass = args[i].toCharArray();
                continue;
            }
            if (collator.compare(flags, "-srckeypass") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.srckeyPass = args[i].toCharArray();
                this.passwords.add(this.srckeyPass);
                continue;
            }
            if (collator.compare(flags, "-new") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.newPass = args[i].toCharArray();
                continue;
            }
            if (collator.compare(flags, "-alias") == 0 || collator.compare(flags, "-srcalias") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.alias = args[i];
                continue;
            }
            if (collator.compare(flags, "-aliasrange") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.aliasRange = args[i];
                continue;
            }
            if (collator.compare(flags, "-dest") == 0 || collator.compare(flags, "-destalias") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.dest = args[i];
                continue;
            }
            if (collator.compare(flags, "-dname") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.dname = args[i];
                continue;
            }
            if (collator.compare(flags, "-keysize") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.keysize = Integer.parseInt(args[i]);
                continue;
            }
            if (collator.compare(flags, "-keyalg") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.keyAlgName = args[i];
                continue;
            }
            if (collator.compare(flags, "-sigalg") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.sigAlgName = args[i];
                continue;
            }
            if (collator.compare(flags, "-validity") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.validity = Long.parseLong(args[i]);
                this.validitySpecified = true;
                continue;
            }
            if (collator.compare(flags, "-file") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.filename = args[i];
                continue;
            }
            if (collator.compare(flags, "-all") == 0) {
                this.doAll = true;
                continue;
            }
            if (collator.compare(flags, "-importfile") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.importSecFile = args[i];
                continue;
            }
            if (collator.compare(flags, "-exportfile") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.exportSecFile = args[i];
                continue;
            }
            if (collator.compare(flags, "-keyalias") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.keyAlias = args[i];
                continue;
            }
            if (collator.compare(flags, "-hardwaretype") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                this.hwType = args[i];
                continue;
            }
            if (flags.equalsIgnoreCase("-hardwareusage")) {
                if (++i == args.length) {
                    this.usage();
                }
                this.hwUsage = args[i];
                continue;
            }
            if (flags.equalsIgnoreCase("-keylabel")) {
                if (++i == args.length) {
                    this.usage();
                }
                this.keyLabel = args[i];
                continue;
            }
            if (flags.equalsIgnoreCase("-existinglabel")) {
                if (++i == args.length) {
                    this.usage();
                }
                this.existingLabel = args[i];
                continue;
            }
            if (collator.compare(flags, "-provider") == 0 || collator.compare(flags, "-providerClass") == 0) {
                if (++i == args.length) {
                    this.usage();
                }
                if (this.providers == null) {
                    this.providers = new Vector(3);
                }
                this.providers.add(args[i]);
                if (args.length <= i + 1 || collator.compare(flags = args[i + 1], "-providerArg") != 0) continue;
                if (args.length == i + 2) {
                    this.usage();
                }
                this.providerArgs.put(args[i], args[i + 2]);
                i += 2;
                continue;
            }
            if (flags.equalsIgnoreCase("-wrappingMode")) {
                if (++i == args.length) {
                    this.usage();
                }
                this.wrappingMode = args[i];
                continue;
            }
            if (collator.compare(flags, "-v") == 0) {
                this.verbose = true;
                continue;
            }
            if (collator.compare(flags, "-debug") == 0) {
                debug = true;
                continue;
            }
            if (collator.compare(flags, "-rfc") == 0) {
                this.rfc = true;
                continue;
            }
            if (collator.compare(flags, "-noprompt") == 0) {
                this.noprompt = true;
                continue;
            }
            if (collator.compare(flags, "-trustcacerts") == 0) {
                this.trustcacerts = true;
                continue;
            }
            if (collator.compare(flags, "-pkcs12") == 0) {
                this.pkcs12 = true;
                continue;
            }
            if (collator.compare(flags, "-protected") == 0 || collator.compare(flags, "-destprotected") == 0) {
                this.protectedPath = true;
                continue;
            }
            if (collator.compare(flags, "-srcprotected") == 0) {
                this.srcprotectedPath = true;
                continue;
            }
            if (collator.compare(flags, "-hardwarekey") == 0) {
                this.hwKey = true;
                continue;
            }
            System.err.println(rb.getString("Illegal option:  ") + flags);
            this.usage();
        }
        if (i < args.length || this.command == null) {
            this.usage();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    void doCommands(PrintStream out) throws Exception {
        block208: {
            Object[] source;
            block215: {
                String importAlias;
                InputStream inStream;
                block216: {
                    block214: {
                        block213: {
                            block212: {
                                block211: {
                                    block210: {
                                        block209: {
                                            File kfile;
                                            block207: {
                                                if (!this.command.equals("printcert")) {
                                                    boolean defaultStoreType = false;
                                                    if (this.storetype == null) {
                                                        this.storetype = KeyStore.getDefaultType();
                                                        defaultStoreType = true;
                                                    }
                                                    if (!(this.storetype.equalsIgnoreCase(P11KEYSTORE1) || this.storetype.equalsIgnoreCase(P11KEYSTORE2) || this.storetype.equalsIgnoreCase("JCE4758RACFKS") || this.storetype.equalsIgnoreCase("JCECCARACFKS") || this.storetype.equalsIgnoreCase("JCE4758KS") || this.storetype.equalsIgnoreCase("JCECCAKS"))) {
                                                        if (true != defaultStoreType) throw new Exception(rb.getString("-storetype must be PKCS11, JCECCAKS, JCECCARACFKS, JCE4758KS or JCE4758RACFKS."));
                                                        MessageFormat form = new MessageFormat(rb.getString("-storetype has defaulted to {0}.\n -storetype must be PKCS11, JCECCAKS, JCECCARACFKS, JCE4758KS or JCE4758RACFKS."));
                                                        Object[] source2 = new Object[]{this.storetype};
                                                        throw new Exception(form.format(source2));
                                                    }
                                                }
                                                if (this.storetype != null && (this.storetype.equalsIgnoreCase("JCECCARACFKS") || this.storetype.equalsIgnoreCase("JCE4758RACFKS"))) {
                                                    this.isRACFkeystore = true;
                                                    if (this.command.equals("keypasswd")) throw new Exception(rb.getString("RACF keystores do not support the following commands: -changealias, -exportseckey, -genseckey, -importseckey, -keyclone, -keypasswd, -storepasswd"));
                                                    if (this.command.equals("storepasswd")) throw new Exception(rb.getString("RACF keystores do not support the following commands: -changealias, -exportseckey, -genseckey, -importseckey, -keyclone, -keypasswd, -storepasswd"));
                                                    if (this.command.equals("changealias")) throw new Exception(rb.getString("RACF keystores do not support the following commands: -changealias, -exportseckey, -genseckey, -importseckey, -keyclone, -keypasswd, -storepasswd"));
                                                    if (this.command.equals("importseckey")) throw new Exception(rb.getString("RACF keystores do not support the following commands: -changealias, -exportseckey, -genseckey, -importseckey, -keyclone, -keypasswd, -storepasswd"));
                                                    if (this.command.equals("exportseckey")) throw new Exception(rb.getString("RACF keystores do not support the following commands: -changealias, -exportseckey, -genseckey, -importseckey, -keyclone, -keypasswd, -storepasswd"));
                                                    if (this.command.equals("genseckey")) throw new Exception(rb.getString("RACF keystores do not support the following commands: -changealias, -exportseckey, -genseckey, -importseckey, -keyclone, -keypasswd, -storepasswd"));
                                                    if (this.command.equals("keyclone")) throw new Exception(rb.getString("RACF keystores do not support the following commands: -changealias, -exportseckey, -genseckey, -importseckey, -keyclone, -keypasswd, -storepasswd"));
                                                    if (this.command.equals("refreshkeystore")) {
                                                        throw new Exception(rb.getString("RACF keystores do not support the following commands: -changealias, -exportseckey, -genseckey, -importseckey, -keyclone, -keypasswd, -storepasswd"));
                                                    }
                                                    if (this.command.equals("importkeystore")) {
                                                        if (this.storePass != null) throw new Exception(rb.getString("RACF keystores do not support the -deststorepass or -destkeypass option on -importkeystore command."));
                                                        if (this.keyPass != null) {
                                                            throw new Exception(rb.getString("RACF keystores do not support the -deststorepass or -destkeypass option on -importkeystore command."));
                                                        }
                                                    }
                                                    if (this.storePass != null) {
                                                        throw new Exception(rb.getString("RACF keystores do not support the -storepass option."));
                                                    }
                                                    if (this.keyPass != null && !this.pkcs12) {
                                                        throw new Exception(rb.getString("RACF keystores do not save a key password. The -keypass option is only used for importing or exporting certificates in PKCS12 format."));
                                                    }
                                                    if (this.pkcs12) {
                                                        if (this.keyPass == null) {
                                                            this.keyPass = this.getKeyPasswd(this.alias, null, null);
                                                        }
                                                    } else {
                                                        this.keyPass = "password".toCharArray();
                                                    }
                                                }
                                                if (this.srcstoretype != null && (this.srcstoretype.equalsIgnoreCase("JCECCARACFKS") || this.srcstoretype.equalsIgnoreCase("JCE4758RACFKS") || this.srcstoretype.equalsIgnoreCase("JCERACFKS"))) {
                                                    this.src_isRACFkeystore = true;
                                                    if (this.srcstorePass != null) throw new Exception(rb.getString("RACF keystores do not support the -srcstorepass or -srckeypass option on -importkeystore command."));
                                                    if (this.srckeyPass != null) {
                                                        throw new Exception(rb.getString("RACF keystores do not support the -srcstorepass or -srckeypass option on -importkeystore command."));
                                                    }
                                                }
                                                if (this.ksfname != null && NONE.equalsIgnoreCase(this.ksfname)) {
                                                    if (this.isRACFkeystore) {
                                                        throw new Exception(rb.getString("RACF keystores do not support -keystore NONE option."));
                                                    }
                                                    this.nullStream = true;
                                                }
                                                if (this.storetype == null) {
                                                    this.storetype = KeyStore.getDefaultType();
                                                }
                                                if (this.srcstoretype == null) {
                                                    this.srcstoretype = KeyStore.getDefaultType();
                                                }
                                                if (P11KEYSTORE1.equalsIgnoreCase(this.storetype) || P11KEYSTORE2.equalsIgnoreCase(this.storetype)) {
                                                    this.token = true;
                                                    this.storetype = P11KEYSTORE2;
                                                }
                                                if (this.token) {
                                                    if (!this.nullStream) {
                                                        throw new Exception(rb.getString("-keystore must be NONE if -storetype is PKCS11"));
                                                    }
                                                    if (this.command.equals("keypasswd")) throw new UnsupportedOperationException(rb.getString("-storepasswd and -keypasswd commands not supported if -storetype is PKCS11"));
                                                    if (this.command.equals("storepasswd")) {
                                                        throw new UnsupportedOperationException(rb.getString("-storepasswd and -keypasswd commands not supported if -storetype is PKCS11"));
                                                    }
                                                    if (this.command.equals("importkeystore")) {
                                                        throw new UnsupportedOperationException(rb.getString("-importkeystore command not supported if -srcstoretype or -deststoretype is PKCS11"));
                                                    }
                                                    if (this.command.equals("refreshkeystore")) {
                                                        throw new UnsupportedOperationException(rb.getString("-refreshkeystore command not supported if -storetype is PKCS11"));
                                                    }
                                                    if (this.newPass != null) {
                                                        throw new IllegalArgumentException(rb.getString("-new can not be specified if -storetype is PKCS11"));
                                                    }
                                                    if (this.keyPass != null && !this.pkcs12) {
                                                        throw new Exception(rb.getString("PKCS11 keystores do not save a key password. The -keypass option is only used for importing or exporting certificates in PKCS12 format."));
                                                    }
                                                    if (this.pkcs12) {
                                                        if (this.keyPass == null) {
                                                            this.keyPass = this.getKeyPasswd(this.alias, null, null);
                                                        }
                                                    } else {
                                                        this.keyPass = "password".toCharArray();
                                                    }
                                                    if (this.existingLabel != null) throw new IllegalArgumentException(rb.getString("-hardwaretype, -hardwareusage, -hardwarekey, -keylabel and -existinglabel options not supported if -storetype is PKCS11"));
                                                    if (this.hwType != null) throw new IllegalArgumentException(rb.getString("-hardwaretype, -hardwareusage, -hardwarekey, -keylabel and -existinglabel options not supported if -storetype is PKCS11"));
                                                    if (this.hwUsage != null) throw new IllegalArgumentException(rb.getString("-hardwaretype, -hardwareusage, -hardwarekey, -keylabel and -existinglabel options not supported if -storetype is PKCS11"));
                                                    if (this.keyLabel != null) throw new IllegalArgumentException(rb.getString("-hardwaretype, -hardwareusage, -hardwarekey, -keylabel and -existinglabel options not supported if -storetype is PKCS11"));
                                                    if (this.hwKey) {
                                                        throw new IllegalArgumentException(rb.getString("-hardwaretype, -hardwareusage, -hardwarekey, -keylabel and -existinglabel options not supported if -storetype is PKCS11"));
                                                    }
                                                    if (this.storePass != null) {
                                                        throw new Exception(rb.getString("PKCS11 keystores do not support the -storepass option."));
                                                    }
                                                }
                                                if (this.srcstoretype != null && (P11KEYSTORE1.equalsIgnoreCase(this.srcstoretype) || P11KEYSTORE2.equalsIgnoreCase(this.srcstoretype))) {
                                                    if (this.srcksfname == null) throw new Exception(rb.getString("-srckeystore must be NONE if -srcstoretype is PKCS11"));
                                                    if (!NONE.equalsIgnoreCase(this.srcksfname)) throw new Exception(rb.getString("-srckeystore must be NONE if -srcstoretype is PKCS11"));
                                                    if (this.command.equals("importkeystore")) {
                                                        throw new UnsupportedOperationException(rb.getString("-importkeystore command not supported if -srcstoretype or -deststoretype is PKCS11"));
                                                    }
                                                }
                                                if (this.protectedPath) {
                                                    throw new IllegalArgumentException(rb.getString("Neither -protected nor -destprotected are supported by the hwkeytool."));
                                                }
                                                if (this.srcprotectedPath) {
                                                    throw new IllegalArgumentException(rb.getString("-srcprotected is not supported by the hwkeytool."));
                                                }
                                                if (this.validity <= 0L) {
                                                    throw new Exception(rb.getString("Validity must be greater than zero"));
                                                }
                                                if (this.command.equals("keypasswd") && this.alias == null && !this.doAll) {
                                                    this.usage();
                                                }
                                                if (this.command.equals("keypasswd") && this.alias != null && this.doAll) {
                                                    this.usage();
                                                }
                                                if (this.providers != null) {
                                                    Provider[] provs = Security.getProviders();
                                                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                                                    Enumeration e = this.providers.elements();
                                                    while (e.hasMoreElements()) {
                                                        int i;
                                                        String provName;
                                                        String tmpName = provName = (String)e.nextElement();
                                                        int lastDot = provName.lastIndexOf(46);
                                                        if (lastDot > 0) {
                                                            tmpName = provName.substring(lastDot + 1);
                                                        }
                                                        for (i = 0; i < provs.length && !provs[i].getName().equals(tmpName); ++i) {
                                                        }
                                                        if (i == 0 || i != provs.length) continue;
                                                        Class<?> provClass = cl != null ? cl.loadClass(provName) : Class.forName(provName);
                                                        Object obj = provClass.newInstance();
                                                        if (!(obj instanceof Provider)) {
                                                            MessageFormat form = new MessageFormat(rb.getString("provName not a provider"));
                                                            Object[] source3 = new Object[]{provName};
                                                            throw new Exception(form.format(source3));
                                                        }
                                                        Security.addProvider((Provider)obj);
                                                    }
                                                }
                                                if (this.command.equals("list") && this.verbose && this.rfc) {
                                                    System.err.println(rb.getString("Must not specify both -v and -rfc with 'list' command"));
                                                    this.usage();
                                                }
                                                if (this.command.equals("genseckey") && this.keyPass != null && this.keyPass.length < 6) {
                                                    throw new Exception(rb.getString("Key password must be at least 6 characters"));
                                                }
                                                if (this.command.equals("genkey") && this.keyPass != null && this.keyPass.length < 6) {
                                                    throw new Exception(rb.getString("Key password must be at least 6 characters"));
                                                }
                                                if (this.newPass != null && this.newPass.length < 6) {
                                                    throw new Exception(rb.getString("New password must be at least 6 characters"));
                                                }
                                                if (!this.command.equals("printcert")) {
                                                    if (this.isRACFkeystore) {
                                                        if (this.ksfname == null) {
                                                            throw new Exception(rb.getString("Must specify -keystore for RACF keystore."));
                                                        }
                                                        try {
                                                            this.urlFile = new URL(this.ksfname);
                                                            this.ksStream = this.urlFile.openStream();
                                                        }
                                                        catch (IOException e) {
                                                            if (e.getMessage().indexOf("profile for ring not found") <= -1) throw e;
                                                            if (!(this.command.equals("genkey") || this.command.equals("identitydb") || this.command.equals("importkeystore"))) {
                                                                if (!this.command.equals("import")) throw new Exception(rb.getString("Keystore does not exist: ") + this.ksfname);
                                                            }
                                                            break block207;
                                                        }
                                                    }
                                                    if (this.ksfname == null) {
                                                        this.ksfname = System.getProperty("user.home") + File.separator + ".HWkeystore";
                                                    }
                                                    if (!this.nullStream) {
                                                        try {
                                                            try {
                                                                this.urlFile = new URL(this.ksfname);
                                                            }
                                                            catch (MalformedURLException e) {
                                                                kfile = new File(this.ksfname);
                                                                if (kfile.exists() && kfile.length() == 0L) {
                                                                    throw new Exception(rb.getString("Keystore file exists, but is empty: ") + this.ksfname);
                                                                }
                                                                this.urlFile = kfile.toURI().toURL();
                                                            }
                                                            this.ksStream = this.urlFile.openStream();
                                                        }
                                                        catch (FileNotFoundException e) {
                                                            if (this.command.equals("genkey") || this.command.equals("genseckey") || this.command.equals("identitydb") || this.command.equals("importkeystore") || this.command.equals("import")) break block207;
                                                            throw new Exception(rb.getString("Keystore file does not exist: ") + this.ksfname);
                                                        }
                                                    }
                                                }
                                            }
                                            if ((this.command.equals("keyclone") || this.command.equals("changealias")) && this.dest == null) {
                                                this.dest = this.getAlias("destination");
                                                if (null == this.dest) throw new Exception(rb.getString("Must specify destination alias"));
                                                if (this.dest.equals("")) {
                                                    throw new Exception(rb.getString("Must specify destination alias"));
                                                }
                                            }
                                            if (this.command.equals("delete") && this.alias == null) {
                                                this.alias = this.getAlias(null);
                                                if (this.alias.equals("")) {
                                                    throw new Exception(rb.getString("Must specify alias"));
                                                }
                                            }
                                            this.keyStore = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
                                            this.providerName = this.keyStore.getProvider().getName();
                                            if (!this.nullStream) {
                                                this.keyStore.load(this.ksStream, this.storePass);
                                                if (this.ksStream != null) {
                                                    this.ksStream.close();
                                                }
                                            }
                                            if (this.nullStream && this.storePass != null) {
                                                this.keyStore.load(null, this.storePass);
                                            } else if (!this.nullStream && this.storePass != null) {
                                                if (this.ksStream == null && this.storePass.length < 6) {
                                                    throw new Exception(rb.getString("Keystore password must be at least 6 characters"));
                                                }
                                            } else if (this.storePass == null) {
                                                if (!(!this.token && !this.isRACFkeystore && (this.command.equals("certreq") || this.command.equals("delete") || this.command.equals("genkey") || this.command.equals("genseckey") || this.command.equals("import") || this.command.equals("importkeystore") || this.command.equals("keyclone") || this.command.equals("changealias") || this.command.equals("selfcert") || this.command.equals("storepasswd") || this.command.equals("keypasswd") || this.command.equals("identitydb") || this.command.equals("importseckey") || this.command.equals("exportseckey") || this.command.equals("refreshkeystore")))) {
                                                    if (!(this.token || this.command.equals("printcert") || this.isRACFkeystore)) {
                                                        System.err.print(rb.getString("Enter keystore password:  "));
                                                        System.err.flush();
                                                        this.storePass = Password.readPassword((InputStream)System.in);
                                                        this.passwords.add(this.storePass);
                                                    }
                                                } else {
                                                    int count = 0;
                                                    do {
                                                        if (this.command.equals("importkeystore")) {
                                                            System.err.print(rb.getString("Enter destination keystore password:  "));
                                                        } else {
                                                            System.err.print(rb.getString("Enter keystore password:  "));
                                                        }
                                                        System.err.flush();
                                                        this.storePass = Password.readPassword((InputStream)System.in);
                                                        this.passwords.add(this.storePass);
                                                        if (this.storePass == null) {
                                                            ++count;
                                                            continue;
                                                        }
                                                        if (!this.nullStream && this.ksStream == null && this.storePass.length < 6) {
                                                            System.err.println(rb.getString("Keystore password is too short - must be at least 6 characters"));
                                                            this.storePass = null;
                                                            ++count;
                                                            continue;
                                                        }
                                                        if (this.storePass != null && !this.nullStream && this.ksStream == null) {
                                                            System.err.print(rb.getString("Re-enter new password: "));
                                                            char[] storePassAgain = Password.readPassword((InputStream)System.in);
                                                            this.passwords.add(storePassAgain);
                                                            if (!Arrays.equals(this.storePass, storePassAgain)) {
                                                                System.err.println(rb.getString("The re-entered password does not match with the first one. Try again"));
                                                                this.storePass = null;
                                                                count = 0;
                                                                continue;
                                                            }
                                                        }
                                                        ++count;
                                                    } while (this.storePass == null && count < 3);
                                                    if (this.storePass == null) {
                                                        System.err.println(rb.getString("Too many failures - try later"));
                                                        return;
                                                    }
                                                }
                                            }
                                            if (this.nullStream) {
                                                this.keyStore.load(null, this.storePass);
                                            } else if (this.ksStream != null) {
                                                try {
                                                    this.urlFile = new URL(this.ksfname);
                                                }
                                                catch (MalformedURLException e) {
                                                    kfile = new File(this.ksfname);
                                                    this.urlFile = kfile.toURI().toURL();
                                                }
                                                if (!this.isRACFkeystore && this.ksStream != null) {
                                                    this.ksStream = this.urlFile.openStream();
                                                    this.keyStore.load(this.ksStream, this.storePass);
                                                    this.ksStream.close();
                                                }
                                            }
                                            if (this.command.equals("printcert") || this.command.equals("import") || this.command.equals("identitydb") || this.command.equals("genkey") && this.existingLabel != null) {
                                                try {
                                                    this.cf = CertificateFactory.getInstance("X509", this.providerName);
                                                }
                                                catch (NoSuchProviderException nsae) {
                                                    this.cf = CertificateFactory.getInstance("X509");
                                                }
                                            }
                                            if (this.trustcacerts) {
                                                this.caks = this.getCacertsKeyStore();
                                            }
                                            if (!this.command.equals("certreq")) break block209;
                                            if (this.filename != null) {
                                                PrintStream ps;
                                                out = ps = new PrintStream(new FileOutputStream(this.filename));
                                            }
                                            this.doCertReq(this.alias, this.sigAlgName, out);
                                            if (this.verbose && this.filename != null) {
                                                MessageFormat form = new MessageFormat(rb.getString("Certification request stored in file <filename>"));
                                                source = new Object[]{this.filename};
                                                System.err.println(form.format(source));
                                                System.err.println(rb.getString("Submit this to your CA"));
                                            }
                                            break block208;
                                        }
                                        if (!this.command.equals("delete")) break block210;
                                        this.doDeleteEntry(this.alias);
                                        this.kssave = true;
                                        break block208;
                                    }
                                    if (!this.command.equals("export")) break block211;
                                    if (this.filename != null) {
                                        PrintStream ps;
                                        out = ps = new PrintStream(new FileOutputStream(this.filename));
                                    }
                                    if (this.pkcs12) {
                                        this.doExportCertToPkcs12(this.alias, out);
                                    } else {
                                        this.doExportCert(this.alias, out);
                                    }
                                    if (this.filename != null) {
                                        MessageFormat form = new MessageFormat(rb.getString("Certificate stored in file <filename>"));
                                        source = new Object[]{this.filename};
                                        System.err.println(form.format(source));
                                    }
                                    break block208;
                                }
                                if (!this.command.equals("genkey")) break block212;
                                if (this.keyAlgName == null) {
                                    this.keyAlgName = "RSA";
                                }
                                if (this.existingLabel == null) {
                                    if (!this.token) {
                                        if (this.keyAlgName.equalsIgnoreCase("RSA")) {
                                            if (this.hwUsage == null) {
                                                this.hwUsage = this.hwUsageRSADefault;
                                            }
                                            if (this.hwType == null) {
                                                this.hwType = this.hwTypeRSADefault;
                                            }
                                        } else if (this.keyAlgName.equalsIgnoreCase("EC")) {
                                            if (this.hwType == null) {
                                                this.hwType = this.hwTypeECDefault;
                                            }
                                        } else {
                                            if (this.hwUsage == null) {
                                                this.hwUsage = this.hwUsageDSADefault;
                                            }
                                            if (this.hwType == null) {
                                                this.hwType = this.hwTypeDSADefault;
                                            }
                                        }
                                    }
                                    this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
                                } else {
                                    if (this.hwUsage != null) {
                                        throw new IllegalArgumentException(rb.getString("-genkeypair does not support -hardwareusage when -existinglabel is specified."));
                                    }
                                    if (this.hwType != null) {
                                        throw new IllegalArgumentException(rb.getString("-genkeypair does not support -hardwaretype when -existinglabel is specified."));
                                    }
                                    if (this.keysize != -1) {
                                        throw new IllegalArgumentException(rb.getString("-genkeypair does not support -keysize when -existinglabel is specified."));
                                    }
                                    this.doGenKeyPairExisting(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
                                }
                                this.kssave = true;
                                break block208;
                            }
                            if (!this.command.equals("genseckey")) break block213;
                            if (this.keyAlgName == null) {
                                this.keyAlgName = "DES";
                            }
                            if (!this.token) {
                                if (this.hwType == null) {
                                    this.hwType = this.hwTypeSecDefault;
                                } else if (this.hwType.equalsIgnoreCase("protected")) {
                                    this.hwType = "PROTECTED";
                                } else if (this.hwType.equalsIgnoreCase("secure_internal_token")) {
                                    this.hwType = "SECURE_INTERNAL_TOKEN";
                                } else if (this.hwType.equalsIgnoreCase("clear")) {
                                    this.hwType = "CLEAR";
                                } else {
                                    if (!this.hwType.equalsIgnoreCase("ckds")) {
                                        MessageFormat form = new MessageFormat(rb.getString("-hardwareType <hwType> not supported for -genseckey. Specify CLEAR, SECURE_INTERNAL_TOKEN, or CKDS."));
                                        source = new Object[]{this.hwType};
                                        throw new IllegalArgumentException(form.format(source));
                                    }
                                    this.hwType = "CKDS";
                                }
                            }
                            if (!(this.token || this.hwType.equalsIgnoreCase("CLEAR") || this.keyAlgName.toUpperCase().startsWith("HMAC") || this.keyAlgName.equalsIgnoreCase("AES") || this.keyAlgName.equalsIgnoreCase("DES") || this.keyAlgName.equalsIgnoreCase("TripleDES") || this.keyAlgName.equalsIgnoreCase("3DES") || this.keyAlgName.equalsIgnoreCase("DESede"))) {
                                MessageFormat form = new MessageFormat(rb.getString("-hardwareType <hwType> not supported for -keyAlg <keyAlgName>."));
                                source = new Object[]{this.hwType, this.keyAlgName};
                                throw new IllegalArgumentException(form.format(source));
                            }
                            if (debug) {
                                System.out.println("token: " + this.token);
                                System.out.println("keyAlgName: [" + this.keyAlgName + "]");
                                System.out.println("hwType: [" + this.hwType + "]");
                                System.out.println("existingLabel: [" + this.existingLabel + "]");
                            }
                            if (!this.token && this.keyAlgName.toUpperCase().startsWith("HMAC")) {
                                if (this.hwType.equalsIgnoreCase("CKDS") && this.existingLabel == null) {
                                    MessageFormat form = new MessageFormat(rb.getString("-genseckey is not supported for -keyAlg <keyAlgName> and -hardwareType <hwType> unless -existinglabel is specified."));
                                    source = new Object[]{this.keyAlgName, this.hwType};
                                    throw new IllegalArgumentException(form.format(source));
                                }
                                if (this.hwType.equalsIgnoreCase("SECURE_INTERNAL_TOKEN") || this.hwType.equalsIgnoreCase("PROTECTED")) {
                                    MessageFormat form = new MessageFormat(rb.getString("-genseckey is not supported for -keyAlg <keyAlgName> for -hardwareType " + this.hwType + "."));
                                    source = new Object[]{this.keyAlgName};
                                    throw new IllegalArgumentException(form.format(source));
                                }
                                if (!this.storetype.equalsIgnoreCase("JCECCAKS")) {
                                    MessageFormat form = new MessageFormat(rb.getString("-genseckey -keyAlg <keyAlgName> is only supported for -storetype JCECCAKS."));
                                    source = new Object[]{this.keyAlgName};
                                    throw new IllegalArgumentException(form.format(source));
                                }
                            }
                            if (this.alias != null && this.aliasRange != null) {
                                throw new Exception(rb.getString("Either alias or aliasRange must be specified"));
                            }
                            if (this.aliasRange != null && this.keyLabel != null) {
                                throw new IllegalArgumentException(rb.getString("-genseckey does not support -keylabel when -aliasrange is specified."));
                            }
                            if (!this.token && !this.hwType.equalsIgnoreCase("CKDS") && this.existingLabel != null) {
                                MessageFormat form = new MessageFormat(rb.getString("-hardwareType <hwType> not supported for use with -existinglabel."));
                                source = new Object[]{this.hwType};
                                throw new IllegalArgumentException(form.format(source));
                            }
                            if (this.aliasRange != null && this.existingLabel != null) {
                                throw new IllegalArgumentException(rb.getString("-genseckey does not support -existinglabel when -aliasrange is specified."));
                            }
                            if (this.existingLabel != null && this.keyLabel != null) {
                                throw new IllegalArgumentException(rb.getString("-genseckey does not support -keylabel when -existinglabel is specified."));
                            }
                            if (this.existingLabel != null && this.keysize != -1) {
                                throw new IllegalArgumentException(rb.getString("-genseckey does not support -keysize when -existinglabel is specified."));
                            }
                            if (this.wrappingMode != null && !this.wrappingMode.equalsIgnoreCase("DEFAULT") && !this.wrappingMode.equalsIgnoreCase("CBC")) {
                                if (!this.wrappingMode.equalsIgnoreCase("ECB")) throw new IllegalArgumentException(rb.getString("-wrappingMode must specify DEFAULT, CBC, or ECB."));
                            }
                            if (this.wrappingMode != null && this.hwType.equalsIgnoreCase("CLEAR")) {
                                throw new IllegalArgumentException(rb.getString("-wrappingMode is not supported with -hardwareType of CLEAR."));
                            }
                            if (this.wrappingMode != null && this.keyAlgName.equalsIgnoreCase("AES")) {
                                throw new IllegalArgumentException(rb.getString("-wrappingMode is not supported with the -keyalg of AES."));
                            }
                            if (this.aliasRange == null) {
                                this.doGenSecretKey(this.alias, this.keyAlgName, this.keysize);
                                this.kssave = true;
                                break block208;
                            } else if (this.aliasRange != null) {
                                String[] parsed = this.parseAliasRange(this.aliasRange);
                                BigInteger[] range = this.validatePrefixRange(parsed[0], parsed[1], parsed[2]);
                                String[] aliases = this.composeAliases(parsed[0], range[0], range[1]);
                                this.doGenBatchSecretKey(aliases, this.keyAlgName, this.keysize);
                                break block208;
                            } else {
                                this.doGenSecretKey(this.defaultAlias, this.keyAlgName, this.keysize);
                                this.kssave = true;
                            }
                            break block208;
                        }
                        if (!this.command.equals("identitydb")) break block214;
                        InputStream inStream2 = System.in;
                        if (this.filename != null) {
                            inStream2 = new FileInputStream(this.filename);
                        }
                        this.doImportIdentityDatabase(inStream2);
                        break block208;
                    }
                    if (!this.command.equals("import")) break block215;
                    inStream = System.in;
                    if (this.filename != null) {
                        inStream = new FileInputStream(this.filename);
                    }
                    String string = importAlias = this.alias != null ? this.alias : this.keyAlias;
                    if (!this.pkcs12) break block216;
                    this.kssave = this.importPkcs12(importAlias, inStream);
                    if (this.kssave) {
                        System.err.println(rb.getString("Content of pkcs12 file was imported in keystore"));
                        break block208;
                    } else {
                        System.err.println(rb.getString("Content of pkcs12 file was not imported in keystore"));
                    }
                    break block208;
                }
                if (this.keyStore.isKeyEntry(importAlias)) {
                    this.kssave = this.installReply(importAlias, inStream);
                    if (this.kssave) {
                        System.err.println(rb.getString("Certificate reply was installed in keystore"));
                        break block208;
                    } else {
                        System.err.println(rb.getString("Certificate reply was not installed in keystore"));
                    }
                    break block208;
                } else {
                    this.kssave = this.addTrustedCert(importAlias, inStream);
                    if (this.kssave) {
                        System.err.println(rb.getString("Certificate was added to keystore"));
                        break block208;
                    } else {
                        System.err.println(rb.getString("Certificate was not added to keystore"));
                    }
                }
                break block208;
            }
            if (this.command.equals("importkeystore")) {
                this.doImportKeyStore();
                this.kssave = true;
            } else if (this.command.equals("keyclone")) {
                this.keyPassNew = this.newPass;
                this.doCloneKey(this.alias, this.dest, true);
                this.kssave = true;
                if (this.verbose) {
                    MessageFormat form = new MessageFormat(rb.getString("Entry with alias <origAlias> cloned in entry with alias <newAlias>."));
                    source = new Object[]{this.alias, this.dest};
                    System.err.println(form.format(source));
                }
            } else if (this.command.equals("changealias")) {
                if (this.alias == null) {
                    this.alias = this.keyAlias;
                }
                this.doCloneKey(this.alias, this.dest, false);
                if (this.keyStore.containsAlias(this.alias)) {
                    this.doDeleteEntry(this.alias);
                }
                this.kssave = true;
                if (this.verbose) {
                    MessageFormat form = new MessageFormat(rb.getString("Alias changed from <origAlias> to <newAlias>."));
                    source = new Object[]{this.alias, this.dest};
                    System.err.println(form.format(source));
                }
            } else if (this.command.equals("keypasswd")) {
                this.keyPassNew = this.newPass;
                if (this.alias != null && !this.doAll) {
                    this.doChangeKeyPasswd(this.alias);
                } else if (this.doAll) {
                    this.doChangeAllKeysPasswd();
                }
                this.kssave = true;
            } else if (this.command.equals("list")) {
                if (this.alias != null) {
                    this.doPrintEntry(this.alias, out, true);
                } else {
                    this.doPrintEntries(out);
                }
            } else if (this.command.equals("printcert")) {
                InputStream inStream = System.in;
                if (this.filename != null) {
                    inStream = new FileInputStream(this.filename);
                }
                this.doPrintCert(inStream, out);
            } else if (this.command.equals("selfcert")) {
                this.doSelfCert(this.alias, this.dname, this.sigAlgName);
                this.kssave = true;
            } else if (this.command.equals("storepasswd")) {
                this.storePassNew = this.newPass;
                if (this.storePassNew == null) {
                    this.storePassNew = this.getNewPasswd("keystore password", this.storePass);
                } else if (String.valueOf(this.storePassNew).equals(String.valueOf(this.storePass))) {
                    throw new Exception(rb.getString("Passwords must differ"));
                }
                if (this.doAll) {
                    this.keyPassNew = this.storePassNew;
                    this.keyPass = this.storePass;
                    this.doChangeAllKeysPasswd();
                }
                this.kssave = true;
            } else if (this.command.equals("importseckey")) {
                if (!this.token && this.keyPass == null) {
                    this.keyPass = this.getKeyPasswd("imported secret keys", null, null);
                }
                if (this.keyAlias == null || this.importSecFile == null) {
                    this.usage();
                }
                if (this.importSecFile != null) {
                    File file = new File(this.importSecFile);
                    if (!file.exists()) throw new Exception(rb.getString("The specified importfile either does not exist or is not readable."));
                    if (!file.canRead()) {
                        throw new Exception(rb.getString("The specified importfile either does not exist or is not readable."));
                    }
                }
                this.doImportSecretKey(this.keyAlias, this.importSecFile, this.keyStore);
            } else if (this.command.equals("exportseckey")) {
                PublicKey publicKey = null;
                if (this.alias != null && this.aliasRange != null) {
                    throw new Exception(rb.getString("You must specify either one of alias or aliasRange"));
                }
                if (this.keyAlias == null || this.exportSecFile == null) {
                    this.usage();
                }
                if (this.keyAlias != null) {
                    Object[] source4;
                    MessageFormat form;
                    if (!this.keyStore.containsAlias(this.keyAlias)) {
                        form = new MessageFormat(rb.getString("Export is aborted, -keyAlias <keyAlias> does not exist"));
                        source4 = new Object[]{this.keyAlias};
                        throw new Exception(form.format(source4));
                    }
                    publicKey = this.getPublicKey(this.keyAlias, this.keyStore);
                    if (publicKey == null) {
                        form = new MessageFormat(rb.getString("Export is aborted, public key from <keyAlias> does not exist"));
                        source4 = new Object[]{this.keyAlias};
                        throw new Exception(form.format(source4));
                    }
                }
                if (this.exportSecFile != null) {
                    File file = new File(this.exportSecFile);
                    String ans = null;
                    if (file.exists()) {
                        System.err.print(this.exportSecFile + rb.getString(" exists, Would you like to overwrite it? [y|n]"));
                        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                        try {
                            ans = br.readLine();
                        }
                        catch (IOException ex) {
                            throw new Exception(ex);
                        }
                        if (ans == null) return;
                        if (!ans.equalsIgnoreCase("y")) {
                            return;
                        }
                    }
                }
                String[] aliases = new String[]{""};
                if (this.aliasRange != null) {
                    String[] parsed = this.parseAliasRange(this.aliasRange);
                    BigInteger[] range = this.validatePrefixRange(parsed[0], parsed[1], parsed[2]);
                    aliases = this.composeAliases(parsed[0], range[0], range[1]);
                } else if (this.alias != null) {
                    aliases[0] = this.alias;
                }
                this.doExportSecretKey(aliases, publicKey, this.keyStore);
            } else if (this.command.equals("refreshkeystore")) {
                this.doRefreshKeyStore();
                this.kssave = true;
            }
        }
        if (!this.kssave) return;
        if (this.token) return;
        this.saveKeyStore();
    }

    private void saveKeyStore() throws Exception {
        OutputStream fout;
        if (this.verbose && !this.token) {
            MessageFormat form = new MessageFormat(rb.getString("[Storing ksfname]"));
            Object[] source = new Object[]{this.nullStream ? "keystore" : this.ksfname};
            System.err.println(form.format(source));
        }
        if (this.token) {
            return;
        }
        if (this.isRACFkeystore) {
            fout = this.urlFile.openConnection().getOutputStream();
            this.keyStore.store(fout, this.storePass);
            fout.close();
        } else {
            fout = this.nullStream ? (FileOutputStream)null : new FileOutputStream(this.ksfname);
            this.keyStore.store(fout, this.storePassNew != null ? this.storePassNew : this.storePass);
            if (fout != null) {
                ((FileOutputStream)fout).close();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean importPkcs12(String alias, InputStream inStream) throws Exception {
        PrivateKeyInfo[] keys;
        byte[] data;
        if (alias == null) {
            throw new Exception(rb.getString("Must specify alias"));
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Certificate not imported, alias <alias> already exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (this.keyPass == null) {
            this.keyPass = this.getKeyPasswd(alias, null, null);
        }
        PKCS12PFX pfx = null;
        if (this.rfc) {
            data = this.base64_to_binary(inStream);
        } else {
            data = new byte[inStream.available()];
            inStream.read(data);
        }
        pfx = new PKCS12PFX(data);
        if (!pfx.verifyMac(this.keyPass)) {
            throw new Exception(rb.getString("Invalid key password"));
        }
        Certificate[] p12Certs = pfx.getCertificates(this.keyPass, null, null);
        Certificate[] certs = null;
        if (p12Certs != null) {
            certs = p12Certs.length == 1 ? this.establishCertChain(null, p12Certs[0]) : this.validateCerts(p12Certs);
        }
        if ((keys = pfx.getPrivateKeys(null, null, null)) != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                if (this.token || this.isRACFkeystore) {
                    this.keyStore.setKeyEntry(alias, (Key)keys[i], "password".toCharArray(), certs);
                    continue;
                }
                this.keyStore.setKeyEntry(alias, (Key)keys[i], this.keyPass, certs);
            }
            return true;
        }
        EncryptedPrivateKeyInfo[] sKeys = pfx.getShroudedKeys(null, null, null);
        if (sKeys == null || sKeys.length <= 0) return false;
        for (int i = 0; i < sKeys.length; ++i) {
            PrivateKey privKey;
            KeyFactory keyFactory;
            byte[] priEnc = sKeys[i].decrypt(this.keyPass);
            PrivateKeyInfo pki = new PrivateKeyInfo(priEnc);
            if (pki.getAlgorithm().equalsIgnoreCase("DSA")) {
                keyFactory = KeyFactory.getInstance("DSA", "IBMJCE");
                privKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(priEnc));
            } else if (pki.getAlgorithm().equalsIgnoreCase("RSA")) {
                keyFactory = KeyFactory.getInstance("RSA", "IBMJCE");
                privKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(priEnc));
            } else {
                if (!pki.getAlgorithm().equalsIgnoreCase("EC")) throw new Exception(rb.getString("KeyStore error invalid key type"));
                keyFactory = KeyFactory.getInstance("EC", "IBMJCE");
                privKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(priEnc));
            }
            if (this.keyStore.getType().equalsIgnoreCase("JCECCAKS") || this.keyStore.getType().equalsIgnoreCase("JCECCARACFKS") || this.keyStore.getType().equalsIgnoreCase("JCE4758RACFKS") || this.keyStore.getType().equalsIgnoreCase("JCE4758KS")) {
                void var16_20;
                boolean isDefaultECHWUsage;
                byte storeType;
                if (pki.getAlgorithm().equalsIgnoreCase("RSA")) {
                    if (this.hwUsage == null) {
                        this.hwUsage = this.hwUsageRSADefault;
                    }
                    if (this.hwType == null) {
                        this.hwType = this.hwTypeRSADefault;
                    }
                } else if (pki.getAlgorithm().equalsIgnoreCase("DSA")) {
                    if (this.hwUsage == null) {
                        this.hwUsage = this.hwUsageDSADefault;
                    }
                    if (this.hwType == null) {
                        this.hwType = this.hwTypeDSADefault;
                    }
                } else if (pki.getAlgorithm().equalsIgnoreCase("EC") && this.hwType == null) {
                    this.hwType = this.hwTypeECDefault;
                }
                if (this.hwType.equalsIgnoreCase("RETAINED")) {
                    storeType = 1;
                } else if (this.hwType.equalsIgnoreCase("CLEAR")) {
                    storeType = 2;
                } else {
                    if (!this.hwType.equalsIgnoreCase("PKDS")) throw new Exception(rb.getString("Unrecognized hardware type."));
                    storeType = 0;
                }
                if (debug) {
                    System.err.println("hwkeytool.importPkcs12: --->  Set hwUsage: [" + this.hwUsage + "]");
                }
                byte keyUsage = -1;
                boolean bl = isDefaultECHWUsage = pki.getAlgorithm().equalsIgnoreCase("EC") && this.hwUsage == null;
                if (!isDefaultECHWUsage) {
                    if (debug) {
                        System.err.println("hwkeytool.importPkcs12: --->  hwUsage is NOT NULL. Processing the hwUsage: [" + this.hwUsage + "]");
                    }
                    if (this.hwUsage.equalsIgnoreCase("KEYMANAGEMENT")) {
                        keyUsage = 4;
                    } else {
                        if (!this.hwUsage.equalsIgnoreCase("SIGNATURE")) throw new Exception(rb.getString("Unrecognized key usage."));
                        keyUsage = 3;
                    }
                } else if (debug) {
                    System.err.println("hwkeytool.importPkcs12: --->  hwUsage is NULL and key alg is EC. Not processing the hwUsage.");
                }
                if (debug) {
                    System.err.println("hwkeytool.importPkcs12: --->  Processed keyUsage: [" + keyUsage + "]");
                }
                Object var16_21 = null;
                if (pki.getAlgorithm().equalsIgnoreCase("RSA")) {
                    RSAKeyHWAttributes rSAKeyHWAttributes = new RSAKeyHWAttributes(storeType, keyUsage);
                } else if (pki.getAlgorithm().equalsIgnoreCase("DSA")) {
                    DSAKeyHWAttributes dSAKeyHWAttributes = new DSAKeyHWAttributes(storeType, keyUsage);
                } else {
                    if (!pki.getAlgorithm().equalsIgnoreCase("EC")) throw new KeyStoreException("Key is of unknown instance.");
                    if (this.hwUsage == null) {
                        if (debug) {
                            System.err.println("hwkeytool.importPkcs12: --->  hwUsage is NULL. Letting underlying API determine default.");
                        }
                        ECHWKeyAttributes eCHWKeyAttributes = new ECHWKeyAttributes(storeType);
                    } else {
                        if (debug) {
                            System.err.println("hwkeytool.importPkcs12: --->  hwUsage is NOT NULL. Using this: [" + keyUsage + "]");
                        }
                        ECHWKeyAttributes eCHWKeyAttributes = new ECHWKeyAttributes(storeType, keyUsage);
                    }
                }
                WrapperKey wrappedKey = new WrapperKey(privKey, (KeyHWAttributes)var16_20);
                if (this.isRACFkeystore) {
                    this.keyStore.setKeyEntry(alias, wrappedKey, "password".toCharArray(), certs);
                    continue;
                }
                this.keyStore.setKeyEntry(alias, wrappedKey, this.keyPass, certs);
                continue;
            }
            if (this.token) {
                this.keyStore.setKeyEntry(alias, privKey, "password".toCharArray(), certs);
                continue;
            }
            this.keyStore.setKeyEntry(alias, privKey, this.keyPass, certs);
        }
        return true;
    }

    private byte[] base64_to_binary(InputStream is) throws IOException {
        long len = 0L;
        BufferedInputStream bufin = new BufferedInputStream(is);
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)bufin, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            isr = new InputStreamReader(bufin);
        }
        BufferedReader br = new BufferedReader(isr);
        String temp = this.readLine(br);
        if (temp == null || !temp.startsWith("-----BEGIN")) {
            throw new IOException(rb.getString("Invalid format"));
        }
        len += (long)temp.length();
        StringBuffer strBuf = new StringBuffer();
        while ((temp = this.readLine(br)) != null && !temp.startsWith("-----END")) {
            strBuf.append(temp);
        }
        if (temp == null) {
            throw new IOException(rb.getString("Invalid format"));
        }
        len += (long)temp.length();
        BASE64Decoder decoder = new BASE64Decoder();
        return decoder.decodeBuffer(strBuf.toString());
    }

    private String readLine(BufferedReader br) throws IOException {
        int c;
        int i = 0;
        boolean isMatch = true;
        boolean matched = false;
        int defaultExpectedLineLength = 80;
        char[] endBoundary = new char[]{'-', '-', '-', '-', '-', 'E', 'N', 'D'};
        StringBuffer sb = new StringBuffer(defaultExpectedLineLength);
        do {
            c = br.read();
            if (isMatch && i < endBoundary.length) {
                boolean bl = isMatch = (char)c == endBoundary[i++];
            }
            if (!matched) {
                matched = isMatch && i == endBoundary.length;
            }
            sb.append((char)c);
        } while (c != -1 && c != 10 && c != 13);
        if (!matched && c == -1) {
            return null;
        }
        if (c == 13) {
            br.mark(1);
            int c2 = br.read();
            if (c2 == 10) {
                sb.append((char)c);
            } else {
                br.reset();
            }
        }
        return sb.toString();
    }

    private void doCertReq(String alias, String sigAlgName, PrintStream out) throws Exception {
        Certificate cert;
        if (alias == null) {
            alias = this.keyAlias;
        }
        Object[] objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs[0];
        if (this.keyPass == null && !this.token) {
            this.keyPass = (char[])objs[1];
        }
        if ((cert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Principal tempSubject = ((X509Certificate)cert).getSubjectDN();
        X500Name subject = new X500Name(((Object)tempSubject).toString());
        CertificationRequestInfo certInfo = new CertificationRequestInfo(subject, cert.getPublicKey(), null);
        CertificationRequest request = new CertificationRequest(certInfo, this.providerName);
        if (sigAlgName == null) {
            String keyAlgName = privKey.getAlgorithm();
            if (keyAlgName.equalsIgnoreCase("DSA") || keyAlgName.equalsIgnoreCase("DSS")) {
                sigAlgName = "SHA1WithDSA";
            } else if (keyAlgName.equalsIgnoreCase("RSA")) {
                sigAlgName = "SHA256WithRSA";
            } else if (keyAlgName.equalsIgnoreCase("EC")) {
                sigAlgName = "SHA256WithECDSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        CertificationRequest request2 = request.sign(sigAlgName, privKey);
        request2.print(out);
    }

    private void doDeleteEntry(String alias) throws Exception {
        block48: {
            if (!this.keyStore.containsAlias(alias)) {
                MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
                Object[] source = new Object[]{alias};
                throw new Exception(form.format(source));
            }
            if (!this.token && this.hwKey && this.keyStore.isKeyEntry(alias)) {
                hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
                this.thikm = new THIKM();
                String keyFormat = "";
                String algorithm = "";
                String labelString = "";
                Object[] objs = this.recoverKey(alias, this.storePass, this.keyPass);
                if (objs[0] instanceof SecretKey) {
                    if (objs[0] instanceof DESKey) {
                        algorithm = "DES";
                        keyFormat = ((DESKey)objs[0]).getFormat();
                        byte[] token = ((DESKey)objs[0]).getEncoded();
                        if (keyFormat.equals("CKDSLabel")) {
                            try {
                                ((DESKey)objs[0]).deleteCKDSEntry();
                            }
                            catch (Exception ex) {
                                System.out.println(rb.getString("hwkeytool error (likely untranslated): ") + ex.getMessage());
                                if (debug) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    } else if (objs[0] instanceof DESedeKey) {
                        algorithm = "DESede";
                        keyFormat = ((DESedeKey)objs[0]).getFormat();
                        byte[] token = ((DESedeKey)objs[0]).getEncoded();
                        if (keyFormat.equals("CKDSLabel")) {
                            try {
                                ((DESedeKey)objs[0]).deleteCKDSEntry();
                            }
                            catch (Exception ex) {
                                System.out.println(rb.getString("hwkeytool error (likely untranslated): ") + ex.getMessage());
                                if (debug) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    } else if (objs[0] instanceof AESKey) {
                        algorithm = "AES";
                        keyFormat = ((AESKey)objs[0]).getFormat();
                        byte[] token = ((AESKey)objs[0]).getEncoded();
                        if (keyFormat.equals("CKDSLabel")) {
                            try {
                                ((AESKey)objs[0]).deleteCKDSEntry();
                            }
                            catch (Exception ex) {
                                System.out.println(rb.getString("hwkeytool error (likely untranslated): ") + ex.getMessage());
                                if (debug) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                } else {
                    byte type;
                    byte[] token;
                    PrivateKey privKey;
                    if (objs[0] instanceof RSAPrivateHWKey) {
                        algorithm = "RSA";
                        privKey = (PrivateKey)objs[0];
                        token = ((RSAPrivateHWKey)privKey).getToken();
                        type = ((RSAPrivateHWKey)privKey).getType();
                    } else if (objs[0] instanceof DSAPrivateHWKey) {
                        algorithm = "DSA";
                        privKey = (PrivateKey)objs[0];
                        token = ((DSAPrivateHWKey)((Object)privKey)).getToken();
                        type = ((DSAPrivateHWKey)((Object)privKey)).getType();
                    } else if (objs[0] instanceof ECPrivateHWKey) {
                        algorithm = "EC";
                        privKey = (PrivateKey)objs[0];
                        token = ((ECPrivateHWKey)privKey).getToken();
                        type = ((ECPrivateHWKey)privKey).getType();
                    } else {
                        throw new RuntimeException(rb.getString("KeyStore error invalid key type"));
                    }
                    if (debug) {
                        if (type == 2) {
                            keyFormat = "CLEAR";
                        } else if (type == 0) {
                            keyFormat = "PKDS";
                        } else if (type == 1) {
                            keyFormat = "RETAIN";
                        }
                        labelString = type != 2 ? "\n    label   = " + new String(token) : "";
                        System.out.println("delete KeyPair entry: \n    alias     =  " + alias + "\n    algorithm = " + algorithm + "\n    format    = " + keyFormat + labelString);
                    }
                    if (type != 2) {
                        System.out.println(rb.getString("Label: ") + new String(token, StandardCharsets.ISO_8859_1));
                        if (type == 0) {
                            if (!(objs[0] instanceof RSAPrivateHWKey || objs[0] instanceof ECPrivateHWKey || objs[0] instanceof DSAPrivateHWKey)) {
                                throw new Exception(rb.getString("KeyStore error invalid key type"));
                            }
                            try {
                                if (objs[0] instanceof RSAPrivateHWKey) {
                                    ((RSAPrivateHWKey)privKey).deletePKDSEntry();
                                } else if (objs[0] instanceof ECPrivateHWKey) {
                                    ((ECPrivateHWKey)privKey).deletePKDSEntry();
                                } else if (objs[0] instanceof DSAPrivateHWKey) {
                                    ((DSAPrivateHWKey)((Object)privKey)).deletePKDSEntry();
                                }
                                break block48;
                            }
                            catch (Exception ex) {
                                System.out.println(rb.getString("hwkeytool error (likely untranslated): ") + ex.getMessage());
                                if (debug) {
                                    ex.printStackTrace();
                                }
                                break block48;
                            }
                        }
                        if (type == 1) {
                            Object[] source;
                            MessageFormat form;
                            byte[] ruleArray = new byte[]{};
                            ruleArrayCount.setValue(0);
                            try {
                                this.thikm.CSNDRKDJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, token);
                                form = new MessageFormat(rb.getString("CSNDKRD returnCode returnCode.getValue() reasonCode reasonCode.getValue()"));
                                source = new Object[]{new Integer(this.returnCode.getValue()), new Integer(this.reasonCode.getValue())};
                                System.out.println(form.format(source));
                            }
                            catch (IllegalArgumentException e) {
                                throw new RuntimeException(rb.getString("Hardware error from call CSNDKRD ") + e);
                            }
                            if (this.returnCode.getValue() != 0) {
                                form = new MessageFormat(rb.getString("Hardware error from call CSNDRKD or CSNDKRD returnCode returnCode.getValue() reasonCode reasonCode.getValue() no delete was performed."));
                                source = new Object[]{new Integer(this.returnCode.getValue()), new Integer(this.reasonCode.getValue())};
                                System.out.println(form.format(source));
                                throw new RuntimeException(form.format(source));
                            }
                        }
                    }
                }
            }
        }
        this.keyStore.deleteEntry(alias);
    }

    private void doExportCert(String alias, PrintStream out) throws Exception {
        if (this.storePass == null && !this.isRACFkeystore && !this.token) {
            this.printWarning();
        }
        if (alias == null) {
            alias = this.keyAlias;
        }
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
        if (cert == null) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> has no certificate"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        this.dumpCert(cert, out);
    }

    private char[] promptForKeyPass(String alias, String orig, char[] origPass) throws Exception {
        int count;
        if (P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
            return origPass;
        }
        for (count = 0; count < 3; ++count) {
            MessageFormat form;
            if (alias != null) {
                form = new MessageFormat(rb.getString("Enter key password for <alias>"));
                Object[] source = new Object[]{alias};
                System.err.println(form.format(source));
            } else {
                System.err.println(rb.getString("Enter key password for <keys>"));
            }
            if (orig == null) {
                System.err.print(rb.getString("\t(RETURN if same as keystore password):  "));
            } else {
                form = new MessageFormat(rb.getString("\t(RETURN if same as for <otherAlias>)"));
                Object[] src = new Object[]{orig};
                System.err.print(form.format(src));
            }
            System.err.flush();
            char[] entered = Password.readPassword((InputStream)System.in);
            this.passwords.add(entered);
            if (entered == null) {
                return origPass;
            }
            if (entered.length >= 6) {
                System.err.print(rb.getString("Re-enter new password: "));
                char[] passAgain = Password.readPassword((InputStream)System.in);
                this.passwords.add(passAgain);
                if (!Arrays.equals(entered, passAgain)) {
                    System.err.println(rb.getString("The re-entered password does not match with the first one. Try again"));
                    count = 0;
                    continue;
                }
                return entered;
            }
            System.err.println(rb.getString("Key password is too short - must be at least 6 characters"));
        }
        if (count == 3) {
            if (this.command.equals("keyclone")) {
                throw new Exception(rb.getString("Too many failures. Key entry not cloned"));
            }
            throw new Exception(rb.getString("Too many failures - key not added to keystore"));
        }
        return null;
    }

    private void doGenSecretKey(String alias, String keyAlgName, int keysize) throws Exception {
        CCAAlgorithmParameterSpec ccaAlgParmSpec;
        if (alias == null) {
            alias = this.keyAlias;
        }
        if (!(this.token || this.storetype.equalsIgnoreCase("JCEKS") || this.storetype.equalsIgnoreCase("JCECCAKS") || this.storetype.equalsIgnoreCase("JCE4758KS"))) {
            throw new Exception(rb.getString("KeyStore cannot store non-private keys"));
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Secret key not generated, alias <alias> already exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        int actualKeySize = 0;
        SecretKey secKey = null;
        KeyGenerator keygen = null;
        if (null == this.existingLabel || "".equals(this.existingLabel)) {
            keygen = KeyGenerator.getInstance(keyAlgName, this.providerName);
            if (keysize != -1) {
                actualKeySize = keysize;
            } else if ("DES".equalsIgnoreCase(keyAlgName)) {
                actualKeySize = this.token ? 64 : 56;
            } else if ("DESede".equalsIgnoreCase(keyAlgName)) {
                actualKeySize = this.token ? 192 : 168;
            } else if ("AES".equalsIgnoreCase(keyAlgName)) {
                actualKeySize = 256;
            } else {
                throw new Exception(rb.getString("Please provide -keysize for secret key generation"));
            }
        }
        if (!this.token && ("SECURE_INTERNAL_TOKEN".equals(this.hwType) || "PROTECTED".equals(this.hwType))) {
            ccaAlgParmSpec = new CCAAlgorithmParameterSpec(actualKeySize);
            if (this.wrappingMode != null) {
                if (this.wrappingMode.equalsIgnoreCase("DEFAULT")) {
                    ccaAlgParmSpec.setTokenWrappingMode((byte)10);
                } else if (this.wrappingMode.equalsIgnoreCase("CBC")) {
                    ccaAlgParmSpec.setTokenWrappingMode((byte)12);
                } else if (this.wrappingMode.equalsIgnoreCase("ECB")) {
                    ccaAlgParmSpec.setTokenWrappingMode((byte)11);
                }
            }
            keygen.init(ccaAlgParmSpec, null);
            secKey = keygen.generateKey();
        } else if (!this.token && "CKDS".equals(this.hwType)) {
            if (null != this.existingLabel && !"".equals(this.existingLabel)) {
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(keyAlgName, this.providerName);
                KeyLabelKeySpec spec = new KeyLabelKeySpec(this.existingLabel);
                secKey = keyFactory.generateSecret(spec);
            } else {
                ccaAlgParmSpec = null;
                ccaAlgParmSpec = this.keyLabel != null ? new CCAAlgorithmParameterSpec(actualKeySize, 0, this.keyLabel) : new CCAAlgorithmParameterSpec(actualKeySize, 0);
                if (this.wrappingMode != null) {
                    if (this.wrappingMode.equalsIgnoreCase("DEFAULT")) {
                        ccaAlgParmSpec.setTokenWrappingMode((byte)10);
                    } else if (this.wrappingMode.equalsIgnoreCase("CBC")) {
                        ccaAlgParmSpec.setTokenWrappingMode((byte)12);
                    } else if (this.wrappingMode.equalsIgnoreCase("ECB")) {
                        ccaAlgParmSpec.setTokenWrappingMode((byte)11);
                    }
                }
                keygen.init(ccaAlgParmSpec, null);
                secKey = keygen.generateKey();
            }
        } else {
            if (actualKeySize == 0) {
                keygen.init((SecureRandom)null);
            } else {
                keygen.init(actualKeySize);
            }
            secKey = keygen.generateKey();
        }
        if (!this.token && this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(alias, null, this.storePass);
        }
        this.keyStore.setKeyEntry(alias, secKey, this.keyPass, null);
        if (this.verbose) {
            MessageFormat form = new MessageFormat(rb.getString("Secret key generated and added to KeyStore with alias <alias>."));
            Object[] source = new Object[]{alias};
            System.err.println(form.format(source));
        }
    }

    private void doGenBatchSecretKey(String[] aliases, String keyAlgName, int keysize) throws Exception {
        if (!this.token && this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(this.alias, null, this.storePass);
        }
        System.err.println(rb.getString("hwkeytool is generating a batch of keys. This process will take a while, be patient ..."));
        for (String alias : aliases) {
            this.doGenSecretKey(alias, keyAlgName, keysize);
            this.saveKeyStore();
        }
        int count = aliases.length;
        System.err.println(count + rb.getString(" secret keys have been generated"));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doGenKeyPair(String alias, String dname, String keyAlgName, int keysize, String sigAlgName) throws Exception {
        Object[] source;
        if (alias == null) {
            alias = this.keyAlias;
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Key pair not generated, alias <alias> already exists"));
            Object[] source2 = new Object[]{alias};
            throw new Exception(form.format(source2));
        }
        if (sigAlgName == null) {
            if (keyAlgName.equalsIgnoreCase("DSA")) {
                sigAlgName = "SHA1WithDSA";
            } else if (keyAlgName.equalsIgnoreCase("RSA")) {
                sigAlgName = "SHA256WithRSA";
            } else {
                if (!keyAlgName.equalsIgnoreCase("EC")) throw new Exception(rb.getString("Cannot derive signature algorithm"));
                sigAlgName = "SHA256withECDSA";
                if (debug) {
                    System.err.println("hwkeytool.doGenKeyPair: --->  sigAlg is null, setting it to: [" + sigAlgName + "]");
                }
            }
        } else if (keyAlgName != null) {
            String sigAlgNameLower;
            if (keyAlgName.equalsIgnoreCase("DSA")) {
                sigAlgNameLower = sigAlgName.toLowerCase();
                if (sigAlgNameLower.indexOf("rsa") != -1 || sigAlgNameLower.indexOf("ecdsa") != -1 || sigAlgNameLower.indexOf("ec") != -1) {
                    throw new Exception(rb.getString("Key algorithm and signature algorithm mismatch"));
                }
            } else if (keyAlgName.equalsIgnoreCase("RSA")) {
                sigAlgNameLower = sigAlgName.toLowerCase();
                if (sigAlgNameLower.indexOf("dsa") != -1 || sigAlgNameLower.indexOf("ecdsa") != -1 || sigAlgNameLower.indexOf("ec") != -1) {
                    throw new Exception(rb.getString("Key algorithm and signature algorithm mismatch"));
                }
            } else {
                if (!keyAlgName.equalsIgnoreCase("EC")) throw new Exception(rb.getString("Algorithm not recognized"));
                sigAlgNameLower = sigAlgName.toLowerCase();
                if (sigAlgNameLower.indexOf("ec") == -1) {
                    throw new Exception(rb.getString("Key algorithm and signature algorithm mismatch"));
                }
            }
        }
        if (keysize == -1) {
            if (keyAlgName.equalsIgnoreCase("DSA") || keyAlgName.equalsIgnoreCase("RSA")) {
                keysize = 1024;
            } else {
                if (!keyAlgName.equalsIgnoreCase("EC")) throw new Exception(rb.getString("Algorithm not recognized"));
                keysize = 256;
            }
        }
        CertAndKeyGen keypair = null;
        keypair = sigAlgName != null && (sigAlgName.equalsIgnoreCase("RSAPSS") || sigAlgName.equalsIgnoreCase("RSASSA-PSS") || sigAlgName.equalsIgnoreCase("RSA-PSS") || sigAlgName.equalsIgnoreCase("RSASA-PSS") || sigAlgName.equalsIgnoreCase("PSS")) ? new CertAndKeyGen("RSASSA-PSS", sigAlgName, this.providerName) : new CertAndKeyGen(keyAlgName, sigAlgName, this.providerName);
        X500Name x500Name = dname == null ? this.getX500Name() : new X500Name(dname);
        if (this.verbose) {
            MessageFormat form = new MessageFormat(rb.getString("Generating keysize bit keyAlgName key pair and self-signed certificate (sigAlgName) with a validity of validality days\n\tfor: x500Name"));
            Object[] source3 = new Object[]{new Integer(keysize), keyAlgName, sigAlgName, new Long(this.validity), x500Name};
            System.err.println(form.format(source3));
        }
        if (!this.token) {
            boolean isDefaultECHWUsage;
            byte storeType;
            if (this.hwType.equalsIgnoreCase("RETAINED")) {
                storeType = 1;
            } else if (this.hwType.equalsIgnoreCase("CLEAR")) {
                storeType = 2;
            } else {
                if (!this.hwType.equalsIgnoreCase("PKDS")) throw new Exception(rb.getString("Unrecognized hardware type."));
                storeType = 0;
            }
            byte keyUsage = -1;
            boolean bl = isDefaultECHWUsage = keyAlgName.equalsIgnoreCase("EC") && this.hwUsage == null;
            if (!isDefaultECHWUsage) {
                if (debug) {
                    System.err.println("hwkeytool.doGenKeyPair: --->  hwUsage is NOT NULL. Processing the hwUsage: [" + this.hwUsage + "]");
                }
                if (this.hwUsage.equalsIgnoreCase("KEYMANAGEMENT")) {
                    keyUsage = 4;
                } else {
                    if (!this.hwUsage.equalsIgnoreCase("SIGNATURE")) throw new Exception(rb.getString("Unrecognized key usage."));
                    keyUsage = 3;
                }
            } else if (debug) {
                System.err.println("hwkeytool.doGenKeyPair: --->  hwUsage is NULL and key alg is EC. Not processing the hwUsage.");
            }
            if (debug) {
                System.err.println("hwkeytool.doGenKeyPair: --->  Processed keyUsage: [" + keyUsage + "]");
            }
            try {
                void var11_27;
                if (this.keyLabel != null) {
                    this.keyLabel = this.keyLabel.toUpperCase();
                    if (this.keyLabel.length() > 64) {
                        MessageFormat messageFormat = new MessageFormat(rb.getString("Key pair not generated, keyLabel length <keyLabel.length()> must be 64 characters or less."));
                        Object[] source4 = new Object[]{new Integer(this.keyLabel.length())};
                        throw new Exception(messageFormat.format(source4));
                    }
                    MessageFormat messageFormat = new MessageFormat(rb.getString("Key pair will be generated with a label of <keyLabel>"));
                    source = new Object[]{this.keyLabel};
                    System.out.println(messageFormat.format(source));
                }
                if (debug) {
                    System.err.println("hwkeytool.doGenKeyPair: alias      = " + alias);
                    System.err.println("hwkeytool.doGenKeyPair: dname      = " + dname);
                    System.err.println("hwkeytool.doGenKeyPair: keyAlgName = " + keyAlgName);
                    System.err.println("hwkeytool.doGenKeyPair: keysize    = " + keysize);
                    System.err.println("hwkeytool.doGenKeyPair: sigAlgName = " + sigAlgName);
                    System.err.println("hwkeytool.doGenKeyPair: ");
                    System.err.println("hwkeytool.doGenKeyPair: keylabel   = " + this.keyLabel);
                }
                if (keyAlgName.equalsIgnoreCase("DSA")) {
                    if (this.keyLabel != null) {
                        DSAHWKeyParameterSpec dSAHWKeyParameterSpec = new DSAHWKeyParameterSpec(keysize, this.keyLabel);
                    } else {
                        DSAHWKeyParameterSpec dSAHWKeyParameterSpec = new DSAHWKeyParameterSpec(keysize, storeType);
                    }
                } else if (keyAlgName.equalsIgnoreCase("RSA")) {
                    if (this.keyLabel != null) {
                        if (debug) {
                            System.err.println("hwkeytool.doGenKeyPair: ---> RSAKeyParameterSpec for RSA, keyLabel not null ");
                        }
                        RSAKeyParameterSpec rSAKeyParameterSpec = new RSAKeyParameterSpec(keysize, storeType, keyUsage, this.keyLabel);
                    } else {
                        if (debug) {
                            System.err.println("hwkeytool.doGenKeyPair: --->  RSAKeyParameterSpec for RSA, keyLabel is null ");
                        }
                        RSAKeyParameterSpec rSAKeyParameterSpec = new RSAKeyParameterSpec(keysize, storeType, keyUsage);
                    }
                } else {
                    void var11_26;
                    if (!keyAlgName.equalsIgnoreCase("EC")) throw new Exception(rb.getString("Algorithm not recognized"));
                    if (this.keyLabel != null) {
                        if (debug) {
                            System.err.println("hwkeytool.doGenKeyPair: ---> ECHWKeyParameterSpec for EC, keyLabel not null ");
                        }
                        if (this.hwUsage == null) {
                            ECHWKeyParameterSpec eCHWKeyParameterSpec = new ECHWKeyParameterSpec(keysize, storeType, this.keyLabel);
                        } else {
                            ECHWKeyParameterSpec eCHWKeyParameterSpec = new ECHWKeyParameterSpec(keysize, storeType, keyUsage, this.keyLabel);
                        }
                    } else {
                        if (debug) {
                            System.err.println("hwkeytool.doGenKeyPair: --->  ECHWKeyParameterSpec for EC, keyLabel is null ");
                        }
                        if (this.hwUsage == null) {
                            if (debug) {
                                System.err.println("hwkeytool.doGenKeyPair: --->  hwUsage is NULL. Letting underlying API determine default.");
                            }
                            ECHWKeyParameterSpec eCHWKeyParameterSpec = new ECHWKeyParameterSpec(keysize, storeType);
                        } else {
                            if (debug) {
                                System.err.println("hwkeytool.doGenKeyPair: --->  hwUsage is NOT NULL. Using this: [" + keyUsage + "]");
                            }
                            ECHWKeyParameterSpec eCHWKeyParameterSpec = new ECHWKeyParameterSpec(keysize, storeType, keyUsage);
                        }
                    }
                    if (debug && var11_26 instanceof ECHWKeyParameterSpec) {
                        System.err.println("hwkeytool.doGenKeyPair: --->  Generated key usage: " + ((ECHWKeyParameterSpec)var11_26).getAttributes().getKeyUsage());
                    }
                }
                keypair.generate((AlgorithmParameterSpec)var11_27);
            }
            catch (Exception exception) {
                throw new Exception(rb.getString("Key pair not generated, ") + exception);
            }
        } else {
            keypair.generate(keysize);
        }
        PrivateKey privKey = keypair.getPrivateKey();
        Certificate[] chain = new X509Certificate[]{keypair.getSelfCertificate(x500Name, this.validity * 24L * 60L * 60L)};
        if (!this.token && this.keyPass == null) {
            int count;
            for (count = 0; count < 3 && this.keyPass == null; ++count) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Enter key password for <alias>"));
                source = new Object[]{alias};
                System.err.println(messageFormat.format(source));
                System.err.print(rb.getString("\t(RETURN if same as keystore password):  "));
                System.err.flush();
                this.keyPass = Password.readPassword((InputStream)System.in);
                if (this.keyPass == null) {
                    this.keyPass = this.storePass;
                    continue;
                }
                if (this.keyPass.length >= 6) continue;
                System.err.println(rb.getString("Key password is too short - must be at least 6 characters"));
                this.keyPass = null;
            }
            if (count == 3) {
                throw new Exception(rb.getString("Too many failures - key not added to keystore"));
            }
        }
        this.keyStore.setKeyEntry(alias, privKey, this.keyPass, chain);
        if (!this.verbose) return;
        MessageFormat form = new MessageFormat(rb.getString("Key pair generated and added to KeyStore with alias <alias>."));
        Object[] objectArray = new Object[]{alias};
        System.err.println(form.format(objectArray));
    }

    private void doGenKeyPairExisting(String alias, String dname, String keyAlgName, int keysize, String sigAlgName) throws Exception {
        PrivateKey privKey;
        if (dname != null) {
            throw new IllegalArgumentException(rb.getString("-genkeypair does not support -dname when -existinglabel is specified."));
        }
        if (sigAlgName != null) {
            throw new IllegalArgumentException(rb.getString("-genkeypair does not support -sigalg when -existinglabel is specified."));
        }
        if (this.keyLabel != null) {
            throw new IllegalArgumentException(rb.getString("-genkeypair does not support -keylabel when -existinglabel is specified."));
        }
        if (this.validitySpecified) {
            throw new IllegalArgumentException(rb.getString("-genkeypair does not support -validity when -existinglabel is specified."));
        }
        if (this.filename == null) {
            throw new IllegalArgumentException(rb.getString("-genkeypair requires -file when -existinglabel is specified."));
        }
        if (alias == null) {
            alias = this.keyAlias;
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Key pair not generated, alias <alias> already exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        try {
            this.existingLabel = this.existingLabel.toUpperCase();
            if (this.existingLabel.length() > 64) {
                MessageFormat form = new MessageFormat(rb.getString("Key pair not generated, existinglabel length <existingLabel.length()> must be 64 characters or less."));
                Object[] source = new Object[]{new Integer(this.existingLabel.length())};
                throw new Exception(form.format(source));
            }
            MessageFormat form = new MessageFormat(rb.getString("Key pair will be generated with an existing label of <existingLabel>"));
            Object[] source = new Object[]{this.existingLabel};
            System.out.println(form.format(source));
            if (debug) {
                System.err.println("hwkeytool.doGenKeyPairExisting: alias          = " + alias);
                System.err.println("hwkeytool.doGenKeyPairExisting: keyAlgName     = " + keyAlgName);
                System.err.println("hwkeytool.doGenKeyPairExisting: sigAlgName     = " + sigAlgName);
                System.err.println("hwkeytool.doGenKeyPairExisting: keylabel       = " + this.keyLabel);
                System.err.println("hwkeytool.doGenKeyPairExisting: existingLabel  = " + this.existingLabel);
            }
            KeyLabelKeySpec keySpec = new KeyLabelKeySpec(this.existingLabel);
            if (keyAlgName.equalsIgnoreCase("RSA")) {
                KeyFactory rsaKf = KeyFactory.getInstance("RSA", "IBMJCECCA");
                privKey = rsaKf.generatePrivate(keySpec);
            } else if (keyAlgName.equalsIgnoreCase("EC")) {
                KeyFactory ecKf = KeyFactory.getInstance("EC", "IBMJCECCA");
                privKey = ecKf.generatePrivate(keySpec);
            } else {
                KeyFactory dsaKf = KeyFactory.getInstance("DSA", "IBMJCECCA");
                privKey = dsaKf.generatePrivate(keySpec);
            }
        }
        catch (Exception e) {
            throw new Exception(rb.getString("Key pair not generated, ") + e);
        }
        Certificate[] chain = new X509Certificate[1];
        try {
            this.inStream = new FileInputStream(this.filename);
            chain[0] = (X509Certificate)this.cf.generateCertificate(this.inStream);
        }
        catch (FileNotFoundException cce) {
            throw new Exception(rb.getString("Input certificate file was not found"));
        }
        catch (ClassCastException cce) {
            throw new Exception(rb.getString("Input certificate file does not contain a X.509 certificate"));
        }
        catch (CertificateException ce) {
            throw new Exception(rb.getString("Input certificate file does not contain a X.509 certificate"));
        }
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(alias, null, this.storePass);
        }
        this.keyStore.setKeyEntry(alias, privKey, this.keyPass, chain);
        if (this.verbose) {
            MessageFormat form = new MessageFormat(rb.getString("Key pair generated and added to KeyStore with alias <alias>."));
            Object[] source = new Object[]{alias};
            System.err.println(form.format(source));
        }
    }

    private void doCloneKey(String orig, String dest, boolean changePassword) throws Exception {
        if (orig == null) {
            orig = this.keyAlias;
        }
        if (this.keyStore.containsAlias(dest)) {
            MessageFormat form = new MessageFormat(rb.getString("Destination alias <dest> already exists"));
            Object[] source = new Object[]{dest};
            throw new Exception(form.format(source));
        }
        Object[] objs = this.recoverEntry(this.keyStore, orig, this.storePass, this.keyPass);
        KeyStore.Entry entry = (KeyStore.Entry)objs[0];
        if (!this.token) {
            this.keyPass = (char[])objs[1];
        }
        KeyStore.PasswordProtection pp = null;
        if (this.keyPass != null) {
            if (!changePassword || P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
                this.keyPassNew = this.keyPass;
            } else if (!this.token && this.keyPassNew == null) {
                this.keyPassNew = this.promptForKeyPass(dest, orig, this.keyPass);
            }
            pp = new KeyStore.PasswordProtection(this.keyPassNew);
        }
        this.keyStore.setEntry(dest, entry, pp);
    }

    private void doChangeKeyPasswd(String alias) throws Exception {
        if (alias == null) {
            alias = this.keyAlias;
        }
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) && !this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> has no key"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (this.keyPassNew == null) {
            MessageFormat form = new MessageFormat(rb.getString("key password for <alias>"));
            Object[] source = new Object[]{alias};
            this.keyPassNew = this.getNewPasswd(form.format(source), this.keyPass);
        }
        Object[] objs = this.recoverEntry(this.keyStore, alias, this.storePass, this.keyPass);
        if (this.keyPass == null) {
            this.keyPass = (char[])objs[1];
        }
        if (String.valueOf(this.keyPassNew).equals(String.valueOf(this.keyPass))) {
            throw new Exception(rb.getString("Passwords must differ"));
        }
        KeyStore.Entry entry = (KeyStore.Entry)objs[0];
        KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(this.keyPassNew);
        this.keyStore.setEntry(alias, entry, pp);
    }

    private void doChangeAllKeysPasswd() throws Exception {
        if (this.keyPass == null) {
            this.keyPass = this.storePass;
        }
        if (this.keyPassNew == null) {
            this.keyPassNew = this.getNewPasswd(rb.getString("password for all keys"), this.keyPass);
        } else if (String.valueOf(this.keyPassNew).equals(String.valueOf(this.keyPass))) {
            throw new Exception(rb.getString("Passwords must differ"));
        }
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Object[] source;
            MessageFormat form;
            String al = aliases.nextElement();
            if (!this.keyStore.isKeyEntry(al)) continue;
            try {
                Key k = this.keyStore.getKey(al, this.keyPass);
                this.keyStore.setKeyEntry(al, k, this.keyPassNew, this.keyStore.getCertificateChain(al));
                form = new MessageFormat(rb.getString("Password change successful for alias <alias> "));
                source = new Object[]{al};
                System.out.println(form.format(source));
            }
            catch (Exception e) {
                form = new MessageFormat(rb.getString("Password change failed for alias <alias> "));
                source = new Object[]{al};
                System.out.println(form.format(source));
            }
        }
    }

    private void doImportIdentityDatabase(InputStream in) throws Exception {
        System.err.println(rb.getString("No entries from identity database added"));
    }

    KeyStore loadSourceKeyStore() throws Exception {
        InputStream is = null;
        if (this.src_isRACFkeystore) {
            if (this.srcksfname == null) {
                throw new Exception(rb.getString("Must specify -srckeystore for RACF keystore on -importkeystore command."));
            }
            if (NONE.equals(this.srcksfname)) {
                throw new Exception(rb.getString("RACF keystores do not support -keystore NONE option."));
            }
            try {
                this.src_urlFile = new URL(this.srcksfname);
                is = this.src_urlFile.openStream();
            }
            catch (IOException e) {
                if (e.getMessage().indexOf("profile for ring not found") > -1) {
                    throw new Exception(rb.getString("Keystore does not exist: ") + this.srcksfname);
                }
                throw e;
            }
            this.srcstorePass = "password".toCharArray();
        } else if (this.srcksfname != null) {
            File srcksfile = new File(this.srcksfname);
            if (srcksfile.exists() && srcksfile.length() == 0L) {
                throw new Exception(rb.getString("Source keystore file exists, but is empty: ") + this.srcksfname);
            }
            is = new FileInputStream(srcksfile);
        } else {
            throw new Exception(rb.getString("Please specify -srckeystore"));
        }
        KeyStore store = this.srcProviderName == null ? KeyStore.getInstance(this.srcstoretype) : KeyStore.getInstance(this.srcstoretype, this.srcProviderName);
        if (this.srcstorePass == null) {
            System.err.print(rb.getString("Enter source keystore password:  "));
            System.err.flush();
            this.srcstorePass = Password.readPassword((InputStream)System.in);
            this.passwords.add(this.srcstorePass);
        }
        if (P12KEYSTORE.equalsIgnoreCase(this.srcstoretype) && this.srckeyPass != null && this.srcstorePass != null && !Arrays.equals(this.srcstorePass, this.srckeyPass)) {
            MessageFormat form = new MessageFormat(rb.getString("Warning:  Different store and key passwords not supported for PKCS12 KeyStores. Ignoring user-specified <command> value."));
            Object[] source = new Object[]{"-srckeypass"};
            System.err.println(form.format(source));
            this.srckeyPass = this.srcstorePass;
        }
        store.load(is, this.srcstorePass);
        if (this.srcstorePass == null) {
            System.err.println();
            System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
            System.err.println(rb.getString("* The integrity of the information stored in your keystore  *"));
            System.err.println(rb.getString("* has NOT been verified!  In order to verify its integrity, *"));
            System.err.println(rb.getString("* you must provide your keystore password.                  *"));
            System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
            System.err.println();
        }
        return store;
    }

    private void doImportKeyStore() throws Exception {
        if (this.alias != null) {
            if (this.destKeyPass != null && this.destKeyPass.length < 6) {
                throw new Exception(rb.getString("Key password must be at least 6 characters"));
            }
            this.doImportKeyStoreSingle(this.loadSourceKeyStore(), this.alias);
        } else {
            if (this.dest != null || this.srckeyPass != null || this.destKeyPass != null) {
                throw new Exception(rb.getString("if -alias not specified, -destalias, -srckeypass, and -destkeypass must not be specified"));
            }
            this.doImportKeyStoreAll(this.loadSourceKeyStore());
        }
    }

    private int doImportKeyStoreSingle(KeyStore srckeystore, String alias) throws Exception {
        String newAlias = this.dest == null ? alias : this.dest;
        Object[] source = new Object[]{alias};
        if (this.keyStore.containsAlias(newAlias)) {
            if (this.noprompt) {
                System.err.println(new MessageFormat(rb.getString("Warning: Overwriting existing alias <alias> in destination keystore")).format(source));
            } else {
                String reply = this.getYesNoReply(new MessageFormat(rb.getString("Existing entry alias <alias> exists, overwrite? [no]:  ")).format(source));
                if ("NO".equals(reply) && "".equals(newAlias = this.inputStringFromStdin(rb.getString("Enter new alias name\t(RETURN to cancel import for this entry):  ")))) {
                    System.err.println(new MessageFormat(rb.getString("Entry for alias <alias> not imported.")).format(source));
                    return 0;
                }
            }
        }
        Object[] objs = null;
        KeyStore.Entry entry = null;
        try {
            if (debug) {
                if (this.srcstorePass == null) {
                    System.err.println("hwkeytool.doImportKeyStoreSingle: srcstorePass is NULL");
                } else {
                    System.err.println("hwkeytool.doImportKeyStoreSingle: srcstorePass = " + new String(this.srcstorePass));
                }
                if (this.srckeyPass == null) {
                    System.err.println("hwkeytool.doImportKeyStoreSingle: srckeyPass is NULL");
                } else {
                    System.err.println("hwkeytool.doImportKeyStoreSingle: srckeyPass = " + new String(this.srckeyPass));
                }
            }
            objs = this.recoverEntry(srckeystore, alias, this.srcstorePass, this.srckeyPass);
            entry = (KeyStore.Entry)objs[0];
        }
        catch (UnrecoverableKeyException urk) {
            System.err.println(urk);
            System.err.println(new MessageFormat(rb.getString("Entry for alias <alias> not imported.")).format(source));
            return 2;
        }
        KeyStore.PasswordProtection pp = null;
        if (this.isRACFkeystore) {
            this.destKeyPass = (char[])(srckeystore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) ? "password".toCharArray() : null);
        }
        if (this.destKeyPass != null) {
            pp = new KeyStore.PasswordProtection(this.destKeyPass);
        } else if (objs[1] != null) {
            pp = new KeyStore.PasswordProtection((char[])objs[1]);
        }
        try {
            if (this.isRACFkeystore && srckeystore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                MessageFormat form = new MessageFormat(rb.getString("Entry for alias <alias> not imported.  RACF keystores do not include secret keys."));
                System.err.println(form.format(source));
                return 2;
            }
            this.keyStore.setEntry(newAlias, entry, pp);
            return 1;
        }
        catch (KeyStoreException kse) {
            Object[] source2 = new Object[]{alias, kse.toString()};
            MessageFormat form = new MessageFormat(rb.getString("Problem importing entry for alias <alias>: <exception>.\nEntry for alias <alias> not imported."));
            System.err.println(form.format(source2));
            return 2;
        }
    }

    private void doImportKeyStoreAll(KeyStore srckeystore) throws Exception {
        block4: {
            int ok = 0;
            int count = srckeystore.size();
            this.srckeyPass = this.srcstorePass;
            Enumeration<String> e = srckeystore.aliases();
            while (e.hasMoreElements()) {
                String reply;
                String alias = e.nextElement();
                int result = this.doImportKeyStoreSingle(srckeystore, alias);
                if (result == 1) {
                    ++ok;
                    Object[] source = new Object[]{alias};
                    MessageFormat form = new MessageFormat(rb.getString("Entry for alias <alias> successfully imported."));
                    System.err.println(form.format(source));
                    continue;
                }
                if (result != 2 || this.noprompt || !"YES".equals(reply = this.getYesNoReply("Do you want to quit the import process? [no]:  "))) continue;
                break;
            }
            try {
                Object[] source = new Object[]{ok, count - ok};
                MessageFormat form = new MessageFormat(rb.getString("Import command completed:  <ok> entries successfully imported, <fail> entries failed or cancelled"));
                System.err.println(form.format(source));
            }
            catch (Exception ex) {
                System.out.println(rb.getString("hwkeytool error (likely untranslated): ") + ex.getMessage());
                if (!debug) break block4;
                ex.printStackTrace();
            }
        }
    }

    private void doPrintEntry(String alias, PrintStream out, boolean printWarning) throws Exception {
        Object[] source;
        MessageFormat form;
        if (this.storePass == null && printWarning && !this.isRACFkeystore && !this.token) {
            this.printWarning();
        }
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form2 = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source2 = new Object[]{alias};
            throw new Exception(form2.format(source2));
        }
        if (this.verbose || this.rfc || debug) {
            form = new MessageFormat(rb.getString("Alias name: alias"));
            source = new Object[]{alias};
            out.println(form.format(source));
            if (!this.token) {
                form = new MessageFormat(rb.getString("Creation date: keyStore.getCreationDate(alias)"));
                Object[] src = new Object[]{this.keyStore.getCreationDate(alias)};
                out.println(form.format(src));
            }
        } else if (!this.token) {
            form = new MessageFormat(rb.getString("alias, keyStore.getCreationDate(alias), "));
            source = new Object[]{alias, this.keyStore.getCreationDate(alias)};
            out.print(form.format(source));
        } else {
            form = new MessageFormat(rb.getString("alias, "));
            source = new Object[]{alias};
            out.print(form.format(source));
        }
        if (this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
            if (this.verbose || this.rfc || debug) {
                out.println(rb.getString("Entry type: SecretKeyEntry"));
            } else {
                out.println(rb.getString("SecretKeyEntry,"));
            }
        } else if (this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
            if (this.verbose || this.rfc || debug) {
                out.println(rb.getString("Entry type: keyEntry"));
            } else {
                out.println(rb.getString("keyEntry,"));
            }
            Certificate[] chain = this.keyStore.getCertificateChain(alias);
            if (chain != null) {
                if (this.verbose || this.rfc || debug) {
                    out.println(rb.getString("Certificate chain length: ") + chain.length);
                    for (int i = 0; i < chain.length; ++i) {
                        MessageFormat form3 = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                        Object[] source3 = new Object[]{new Integer(i + 1)};
                        out.println(form3.format(source3));
                        if (this.verbose && chain[i] instanceof X509Certificate) {
                            this.printX509Cert((X509Certificate)chain[i], out);
                            continue;
                        }
                        if (debug) {
                            out.println(chain[i].toString());
                            continue;
                        }
                        this.dumpCertPrintableOnZOS(chain[i], out);
                    }
                } else {
                    out.println(rb.getString("Certificate fingerprint (MD5): ") + this.getCertFingerPrint("MD5", chain[0]));
                }
            }
        } else if (this.keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
            Certificate cert = this.keyStore.getCertificate(alias);
            if (this.verbose && cert instanceof X509Certificate) {
                out.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.printX509Cert((X509Certificate)cert, out);
            } else if (this.rfc) {
                out.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.dumpCertPrintableOnZOS(cert, out);
            } else if (debug) {
                out.println(cert.toString());
            } else {
                out.println(rb.getString("trustedCertEntry,"));
                out.println(rb.getString("Certificate fingerprint (MD5): ") + this.getCertFingerPrint("MD5", cert));
            }
        } else {
            out.println(rb.getString("Unknown Entry Type"));
        }
    }

    private void doPrintEntries(PrintStream out) throws Exception {
        if (this.storePass == null && !this.isRACFkeystore && !this.token) {
            this.printWarning();
        } else {
            out.println();
        }
        out.println(rb.getString("Keystore type: ") + this.keyStore.getType());
        out.println(rb.getString("Keystore provider: ") + this.keyStore.getProvider().getName());
        out.println();
        MessageFormat form = this.keyStore.size() == 1 ? new MessageFormat(rb.getString("Your keystore contains keyStore.size() entry")) : new MessageFormat(rb.getString("Your keystore contains keyStore.size() entries"));
        Object[] source = new Object[]{new Integer(this.keyStore.size())};
        out.println(form.format(source));
        out.println();
        Enumeration<String> e = this.keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            this.doPrintEntry(alias, out, false);
            if (!this.verbose && !this.rfc) continue;
            out.println(rb.getString("\n"));
            out.println(rb.getString("*******************************************"));
            out.println(rb.getString("*******************************************\n\n"));
        }
    }

    private void doPrintCert(InputStream in, PrintStream out) throws Exception {
        Collection<? extends Certificate> c = null;
        try {
            c = this.cf.generateCertificates(in);
        }
        catch (CertificateException ce) {
            throw new Exception(rb.getString("Failed to parse input"), ce);
        }
        if (c.isEmpty()) {
            throw new Exception(rb.getString("Empty input"));
        }
        Iterator<? extends Certificate> i = c.iterator();
        boolean moreCerts = i.hasNext();
        int numberOfCerts = 1;
        while (moreCerts) {
            Certificate cert = i.next();
            X509Certificate x509Cert = null;
            try {
                x509Cert = (X509Certificate)cert;
            }
            catch (ClassCastException cce) {
                throw new Exception(rb.getString("Not X.509 certificate"));
            }
            if (numberOfCerts > 1) {
                MessageFormat form = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                Object[] source = new Object[]{new Integer(numberOfCerts)};
                out.println(form.format(source));
            }
            this.printX509Cert(x509Cert, out);
            moreCerts = i.hasNext();
            if (moreCerts) {
                out.println();
            }
            ++numberOfCerts;
        }
    }

    private void doSelfCert(String alias, String dname, String sigAlgName) throws Exception {
        X500Name owner;
        Certificate oldCert;
        if (alias == null) {
            alias = this.keyAlias;
        }
        Object[] objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs[0];
        if (!this.token && this.keyPass == null) {
            this.keyPass = (char[])objs[1];
        }
        if (sigAlgName == null) {
            String keyAlgName = privKey.getAlgorithm();
            if (keyAlgName.equalsIgnoreCase("DSA") || keyAlgName.equalsIgnoreCase("DSS")) {
                sigAlgName = "SHA1WithDSA";
            } else if (keyAlgName.equalsIgnoreCase("RSA")) {
                sigAlgName = "SHA256WithRSA";
            } else if (keyAlgName.equalsIgnoreCase("EC")) {
                sigAlgName = "SHA256WithECDSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        if ((oldCert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias has no public key"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (!(oldCert instanceof X509Certificate)) {
            MessageFormat form = new MessageFormat(rb.getString("alias has no X.509 certificate"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        byte[] encoded = oldCert.getEncoded();
        X509CertImpl certImpl = new X509CertImpl(encoded);
        X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
        Date firstDate = new Date();
        Date lastDate = new Date();
        lastDate.setTime(firstDate.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        certInfo.set("validity", (Object)interval);
        certInfo.set("serialNumber", (Object)new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
        if (dname == null) {
            owner = (X500Name)certInfo.get("subject.dname");
        } else {
            owner = new X500Name(dname);
            certInfo.set("subject.dname", (Object)owner);
        }
        certInfo.set("issuer.dname", (Object)owner);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(privKey, sigAlgName, this.providerName);
        AlgorithmId sigAlgid = (AlgorithmId)newCert.get("x509.algorithm");
        certInfo.set("algorithmID.algorithm", (Object)sigAlgid);
        newCert = new X509CertImpl(certInfo);
        newCert.sign(privKey, sigAlgName, this.providerName);
        this.keyStore.setKeyEntry(alias, privKey, this.keyPass != null ? this.keyPass : this.storePass, new Certificate[]{newCert});
        if (this.verbose) {
            System.err.println(rb.getString("New certificate (self-signed):"));
            System.err.print(newCert.toString());
            System.err.println();
        }
    }

    private boolean installReply(String alias, InputStream in) throws Exception {
        Certificate userCert;
        if (alias == null) {
            alias = this.keyAlias;
        }
        Object[] objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs[0];
        if (!this.token && this.keyPass == null) {
            this.keyPass = (char[])objs[1];
        }
        if ((userCert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Collection<? extends Certificate> c = this.cf.generateCertificates(in);
        if (c.isEmpty()) {
            throw new Exception(rb.getString("Reply has no certificates"));
        }
        Certificate[] replyCerts = c.toArray(new Certificate[0]);
        Certificate[] newChain = replyCerts.length == 1 ? this.establishCertChain(userCert, replyCerts[0]) : this.validateReply(alias, userCert, replyCerts);
        if (newChain != null) {
            this.keyStore.setKeyEntry(alias, privKey, this.keyPass != null ? this.keyPass : this.storePass, newChain);
            return true;
        }
        return false;
    }

    private boolean addTrustedCert(String alias, InputStream in) throws Exception {
        MessageFormat form;
        if (alias == null) {
            throw new Exception(rb.getString("Must specify alias"));
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form2 = new MessageFormat(rb.getString("Certificate not imported, alias <alias> already exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form2.format(source));
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.cf.generateCertificate(in);
        }
        catch (ClassCastException cce) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        catch (CertificateException ce) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        boolean selfSigned = false;
        if (this.isSelfSigned(cert)) {
            cert.verify(cert.getPublicKey());
            selfSigned = true;
        }
        String reply = null;
        String trustalias = this.keyStore.getCertificateAlias(cert);
        if (trustalias != null) {
            if (this.isRACFkeystore) {
                MessageFormat form3 = new MessageFormat(rb.getString("Certificate already exists in keystore under alias <trustalias>.  RACF keystore will not support adding it again."));
                Object[] source = new Object[]{trustalias};
                throw new Exception(form3.format(source));
            }
            if (!this.noprompt) {
                form = new MessageFormat(rb.getString("Certificate already exists in keystore under alias <trustalias>"));
                Object[] source = new Object[]{trustalias};
                System.err.println(form.format(source));
                reply = this.getYesNoReply(rb.getString("Do you still want to add it? [no]:  "));
            }
        } else if (selfSigned) {
            if (this.trustcacerts && this.caks != null && (trustalias = this.caks.getCertificateAlias(cert)) != null) {
                if (this.isRACFkeystore) {
                    MessageFormat form4 = new MessageFormat(rb.getString("Certificate already exists in system-wide CA keystore under alias <trustalias>.  RACF keystore will not support adding it again."));
                    Object[] source = new Object[]{trustalias};
                    throw new Exception(form4.format(source));
                }
                if (!this.noprompt) {
                    form = new MessageFormat(rb.getString("Certificate already exists in system-wide CA keystore under alias <trustalias>"));
                    Object[] source = new Object[]{trustalias};
                    System.err.println(form.format(source));
                    reply = this.getYesNoReply(rb.getString("Do you still want to add it to your own keystore? [no]:  "));
                }
            }
            if (trustalias == null && !this.noprompt) {
                this.printX509Cert(cert, System.out);
                reply = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            }
        }
        if (this.noprompt || reply != null && reply.equals("YES")) {
            this.keyStore.setCertificateEntry(alias, cert);
            return true;
        }
        if (reply != null && reply.equals("NO")) {
            return false;
        }
        try {
            Certificate[] chain = this.establishCertChain(null, cert);
            if (chain != null) {
                this.keyStore.setCertificateEntry(alias, cert);
                return true;
            }
        }
        catch (Exception e) {
            this.printX509Cert(cert, System.out);
            reply = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            if (reply.equals("YES")) {
                this.keyStore.setCertificateEntry(alias, cert);
                return true;
            }
            return false;
        }
        return false;
    }

    private char[] getNewPasswd(String prompt, char[] oldPasswd) throws Exception {
        char[] entered = null;
        char[] reentered = null;
        for (int count = 0; count < 3; ++count) {
            MessageFormat form = new MessageFormat(rb.getString("New prompt: "));
            Object[] source = new Object[]{prompt};
            System.err.print(form.format(source));
            entered = Password.readPassword((InputStream)System.in);
            this.passwords.add(entered);
            if (entered == null || entered.length < 6) {
                System.err.println(rb.getString("Password is too short - must be at least 6 characters"));
            } else if (Arrays.equals(entered, oldPasswd)) {
                System.err.println(rb.getString("Passwords must differ"));
            } else {
                form = new MessageFormat(rb.getString("Re-enter new prompt: "));
                Object[] src = new Object[]{prompt};
                System.err.print(form.format(src));
                reentered = Password.readPassword((InputStream)System.in);
                this.passwords.add(reentered);
                if (!Arrays.equals(entered, reentered)) {
                    System.err.println(rb.getString("The re-entered password does not match with the first one. Try again"));
                } else {
                    Arrays.fill(reentered, ' ');
                    return entered;
                }
            }
            if (entered != null) {
                Arrays.fill(entered, ' ');
                entered = null;
            }
            if (reentered == null) continue;
            Arrays.fill(reentered, ' ');
            reentered = null;
        }
        throw new Exception(rb.getString("Too many failures - try later"));
    }

    private String getAlias(String prompt) throws Exception {
        InputStreamReader isr = null;
        if (prompt != null) {
            MessageFormat form = new MessageFormat(rb.getString("Enter prompt alias name:  "));
            Object[] source = new Object[]{prompt};
            System.err.print(form.format(source));
        } else {
            System.err.print(rb.getString("Enter alias name:  "));
        }
        isr = new InputStreamReader(System.in);
        return new BufferedReader(isr).readLine();
    }

    private String inputStringFromStdin(String prompt) throws Exception {
        System.err.print(prompt);
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private char[] getKeyPasswd(String alias, String otherAlias, char[] otherKeyPass) throws Exception {
        int count = 0;
        char[] keyPass = null;
        do {
            Object[] source;
            MessageFormat form;
            if (otherKeyPass != null) {
                form = new MessageFormat(rb.getString("Enter key password for <alias>"));
                source = new Object[]{alias};
                System.err.println(form.format(source));
                form = new MessageFormat(rb.getString("\t(RETURN if same as for <otherAlias>)"));
                Object[] src = new Object[]{otherAlias};
                System.err.print(form.format(src));
            } else {
                form = new MessageFormat(rb.getString("Enter key password for <alias>"));
                source = new Object[]{alias};
                System.err.print(form.format(source));
            }
            System.err.flush();
            keyPass = Password.readPassword((InputStream)System.in);
            this.passwords.add(keyPass);
            if (keyPass != null) continue;
            keyPass = otherKeyPass;
        } while (keyPass == null && ++count < 3);
        if (keyPass == null) {
            throw new Exception(rb.getString("Too many failures - try later"));
        }
        return keyPass;
    }

    private void printX509Cert(X509Certificate cert, PrintStream out) throws Exception {
        MessageFormat form = new MessageFormat(rb.getString("*PATTERN* printX509Cert"));
        Object[] source = new Object[]{cert.getSubjectDN().toString(), cert.getIssuerDN().toString(), cert.getSerialNumber().toString(16), cert.getNotBefore().toString(), cert.getNotAfter().toString(), this.getCertFingerPrint("MD5", cert), this.getCertFingerPrint("SHA1", cert), this.getCertFingerPrint("SHA-256", cert), cert.getSigAlgName().toString(), cert.getVersion()};
        out.println(form.format(source));
    }

    private boolean isSelfSigned(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    private boolean isTrusted(Certificate cert) throws Exception {
        if (this.keyStore.getCertificateAlias(cert) != null) {
            return true;
        }
        return this.trustcacerts && this.caks != null && this.caks.getCertificateAlias(cert) != null;
    }

    private X500Name getX500Name() throws IOException {
        X500Name name;
        Object[] source;
        MessageFormat form;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String commonName = rb.getString("Unknown");
        String organizationalUnit = rb.getString("Unknown");
        String organization = rb.getString("Unknown");
        String city = rb.getString("Unknown");
        String state = rb.getString("Unknown");
        String country = rb.getString("Unknown");
        String userInput = null;
        do {
            commonName = this.inputString(in, rb.getString("What is your first and last name?"), commonName);
            organizationalUnit = this.inputString(in, rb.getString("What is the name of your organizational unit?"), organizationalUnit);
            organization = this.inputString(in, rb.getString("What is the name of your organization?"), organization);
            city = this.inputString(in, rb.getString("What is the name of your City or Locality?"), city);
            state = this.inputString(in, rb.getString("What is the name of your State or Province?"), state);
            country = this.inputString(in, rb.getString("What is the two-letter country code for this unit?"), country);
            name = new X500Name(commonName, organizationalUnit, organization, city, state, country);
        } while (collator.compare(userInput = this.inputString(in, (form = new MessageFormat(rb.getString("Is <name> correct?"))).format(source = new Object[]{name}), rb.getString("no")), rb.getString("yes")) != 0 && collator.compare(userInput, rb.getString("y")) != 0);
        System.err.println();
        return name;
    }

    private String inputString(BufferedReader in, String prompt, String defaultValue) throws IOException {
        System.err.println(prompt);
        MessageFormat form = new MessageFormat(rb.getString("  [defaultValue]:  "));
        Object[] source = new Object[]{defaultValue};
        System.err.print(form.format(source));
        System.err.flush();
        String value = in.readLine();
        if (value == null || collator.compare(value, "") == 0) {
            value = defaultValue;
        }
        return value;
    }

    private void dumpCert(Certificate cert, PrintStream out) throws IOException, CertificateException {
        if (this.rfc) {
            BASE64Encoder encoder = new BASE64Encoder();
            byte[] ba = null;
            try {
                ba = "-----BEGIN CERTIFICATE-----\r\n".getBytes("8859_1");
            }
            catch (UnsupportedEncodingException uee) {
                ba = "-----BEGIN CERTIFICATE-----\r\n".getBytes();
            }
            out.write(ba, 0, ba.length);
            String temp = new String(cert.getEncoded());
            encoder.encodeBuffer(cert.getEncoded(), (OutputStream)out);
            try {
                ba = "-----END CERTIFICATE-----\r\n".getBytes("8859_1");
            }
            catch (UnsupportedEncodingException uee) {
                ba = "-----END CERTIFICATE-----\r\n".getBytes();
            }
            out.write(ba, 0, ba.length);
        } else {
            out.write(cert.getEncoded());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doExportCertToPkcs12(String alias, PrintStream out) throws Exception {
        PrivateKey privKey;
        if (this.keyPass == null) {
            this.keyPass = this.getKeyPasswd(alias, null, null);
        }
        if (this.storePass == null && !this.isRACFkeystore && !this.token) {
            this.printWarning();
        }
        if (alias == null) {
            alias = this.keyAlias;
        }
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Certificate[] certs = this.keyStore.getCertificateChain(alias);
        if (certs == null && (certs = new Certificate[]{this.keyStore.getCertificate(alias)})[0] == null) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> has no certificate"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        PKCS12PFX pfx = new PKCS12PFX();
        byte[] inputBytes = null;
        PrivateKeyInfo privkeyInfo = null;
        inputBytes = certs[0].getPublicKey().getEncoded();
        if (inputBytes == null) {
            throw new Exception(rb.getString("No public key information available"));
        }
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(inputBytes);
        byte[] lKeyId = md.digest();
        String fname = alias;
        PKCSAttribute attr = new PKCSAttribute(PKCSOID.LOCAL_KEY_ID_OID, (Object)lKeyId);
        PKCSAttribute[] inAttrs = new PKCSAttribute[]{attr};
        PKCSAttributes attrs = new PKCSAttributes(inAttrs);
        attrs = attrs.addAttribute(new PKCSAttribute(PKCSOID.FRIENDLY_NAME_OID, (Object)fname));
        EncryptedPrivateKeyInfo epki = null;
        if (this.isRACFkeystore || this.storetype.equalsIgnoreCase("jceccaks") || this.storetype.equalsIgnoreCase("jce4758ks")) {
            privKey = this.isRACFkeystore ? (PrivateKey)this.keyStore.getKey(alias, "password".toCharArray()) : (PrivateKey)this.keyStore.getKey(alias, this.keyPass);
            if (privKey instanceof RSAPrivateHWKey) {
                if ((privKey = this.getExternalTokenPrivKey(privKey)) == null) throw new Exception(rb.getString("Cannot obtain private key"));
                privkeyInfo = new PrivateKeyInfo(privKey.getEncoded());
                epki = new EncryptedPrivateKeyInfo(this.keyPass, privkeyInfo, "SHA", "3KeyTripleDES");
            } else {
                if (!(privKey instanceof ECPrivateHWKey)) throw new Exception(rb.getString("Unsupported hardware key format for export"));
                if ((privKey = this.getSoftwareECPrivateKey((ECPrivateHWKey)privKey)) == null) throw new Exception(rb.getString("Cannot obtain private key"));
                privkeyInfo = new PrivateKeyInfo(privKey.getEncoded());
                epki = new EncryptedPrivateKeyInfo(this.keyPass, privkeyInfo, "SHA", "3KeyTripleDES");
            }
        } else if (this.token) {
            privKey = (PrivateKey)this.keyStore.getKey(alias, "password".toCharArray());
            if (privKey == null) throw new Exception(rb.getString("Cannot obtain private key"));
            privkeyInfo = new PrivateKeyInfo(privKey.getEncoded());
            epki = new EncryptedPrivateKeyInfo(this.keyPass, privkeyInfo, "SHA", "3KeyTripleDES");
        } else {
            privKey = (PrivateKey)this.keyStore.getKey(alias, this.keyPass);
            privkeyInfo = new PrivateKeyInfo(privKey.getEncoded());
            epki = new EncryptedPrivateKeyInfo(this.keyPass, privkeyInfo, "SHA", "3KeyTripleDES");
        }
        if (epki == null) {
            throw new Exception(rb.getString("Private key could not be encrypted"));
        }
        ShroudedKeyBag skb = new ShroudedKeyBag(epki);
        SafeBag sb = new SafeBag((Bag)skb, attrs);
        SafeBag[] sba = new SafeBag[]{sb};
        pfx.addSafeBags(sba);
        sba = new SafeBag[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate cert = (X509Certificate)certs[i];
            X500Name name = new X500Name(cert.getSubjectDN().getName());
            fname = name.getCommonName();
            if (fname == null) {
                fname = ((X509Certificate)certs[i]).getSubjectDN().getName();
            }
            inAttrs = new PKCSAttribute[]{attr};
            attrs = new PKCSAttributes(inAttrs);
            attrs = attrs.addAttribute(new PKCSAttribute(PKCSOID.FRIENDLY_NAME_OID, (Object)fname));
            CertBag cb = new CertBag(certs[i]);
            sba[i] = sb = new SafeBag((Bag)cb, attrs);
        }
        pfx.addSafeBagsWithPasswordPrivacy(sba, "3KeyTripleDes", this.keyPass);
        pfx.applyMac(this.keyPass);
        if (this.rfc) {
            BASE64Encoder encoder = new BASE64Encoder();
            byte[] ba = null;
            try {
                ba = "-----BEGIN CERTIFICATE-----\r\n".getBytes("8859_1");
            }
            catch (UnsupportedEncodingException uee) {
                ba = "-----BEGIN CERTIFICATE-----\r\n".getBytes();
            }
            out.write(ba, 0, ba.length);
            encoder.encodeBuffer(pfx.encode(), (OutputStream)out);
            try {
                ba = "-----END CERTIFICATE-----\r\n".getBytes("8859_1");
            }
            catch (UnsupportedEncodingException uee) {
                ba = "-----END CERTIFICATE-----\r\n".getBytes();
            }
            out.write(ba, 0, ba.length);
            return;
        }
        out.write(pfx.encode());
    }

    private void doRefreshKeyStore() throws Exception {
        if (this.alias != null) {
            this.doRefreshKeyStoreSingle(this.alias);
        } else {
            if (this.keyPass != null) {
                throw new Exception(rb.getString("if -alias not specified, -keypass must not be specified"));
            }
            this.doRefreshKeyStoreAll();
        }
    }

    private int doRefreshKeyStoreSingle(String alias) throws Exception {
        PrivateKey privKey;
        Object[] source = new Object[]{alias};
        Object[] objs = null;
        try {
            objs = this.recoverKey(alias, this.storePass, this.keyPass);
        }
        catch (UnrecoverableKeyException urk) {
            System.err.println(urk);
            System.err.println(new MessageFormat(rb.getString("Entry for alias <alias> not refreshed.")).format(source));
            return 2;
        }
        if (objs[0] instanceof RSAPrivateHWKey) {
            privKey = (PrivateKey)objs[0];
            byte type = ((RSAPrivateHWKey)privKey).getType();
            if (type != 2) {
                MessageFormat form = new MessageFormat(rb.getString("-refreshkeystore is only supported with CLEAR keys"));
                throw new Exception(form.format(source));
            }
        } else {
            MessageFormat form = new MessageFormat(rb.getString("-refreshkeystore is only supported with keyalg RSA"));
            throw new Exception(form.format(source));
        }
        PrivateKey refreshedKey = this.getExternalTokenPrivKey(privKey);
        RSAKeyHWAttributes keyAttrs = new RSAKeyHWAttributes(((RSAPrivateHWKey)privKey).getType(), ((RSAPrivateHWKey)privKey).getUsage());
        WrapperKey wrappedKey = new WrapperKey(refreshedKey, keyAttrs);
        try {
            this.keyStore.setKeyEntry(alias, wrappedKey, (char[])objs[1], this.keyStore.getCertificateChain(alias));
            return 1;
        }
        catch (KeyStoreException kse) {
            Object[] source2 = new Object[]{alias, kse.toString()};
            MessageFormat form = new MessageFormat(rb.getString("Problem refreshing entry for alias <alias>: <exception>.\nEntry for alias <alias> not refreshed."));
            System.err.println(form.format(source2));
            return 2;
        }
    }

    private void doRefreshKeyStoreAll() throws Exception {
        block6: {
            int ok = 0;
            int count = 0;
            int skip = 0;
            Enumeration<String> e = this.keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                try {
                    String reply;
                    int result = this.doRefreshKeyStoreSingle(alias);
                    ++count;
                    if (result == 1) {
                        ++ok;
                        Object[] source = new Object[]{alias};
                        MessageFormat form = new MessageFormat(rb.getString("Entry for alias <alias> successfully refreshed."));
                        System.err.println(form.format(source));
                        continue;
                    }
                    if (result != 2 || !"YES".equals(reply = this.getYesNoReply("Do you want to quit the refresh process? [no]:  "))) continue;
                    break;
                }
                catch (Exception ex) {
                    ++skip;
                }
            }
            try {
                Object[] source = new Object[]{ok, count - ok, skip};
                MessageFormat form = new MessageFormat(rb.getString("Refresh command completed:  <ok> entries successfully refreshed, <fail> entries failed or cancelled, <skip> entries ignored"));
                System.err.println(form.format(source));
            }
            catch (Exception ex) {
                System.out.println(rb.getString("hwkeytool error (likely untranslated): ") + ex.getMessage());
                if (!debug) break block6;
                ex.printStackTrace();
            }
        }
    }

    private void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            this.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    private Object[] recoverEntry(KeyStore ks, String alias, char[] pstore, char[] pkey) throws Exception {
        if (debug) {
            if (alias == null) {
                System.err.println("hwkeytool.recoverEntry: alias is NULL");
            } else {
                System.err.println("hwkeytool.recoverEntry: alias = " + alias);
            }
            if (pkey == null) {
                System.err.println("hwkeytool.recoverEntry: keyPass is NULL");
            } else {
                System.err.println("hwkeytool.recoverEntry: keyPass = " + new String(pkey));
            }
        }
        if (!ks.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        KeyStore.PasswordProtection pp = null;
        KeyStore.Entry entry = null;
        try {
            entry = ks.getEntry(alias, pp);
            pkey = null;
        }
        catch (Exception une) {
            if (P11KEYSTORE1.equalsIgnoreCase(ks.getType()) || P11KEYSTORE2.equalsIgnoreCase(ks.getType())) {
                throw une;
            }
            if (pkey != null) {
                pp = new KeyStore.PasswordProtection(pkey);
                entry = ks.getEntry(alias, pp);
            }
            try {
                pp = new KeyStore.PasswordProtection(pstore);
                entry = ks.getEntry(alias, pp);
                pkey = pstore;
            }
            catch (UnrecoverableEntryException une2) {
                if (P12KEYSTORE.equalsIgnoreCase(ks.getType())) {
                    throw une2;
                }
                pkey = this.getKeyPasswd(alias, null, null);
                pp = new KeyStore.PasswordProtection(pkey);
                entry = ks.getEntry(alias, pp);
            }
        }
        return new Object[]{entry, pkey};
    }

    private Object[] recoverKey(String alias, char[] storePass, char[] keyPass) throws Exception {
        Key key = null;
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) && !this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> has no key"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (keyPass == null) {
            try {
                key = this.keyStore.getKey(alias, storePass);
                keyPass = storePass;
            }
            catch (UnrecoverableKeyException e) {
                if (!this.token) {
                    keyPass = this.getKeyPasswd(alias, null, null);
                    key = this.keyStore.getKey(alias, keyPass);
                }
                throw e;
            }
        } else {
            key = this.keyStore.getKey(alias, keyPass);
        }
        return new Object[]{key, keyPass};
    }

    private String getCertFingerPrint(String mdAlg, Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(mdAlg, this.providerName);
        }
        catch (NoSuchProviderException nspe) {
            md = MessageDigest.getInstance(mdAlg);
        }
        byte[] digest = md.digest(encCertInfo);
        return this.toHexString(digest);
    }

    private void printWarning() {
        System.err.println();
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println(rb.getString("* The integrity of the information stored in your keystore  *"));
        System.err.println(rb.getString("* has NOT been verified!  In order to verify its integrity, *"));
        System.err.println(rb.getString("* you must provide your keystore password.                  *"));
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println();
    }

    private Certificate[] validateReply(String alias, Certificate userCert, Certificate[] replyCerts) throws Exception {
        int i;
        PublicKey userPubKey = userCert.getPublicKey();
        for (i = 0; i < replyCerts.length && !userPubKey.equals(replyCerts[i].getPublicKey()); ++i) {
        }
        if (i == replyCerts.length) {
            MessageFormat form = new MessageFormat(rb.getString("Certificate reply does not contain public key for <alias>"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Certificate tmpCert = replyCerts[0];
        replyCerts[0] = replyCerts[i];
        replyCerts[i] = tmpCert;
        Principal issuer = ((X509Certificate)replyCerts[0]).getIssuerDN();
        for (i = 1; i < replyCerts.length - 1; ++i) {
            int j;
            for (j = i; j < replyCerts.length; ++j) {
                Principal subject = ((X509Certificate)replyCerts[j]).getSubjectDN();
                if (!subject.equals(issuer)) continue;
                tmpCert = replyCerts[i];
                replyCerts[i] = replyCerts[j];
                replyCerts[j] = tmpCert;
                issuer = ((X509Certificate)replyCerts[i]).getIssuerDN();
                break;
            }
            if (j != replyCerts.length) continue;
            throw new Exception(rb.getString("Incomplete certificate chain in reply"));
        }
        for (i = 0; i < replyCerts.length - 1; ++i) {
            PublicKey pubKey = replyCerts[i + 1].getPublicKey();
            try {
                replyCerts[i].verify(pubKey);
                continue;
            }
            catch (Exception e) {
                throw new Exception(rb.getString("Certificate chain in reply does not verify: ") + e.getMessage());
            }
        }
        if (this.noprompt) {
            return replyCerts;
        }
        Certificate topCert = replyCerts[replyCerts.length - 1];
        if (!this.isTrusted(topCert)) {
            boolean verified = false;
            Certificate rootCert = null;
            if (this.trustcacerts && this.caks != null) {
                Enumeration<String> aliases = this.caks.aliases();
                while (aliases.hasMoreElements()) {
                    String name = aliases.nextElement();
                    rootCert = this.caks.getCertificate(name);
                    if (rootCert == null) continue;
                    try {
                        topCert.verify(rootCert.getPublicKey());
                        verified = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (!verified) {
                System.err.println();
                System.err.println(rb.getString("Top-level certificate in reply:\n"));
                this.printX509Cert((X509Certificate)topCert, System.out);
                System.err.println();
                System.err.print(rb.getString("... is not trusted. "));
                String reply = this.getYesNoReply(rb.getString("Install reply anyway? [no]:  "));
                if (reply.equals("NO")) {
                    return null;
                }
            } else if (!this.isSelfSigned((X509Certificate)topCert)) {
                Certificate[] tmpCerts = new Certificate[replyCerts.length + 1];
                System.arraycopy(replyCerts, 0, tmpCerts, 0, replyCerts.length);
                tmpCerts[tmpCerts.length - 1] = rootCert;
                replyCerts = tmpCerts;
            }
        }
        return replyCerts;
    }

    private Certificate[] establishCertChain(Certificate userCert, Certificate certToVerify) throws Exception {
        Vector chain;
        if (userCert != null) {
            PublicKey replyPubKey;
            PublicKey origPubKey = userCert.getPublicKey();
            if (!origPubKey.equals(replyPubKey = certToVerify.getPublicKey())) {
                throw new Exception(rb.getString("Public keys in reply and keystore don't match"));
            }
            if (certToVerify.equals(userCert)) {
                throw new Exception(rb.getString("Certificate reply and certificate in keystore are identical"));
            }
        }
        Hashtable certs = null;
        if (this.keyStore.size() > 0) {
            certs = new Hashtable(11);
            this.keystorecerts2Hashtable(this.keyStore, certs);
        }
        if (this.trustcacerts && this.caks != null && this.caks.size() > 0) {
            if (certs == null) {
                certs = new Hashtable(11);
            }
            this.keystorecerts2Hashtable(this.caks, certs);
        }
        if (this.buildChain((X509Certificate)certToVerify, chain = new Vector(2), certs)) {
            Certificate[] newChain = new Certificate[chain.size()];
            int j = 0;
            for (int i = chain.size() - 1; i >= 0; --i) {
                newChain[j] = (Certificate)chain.elementAt(i);
                ++j;
            }
            return newChain;
        }
        throw new Exception(rb.getString("Failed to establish chain from reply"));
    }

    private boolean buildChain(X509Certificate certToVerify, Vector chain, Hashtable certs) {
        Principal issuer;
        Principal subject = certToVerify.getSubjectDN();
        if (subject.equals(issuer = certToVerify.getIssuerDN())) {
            chain.addElement(certToVerify);
            return true;
        }
        Vector vec = (Vector)certs.get(issuer);
        if (vec == null) {
            return false;
        }
        Enumeration issuerCerts = vec.elements();
        while (issuerCerts.hasMoreElements()) {
            X509Certificate issuerCert = (X509Certificate)issuerCerts.nextElement();
            PublicKey issuerPubKey = issuerCert.getPublicKey();
            try {
                certToVerify.verify(issuerPubKey);
            }
            catch (Exception e) {
                continue;
            }
            if (!this.buildChain(issuerCert, chain, certs)) continue;
            chain.addElement(certToVerify);
            return true;
        }
        return false;
    }

    private Certificate[] validateCerts(Certificate[] certs) throws Exception {
        int i;
        Certificate[] chain = new Certificate[certs.length];
        Hashtable hash = new Hashtable();
        for (i = 0; i < certs.length; ++i) {
            Principal subjectDN = ((X509Certificate)certs[i]).getSubjectDN();
            Vector<Certificate> vec = (Vector<Certificate>)hash.get(subjectDN);
            if (vec == null) {
                vec = new Vector<Certificate>();
                vec.addElement(certs[i]);
            } else if (!vec.contains(certs[i])) {
                vec.addElement(certs[i]);
            }
            hash.put(subjectDN, vec);
        }
        for (i = 0; i < certs.length; ++i) {
            Vector orderedChain = new Vector();
            if (this.buildChain((X509Certificate)certs[i], orderedChain, hash)) {
                if (orderedChain.size() != certs.length) continue;
                int j = 0;
                for (int l = orderedChain.size() - 1; l >= 0; --l) {
                    chain[j] = (Certificate)orderedChain.elementAt(l);
                    ++j;
                }
                break;
            }
            throw new Exception("Failed to establish chain from the given certificates");
        }
        for (i = 0; i < chain.length - 1; ++i) {
            PublicKey pubKey = chain[i + 1].getPublicKey();
            try {
                chain[i].verify(pubKey);
                continue;
            }
            catch (Exception e) {
                throw new Exception(rb.getString("Certificate chain does not verify: ") + e.getMessage());
            }
        }
        if (this.noprompt) {
            return chain;
        }
        Certificate topCert = chain[chain.length - 1];
        if (!this.isTrusted(topCert)) {
            boolean verified = false;
            Certificate rootCert = null;
            if (this.trustcacerts && this.caks != null) {
                Enumeration<String> aliases = this.caks.aliases();
                while (aliases.hasMoreElements()) {
                    String name = aliases.nextElement();
                    rootCert = this.caks.getCertificate(name);
                    if (rootCert == null) continue;
                    try {
                        topCert.verify(rootCert.getPublicKey());
                        verified = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (!verified) {
                System.err.println();
                System.err.println(rb.getString("Top-level certificate in reply:\n"));
                this.printX509Cert((X509Certificate)topCert, System.out);
                System.err.println();
                System.err.print(rb.getString("... is not trusted. "));
                String reply = this.getYesNoReply(rb.getString("Install reply anyway? [no]:  "));
                if (reply.equalsIgnoreCase("NO")) {
                    return null;
                }
            } else if (!this.isSelfSigned((X509Certificate)topCert)) {
                Certificate[] tmpCerts = new Certificate[chain.length + 1];
                System.arraycopy(chain, 0, tmpCerts, 0, chain.length);
                tmpCerts[tmpCerts.length - 1] = rootCert;
                chain = tmpCerts;
            }
        }
        return chain;
    }

    private String getYesNoReply(String prompt) throws IOException {
        String reply = null;
        do {
            System.err.print(prompt);
            System.err.flush();
            reply = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (collator.compare(reply, "") == 0 || collator.compare(reply, rb.getString("n")) == 0 || collator.compare(reply, rb.getString("no")) == 0) {
                reply = "NO";
                continue;
            }
            if (collator.compare(reply, rb.getString("y")) == 0 || collator.compare(reply, rb.getString("yes")) == 0) {
                reply = "YES";
                continue;
            }
            System.err.println(rb.getString("Wrong answer, try again"));
            reply = null;
        } while (reply == null);
        return reply;
    }

    private KeyStore getCacertsKeyStore() throws Exception {
        String sep = File.separator;
        File file = new File(System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + "cacerts");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        KeyStore caks = null;
        try {
            caks = KeyStore.getInstance(JKS, this.providerName);
        }
        catch (NoSuchProviderException e) {
            caks = KeyStore.getInstance(JKS);
        }
        catch (KeyStoreException e) {
            caks = KeyStore.getInstance(JKS);
        }
        caks.load(fis, null);
        fis.close();
        return caks;
    }

    private void keystorecerts2Hashtable(KeyStore ks, Hashtable hash) throws Exception {
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) continue;
            Principal subjectDN = ((X509Certificate)cert).getSubjectDN();
            Vector<Certificate> vec = (Vector<Certificate>)hash.get(subjectDN);
            if (vec == null) {
                vec = new Vector<Certificate>();
                vec.addElement(cert);
            } else if (!vec.contains(cert)) {
                vec.addElement(cert);
            }
            hash.put(subjectDN, vec);
        }
    }

    private PrivateKey getExternalTokenPrivKey(PrivateKey privKey) throws Exception {
        PrivateKey pkey = null;
        byte token_ME_form = 0;
        byte[] RSAHWtoken = null;
        RSAHWtoken = ((RSAPrivateHWKey)privKey).getExternalKeyToken();
        if (RSAHWtoken == null) {
            MessageFormat form = new MessageFormat(rb.getString("Cannot get primary encoding format of key with alias <alias>"));
            Object[] source = new Object[]{this.alias};
            throw new Exception(form.format(source));
        }
        token_ME_form = RSAHWtoken[8];
        if (token_ME_form != 8) {
            throw new Exception(rb.getString("Unsupported hardware key format for export"));
        }
        CrtToken crt_token = new CrtToken(RSAHWtoken, null);
        pkey = crt_token.generatePrivateCrtkey();
        if (pkey == null) {
            throw new Exception(rb.getString("Cannot obtain private key"));
        }
        return pkey;
    }

    private PrivateKey getSoftwareECPrivateKey(ECPrivateHWKey privKey) throws Exception {
        if (privKey.getExternalKeyToken() == null) {
            MessageFormat form = new MessageFormat(rb.getString("Cannot get primary encoding format of key with alias <alias>"));
            Object[] source = new Object[]{this.alias};
            throw new Exception(form.format(source));
        }
        KeyFactory jceccaKeyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
        ECPrivateKeySpec privateKeySpec = jceccaKeyFactory.getKeySpec(privKey, ECPrivateKeySpec.class);
        KeyFactory jceKeyFactory = KeyFactory.getInstance("EC", "IBMJCE");
        PrivateKey softwareECPrivateKey = jceKeyFactory.generatePrivate(privateKeySpec);
        return softwareECPrivateKey;
    }

    private void usage() {
        System.err.println(rb.getString("hwkeytool usage:\n"));
        System.err.println(rb.getString("-certreq     [-v]"));
        System.err.println(rb.getString("\t     [-alias <alias>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-file <csr_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println();
        System.err.println(rb.getString("-changealias [-v] -alias <alias> -destalias <destalias>"));
        System.err.println(rb.getString("\t     [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerPath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-delete      [-v] -alias <alias>"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-hardwarekey] [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println();
        System.err.println(rb.getString("-exportcert      [-v] [-rfc]"));
        System.err.println(rb.getString("\t     [-alias <alias>] [-file <cert_file>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>] [-pkcs12]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println();
        System.err.println(rb.getString("-exportseckey      [-v]"));
        System.err.println(rb.getString("\t     [-alias <alias> | aliasrange <aliasRange>] [-keyalias <keyalias>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-exportfile <exportfile>]"));
        System.err.println();
        System.err.println(rb.getString("-genkeypair  [-v]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keyalg <keyalg>] [-keysize <keysize>]"));
        System.err.println(rb.getString("\t     [-sigalg <sigalg>] [-dname <dname>]"));
        System.err.println(rb.getString("\t     [-validity <valDays>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-keylabel <keylabel>] [-hardwaretype <hardwaretype>]"));
        System.err.println(rb.getString("\t     [-existinglabel <existinglabel>] [-file <cert_file>]"));
        System.err.println(rb.getString("\t     [-hardwareusage <hardwareusage>] "));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println();
        System.err.println(rb.getString("-genseckey   [-v]"));
        System.err.println(rb.getString("\t     [-alias <alias> | aliasrange <aliasRange>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keyalg <keyalg>] [-keysize <keysize>]"));
        System.err.println(rb.getString("\t     [-keylabel <keylabel> | -existinglabel <existinglabel>]"));
        System.err.println(rb.getString("\t     [-hardwaretype <hardwaretype>] "));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerPath <pathlist>]"));
        System.err.println(rb.getString("\t     [-wrappingMode <mode>]"));
        System.err.println();
        System.err.println(rb.getString("-help"));
        System.err.println();
        System.err.println(rb.getString("-importcert      [-v] [-rfc] [-noprompt] [-trustcacerts]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-file <cert_file>] [-keypass <keypass>] [-pkcs12]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-hardwaretype <hardwaretype>] [-hardwareusage <hardwareusage>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println();
        System.err.println(rb.getString("-importkeystore [-v] "));
        System.err.println(rb.getString("\t     [-srckeystore <srckeystore>] [-destkeystore <destkeystore>]"));
        System.err.println(rb.getString("\t     [-srcstoretype <srcstoretype>] [-deststoretype <deststoretype>]"));
        System.err.println(rb.getString("\t     [-srcstorepass <srcstorepass>] [-deststorepass <deststorepass>]"));
        System.err.println(rb.getString("\t     [-srcprovidername <srcprovidername>]\n\t     [-destprovidername <destprovidername>]"));
        System.err.println(rb.getString("\t     [-srcalias <srcalias> [-destalias <destalias>]"));
        System.err.println(rb.getString("\t     [-srckeypass <srckeypass>] [-destkeypass <destkeypass>]]"));
        System.err.println(rb.getString("\t     [-noprompt]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerPath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-importseckey       [-v]"));
        System.err.println(rb.getString("\t     [-keyalias <keyalias>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-importfile <importfile>]"));
        System.err.println();
        System.err.println(rb.getString("-keypasswd   [-v] [-all | -alias <alias>]"));
        System.err.println(rb.getString("\t     [-keypass <old_keypass>] [-new <new_keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println();
        System.err.println(rb.getString("-list        [-v | -rfc]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println();
        System.err.println(rb.getString("-printcert   [-v] [-file <cert_file>]"));
        System.err.println();
        System.err.println(rb.getString("-storepasswd [-v] [-all] [-new <new_storepass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providerName <name>]"));
        System.err.println(rb.getString("\t     [-providerClass <provider_class_name> [-providerArg <arg>]] ..."));
        System.err.println();
        System.exit(1);
    }

    private void dumpCertPrintableOnZOS(Certificate cert, PrintStream out) throws IOException, CertificateException {
        if (this.rfc) {
            byte[] ba = null;
            String temp = new String(this.ByteArrayToCharArray(cert.getEncoded()));
            ba = "-----BEGIN CERTIFICATE-----\n".getBytes();
            out.write(ba, 0, ba.length);
            for (int i = 0; i <= temp.length(); i += 152) {
                StringBuffer outputLine = i + 152 <= temp.length() ? new StringBuffer(temp.substring(i, i + 152)) : new StringBuffer(temp.substring(i, i + temp.length() % 152));
                out.print(new String(outputLine) + "\n");
            }
            ba = "-----END CERTIFICATE-----\n".getBytes();
            out.write(ba, 0, ba.length);
        } else {
            out.write(cert.getEncoded());
        }
    }

    private char[] ByteArrayToCharArray(byte[] binaryBytes) {
        char[] C_hexCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] chars = new char[binaryBytes.length << 1];
        for (int i = 0; i < binaryBytes.length; ++i) {
            byte upperNibble = (byte)((binaryBytes[i] & 0xF0) >> 4);
            byte lowerNibble = (byte)(binaryBytes[i] & 0xF);
            int index = i * 2;
            chars[index] = C_hexCharMap[upperNibble];
            chars[index + 1] = C_hexCharMap[lowerNibble];
        }
        return chars;
    }

    private void tinyHelp() {
        System.err.println(rb.getString("Try keytool -help"));
        if (debug) {
            throw new RuntimeException("NO BIG ERROR, SORRY");
        }
        System.exit(1);
    }

    private String[] parseAliasRange(String aliasRange) throws Exception {
        String[] results = new String[]{"", "", ""};
        StringTokenizer parser = new StringTokenizer(aliasRange, delim);
        String prefix = "";
        if (parser.hasMoreTokens()) {
            prefix = parser.nextToken();
        }
        if (parser.hasMoreTokens()) {
            results[2] = parser.nextToken();
        }
        if (prefix != null) {
            results[0] = prefix.substring(0, 3);
            results[1] = prefix.substring(3);
        }
        return results;
    }

    static boolean isAlphabetic(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.toLowerCase().charAt(i);
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    static void isStringHex(String s) throws Exception {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (KeyTool.isCharHex(ch)) continue;
            throw new Exception(rb.getString("The alias range string contains non-hexadecimal value"));
        }
    }

    static boolean isCharHex(char ch) {
        for (int i = 0; i < hexChars.length; ++i) {
            if (ch != hexChars[i]) continue;
            return true;
        }
        return false;
    }

    void bytes2hex(byte[] bytes, StringBuffer buf) {
        for (byte b : bytes) {
            this.byte2hex(b, buf);
        }
    }

    private String[] composeAliases(String prefix, BigInteger start, BigInteger end) {
        ArrayList<String> list = new ArrayList<String>();
        BigInteger i = start;
        while (i.compareTo(end) <= 0) {
            byte[] temp = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
            StringBuffer buffer = new StringBuffer(prefix);
            byte[] current = i.toByteArray();
            System.arraycopy(current, 0, temp, temp.length - current.length, current.length);
            this.bytes2hex(temp, buffer);
            list.add(buffer.toString());
            i = i.add(BigInteger.ONE);
        }
        String[] stringArray = list.toArray(new String[list.size()]);
        return stringArray;
    }

    private BigInteger[] validatePrefixRange(String aliasName, String beginStr, String endStr) throws Exception {
        BigInteger[] range = new BigInteger[]{null, null};
        if (!KeyTool.isAlphabetic(aliasName)) {
            throw new Exception(rb.getString("The alias name prefix (3 characters) is not alphabetic"));
        }
        if (beginStr == null || beginStr.equals("") || endStr == null || endStr.equals("")) {
            MessageFormat form = new MessageFormat(rb.getString("The alias range <aliasRange> is not valid"));
            Object[] source = new Object[]{aliasName};
            throw new Exception(form.format(source));
        }
        byte[] startBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] endBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        KeyTool.isStringHex(beginStr.toUpperCase());
        KeyTool.isStringHex(endStr.toUpperCase());
        range[0] = new BigInteger(beginStr, 16);
        byte[] s = range[0].toByteArray();
        range[1] = new BigInteger(endStr, 16);
        byte[] e = range[1].toByteArray();
        if (s.length > startBytes.length || e.length > endBytes.length) {
            throw new Exception(rb.getString("The alias range length is too large"));
        }
        if (range[1].compareTo(range[0]) < 0) {
            throw new Exception(rb.getString("The alias range end value must be greater than or equal to the alias range start value"));
        }
        System.arraycopy(s, 0, startBytes, startBytes.length - s.length, s.length);
        System.arraycopy(e, 0, endBytes, endBytes.length - e.length, e.length);
        if (startBytes[0] != 0 || endBytes[0] != 0) {
            throw new Exception(rb.getString("The alias range value is too large"));
        }
        return range;
    }

    private void doImportSecretKey(String keyAlias, String importfile, KeyStore keyStore) throws Exception {
        FileInputStream fis = new FileInputStream(importfile);
        int available = fis.available();
        int totalRead = 0;
        int keyCount = 0;
        if (!(this.token || this.storetype.equalsIgnoreCase("JCEKS") || this.storetype.equalsIgnoreCase("JCECCAKS") || this.storetype.equalsIgnoreCase("JCE4758KS"))) {
            throw new Exception(rb.getString("KeyStore cannot store non-private keys"));
        }
        if (available == 0) {
            throw new Exception(importfile + rb.getString(", file size is zero bytes: check the filename and try again."));
        }
        byte[] buffer = new byte[available];
        fis.read(buffer);
        PrivateKey privateKey = this.getPrivateKey(keyAlias, keyStore, this.storePass);
        if (privateKey == null) {
            MessageFormat form = new MessageFormat(rb.getString("cannot find valid private key with keyalias <keyalias>"));
            Object[] source = new Object[]{keyAlias};
            throw new Exception(form.format(source));
        }
        while (totalRead < available) {
            byte[] lengthba = new byte[4];
            System.arraycopy(buffer, totalRead, lengthba, 0, 4);
            int length = KeyTool.toIntFromByte4(lengthba);
            byte[] derBuf = new byte[length];
            System.arraycopy(buffer, totalRead += 4, derBuf, 0, length);
            totalRead += length;
            if (KeyTool.getDerTag() != derBuf[0]) {
                throw new Exception(rb.getString("import file is corrupted"));
            }
            DerInputStream derIs = new DerInputStream(derBuf, 1, length - 1);
            String alias = derIs.getGeneralString();
            String skeyalg = derIs.getGeneralString();
            byte[] cipherKey = derIs.getOctetString();
            SecretKey secretKey = this.decryptKey(cipherKey, skeyalg, privateKey, this.providerName);
            if (keyStore.containsAlias(alias)) {
                if (keyCount > 0) {
                    this.saveKeyStore();
                }
                System.err.println(keyCount + rb.getString(" secret keys have been imported"));
                MessageFormat form = new MessageFormat(rb.getString("secret key not imported, alias <alias> already exists"));
                Object[] source = new Object[]{alias};
                throw new Exception(form.format(source));
            }
            keyStore.setKeyEntry(alias, secretKey, this.keyPass, null);
            ++keyCount;
        }
        if (keyCount > 0) {
            this.saveKeyStore();
        }
        System.err.println(keyCount + rb.getString(" secret keys have been imported"));
    }

    private void exportSecretKeyToOutputStream(String alias, PublicKey pubKey, KeyStore keyStore, OutputStream os) throws Exception {
        SecretKey skey = this.getSecretKey(alias, keyStore);
        if (skey == null) {
            MessageFormat form = new MessageFormat(rb.getString("cannot find valid secret key with alias <alias>"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        byte[] cipherkey = this.encryptKey(pubKey, skey, this.providerName);
        DerOutputStream derData = new DerOutputStream();
        derData.putGeneralString(alias);
        derData.putGeneralString(skey.getAlgorithm());
        derData.putOctetString(cipherkey);
        int len = derData.toByteArray().length + 1;
        byte tag = KeyTool.getDerTag();
        os.write(KeyTool.toByte4FromInt(len));
        os.write(tag);
        os.write(derData.toByteArray());
    }

    private void doExportSecretKey(String[] aliases, PublicKey pubKey, KeyStore keyStore) throws Exception {
        FileOutputStream fs = new FileOutputStream(this.exportSecFile);
        for (String alias : aliases) {
            this.exportSecretKeyToOutputStream(alias, pubKey, keyStore, fs);
        }
        fs.close();
        int count = aliases.length;
        System.err.println(count + rb.getString(" secret keys have been successfully exported"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecretKey getSecretKey(String alias, KeyStore keyStore) throws Exception {
        SecretKey skey = null;
        KeyStore.PasswordProtection pwdProctection = new KeyStore.PasswordProtection(this.keyPass);
        if (this.token || this.keyPass != null) {
            if (!keyStore.containsAlias(alias)) return skey;
            try {
                KeyStore.Entry entry = keyStore.getEntry(alias, pwdProctection);
                if (!(entry instanceof KeyStore.SecretKeyEntry)) return skey;
                KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
                if (secretKeyEntry == null) return skey;
                return secretKeyEntry.getSecretKey();
            }
            catch (UnrecoverableKeyException uke) {
                throw new Exception(rb.getString("Invalid key password"));
            }
        }
        this.usage();
        return skey;
    }

    private PrivateKey getPrivateKey(String alias, KeyStore kstore, char[] storePassword) throws Exception {
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)kstore.getKey(alias, storePassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return privateKey;
    }

    private PublicKey getPublicKey(String alias, KeyStore kstore) throws Exception {
        Certificate cert;
        PublicKey pubKey = null;
        if (kstore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
            Certificate[] chain = kstore.getCertificateChain(alias);
            if (chain != null) {
                pubKey = chain[0].getPublicKey();
            }
        } else if (kstore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class) && (cert = kstore.getCertificate(alias)) != null) {
            pubKey = cert.getPublicKey();
        }
        return pubKey;
    }

    private byte[] encryptKey(PublicKey pubkey, SecretKey skey, String provider) throws Exception {
        byte[] cipherKey = new byte[]{0};
        String keyAlg = pubkey.getAlgorithm();
        Cipher cp = provider == null ? Cipher.getInstance(keyAlg) : Cipher.getInstance(keyAlg, provider);
        cp.init(3, pubkey);
        cipherKey = cp.wrap(skey);
        return cipherKey;
    }

    private SecretKey decryptKey(byte[] wrapkey, String secretKeyAlg, PrivateKey privateKey, String provider) throws Exception {
        SecretKey secretKey = null;
        String keyAlg = privateKey.getAlgorithm();
        Cipher cp = provider == null || provider.equals("") ? Cipher.getInstance(keyAlg) : Cipher.getInstance(keyAlg, provider);
        cp.init(4, privateKey);
        secretKey = (SecretKey)cp.unwrap(wrapkey, secretKeyAlg, 3);
        return secretKey;
    }

    static final int toIntFromByte4(byte[] lengthBytes) {
        return lengthBytes[0] << 24 | (lengthBytes[1] & 0xFF) << 16 | (lengthBytes[2] & 0xFF) << 8 | lengthBytes[3] & 0xFF;
    }

    static final byte[] toByte4FromInt(int length) {
        return new byte[]{(byte)(length >> 24), (byte)(length >> 16), (byte)(length >> 8), (byte)length};
    }

    static byte getDerTag() {
        return DerValue.createTag((byte)-128, (boolean)true, (byte)0);
    }

    static {
        collator.setStrength(0);
    }
}

