/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import java.security.Key;
import java.security.PrivateKey;

public class WrapperKey
implements Key {
    static final long serialVersionUID = 8237353858785312653L;
    private Key theKey;
    private KeyHWAttributes keyAttributes;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.WrapperKey";

    public WrapperKey(PrivateKey key, KeyHWAttributes attrs) throws Exception {
        boolean allowWrapper;
        if (debug != null) {
            Object[] parms = new Object[]{key, attrs};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "WrapperKey", parms);
        }
        String allowWrapperProperty = System.getProperty("ibm.ibmjcecca.allowwrapperhwkey");
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC | 0x8000L, className, "WrapperKey", "Value of ibm.ibmjcecca.allowwrapperhwkey: " + allowWrapperProperty);
        }
        boolean bl = allowWrapper = allowWrapperProperty == null ? false : allowWrapperProperty.equalsIgnoreCase("true");
        if (key == null) {
            NullPointerException npe = new NullPointerException("Key must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "WrapperKey", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "WrapperKey");
            }
            throw npe;
        }
        if (!allowWrapper && (key instanceof RSAPrivateHWKey || key instanceof DSAPrivateHWKey || key instanceof ECPrivateHWKey)) {
            Exception ex = new Exception("Cannot construct a WrapperKey from a RSAPrivateHWKey, DSAPrivateHWKey or an ECPrivateHWKey. RSAPrivateHWKey, DSAPrivateHWKey and ECPrivateHWKey are already bound to the hardware");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "WrapperKey", ex);
                debug.exit(Debug.TYPE_PUBLIC, className, "WrapperKey");
            }
            throw ex;
        }
        if (key.getAlgorithm().equalsIgnoreCase("DSA") && !(attrs instanceof DSAKeyHWAttributes)) {
            Exception e = new Exception("DSAKeyHWAttributes must be used for a DSA key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "WrapperKey", e);
                debug.exit(Debug.TYPE_PUBLIC, className, "WrapperKey");
            }
            throw e;
        }
        if (key.getAlgorithm().equalsIgnoreCase("RSA") && !(attrs instanceof RSAKeyHWAttributes)) {
            Exception e = new Exception("RSAKeyHWAttributes must be used for a RSA key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "WrapperKey", e);
                debug.exit(Debug.TYPE_PUBLIC, className, "WrapperKey");
            }
            throw e;
        }
        if (key.getAlgorithm().equalsIgnoreCase("EC") && !(attrs instanceof ECHWKeyAttributes)) {
            Exception e = new Exception("ECHWKeyAttributes must be used for an Elliptic Curve key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "WrapperKey", e);
                debug.exit(Debug.TYPE_PUBLIC, className, "WrapperKey");
            }
            throw e;
        }
        this.theKey = key;
        this.keyAttributes = attrs;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "WrapperKey");
        }
    }

    @Override
    public byte[] getEncoded() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncoded");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", this.theKey.getEncoded());
        }
        return this.theKey.getEncoded();
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAlgorithm");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAlgorithm", this.theKey.getAlgorithm());
        }
        return this.theKey.getAlgorithm();
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFormat");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", this.theKey.getFormat());
        }
        return this.theKey.getFormat();
    }

    public Key getKey() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKey");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKey", this.theKey);
        }
        return this.theKey;
    }

    public KeyHWAttributes getKeyHWAttributes() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeyHWAttributes");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyHWAttributes", this.keyAttributes);
        }
        return this.keyAttributes;
    }
}

