/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;

final class TokenPair {
    private final byte[] primaryToken;
    private final byte[] secondaryToken;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.TokenPair";

    TokenPair(byte[] primary) {
        this(primary, null);
    }

    TokenPair(byte[] primary, byte[] secondary) {
        if (debug != null) {
            debug.entry(8192L, className, "TokenPair", primary, secondary);
        }
        if (primary == null) {
            NullPointerException npe = new NullPointerException("The primary token should not be null");
            if (debug != null) {
                debug.exception(8192L, className, "TokenPair", npe);
                debug.exit(8192L, className, "TokenPair");
            }
            throw npe;
        }
        this.primaryToken = (byte[])primary.clone();
        byte[] byArray = this.secondaryToken = secondary != null ? (byte[])secondary.clone() : null;
        if (debug != null) {
            debug.exit(8192L, className, "TokenPair");
        }
    }

    final byte[] getPrimaryToken() {
        byte[] tokenCopy = (byte[])this.primaryToken.clone();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getPrimaryToken", tokenCopy);
        }
        return tokenCopy;
    }

    final byte[] getSecondaryToken() {
        byte[] tokenCopy = null;
        if (this.secondaryToken != null) {
            tokenCopy = (byte[])this.secondaryToken.clone();
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getSecondaryToken", tokenCopy);
        }
        return tokenCopy;
    }
}

