/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.LabelUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.TokenPair;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.SecretKey;

public final class SymmetricKeyUtils {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils";
    private static HexDumpEncoder encoder = null;
    private static final HIKM HIKM;

    static final String storeProtectedKeyInCKDS(SecretKey key, String requestedLabel) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(128L, className, "storeProtectedKeyInCKDS", key, requestedLabel);
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException("key is null");
            if (debug != null) {
                debug.exception(8192L, className, "storeProtectedKeyInCKDS", npe);
                debug.exit(256L, className, "storeProtectedKeyInCKDS");
            }
            throw npe;
        }
        if (!key.getFormat().equalsIgnoreCase("ICSFToken")) {
            InvalidKeyException ike = new InvalidKeyException("key is not a SECURE_INTERNAL_TOKEN key");
            if (debug != null) {
                debug.exception(8192L, className, "storeProtectedKeyInCKDS", ike);
                debug.exit(256L, className, "storeProtectedKeyInCKDS");
            }
            throw ike;
        }
        KRCFunction api = SymmetricKeyUtils.getKRCFunction(key);
        int numberOfTries = 1;
        byte[] protectedToken = key.getEncoded();
        byte[] returnLabel = null;
        JCECCARuntimeException krcException = null;
        if (requestedLabel == null) {
            numberOfTries = 3;
        }
        for (int tryCount = 0; tryCount < numberOfTries; ++tryCount) {
            returnLabel = null;
            krcException = null;
            try {
                returnLabel = SymmetricKeyUtils.keyRecordCreate(api, protectedToken, requestedLabel);
                break;
            }
            catch (JCECCARuntimeException jre) {
                krcException = jre;
                if (debug == null) continue;
                int returnCode = jre.getReturnCode();
                int reasonCode = jre.getReasonCode();
                String message = "Hardware error from call " + api.name();
                if (returnCode == 8 && (reasonCode == 16036 || reasonCode == 44)) {
                    message = message + ": key label already exists";
                }
                debug.text(Debug.TYPE_FINE, className, "storeProtectedKeyInCKDS", message + ". returnCode=" + returnCode + ", reasonCode=" + reasonCode + ". tryCount=" + tryCount + ", numberOfTries=" + numberOfTries);
                continue;
            }
        }
        if (krcException != null) {
            int returnCode = krcException.getReturnCode();
            int reasonCode = krcException.getReasonCode();
            if (returnCode == 8 && (reasonCode == 16036 || reasonCode == 44)) {
                krcException = new JCECCARuntimeException(1, api.name(), "Hardware error from call " + api.name() + ": key label already exists. returnCode=8 reasonCode=" + reasonCode + ". Retries exhausted.", returnCode, reasonCode);
            }
            if (debug != null) {
                debug.exception(8192L, className, "storeProtectedKeyInCKDS", krcException);
                debug.exit(256L, className, "storeProtectedKeyInCKDS");
            }
            throw krcException;
        }
        if (api == KRCFunction.CSNBKRC) {
            try {
                SymmetricKeyUtils.keyRecordWrite(protectedToken, returnLabel);
            }
            catch (RuntimeException rte) {
                block21: {
                    if (debug != null) {
                        debug.exception(8192L, className, "storeProtectedKeyInCKDS", rte);
                    }
                    try {
                        SymmetricKeyUtils.keyRecordDelete(KRDFunction.CSNBKRD, returnLabel);
                    }
                    catch (Exception ignore) {
                        if (debug == null) break block21;
                        debug.exception(8192L, className, "storeProtectedKeyInCKDS", ignore);
                    }
                }
                if (debug != null) {
                    debug.exit(256L, className, "storeProtectedKeyInCKDS");
                }
                throw rte;
            }
        }
        String stringLabel = PlatformUtilities.getString(returnLabel);
        if (debug != null) {
            debug.exit(256L, (Object)className, "storeProtectedKeyInCKDS", stringLabel);
        }
        return stringLabel;
    }

    static final void deleteCKDSEntry(SecretKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(128L, (Object)className, "deleteCKDSEntry", key);
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException("key is null");
            if (debug != null) {
                debug.exception(8192L, className, "deleteCKDSEntry", npe);
                debug.exit(256L, className, "deleteCKDSEntry");
            }
            throw npe;
        }
        if (!key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            InvalidKeyException ike = new InvalidKeyException("Only a CKDSLabel key has a CKDS label");
            if (debug != null) {
                debug.exception(8192L, className, "deleteCKDSEntry", ike);
                debug.exit(256L, className, "deleteCKDSEntry");
            }
            throw ike;
        }
        KRDFunction api = SymmetricKeyUtils.getKRDFunction(key);
        byte[] keyLabel = key.getEncoded();
        if (PlatformUtilities.isLinux()) {
            keyLabel = PlatformUtilities.convertBytesETOA(keyLabel);
        }
        try {
            SymmetricKeyUtils.keyRecordDelete(api, keyLabel);
        }
        catch (Exception e) {
            RuntimeException rte = new RuntimeException("Hardware error from call " + api.name() + ": " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "deleteCKDSEntry", rte);
                debug.exit(256L, className, "deleteCKDSEntry");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(256L, className, "deleteCKDSEntry");
        }
    }

    static final byte[] readCKDSEntry(SecretKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(128L, (Object)className, "readCKDSEntry", key);
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException("key is null");
            if (debug != null) {
                debug.exception(8192L, className, "readCKDSEntry", npe);
                debug.exit(256L, className, "readCKDSEntry");
            }
            throw npe;
        }
        if (!key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            InvalidKeyException ike = new InvalidKeyException("key is not a CKDS key");
            if (debug != null) {
                debug.exception(8192L, className, "readCKDSEntry", ike);
                debug.exit(256L, className, "readCKDSEntry");
            }
            throw ike;
        }
        KRRFunction api = SymmetricKeyUtils.getKRRFunction(key);
        byte[] keyLabel = key.getEncoded();
        byte[] keyToken = null;
        if (PlatformUtilities.isLinux()) {
            keyLabel = PlatformUtilities.convertBytesETOA(keyLabel);
        }
        try {
            keyToken = SymmetricKeyUtils.keyRecordRead(api, keyLabel);
        }
        catch (Exception e) {
            RuntimeException rte = new RuntimeException("Hardware error from call " + api.name() + ": " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "readCKDSEntry", rte);
                debug.exit(256L, className, "readCKDSEntry");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(256L, (Object)className, "readCKDSEntry", keyToken);
        }
        return keyToken;
    }

    private static final byte[] keyRecordCreate(KRCFunction api, byte[] token, String requestedLabel) {
        String exitDataString;
        String parmsReport;
        String labelString;
        NullPointerException npe;
        if (debug != null) {
            Object[] parms = new Object[]{api, token, requestedLabel};
            debug.entry(128L, (Object)className, "keyRecordCreate", parms);
        }
        if (api == null) {
            npe = new NullPointerException("api is null");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordCreate", npe);
                debug.exit(256L, className, "keyRecordCreate");
            }
            throw npe;
        }
        if (token == null) {
            npe = new NullPointerException("token is null");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordCreate", npe);
                debug.exit(256L, className, "keyRecordCreate");
            }
            throw npe;
        }
        if (requestedLabel != null && requestedLabel.length() > 64) {
            InvalidParameterException ipe = new InvalidParameterException("label exceeds maximum length of 64");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordCreate", ipe);
                debug.exit(256L, className, "keyRecordCreate");
            }
            throw ipe;
        }
        if (!HardwareProfile.getIsHCR7780OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("Creating key records require ICSF HCR7780 or later");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordCreate", uoe);
                debug.exit(256L, className, "keyRecordCreate");
            }
            throw uoe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(0);
        hikmNativeInteger keyTokenLength = new hikmNativeInteger(token.length);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = new byte[]{};
        byte[] keyLabel = null;
        if (requestedLabel != null && !requestedLabel.isEmpty()) {
            labelString = String.format("%-64s", requestedLabel.toUpperCase());
            keyLabel = PlatformUtilities.getBytesPlatform(labelString);
        } else {
            labelString = LabelUtils.genLabelName();
            keyLabel = PlatformUtilities.getBytesPlatform(labelString);
        }
        byte[] keyTokenCopy = (byte[])token.clone();
        if (debug != null) {
            parmsReport = null;
            exitDataString = encoder.encodeBuffer(exitData);
            String keyLabelString = "\n" + encoder.encodeBuffer(keyLabel);
            String keyTokenString = null;
            if (api == KRCFunction.CSNBKRC) {
                parmsReport = "\nSymmetricKeyUtils: CSNBKRC INPUT PARAMETERS\n    exitDataLength : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    keyLabel       : " + keyLabelString + "\n";
            } else {
                keyTokenString = "\n" + encoder.encodeBuffer(keyTokenCopy);
                parmsReport = "\nSymmetricKeyUtils: " + api.name() + " INPUT PARAMETERS\n    exitDataLength : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    keyLabel       : " + keyLabelString + "\n    keyTokenLength : " + keyTokenLength.getValue() + "\n    keyToken       : " + keyTokenString + "\n";
            }
            debug.text(Debug.TYPE_FINEST, className, "keyRecordCreate", parmsReport);
        }
        try {
            if (api == KRCFunction.CSNBKRC) {
                HIKM.CSNBKRCJ(returnCode, reasonCode, exitDataLength, exitData, keyLabel);
            } else if (api == KRCFunction.CSNBAKRC) {
                HIKM.CSNBAKRCJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyLabel, keyTokenLength, keyTokenCopy);
            } else {
                HIKM.CSNBKRC2(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyLabel, keyTokenLength, keyTokenCopy);
            }
        }
        catch (IllegalArgumentException e) {
            RuntimeException rte = new RuntimeException("Hardware error from call " + api.name() + ". " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordCreate", rte);
                debug.exit(256L, className, "keyRecordCreate");
            }
            throw rte;
        }
        if (debug != null) {
            parmsReport = null;
            exitDataString = encoder.encodeBuffer(exitData);
            String keyTokenString = null;
            if (api == KRCFunction.CSNBKRC) {
                parmsReport = "\nSymmetricKeyUtils: CSNBKRC RETURN PARAMETERS\n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLength : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n";
            } else {
                keyTokenString = "\n" + encoder.encodeBuffer(keyTokenCopy);
                parmsReport = "\nSymmetricKeyUtils: " + api.name() + " RETURN PARAMETERS\n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLength : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    keyToken       : " + keyTokenString + "\n";
            }
            debug.text(Debug.TYPE_FINEST, className, "keyRecordCreate", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyRecordCreate", api.name() + " returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        Arrays.fill(keyTokenCopy, (byte)0);
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, api.name(), "Hardware error from call " + api.name() + " returnCode=" + returnCode.getValue() + " reasonCode=" + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordCreate", re);
                debug.exit(256L, className, "keyRecordCreate");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(256L, (Object)className, "keyRecordCreate", keyLabel);
        }
        return keyLabel;
    }

    private static final void keyRecordWrite(byte[] keyToken, byte[] keyLabel) {
        String keyTokenString;
        String exitDataString;
        if (debug != null) {
            debug.entry(128L, className, "keyRecordWrite", keyToken, keyLabel);
        }
        if (keyToken == null) {
            NullPointerException npe = new NullPointerException("key token is null");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordWrite", npe);
                debug.exit(256L, className, "keyRecordWrite");
            }
            throw npe;
        }
        if (keyLabel == null) {
            NullPointerException npe = new NullPointerException("key label is null");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordWrite", npe);
                debug.exit(256L, className, "keyRecordWrite");
            }
            throw npe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] keyTokenCopy = (byte[])keyToken.clone();
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            keyTokenString = "\n" + encoder.encodeBuffer(keyTokenCopy);
            String keyLabelString = "\n" + encoder.encodeBuffer(keyLabel);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKRW INPUT PARAMETERS\n    exitDataLength : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    keyToken       : " + keyTokenString + "\n    ckdsLabel      : " + keyLabelString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyRecordWrite", parmsReport);
        }
        try {
            HIKM.CSNBKRWJ(returnCode, reasonCode, exitDataLength, exitData, keyTokenCopy, keyLabel);
        }
        catch (IllegalArgumentException e) {
            RuntimeException rte = new RuntimeException("Hardware error from call CSNBKRW. " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordWrite", rte);
                debug.exit(256L, className, "keyRecordWrite");
            }
            throw rte;
        }
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            keyTokenString = "\n" + encoder.encodeBuffer(keyTokenCopy);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKRW RETURN PARAMETERS\n    returnCode   : " + returnCode.getValue() + "\n    reasonCode   : " + reasonCode.getValue() + "\n    exitDataLen  : " + exitDataLength.getValue() + "\n    exitData     : " + exitDataString + "\n    keyToken     : " + keyTokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyRecordWrite", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyRecordWrite", "CSNBKRW returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        Arrays.fill(keyTokenCopy, (byte)0);
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBKRW", "Hardware error from call CSNBKRW returnCode=" + returnCode.getValue() + " reasonCode=" + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordWrite", re);
                debug.exit(256L, className, "keyRecordWrite");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(256L, className, "keyRecordWrite");
        }
    }

    private static final void keyRecordDelete(KRDFunction api, byte[] keyLabel) {
        String exitDataString;
        if (debug != null) {
            debug.entry(128L, className, "keyRecordDelete", (Object)api, keyLabel);
        }
        if (api == null) {
            NullPointerException npe = new NullPointerException("api is null");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordDelete", npe);
                debug.exit(256L, className, "keyRecordDelete");
            }
            throw npe;
        }
        if (keyLabel == null) {
            NullPointerException npe = new NullPointerException("key label is null");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordDelete", npe);
                debug.exit(256L, className, "keyRecordDelete");
            }
            throw npe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] ruleArray = PlatformUtilities.getBytesPlatform("LABEL-DL");
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        if (debug != null) {
            exitDataString = encoder.encodeBuffer(exitData);
            String keyLabelString = "\n" + encoder.encodeBuffer(keyLabel);
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String parmsReport = "\nSymmetricKeyUtils: " + api.name() + " INPUT PARAMETERS\n    exitDataLen    : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    keyLabel       : " + keyLabelString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyRecordDelete", parmsReport);
        }
        try {
            if (api == KRDFunction.CSNBKRD) {
                HIKM.CSNBKRDJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyLabel);
            } else {
                HIKM.CSNBAKRDJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyLabel);
            }
        }
        catch (IllegalArgumentException e) {
            RuntimeException rte = new RuntimeException("Hardware error from call " + api.name() + ". " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordDelete", rte);
                debug.exit(256L, className, "keyRecordDelete");
            }
            throw rte;
        }
        if (debug != null) {
            exitDataString = encoder.encodeBuffer(exitData);
            String parmsReport = "\nSymmetricKeyUtils: " + api.name() + " RETURN PARAMETERS\n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLen    : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyRecordDelete", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyRecordDelete", api.name() + " returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, api.name(), "CKDS entry not deleted. Hardware error from call " + api.name() + " returnCode=" + returnCode.getValue() + " reasonCode=" + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordDelete", re);
                debug.exit(256L, className, "keyRecordDelete");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(256L, className, "keyRecordDelete");
        }
    }

    private static final byte[] keyRecordRead(KRRFunction api, byte[] keyLabel) {
        String exitDataString;
        if (debug != null) {
            debug.entry(128L, (Object)className, "keyRecordRead", (Object)keyLabel);
        }
        if (api == null) {
            NullPointerException npe = new NullPointerException("api is null");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordRead", npe);
                debug.exit(256L, className, "keyRecordRead");
            }
            throw npe;
        }
        if (api == KRRFunction.CSNBKRR) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("The CSNBKRR function is currently not supported");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordRead", uoe);
                debug.exit(256L, className, "keyRecordRead");
            }
            throw uoe;
        }
        if (keyLabel == null) {
            NullPointerException npe = new NullPointerException("key label is null");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordRead", npe);
                debug.exit(256L, className, "keyRecordRead");
            }
            throw npe;
        }
        if (!HardwareProfile.getIsHCR7780OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("Reading key records require ICSF HCR7780 or later");
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordRead", uoe);
                debug.exit(256L, className, "keyRecordRead");
            }
            throw uoe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(0);
        hikmNativeInteger keyTokenLength = new hikmNativeInteger(725);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = new byte[]{};
        byte[] keyToken = new byte[keyTokenLength.getValue()];
        if (debug != null) {
            exitDataString = encoder.encodeBuffer(exitData);
            String keyLabelString = "\n" + encoder.encodeBuffer(keyLabel);
            String parmsReport = "\nSymmetricKeyUtils: " + api.name() + " INPUT PARAMETERS\n    exitDataLength : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    keyLabel       : " + keyLabelString + "\n    keyTokenLength : " + keyTokenLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyRecordRead", parmsReport);
        }
        try {
            if (api == KRRFunction.CSNBAKRR) {
                HIKM.CSNBAKRR(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyLabel, keyTokenLength, keyToken);
            } else {
                HIKM.CSNBKRR2(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyLabel, keyTokenLength, keyToken);
            }
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call " + api.name() + ". " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordRead", re);
                debug.exit(256L, className, "keyRecordRead");
            }
            throw re;
        }
        keyToken = SymmetricKeyUtils.trimSensitiveData(keyToken, keyTokenLength.getValue());
        if (debug != null) {
            exitDataString = encoder.encodeBuffer(exitData);
            String parmsReport = "\nSymmetricKeyUtils: " + api.name() + " RETURN PARAMETERS\n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLength : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    keyTokenLength : " + keyTokenLength.getValue() + "\n    keyToken       : XXX\n";
            debug.text(Debug.TYPE_FINEST, className, "keyRecordRead", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyRecordRead", api.name() + " returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, api.name(), "Hardware error from call " + api.name() + " returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "keyRecordRead", re);
                debug.exit(256L, className, "keyRecordRead");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(256L, (Object)className, "keyRecordRead", keyToken);
        }
        return keyToken;
    }

    static final byte[] generateSymmetricDESSkeletonToken(int keysize, byte keyTokenWrapMode) {
        String keyTokenString;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "generateSymmetricDESSkeletonToken");
        }
        if (PlatformUtilities.isLinux()) {
            byte[] skeletonToken = SymmetricKeyUtils.buildDESDataSkeletonToken(keysize, keyTokenWrapMode);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateSymmetricDESSkeletonToken", skeletonToken);
            }
            return skeletonToken;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] keyToken = new byte[64];
        byte[] keyValue = null;
        hikmNativeInteger masterKeyVersionNumber = new hikmNativeInteger(0);
        hikmNativeInteger keyRegisterNumber = new hikmNativeInteger(0);
        byte[] tokenData1 = new byte[8];
        byte[] controlVector = new byte[]{};
        byte[] initializationVector = new byte[8];
        hikmNativeInteger padCharacter = new hikmNativeInteger(0);
        byte[] masterKeyVerificationPattern = new byte[]{};
        byte[] cryptographicPeriodStart = null;
        cryptographicPeriodStart = PlatformUtilities.getBytesPlatform("        ");
        byte[] keyType = PlatformUtilities.getBytesPlatform("DATA    ");
        String ruleArrayBuilder = "DES     INTERNAL";
        int ruleArrayNum = 2;
        if (keysize == 168) {
            ruleArrayBuilder = ruleArrayBuilder + "KEYLN24 ";
            ++ruleArrayNum;
            keyValue = new byte[24];
        } else if (keysize == 112) {
            ruleArrayBuilder = ruleArrayBuilder + "KEYLN16 ";
            ++ruleArrayNum;
            keyValue = new byte[16];
        } else if (keysize == 56) {
            ruleArrayBuilder = ruleArrayBuilder + "KEYLN8  ";
            ++ruleArrayNum;
            keyValue = new byte[8];
        } else {
            InvalidParameterException e = new InvalidParameterException("Wrong keysize: must be equal to 56, 112, or 168.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateSymmetricDESSkeletonToken", e);
                debug.exit(Debug.TYPE_PUBLIC, className, "generateSymmetricDESSkeletonToken");
            }
            throw e;
        }
        if (keyTokenWrapMode != 10) {
            if (keyTokenWrapMode == 12) {
                ruleArrayBuilder = ruleArrayBuilder + "WRAP-ENH";
                ++ruleArrayNum;
            } else if (keyTokenWrapMode == 11) {
                ruleArrayBuilder = ruleArrayBuilder + "WRAP-ECB";
                ++ruleArrayNum;
            } else {
                RuntimeException e = new RuntimeException("Unrecognized token wrapping mode.");
                if (null != debug) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "generateSymmetricDESSkeletonToken", e);
                    debug.exit(Debug.TYPE_PUBLIC, className, "generateSymmetricDESSkeletonToken");
                }
                throw e;
            }
        }
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayBuilder);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(ruleArrayNum);
        if (null != debug) {
            keyTokenString = "NULL";
            if (null != keyToken) {
                keyTokenString = encoder.encodeBuffer(keyToken);
            }
            String keyTypeString = "NULL";
            if (null != keyType) {
                keyTypeString = encoder.encodeBuffer(keyType);
            }
            String ruleArrayString = "NULL";
            if (null != ruleArray) {
                ruleArrayString = encoder.encodeBuffer(ruleArray);
            }
            String keyValueString = "NULL";
            if (null != keyValue) {
                keyValueString = encoder.encodeBuffer(keyValue);
            }
            String tokenData1String = "NULL";
            if (null != tokenData1) {
                tokenData1String = encoder.encodeBuffer(tokenData1);
            }
            String controlVectorString = "NULL";
            if (null != controlVector) {
                controlVectorString = encoder.encodeBuffer(controlVector);
            }
            String cryptographicPeriodStartString = "NULL";
            if (null != cryptographicPeriodStart) {
                cryptographicPeriodStartString = encoder.encodeBuffer(cryptographicPeriodStart);
            }
            String masterKeyVerificationPatternString = "NULL";
            if (null != masterKeyVerificationPattern) {
                masterKeyVerificationPatternString = encoder.encodeBuffer(masterKeyVerificationPattern);
            }
            String parmsReport = "\nDESKeyGenerator: CSNBKTB INPUT PARAMETERS \n    returnCode                   : " + returnCode.getValue() + "\n    reasonCode                   : " + reasonCode.getValue() + "\n    keyToken                     : \n" + keyTokenString + "\n    keyType                      : \n" + keyTypeString + "\n    ruleArrayCount               : " + ruleArrayCount.getValue() + "\n    ruleArray                    : \n" + ruleArrayString + "\n    keyValue                     : \n" + keyValueString + "\n    masterKeyVersionNumber       : " + masterKeyVersionNumber.getValue() + "\n    tokenData1                   : " + tokenData1String + "\n    controlVector                : \n" + controlVectorString + "\n    padCharacter                 : " + padCharacter.getValue() + "\n    cryptographicPeriodStart     : " + cryptographicPeriodStartString + "\n    masterKeyVerificationPattern : " + masterKeyVerificationPatternString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateSymmetricDESSkeletonToken", parmsReport);
        }
        HIKM.CSNBKTB(returnCode, reasonCode, exitDataLength, exitData, keyToken, keyType, ruleArrayCount, ruleArray, keyValue, masterKeyVersionNumber, keyRegisterNumber, tokenData1, controlVector, initializationVector, padCharacter, cryptographicPeriodStart, masterKeyVerificationPattern);
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "generateSymmetricDESSkeletonToken", "CSNBKTB: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (null != debug) {
            keyTokenString = "NULL";
            if (null != keyToken) {
                keyTokenString = encoder.encodeBuffer(keyToken);
            }
            String parmsReport = "\nDESKeyGenerator: CSNBKTB RETURN PARAMETERS \n    returnCode                   : " + returnCode.getValue() + "\n    reasonCode                   : " + reasonCode.getValue() + "\n    keyToken                     : \n" + keyTokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateSymmetricDESSkeletonToken", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException jre = new JCECCARuntimeException(1, "CSNBKTB", "Hardware error from call CSNBKTB returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateSymmetricDESSkeletonToken", jre);
                debug.exit(Debug.TYPE_PUBLIC, className, "generateSymmetricDESSkeletonToken");
            }
            throw jre;
        }
        if (null != debug) {
            String keyTokenReturnString = "NULL";
            if (null != keyToken) {
                keyTokenReturnString = encoder.encodeBuffer(keyToken);
            }
            String returnValueString = "\n" + keyTokenReturnString + "\n";
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateSymmetricDESSkeletonToken", returnValueString);
        }
        return keyToken;
    }

    private static byte[] buildDESDataSkeletonToken(int keysize, byte keyTokenWrapMode) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "buildDESDataSkeletonToken", keysize, keyTokenWrapMode);
        }
        if (keyTokenWrapMode == 10) {
            keyTokenWrapMode = (byte)12;
        }
        if (keyTokenWrapMode != 11 && keyTokenWrapMode != 12) {
            InvalidParameterException e = new InvalidParameterException("Unrecognized token wrapping mode.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "buildDESDataSkeletonToken", e);
                debug.exit(Debug.TYPE_PUBLIC, className, "buildDESDataSkeletonToken");
            }
            throw e;
        }
        byte[] skeleton = null;
        if (keysize == 56) {
            skeleton = keyTokenWrapMode == 12 ? SymmetricKeyConstants.DESDataSkeleton.KEYLN8_WRAP_CBC.token() : SymmetricKeyConstants.DESDataSkeleton.KEYLN8_WRAP_ECB.token();
        } else if (keysize == 112) {
            skeleton = keyTokenWrapMode == 12 ? SymmetricKeyConstants.DESDataSkeleton.KEYLN16_WRAP_CBC.token() : SymmetricKeyConstants.DESDataSkeleton.KEYLN16_WRAP_ECB.token();
        } else if (keysize == 168) {
            skeleton = keyTokenWrapMode == 12 ? SymmetricKeyConstants.DESDataSkeleton.KEYLN24_WRAP_CBC.token() : SymmetricKeyConstants.DESDataSkeleton.KEYLN24_WRAP_ECB.token();
        } else {
            InvalidParameterException e = new InvalidParameterException("Wrong keysize: must be equal to 56, 112, or 168.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "buildDESDataSkeletonToken", e);
                debug.exit(Debug.TYPE_PUBLIC, className, "buildDESDataSkeletonToken");
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "buildDESDataSkeletonToken", skeleton);
        }
        return skeleton;
    }

    private static final KRCFunction getKRCFunction(Key key) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getKRCFunction", key);
        }
        if (SymmetricKeyUtils.isAESorHMAConLinux(key)) {
            if (null != debug) {
                debug.exit(8192L, (Object)className, "getKRCFunction", (Object)KRCFunction.CSNBAKRC);
            }
            return KRCFunction.CSNBAKRC;
        }
        if (PlatformUtilities.isLinux()) {
            if (null != debug) {
                debug.exit(8192L, (Object)className, "getKRCFunction", (Object)KRCFunction.CSNBKRC);
            }
            return KRCFunction.CSNBKRC;
        }
        if (null != debug) {
            debug.exit(8192L, (Object)className, "getKRCFunction", (Object)KRCFunction.CSNBKRC2);
        }
        return KRCFunction.CSNBKRC2;
    }

    private static final KRDFunction getKRDFunction(Key key) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getKRDFunction", key);
        }
        if (SymmetricKeyUtils.isAESorHMAConLinux(key)) {
            if (null != debug) {
                debug.exit(8192L, (Object)className, "getKRDFunction", (Object)KRDFunction.CSNBAKRD);
            }
            return KRDFunction.CSNBAKRD;
        }
        if (null != debug) {
            debug.exit(8192L, (Object)className, "getKRDFunction", (Object)KRDFunction.CSNBKRD);
        }
        return KRDFunction.CSNBKRD;
    }

    private static final KRRFunction getKRRFunction(Key key) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getKRRFunction", key);
        }
        if (SymmetricKeyUtils.isAESorHMAConLinux(key)) {
            if (null != debug) {
                debug.exit(8192L, (Object)className, "getKRRFunction", (Object)KRRFunction.CSNBAKRR);
            }
            return KRRFunction.CSNBAKRR;
        }
        if (PlatformUtilities.isLinux()) {
            if (null != debug) {
                debug.exit(8192L, (Object)className, "getKRRFunction", (Object)KRRFunction.CSNBKRR);
            }
            return KRRFunction.CSNBKRR;
        }
        if (null != debug) {
            debug.exit(8192L, (Object)className, "getKRRFunction", (Object)KRRFunction.CSNBKRR2);
        }
        return KRRFunction.CSNBKRR2;
    }

    private static final boolean isAESorHMAConLinux(Key key) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "isAESorHMAConLinux", key);
        }
        if (PlatformUtilities.isLinux() && key.getAlgorithm().equalsIgnoreCase("AES")) {
            if (null != debug) {
                debug.exit(8192L, (Object)className, "isAESorHMAConLinux", true);
            }
            return true;
        }
        if (PlatformUtilities.isLinux() && key.getAlgorithm().toUpperCase().startsWith("HMAC")) {
            if (null != debug) {
                debug.exit(8192L, (Object)className, "isAESorHMAConLinux", true);
            }
            return true;
        }
        if (null != debug) {
            debug.exit(8192L, (Object)className, "isAESorHMAConLinux", false);
        }
        return false;
    }

    static final byte[] keyTokenBuild(String keyTypeString, int ruleArrayCount, String ruleArrayString) {
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{keyTypeString, ruleArrayCount, ruleArrayString};
            debug.entry(128L, (Object)className, "keyTokenBuild", parms);
        }
        if (keyTypeString == null || ruleArrayString == null) {
            NullPointerException npe = new NullPointerException("One or more parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild");
            }
            throw npe;
        }
        if (keyTypeString.length() != 8) {
            ipe = new InvalidParameterException("keyType length must be 8");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild");
            }
            throw ipe;
        }
        if (8 * ruleArrayCount != ruleArrayString.length()) {
            ipe = new InvalidParameterException("ruleArrayCount does not match the number of keywords in ruleArray");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild");
            }
            throw ipe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger nativeRuleArrayCount = new hikmNativeInteger(ruleArrayCount);
        hikmNativeInteger masterKeyVersionNumber = new hikmNativeInteger(0);
        hikmNativeInteger keyRegisterNumber = new hikmNativeInteger(0);
        hikmNativeInteger padCharacter = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] keyToken = new byte[64];
        byte[] keyType = PlatformUtilities.getBytesPlatform(keyTypeString);
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayString);
        byte[] keyValue = new byte[]{};
        byte[] tokenData1 = new byte[8];
        byte[] controlVector = new byte[]{};
        byte[] initializationVector = new byte[8];
        byte[] masterKeyVerificationPattern = new byte[]{};
        byte[] cryptographicPeriodStart = PlatformUtilities.getBytesPlatform("        ");
        if (null != debug) {
            String keyTypeEncoded = encoder.encodeBuffer(keyType);
            String ruleArrayEncoded = encoder.encodeBuffer(ruleArray);
            String tokenData1String = encoder.encodeBuffer(tokenData1);
            String controlVectorString = encoder.encodeBuffer(controlVector);
            String masterKeyVerificationPatternString = encoder.encodeBuffer(masterKeyVerificationPattern);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKTB INPUT PARAMETERS\n    exitDataLength               : " + exitDataLength.getValue() + "\n    keyType                      : " + keyTypeEncoded + "\n    ruleArrayCount               : " + nativeRuleArrayCount.getValue() + "\n    ruleArray                    : " + ruleArrayEncoded + "\n    keyValue                     : XXX\n    masterKeyVersionNumber       : " + masterKeyVersionNumber.getValue() + "\n    tokenData1                   : " + tokenData1String + "\n    controlVector                : " + controlVectorString + "\n    padCharacter                 : " + padCharacter.getValue() + "\n    masterKeyVerificationPattern : " + masterKeyVerificationPatternString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyTokenBuild", parmsReport);
        }
        try {
            HIKM.CSNBKTB(returnCode, reasonCode, exitDataLength, exitData, keyToken, keyType, nativeRuleArrayCount, ruleArray, keyValue, masterKeyVersionNumber, keyRegisterNumber, tokenData1, controlVector, initializationVector, padCharacter, cryptographicPeriodStart, masterKeyVerificationPattern);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNBKTB " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild");
            }
            throw re;
        }
        if (null != debug) {
            String parmsReport = "\nSymmetricKeyUtils: CSNBKTB OUTPUT PARAMETERS \n    returnCode : " + returnCode.getValue() + "\n    reasonCode : " + reasonCode.getValue() + "\n    keyToken   : XXX\n";
            debug.text(Debug.TYPE_FINEST, className, "keyTokenBuild", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyTokenBuild", "CSNBKTB returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBKTB", "Hardware error from call CSNBKTB returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(256L, (Object)className, "keyTokenBuild", keyToken);
        }
        return keyToken;
    }

    static final byte[] keyTokenBuild2(int ruleArrayCount, String ruleArrayString) {
        if (debug != null) {
            Object[] parms = new Object[]{ruleArrayCount, ruleArrayString};
            debug.entry(128L, (Object)className, "keyTokenBuild2", parms);
        }
        if (ruleArrayString == null) {
            NullPointerException npe = new NullPointerException("ruleArrayString is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild2", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild2");
            }
            throw npe;
        }
        if (8 * ruleArrayCount != ruleArrayString.length()) {
            InvalidParameterException ipe = new InvalidParameterException("ruleArrayCount does not match the number of keywords in ruleArray");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild2");
            }
            throw ipe;
        }
        if (!HardwareProfile.getIsHCR7780OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("System Error: Key Token Build2 is only supported on HCR7780 or later versions.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild2", uoe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild2");
            }
            throw uoe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger nativeRuleArrayCount = new hikmNativeInteger(ruleArrayCount);
        hikmNativeInteger clearKeyBitLength = new hikmNativeInteger(0);
        hikmNativeInteger keyNameLength = new hikmNativeInteger(0);
        hikmNativeInteger userAssociatedDataLength = new hikmNativeInteger(0);
        hikmNativeInteger tokenDataLength = new hikmNativeInteger(0);
        hikmNativeInteger reservedLength = new hikmNativeInteger(0);
        hikmNativeInteger targetKeyTokenLength = new hikmNativeInteger(725);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayString);
        byte[] clearKeyValue = new byte[]{};
        byte[] keyName = new byte[]{};
        byte[] userAssociatedData = new byte[]{};
        byte[] tokenData = new byte[]{};
        byte[] reserved = new byte[]{};
        byte[] targetKeyToken = new byte[725];
        if (null != debug) {
            String ruleArrayEncoded = encoder.encodeBuffer(ruleArray);
            String keyNameString = encoder.encodeBuffer(keyName);
            String userAssociatedDataString = encoder.encodeBuffer(userAssociatedData);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKTB2 INPUT PARAMETERS \n    exitDataLength           : " + exitDataLength.getValue() + "\n    ruleArrayCount           : " + nativeRuleArrayCount.getValue() + "\n    ruleArray                : " + ruleArrayEncoded + "\n    clearKeyBitLength        : " + clearKeyBitLength.getValue() + "\n    clearKeyValue            : XXX\n    keyNameLength            : " + keyNameLength.getValue() + "\n    keyName                  : " + keyNameString + "\n    userAssociatedDataLength : " + userAssociatedDataLength.getValue() + "\n    userAssociatedData       : " + userAssociatedDataString + "\n    tokenDataLength          : " + tokenDataLength.getValue() + "\n    reservedLength           : " + reservedLength.getValue() + "\n    targetKeyTokenLength     : " + targetKeyTokenLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyTokenBuild2", parmsReport);
        }
        try {
            HIKM.CSNBKTB2(returnCode, reasonCode, exitDataLength, exitData, nativeRuleArrayCount, ruleArray, clearKeyBitLength, clearKeyValue, keyNameLength, keyName, userAssociatedDataLength, userAssociatedData, tokenDataLength, tokenData, reservedLength, reserved, targetKeyTokenLength, targetKeyToken);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNBKTB2 " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild2", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild2");
            }
            throw re;
        }
        targetKeyToken = SymmetricKeyUtils.trimSensitiveData(targetKeyToken, targetKeyTokenLength.getValue());
        if (null != debug) {
            String parmsReport = "\nSymmetricKeyUtils: CSNBKTB2 OUTPUT PARAMETERS \n    returnCode           : " + returnCode.getValue() + "\n    reasonCode           : " + reasonCode.getValue() + "\n    targetKeyTokenLength : " + targetKeyTokenLength.getValue() + "\n    targetKeyToken       : XXX\n";
            debug.text(Debug.TYPE_FINEST, className, "keyTokenBuild2", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyTokenBuild2", "CSNBKTB2 returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBKTB2", "Hardware error from call CSNBKTB2 returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTokenBuild2", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTokenBuild2");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(256L, (Object)className, "keyTokenBuild2", targetKeyToken);
        }
        return targetKeyToken;
    }

    static final TokenPair keyGenerate(String keyFormString, String keyLengthString, String keyType1String, String keyType2String, byte[] kekKeyIdentifier1, byte[] kekKeyIdentifier2, byte[] generatedKeyIdentifier1, byte[] generatedKeyIdentifier2) {
        RuntimeException re;
        String exitDataString;
        byte[] generatedKeyIdentifier2Copy;
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{keyFormString, keyLengthString, keyType1String, keyType2String, kekKeyIdentifier1, kekKeyIdentifier2, generatedKeyIdentifier1, generatedKeyIdentifier2};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "keyGenerate", parms);
        }
        if (keyFormString == null || keyLengthString == null || keyType1String == null) {
            NullPointerException npe = new NullPointerException("One or more required parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate");
            }
            throw npe;
        }
        if (keyFormString.length() != 4) {
            ipe = new InvalidParameterException("keyForm must be exactly 4 characters long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate");
            }
            throw ipe;
        }
        if (keyLengthString.length() != 8) {
            ipe = new InvalidParameterException("keyLength must be exactly 8 characters long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate");
            }
            throw ipe;
        }
        if (keyType1String.length() != 8 || keyType2String != null && keyType2String.length() != 8) {
            ipe = new InvalidParameterException("keyType1 and keyType2 must be exactly 8 characters long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate");
            }
            throw ipe;
        }
        if (kekKeyIdentifier1 != null && kekKeyIdentifier1.length != 64 || kekKeyIdentifier2 != null && kekKeyIdentifier2.length != 64) {
            ipe = new InvalidParameterException("If specified, kekKeyIdentifier1 and kekKeyIdentifier2 must be exactly 64 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate");
            }
            throw ipe;
        }
        if (generatedKeyIdentifier1 != null && generatedKeyIdentifier1.length != 64 || generatedKeyIdentifier2 != null && generatedKeyIdentifier2.length != 64) {
            ipe = new InvalidParameterException("If specified, generatedKeyIdentifier1 and generatedKeyIdentifier2 must be exactly 64 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate");
            }
            throw ipe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] keyForm = PlatformUtilities.getBytesPlatform(keyFormString);
        byte[] keyLength = PlatformUtilities.getBytesPlatform(keyLengthString);
        byte[] keyType1 = PlatformUtilities.getBytesPlatform(keyType1String);
        byte[] keyType2 = new byte[]{};
        if (keyType2String != null) {
            keyType2 = PlatformUtilities.getBytesPlatform(keyType2String);
        }
        byte[] kekKeyIdentifier1Copy = kekKeyIdentifier1 == null ? new byte[64] : (byte[])kekKeyIdentifier1.clone();
        byte[] kekKeyIdentifier2Copy = kekKeyIdentifier2 == null ? new byte[64] : (byte[])kekKeyIdentifier2.clone();
        byte[] generatedKeyIdentifier1Copy = generatedKeyIdentifier1 == null ? new byte[64] : (byte[])generatedKeyIdentifier1.clone();
        byte[] byArray = generatedKeyIdentifier2Copy = generatedKeyIdentifier2 == null ? new byte[64] : (byte[])generatedKeyIdentifier2.clone();
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String keyFormEncoded = encoder.encodeBuffer(keyForm);
            String keyLengthEncoded = encoder.encodeBuffer(keyLength);
            String keyType1Encoded = encoder.encodeBuffer(keyType1);
            String keyType2Encoded = encoder.encodeBuffer(keyType2);
            String kekKeyIdentifier1String = "\n" + encoder.encodeBuffer(kekKeyIdentifier1Copy);
            String kekKeyIdentifier2String = "\n" + encoder.encodeBuffer(kekKeyIdentifier2Copy);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKGN INPUT PARAMETERS\n    exitDataLength          : " + exitDataLength.getValue() + "\n    exitData                : " + exitDataString + "\n    keyForm                 : " + keyFormEncoded + "\n    keyLength               : " + keyLengthEncoded + "\n    keyType1                : " + keyType1Encoded + "\n    keyType2                : " + keyType2Encoded + "\n    kekKeyIdentifier1       : " + kekKeyIdentifier1String + "\n    kekKeyIdentifier2       : " + kekKeyIdentifier2String + "\n    generatedKeyIdentifier1 : XXX\n    generatedKeyIdentifier2 : XXX\n";
            debug.text(Debug.TYPE_FINEST, className, "keyGenerate", parmsReport);
        }
        try {
            HIKM.CSNBKGNJ(returnCode, reasonCode, exitDataLength, exitData, keyForm, keyLength, keyType1, keyType2, kekKeyIdentifier1Copy, kekKeyIdentifier2Copy, generatedKeyIdentifier1Copy, generatedKeyIdentifier2Copy);
        }
        catch (IllegalArgumentException e) {
            re = new RuntimeException("Hardware error from call CSNBKGN " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate");
            }
            throw re;
        }
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String kekKeyIdentifier1String = "\n" + encoder.encodeBuffer(kekKeyIdentifier1Copy);
            String kekKeyIdentifier2String = "\n" + encoder.encodeBuffer(kekKeyIdentifier2Copy);
            String generatedKeyIdentifier1String = "\n" + encoder.encodeBuffer(generatedKeyIdentifier1Copy);
            String generatedKeyIdentifier2String = "\n" + encoder.encodeBuffer(generatedKeyIdentifier2Copy);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKGN RETURN PARAMETERS\n    returnCode              : " + returnCode.getValue() + "\n    reasonCode              : " + reasonCode.getValue() + "\n    exitDataLength          : " + exitDataLength.getValue() + "\n    exitData                : " + exitDataString + "\n    kekKeyIdentifier1       : " + kekKeyIdentifier1String + "\n    kekKeyIdentifier2       : " + kekKeyIdentifier2String + "\n    generatedKeyIdentifier1 : " + generatedKeyIdentifier1String + "\n    generatedKeyIdentifier2 : " + generatedKeyIdentifier2String + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyGenerate", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyGenerate", "CSNBKGN returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        TokenPair result = new TokenPair(generatedKeyIdentifier1Copy, generatedKeyIdentifier2Copy);
        Arrays.fill(kekKeyIdentifier1Copy, (byte)0);
        Arrays.fill(kekKeyIdentifier2Copy, (byte)0);
        Arrays.fill(generatedKeyIdentifier1Copy, (byte)0);
        Arrays.fill(generatedKeyIdentifier2Copy, (byte)0);
        if (returnCode.getValue() != 0) {
            re = new JCECCARuntimeException(1, "CSNBKGN", "Hardware error from call CSNBKGN returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "keyGenerate", result);
        }
        return result;
    }

    static final TokenPair keyGenerate2(int ruleArrayCount, String ruleArrayString, int clearKeyBitLength, String keyType1String, String keyType2String, byte[] kekIdentifier1, byte[] kekIdentifier2) {
        RuntimeException re;
        String exitDataString;
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{ruleArrayCount, ruleArrayString, clearKeyBitLength, keyType1String, keyType2String, kekIdentifier1, kekIdentifier2};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "keyGenerate2", parms);
        }
        if (ruleArrayString == null || keyType1String == null) {
            NullPointerException npe = new NullPointerException("One or more required parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate2", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate2");
            }
            throw npe;
        }
        if (8 * ruleArrayCount != ruleArrayString.length()) {
            ipe = new InvalidParameterException("ruleArrayCount does not match the number of keywords in ruleArray");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate2");
            }
            throw ipe;
        }
        if (keyType1String.length() != 8 || keyType2String != null && keyType2String.length() != 8) {
            ipe = new InvalidParameterException("keyType1 and keyType2 (if specified) length must be 8");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate2");
            }
            throw ipe;
        }
        if (kekIdentifier1 != null && kekIdentifier1.length > 725 || kekIdentifier2 != null && kekIdentifier2.length > 725) {
            ipe = new InvalidParameterException("If specified, kekIdentifier1 and kekIdentifier2 cannot be more than 725 bytes");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate2");
            }
            throw ipe;
        }
        if (!HardwareProfile.getIsHCR7780OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("System Error: Key Generate2 is only supported on HCR7780 or later versions.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate2", uoe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate2");
            }
            throw uoe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger nativeRuleArrayCount = new hikmNativeInteger(ruleArrayCount);
        hikmNativeInteger nativeClearKeyBitLength = new hikmNativeInteger(clearKeyBitLength);
        hikmNativeInteger keyName1Length = new hikmNativeInteger(0);
        hikmNativeInteger keyName2Length = new hikmNativeInteger(0);
        hikmNativeInteger userAssociatedData1Length = new hikmNativeInteger(0);
        hikmNativeInteger userAssociatedData2Length = new hikmNativeInteger(0);
        hikmNativeInteger generatedKeyIdentifier1Length = new hikmNativeInteger(900);
        hikmNativeInteger generatedKeyIdentifier2Length = new hikmNativeInteger(900);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayString);
        byte[] keyType1 = PlatformUtilities.getBytesPlatform(keyType1String);
        byte[] keyType2 = new byte[]{};
        if (keyType2String != null) {
            keyType2 = PlatformUtilities.getBytesPlatform(keyType2String);
        }
        byte[] keyName1 = new byte[]{};
        byte[] keyName2 = new byte[]{};
        byte[] userAssociatedData1 = new byte[]{};
        byte[] userAssociatedData2 = new byte[]{};
        byte[] generatedKeyIdentifier1 = new byte[900];
        byte[] generatedKeyIdentifier2 = new byte[900];
        byte[] keyEncryptingKeyIdentifier1Copy = kekIdentifier1 == null ? new byte[]{} : (byte[])kekIdentifier1.clone();
        byte[] keyEncryptingKeyIdentifier2Copy = kekIdentifier2 == null ? new byte[]{} : (byte[])kekIdentifier2.clone();
        hikmNativeInteger keyEncryptingKeyIdentifier1Length = new hikmNativeInteger(keyEncryptingKeyIdentifier1Copy.length);
        hikmNativeInteger keyEncryptingKeyIdentifier2Length = new hikmNativeInteger(keyEncryptingKeyIdentifier2Copy.length);
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String ruleArrayEncoded = encoder.encodeBuffer(ruleArray);
            String keyType1Encoded = encoder.encodeBuffer(keyType1);
            String keyType2Encoded = encoder.encodeBuffer(keyType2);
            String keyName1String = encoder.encodeBuffer(keyName1);
            String keyName2String = encoder.encodeBuffer(keyName2);
            String userAssociatedData1String = encoder.encodeBuffer(userAssociatedData1);
            String userAssociatedData2String = encoder.encodeBuffer(userAssociatedData2);
            String keyEncryptingKeyIdentifier1String = "\n" + encoder.encodeBuffer(keyEncryptingKeyIdentifier1Copy);
            String keyEncryptingKeyIdentifier2String = "\n" + encoder.encodeBuffer(keyEncryptingKeyIdentifier2Copy);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKGN2 INPUT PARAMETERS\n    exitDataLength                    : " + exitDataLength.getValue() + "\n    exitData                          : " + exitDataString + "\n    ruleArrayCount                    : " + nativeRuleArrayCount.getValue() + "\n    ruleArray                         : " + ruleArrayEncoded + "\n    clearKeyBitLength                 : " + nativeClearKeyBitLength.getValue() + "\n    keyType1                          : " + keyType1Encoded + "\n    keyType2                          : " + keyType2Encoded + "\n    keyName1Length                    : " + keyName1Length.getValue() + "\n    keyName1                          : " + keyName1String + "\n    keyName2Length                    : " + keyName2Length.getValue() + "\n    keyName2                          : " + keyName2String + "\n    userAssociatedData1Length         : " + userAssociatedData1Length.getValue() + "\n    userAssociatedData1               : " + userAssociatedData1String + "\n    userAssociatedData2Length         : " + userAssociatedData2Length.getValue() + "\n    userAssociatedData2               : " + userAssociatedData2String + "\n    keyEncryptingKeyIdentifier1Length : " + keyEncryptingKeyIdentifier1Length.getValue() + "\n    keyEncryptingKeyIdentifier1       : " + keyEncryptingKeyIdentifier1String + "\n    keyEncryptingKeyIdentifier2Length : " + keyEncryptingKeyIdentifier2Length.getValue() + "\n    keyEncryptingKeyIdentifier2       : " + keyEncryptingKeyIdentifier2String + "\n    generatedKeyIdentifier1Length     : " + generatedKeyIdentifier1Length.getValue() + "\n    generatedKeyIdentifier1           : XXX\n    generatedKeyIdentifier2Length     : " + generatedKeyIdentifier2Length.getValue() + "\n    generatedKeyIdentifier2           : XXX\n";
            debug.text(Debug.TYPE_FINEST, className, "keyGenerate2", parmsReport);
        }
        try {
            HIKM.CSNBKGN2(returnCode, reasonCode, exitDataLength, exitData, nativeRuleArrayCount, ruleArray, nativeClearKeyBitLength, keyType1, keyType2, keyName1Length, keyName1, keyName2Length, keyName2, userAssociatedData1Length, userAssociatedData1, userAssociatedData2Length, userAssociatedData2, keyEncryptingKeyIdentifier1Length, keyEncryptingKeyIdentifier1Copy, keyEncryptingKeyIdentifier2Length, keyEncryptingKeyIdentifier2Copy, generatedKeyIdentifier1Length, generatedKeyIdentifier1, generatedKeyIdentifier2Length, generatedKeyIdentifier2);
        }
        catch (IllegalArgumentException e) {
            re = new RuntimeException("Hardware error from call CSNBKGN2 " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate2", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate2");
            }
            throw re;
        }
        generatedKeyIdentifier1 = SymmetricKeyUtils.trimSensitiveData(generatedKeyIdentifier1, generatedKeyIdentifier1Length.getValue());
        generatedKeyIdentifier2 = SymmetricKeyUtils.trimSensitiveData(generatedKeyIdentifier2, generatedKeyIdentifier2Length.getValue());
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String keyEncryptingKeyIdentifier1String = "\n" + encoder.encodeBuffer(keyEncryptingKeyIdentifier1Copy);
            String keyEncryptingKeyIdentifier2String = "\n" + encoder.encodeBuffer(keyEncryptingKeyIdentifier2Copy);
            String generatedKeyIdentifier1String = "\n" + encoder.encodeBuffer(generatedKeyIdentifier1);
            String generatedKeyIdentifier2String = "\n" + encoder.encodeBuffer(generatedKeyIdentifier2);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKGN2 RETURN PARAMETERS\n    returnCode                        : " + returnCode.getValue() + "\n    reasonCode                        : " + reasonCode.getValue() + "\n    exitDataLength                    : " + exitDataLength.getValue() + "\n    exitData                          : " + exitDataString + "\n    keyEncryptingKeyIdentifier1       : " + keyEncryptingKeyIdentifier1String + "\n    keyEncryptingKeyIdentifier2       : " + keyEncryptingKeyIdentifier2String + "\n    generatedKeyIdentifier1Length     : " + generatedKeyIdentifier1Length.getValue() + "\n    generatedKeyIdentifier1           : " + generatedKeyIdentifier1String + "\n    generatedKeyIdentifier2Length     : " + generatedKeyIdentifier2Length.getValue() + "\n    generatedKeyIdentifier2           : " + generatedKeyIdentifier2String + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyGenerate2", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyGenerate2", "CSNBKGN2 returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        TokenPair result = new TokenPair(generatedKeyIdentifier1, generatedKeyIdentifier2);
        Arrays.fill(keyEncryptingKeyIdentifier1Copy, (byte)0);
        Arrays.fill(keyEncryptingKeyIdentifier2Copy, (byte)0);
        Arrays.fill(generatedKeyIdentifier1, (byte)0);
        Arrays.fill(generatedKeyIdentifier2, (byte)0);
        if (returnCode.getValue() != 0) {
            re = new JCECCARuntimeException(1, "CSNBKGN2", "Hardware error from call CSNBKGN2 returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyGenerate2", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyGenerate2");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "keyGenerate2", result);
        }
        return result;
    }

    static final byte[] keyExport(String keyTypeString, byte[] sourceKeyIdentifier, byte[] exporterKeyIdentifier) {
        String exitDataString;
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{keyTypeString, sourceKeyIdentifier, exporterKeyIdentifier};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "keyExport", parms);
        }
        if (keyTypeString == null || sourceKeyIdentifier == null || exporterKeyIdentifier == null) {
            NullPointerException npe = new NullPointerException("One or more required parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyExport", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyExport");
            }
            throw npe;
        }
        if (keyTypeString.length() != 8) {
            ipe = new InvalidParameterException("The keyType parameter must be 8 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyExport", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyExport");
            }
            throw ipe;
        }
        if (sourceKeyIdentifier.length != 64 || exporterKeyIdentifier.length != 64) {
            ipe = new InvalidParameterException("The sourceKeyIdentifier and exporterKeyIdentifier byte array must be 64 bytes in length");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyExport", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyExport");
            }
            throw ipe;
        }
        if (debug != null) {
            String message = "\n    64 Bit       : " + HardwareProfile.getIs64Bit() + "\n    HCR7780 plus : " + HardwareProfile.getIsHCR7780OrLaterPresent() + "\n";
            debug.text(Debug.TYPE_PUBLIC, className, "keyExport", message);
        }
        if (HardwareProfile.getIs64Bit() && !HardwareProfile.getIsHCR7780OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("System Error: Key Export in AMODE(64) is only supported on HCR7780 or later versions.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyExport", uoe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyExport");
            }
            throw uoe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] keyType = PlatformUtilities.getBytesPlatform(keyTypeString);
        byte[] targetKeyIdentifier = new byte[64];
        byte[] sourceKeyIdentifierCopy = (byte[])sourceKeyIdentifier.clone();
        byte[] exporterKeyIdentifierCopy = (byte[])exporterKeyIdentifier.clone();
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String keyTypeEncoded = encoder.encodeBuffer(keyType);
            String sourceKeyIdentifierString = "\n" + encoder.encodeBuffer(sourceKeyIdentifierCopy);
            String exporterKeyIdentifierString = "\n" + encoder.encodeBuffer(exporterKeyIdentifierCopy);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKEX INPUT PARAMETERS\n    exitDataLength          : " + exitDataLength.getValue() + "\n    exitData                : " + exitDataString + "\n    keyType                 : " + keyTypeEncoded + "\n    sourceKeyIdentifier     : " + sourceKeyIdentifierString + "\n    exporterKeyIdentifier   : " + exporterKeyIdentifierString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyExport", parmsReport);
        }
        try {
            HIKM.CSNBKEX(returnCode, reasonCode, exitDataLength, exitData, keyType, sourceKeyIdentifierCopy, exporterKeyIdentifierCopy, targetKeyIdentifier);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNBKEX " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyExport", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyExport");
            }
            throw re;
        }
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String exporterKeyIdentifierString = "\n" + encoder.encodeBuffer(exporterKeyIdentifierCopy);
            String targetKeyIdentifierString = "\n" + encoder.encodeBuffer(targetKeyIdentifier);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKEX RETURN PARAMETERS\n    returnCode              : " + returnCode.getValue() + "\n    reasonCode              : " + reasonCode.getValue() + "\n    exitDataLength          : " + exitDataLength.getValue() + "\n    exitData                : " + exitDataString + "\n    exporterKeyIdentifier   : " + exporterKeyIdentifierString + "\n    targetKeyIdentifier     : " + targetKeyIdentifierString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyExport", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyExport", "CSNBKEX returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        Arrays.fill(sourceKeyIdentifierCopy, (byte)0);
        Arrays.fill(exporterKeyIdentifierCopy, (byte)0);
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBKEX", "Hardware error from call CSNBKEX returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyExport", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyExport");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "keyExport", targetKeyIdentifier);
        }
        return targetKeyIdentifier;
    }

    static final byte[] keyImport(String keyTypeString, byte[] sourceKeyIdentifier, byte[] importerKeyIdentifier) {
        return SymmetricKeyUtils.keyImport(keyTypeString, sourceKeyIdentifier, importerKeyIdentifier, null);
    }

    static final byte[] keyImport(String keyTypeString, byte[] sourceKeyIdentifier, byte[] importerKeyIdentifier, byte[] targetKeyIdentifier) {
        String exitDataString;
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{keyTypeString, sourceKeyIdentifier, importerKeyIdentifier, targetKeyIdentifier};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "keyImport", parms);
        }
        if (keyTypeString == null || sourceKeyIdentifier == null || importerKeyIdentifier == null) {
            NullPointerException npe = new NullPointerException("One or more required parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyImport", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyImport");
            }
            throw npe;
        }
        if (keyTypeString.length() != 8) {
            ipe = new InvalidParameterException("The keyType parameter must be 8 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyImport", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyImport");
            }
            throw ipe;
        }
        if (sourceKeyIdentifier.length != 64 || importerKeyIdentifier.length != 64) {
            ipe = new InvalidParameterException("The sourceKeyIdentifier and importerKeyIdentifier byte array must be 64 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyImport", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyImport");
            }
            throw ipe;
        }
        if (targetKeyIdentifier != null && targetKeyIdentifier.length != 64) {
            ipe = new InvalidParameterException("If not null, the targetKeyIdentifier byte array must be 64 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyImport", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyImport");
            }
            throw ipe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] keyType = PlatformUtilities.getBytesPlatform(keyTypeString);
        if (null == targetKeyIdentifier) {
            targetKeyIdentifier = new byte[64];
        }
        byte[] sourceKeyIdentifierCopy = (byte[])sourceKeyIdentifier.clone();
        byte[] importerKeyIdentifierCopy = (byte[])importerKeyIdentifier.clone();
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String keyTypeEncoded = encoder.encodeBuffer(keyType);
            String sourceKeyIdentifierString = "\n" + encoder.encodeBuffer(sourceKeyIdentifierCopy);
            String importerKeyIdentifierString = "\n" + encoder.encodeBuffer(importerKeyIdentifierCopy);
            String targetKeyIdentifierString = "\n" + encoder.encodeBuffer(targetKeyIdentifier);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKIM INPUT PARAMETERS\n    exitDataLength          : " + exitDataLength.getValue() + "\n    exitData                : " + exitDataString + "\n    keyType                 : " + keyTypeEncoded + "\n    sourceKeyIdentifier     : " + sourceKeyIdentifierString + "\n    importerKeyIdentifier   : " + importerKeyIdentifierString + "\n    targetKeyIdentifier     : " + targetKeyIdentifierString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyImport", parmsReport);
        }
        try {
            HIKM.CSNBKIM(returnCode, reasonCode, exitDataLength, exitData, keyType, sourceKeyIdentifierCopy, importerKeyIdentifierCopy, targetKeyIdentifier);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNBKIM " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyImport", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyImport");
            }
            throw re;
        }
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String importerKeyIdentifierString = "\n" + encoder.encodeBuffer(importerKeyIdentifierCopy);
            String targetKeyIdentifierString = "\n" + encoder.encodeBuffer(targetKeyIdentifier);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKIM RETURN PARAMETERS\n    returnCode              : " + returnCode.getValue() + "\n    reasonCode              : " + reasonCode.getValue() + "\n    exitDataLength          : " + exitDataLength.getValue() + "\n    exitData                : " + exitDataString + "\n    importerKeyIdentifier   : " + importerKeyIdentifierString + "\n    targetKeyIdentifier     : " + targetKeyIdentifierString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyImport", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyImport", "CSNBKIM returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        Arrays.fill(sourceKeyIdentifierCopy, (byte)0);
        Arrays.fill(importerKeyIdentifierCopy, (byte)0);
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBKIM", "Hardware error from call CSNBKIM returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyImport", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyImport");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "keyImport", targetKeyIdentifier);
        }
        return targetKeyIdentifier;
    }

    static final byte[] symmetricKeyExport(int ruleArrayCount, String ruleArrayString, byte[] sourceKeyIdentifier, byte[] transporterKeyIdentifier) {
        String exitDataString;
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{ruleArrayCount, ruleArrayString, sourceKeyIdentifier, transporterKeyIdentifier};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "symmetricKeyExport", parms);
        }
        if (ruleArrayString == null || sourceKeyIdentifier == null || transporterKeyIdentifier == null) {
            NullPointerException npe = new NullPointerException("One or more required parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyExport", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyExport");
            }
            throw npe;
        }
        if (8 * ruleArrayCount != ruleArrayString.length()) {
            ipe = new InvalidParameterException("ruleArrayCount does not match the number of keywords in ruleArray");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyExport", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyExport");
            }
            throw ipe;
        }
        if (sourceKeyIdentifier.length < 64 || sourceKeyIdentifier.length > 725) {
            ipe = new InvalidParameterException("The sourceKeyIdentifier byte array must be between 64 and 725 bytes in length");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyExport", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyExport");
            }
            throw ipe;
        }
        if (transporterKeyIdentifier.length > 3500) {
            ipe = new InvalidParameterException("The transporterKeyIdentifier byte array must be at most 3500 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyExport", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyExport");
            }
            throw ipe;
        }
        if (debug != null) {
            String message = "\n    64 Bit       : " + HardwareProfile.getIs64Bit() + "\n    HCR7770 plus : " + HardwareProfile.getIsHCR7770OrLaterPresent() + "\n";
            debug.text(Debug.TYPE_PUBLIC, className, "symmetricKeyExport", message);
        }
        if (HardwareProfile.getIs64Bit() && !HardwareProfile.getIsHCR7770OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("System Error: Symmetric Key Export in AMODE(64) is only supported on HCR7770 or later versions.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyExport", uoe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyExport");
            }
            throw uoe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger nativeRuleArrayCount = new hikmNativeInteger(ruleArrayCount);
        hikmNativeInteger sourceKeyIdentifierLength = new hikmNativeInteger(sourceKeyIdentifier.length);
        hikmNativeInteger transporterKeyIdentifierLength = new hikmNativeInteger(transporterKeyIdentifier.length);
        hikmNativeInteger encipheredKeyLength = new hikmNativeInteger(900);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayString);
        byte[] encipheredKey = new byte[900];
        byte[] sourceKeyIdentifierCopy = (byte[])sourceKeyIdentifier.clone();
        byte[] transporterKeyIdentifierCopy = (byte[])transporterKeyIdentifier.clone();
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String ruleArrayEncoded = encoder.encodeBuffer(ruleArray);
            String sourceKeyIdentifierString = "\n" + encoder.encodeBuffer(sourceKeyIdentifierCopy);
            String transporterKeyIdentifierString = "\n" + encoder.encodeBuffer(transporterKeyIdentifierCopy);
            String parmsReport = "\nSymmetricKeyUtils: CSNDSYX INPUT PARAMETERS\n    exitDataLength                 : " + exitDataLength.getValue() + "\n    exitData                       : " + exitDataString + "\n    ruleArrayCount                 : " + nativeRuleArrayCount.getValue() + "\n    ruleArray                      : " + ruleArrayEncoded + "\n    sourceKeyIdentifierLength      : " + sourceKeyIdentifierLength.getValue() + "\n    sourceKeyIdentifier            : " + sourceKeyIdentifierString + "\n    transporterKeyIdentifierLength : " + transporterKeyIdentifierLength.getValue() + "\n    transporterKeyIdentifier       : " + transporterKeyIdentifierString + "\n    encipheredKeyLength            : " + encipheredKeyLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "symmetricKeyExport", parmsReport);
        }
        try {
            HIKM.CSNDSYXJ(returnCode, reasonCode, exitDataLength, exitData, nativeRuleArrayCount, ruleArray, sourceKeyIdentifierLength, sourceKeyIdentifierCopy, transporterKeyIdentifierLength, transporterKeyIdentifierCopy, encipheredKeyLength, encipheredKey);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNDSYX " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyExport", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyExport");
            }
            throw re;
        }
        encipheredKey = SymmetricKeyUtils.trimSensitiveData(encipheredKey, encipheredKeyLength.getValue());
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String sourceKeyIdentifierString = "\n" + encoder.encodeBuffer(sourceKeyIdentifierCopy);
            String encipheredKeyString = "\n" + encoder.encodeBuffer(encipheredKey);
            String parmsReport = "\nSymmetricKeyUtils: CSNDSYX RETURN PARAMETERS\n    returnCode                     : " + returnCode.getValue() + "\n    reasonCode                     : " + reasonCode.getValue() + "\n    exitDataLength                 : " + exitDataLength.getValue() + "\n    exitData                       : " + exitDataString + "\n    sourceKeyIdentifier            : " + sourceKeyIdentifierString + "\n    encipheredKeyLength            : " + encipheredKeyLength.getValue() + "\n    encipheredKey                  : " + encipheredKeyString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "symmetricKeyExport", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "symmetricKeyExport", "CSNDSYX returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        Arrays.fill(sourceKeyIdentifierCopy, (byte)0);
        Arrays.fill(transporterKeyIdentifierCopy, (byte)0);
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNDSYX", "Hardware error from call CSNDSYX returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyExport", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyExport");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "symmetricKeyExport", encipheredKey);
        }
        return encipheredKey;
    }

    static final byte[] symmetricKeyImport2(int ruleArrayCount, String ruleArrayString, byte[] encipheredKey, byte[] transporterKeyIdentifier) {
        String exitDataString;
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{ruleArrayCount, ruleArrayString, encipheredKey, transporterKeyIdentifier};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "symmetricKeyImport2", parms);
        }
        if (ruleArrayString == null || encipheredKey == null || transporterKeyIdentifier == null) {
            NullPointerException npe = new NullPointerException("One or more required parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2");
            }
            throw npe;
        }
        if (8 * ruleArrayCount != ruleArrayString.length()) {
            ipe = new InvalidParameterException("ruleArrayCount does not match the number of keywords in ruleArray");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2");
            }
            throw ipe;
        }
        if (encipheredKey.length > 900) {
            ipe = new InvalidParameterException("The encipheredKey byte array must be no more than 900 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2");
            }
            throw ipe;
        }
        if (transporterKeyIdentifier.length > 3500) {
            ipe = new InvalidParameterException("The transporterKeyIdentifier byte array must be no more than 3,500 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2");
            }
            throw ipe;
        }
        if (!HardwareProfile.getIsHCR7780OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("System Error: Symmetric Key Import2 is only supported on HCR7780 or later versions.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2", uoe);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2");
            }
            throw uoe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger nativeRuleArrayCount = new hikmNativeInteger(ruleArrayCount);
        hikmNativeInteger encipheredKeyLength = new hikmNativeInteger(encipheredKey.length);
        hikmNativeInteger transporterKeyIdentifierLength = new hikmNativeInteger(transporterKeyIdentifier.length);
        hikmNativeInteger keyNameLength = new hikmNativeInteger(0);
        hikmNativeInteger targetKeyIdentifierLength = new hikmNativeInteger(725);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayString);
        byte[] keyName = new byte[]{};
        byte[] targetKeyIdentifier = new byte[725];
        byte[] encipheredKeyCopy = (byte[])encipheredKey.clone();
        byte[] transporterKeyIdentifierCopy = (byte[])transporterKeyIdentifier.clone();
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String ruleArrayEncoded = encoder.encodeBuffer(ruleArray);
            String encipheredKeyString = "\n" + encoder.encodeBuffer(encipheredKeyCopy);
            String transporterKeyIdentifierString = "\n" + encoder.encodeBuffer(transporterKeyIdentifierCopy);
            String keyNameString = encoder.encodeBuffer(keyName);
            String parmsReport = "\nSymmetricKeyUtils: CSNDSYI2 INPUT PARAMETERS\n    exitDataLength                 : " + exitDataLength.getValue() + "\n    exitData                       : " + exitDataString + "\n    ruleArrayCount                 : " + nativeRuleArrayCount.getValue() + "\n    ruleArray                      : " + ruleArrayEncoded + "\n    encipheredKeyLength            : " + encipheredKeyLength.getValue() + "\n    encipheredKey                  : " + encipheredKeyString + "\n    transporterKeyIdentifierLength : " + transporterKeyIdentifierLength.getValue() + "\n    transporterKeyIdentifier       : " + transporterKeyIdentifierString + "\n    keyNameLength                  : " + keyNameLength.getValue() + "\n    keyName                        : " + keyNameString + "\n    targetKeyIdentifierLength      : " + targetKeyIdentifierLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "symmetricKeyImport2", parmsReport);
        }
        try {
            HIKM.CSNDSYI2(returnCode, reasonCode, exitDataLength, exitData, nativeRuleArrayCount, ruleArray, encipheredKeyLength, encipheredKeyCopy, transporterKeyIdentifierLength, transporterKeyIdentifierCopy, keyNameLength, keyName, targetKeyIdentifierLength, targetKeyIdentifier);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNDSYI2 " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2");
            }
            throw re;
        }
        targetKeyIdentifier = SymmetricKeyUtils.trimSensitiveData(targetKeyIdentifier, targetKeyIdentifierLength.getValue());
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String targetKeyIdentifierString = "\n" + encoder.encodeBuffer(targetKeyIdentifier);
            String parmsReport = "\nSymmetricKeyUtils: CSNDSYI2 RETURN PARAMETERS\n    returnCode                     : " + returnCode.getValue() + "\n    reasonCode                     : " + reasonCode.getValue() + "\n    exitDataLength                 : " + exitDataLength.getValue() + "\n    exitData                       : " + exitDataString + "\n    targetKeyIdentifierLength      : " + targetKeyIdentifierLength.getValue() + "\n    targetKeyIdentifier            : " + targetKeyIdentifierString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "symmetricKeyImport2", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "symmetricKeyImport2", "CSNDSYI2 returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        Arrays.fill(encipheredKeyCopy, (byte)0);
        Arrays.fill(transporterKeyIdentifierCopy, (byte)0);
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNDSYI2", "Hardware error from call CSNDSYI2 returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "symmetricKeyImport2");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "symmetricKeyImport2", targetKeyIdentifier);
        }
        return targetKeyIdentifier;
    }

    static final byte[] keyTranslate2(int ruleArrayCount, String ruleArrayString, byte[] inputKeyToken, byte[] inputKEKIdentifier, byte[] outputKEKIdentifier, byte[] outputKeyToken) {
        String exitDataString;
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{ruleArrayCount, ruleArrayString, inputKeyToken, inputKEKIdentifier, outputKEKIdentifier, outputKeyToken};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "keyTranslate2", parms);
        }
        if (ruleArrayString == null || inputKeyToken == null) {
            NullPointerException npe = new NullPointerException("One or more required parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw npe;
        }
        if (8 * ruleArrayCount != ruleArrayString.length()) {
            ipe = new InvalidParameterException("ruleArrayCount does not match the number of keywords in ruleArray");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw ipe;
        }
        if (inputKeyToken.length > 900) {
            ipe = new InvalidParameterException("The inputKeyToken byte array must be no more than 900 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw ipe;
        }
        if (inputKEKIdentifier != null && inputKEKIdentifier.length > 725) {
            ipe = new InvalidParameterException("The inputKEKIdentifier byte array must be no more than 725 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw ipe;
        }
        if (outputKEKIdentifier != null && outputKEKIdentifier.length > 725) {
            ipe = new InvalidParameterException("The outputKEKIdentifier byte array must be no more than 725 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw ipe;
        }
        if (outputKeyToken != null && outputKeyToken.length > 900) {
            ipe = new InvalidParameterException("The outputKeyToken byte array must be no more than 900 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw ipe;
        }
        if (!HardwareProfile.getIsHCR7780OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("System Error: Key Translate2 is only supported on HCR7780 or later versions.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", uoe);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw uoe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger nativeRuleArrayCount = new hikmNativeInteger(ruleArrayCount);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayString);
        byte[] inputKeyTokenCopy = (byte[])inputKeyToken.clone();
        byte[] inputKEKIdentifierCopy = inputKEKIdentifier == null ? new byte[]{} : (byte[])inputKEKIdentifier.clone();
        byte[] outputKEKIdentifierCopy = outputKEKIdentifier == null ? new byte[]{} : (byte[])outputKEKIdentifier.clone();
        byte[] outputKeyTokenCopy = new byte[900];
        if (outputKeyToken != null) {
            System.arraycopy(outputKeyToken, 0, outputKeyTokenCopy, 0, outputKeyToken.length);
        }
        hikmNativeInteger inputKeyLength = new hikmNativeInteger(inputKeyTokenCopy.length);
        hikmNativeInteger inputKEKLength = new hikmNativeInteger(inputKEKIdentifierCopy.length);
        hikmNativeInteger outputKEKLength = new hikmNativeInteger(outputKEKIdentifierCopy.length);
        hikmNativeInteger outputKeyLength = new hikmNativeInteger(outputKeyTokenCopy.length);
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String ruleArrayEncoded = encoder.encodeBuffer(ruleArray);
            String inputKeyTokenString = "\n" + encoder.encodeBuffer(inputKeyTokenCopy);
            String inputKEKIdentifierString = "\n" + encoder.encodeBuffer(inputKEKIdentifierCopy);
            String outputKEKIdentifierString = "\n" + encoder.encodeBuffer(outputKEKIdentifierCopy);
            String outputKeyTokenString = "\n" + encoder.encodeBuffer(outputKeyTokenCopy);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKTR2 INPUT PARAMETERS\n    exitDataLength      : " + exitDataLength.getValue() + "\n    exitData            : " + exitDataString + "\n    ruleArrayCount      : " + nativeRuleArrayCount.getValue() + "\n    ruleArray           : " + ruleArrayEncoded + "\n    inputKeyLength      : " + inputKeyLength.getValue() + "\n    inputKeyToken       : " + inputKeyTokenString + "\n    inputKEKLength      : " + inputKEKLength.getValue() + "\n    inputKEKIdentifier  : " + inputKEKIdentifierString + "\n    outputKEKLength     : " + outputKEKLength.getValue() + "\n    outputKEKIdentifier : " + outputKEKIdentifierString + "\n    outputKeyLength     : " + outputKeyLength.getValue() + "\n    outputKeyToken      : " + outputKeyTokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyTranslate2", parmsReport);
        }
        try {
            HIKM.CSNBKTR2(returnCode, reasonCode, exitDataLength, exitData, nativeRuleArrayCount, ruleArray, inputKeyLength, inputKeyTokenCopy, inputKEKLength, inputKEKIdentifierCopy, outputKEKLength, outputKEKIdentifierCopy, outputKeyLength, outputKeyTokenCopy);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNBKTR2 " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw re;
        }
        outputKeyTokenCopy = SymmetricKeyUtils.trimSensitiveData(outputKeyTokenCopy, outputKeyLength.getValue());
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            String inputKeyTokenString = "\n" + encoder.encodeBuffer(inputKeyTokenCopy);
            String inputKEKIdentifierString = "\n" + encoder.encodeBuffer(inputKEKIdentifierCopy);
            String outputKEKIdentifierString = "\n" + encoder.encodeBuffer(outputKEKIdentifierCopy);
            String outputKeyTokenString = "\n" + encoder.encodeBuffer(outputKeyTokenCopy);
            String parmsReport = "\nSymmetricKeyUtils: CSNBKTR2 RETURN PARAMETERS\n    returnCode          : " + returnCode.getValue() + "\n    reasonCode          : " + reasonCode.getValue() + "\n    exitDataLength      : " + exitDataLength.getValue() + "\n    exitData            : " + exitDataString + "\n    inputKeyToken       : " + inputKeyTokenString + "\n    inputKEKIdentifier  : " + inputKEKIdentifierString + "\n    outputKEKIdentifier : " + outputKEKIdentifierString + "\n    outputKeyLength     : " + outputKeyLength.getValue() + "\n    outputKeyToken      : " + outputKeyTokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "keyTranslate2", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "keyTranslate2", "CSNBKTR2 returnCode = " + returnCode.getValue() + " reasonCode = " + reasonCode.getValue());
        }
        Arrays.fill(inputKeyTokenCopy, (byte)0);
        Arrays.fill(inputKEKIdentifierCopy, (byte)0);
        Arrays.fill(outputKEKIdentifierCopy, (byte)0);
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBKTR2", "Hardware error from call CSNBKTR2 returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "keyTranslate2", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "keyTranslate2");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "keyTranslate2", outputKeyTokenCopy);
        }
        return outputKeyTokenCopy;
    }

    static final byte[] convertAESDataTokenToAESCipherToken(byte[] dataToken) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "convertAESDataTokenToAESCipherToken", (Object)dataToken);
        }
        if (!SymmetricKeyUtils.isAESInternalDataKeyToken(dataToken)) {
            InvalidParameterException ipe = new InvalidParameterException("Not an AES internal data key token");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "convertAESDataTokenToAESCipherToken", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "convertAESDataTokenToAESCipherToken");
            }
            throw ipe;
        }
        if (!HardwareProfile.getIsHCR7790OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("Converting an operational AES DATA token to an operational AES CIPHER token is only supported on HCR7790 or later versions.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "convertAESDataTokenToAESCipherToken", uoe);
                debug.exit(Debug.TYPE_PUBLIC, className, "convertAESDataTokenToAESCipherToken");
            }
            throw uoe;
        }
        int ruleArrayCount = 3;
        String ruleArray = "INTERNALAES     CIPHER  ";
        byte[] skeletonCipherToken = SymmetricKeyUtils.keyTokenBuild2(ruleArrayCount, ruleArray);
        ruleArrayCount = 2;
        ruleArray = "REFORMATAES     ";
        byte[] translatedToken = SymmetricKeyUtils.keyTranslate2(ruleArrayCount, ruleArray, dataToken, null, null, skeletonCipherToken);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "convertAESDataTokenToAESCipherToken", translatedToken);
        }
        return translatedToken;
    }

    static final byte[] convertAESCipherTokenToAESDataToken(byte[] cipherToken) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "convertAESCipherTokenToAESDataToken", (Object)cipherToken);
        }
        if (!SymmetricKeyUtils.isAESInternalCipherKeyToken(cipherToken)) {
            InvalidParameterException ipe = new InvalidParameterException("Not an AES internal cipher key token");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "convertAESCipherTokenToAESDataToken", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "convertAESCipherTokenToAESDataToken");
            }
            throw ipe;
        }
        if (!HardwareProfile.getIsHCR7790OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("Converting an operational AES CIPHER token to an operational AES DATA token is only supported on HCR7790 or later versions.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "convertAESCipherTokenToAESDataToken", uoe);
                debug.exit(Debug.TYPE_PUBLIC, className, "convertAESCipherTokenToAESDataToken");
            }
            throw uoe;
        }
        int ruleArrayCount = 2;
        String ruleArray = "REFORMATAES     ";
        byte[] translatedToken = SymmetricKeyUtils.keyTranslate2(ruleArrayCount, ruleArray, cipherToken, null, null, null);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "convertAESCipherTokenToAESDataToken", translatedToken);
        }
        return translatedToken;
    }

    static final boolean isAESInternalDataKeyToken(byte[] token) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "isAESInternalDataKeyToken", (Object)token);
        }
        if (token != null && token.length == 64 && token[0] == 1 && token[4] == 4) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isAESInternalDataKeyToken", true);
            }
            return true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isAESInternalDataKeyToken", false);
        }
        return false;
    }

    static final boolean isAESInternalCipherKeyToken(byte[] token) {
        ByteBuffer byteBuffer;
        short length;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "isAESInternalCipherKeyToken", (Object)token);
        }
        if (token != null && token.length >= 8 && token[0] == 1 && token[4] == 5 && (length = (byteBuffer = ByteBuffer.wrap(new byte[]{token[2], token[3]})).getShort()) == token.length && length >= 44 && token[41] == 2 && token[42] == 0 && token[43] == 1) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isAESInternalCipherKeyToken", true);
            }
            return true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isAESInternalCipherKeyToken", false);
        }
        return false;
    }

    static final byte[] trimSensitiveData(byte[] data, int length) {
        if (data == null) {
            return data;
        }
        if (length < 0 || length > data.length) {
            RuntimeException rte = new RuntimeException("Bad length value. Current token length: " + data.length + ". Trim token length: " + length);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "trimSensitiveData", rte);
            }
            throw rte;
        }
        if (length == 0) {
            return data;
        }
        if (length == data.length) {
            return data;
        }
        byte[] newData = new byte[length];
        System.arraycopy(data, 0, newData, 0, length);
        Arrays.fill(data, (byte)0);
        return newData;
    }

    static {
        if (debug != null) {
            encoder = new HexDumpEncoder();
        }
        HIKM = new HIKM();
    }

    private static enum KRRFunction {
        CSNBKRR,
        CSNBAKRR,
        CSNBKRR2;

    }

    private static enum KRDFunction {
        CSNBKRD,
        CSNBAKRD;

    }

    private static enum KRCFunction {
        CSNBKRC,
        CSNBAKRC,
        CSNBKRC2;

    }
}

