/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.misc.Debug;
import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

final class SealedTokenForKeyProtectorS2
implements Serializable {
    byte[] encToken = null;
    byte[] salt = null;
    int iterCount = 0;
    byte[] iv = null;
    private static Debug debug = Debug.getInstance((String)"ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.KeyProtectorS2.SealedTokenForKeyProtectorS2";

    protected SealedTokenForKeyProtectorS2(byte[] encToken, PBEParameterSpec params) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SealedTokenForKeyProtectorS2", (Object)encToken, (Object)params);
            debug.exit(16384L, (Object)className, "SealedTokenForKeyProtectorS2");
        }
        this.encToken = encToken;
        this.salt = params.getSalt();
        this.iterCount = params.getIterationCount();
        AlgorithmParameterSpec aps = params.getParameterSpec();
        try {
            if (null != aps) {
                this.iv = ((IvParameterSpec)aps).getIV();
            }
        }
        catch (ClassCastException cce) {
            String msg = "unknown";
            try {
                msg = aps.getClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String rteMsg = "PBEParameterSpec.getParameterSpec() expected IvParameterSpec, returned object is " + msg;
            RuntimeException rte = new RuntimeException(rteMsg);
            if (debug != null) {
                debug.exception(16384L, (Object)className, "getParameters", (Throwable)rte);
            }
            throw rte;
        }
    }

    protected PBEParameterSpec getParameterSpec() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getParameterSpec");
        }
        if (null == this.iv) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getParameterSpec", (Object)new String("returning salt, iterCount"));
            }
            return new PBEParameterSpec(this.salt, this.iterCount);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getParameterSpec", (Object)new String("returning salt, iterCount, IvParameterSpec"));
        }
        return new PBEParameterSpec(this.salt, this.iterCount, new IvParameterSpec(this.iv));
    }

    protected byte[] getEncToken() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getEncToken");
            debug.exit(16384L, (Object)className, "getEncToken", (Object)this.encToken);
        }
        return this.encToken;
    }
}

