/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.PBES2Parameters;
import com.ibm.crypto.hdwrCCA.provider.ParametersForPBES2Core;
import com.ibm.misc.Debug;
import java.io.IOException;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SealedObject;

final class SealedObjectForKeyProtectorS2
extends SealedObject {
    private static Debug debug = Debug.getInstance((String)"ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.KeyProtectorS2.SealedObjectForKeyProtectorS2";
    private static Provider prod = Security.getProvider("IBMJCECCA");
    private static final String pbeAlgo = "PBEWithHmacSHA1And128BitAES";

    protected SealedObjectForKeyProtectorS2(Serializable object, Cipher c) throws IOException, IllegalBlockSizeException {
        super(object, c);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SealedObjectForKeyProtectorS2", (Object)object, (Object)c);
            debug.exit(16384L, (Object)className, "SealedObjectForKeyProtectorS2");
        }
    }

    protected SealedObjectForKeyProtectorS2(SealedObject so) {
        super(so);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SealedObjectForKeyProtectorS2", (Object)so);
            debug.exit(16384L, (Object)className, "SealedObjectForKeyProtectorS2");
        }
    }

    protected AlgorithmParameters getParameters() {
        ParametersForPBES2Core params;
        block8: {
            params = null;
            if (debug != null) {
                debug.entry(16384L, (Object)className, "getParameters");
                if (this.encodedParams == null) {
                    debug.text(16384L, (Object)className, "getParameters", "super.encodedParams == null");
                }
            }
            if (this.encodedParams != null) {
                try {
                    PBES2Parameters.HmacSHA1AndAES_128 paramsSpi = new PBES2Parameters.HmacSHA1AndAES_128();
                    params = new ParametersForPBES2Core(paramsSpi, prod, pbeAlgo);
                    params.init(this.encodedParams);
                }
                catch (NoSuchAlgorithmException nsae) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "getParameters", (Throwable)nsae);
                    }
                }
                catch (IOException ioe) {
                    if (debug == null) break block8;
                    debug.exception(16384L, (Object)className, "getParameters", (Throwable)ioe);
                }
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getParameters", params);
        }
        return params;
    }
}

