/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Crypto;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.PKCS11Utils;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;

class SHAwithRSA
extends SignatureSpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.SHAwithRSA";
    private byte[] privKeyLabel;
    private byte[] privExtKeyToken;
    private byte[] cachePrivKeyToken;
    private byte[] pubKeyToken;
    private MessageDigest dataSHA;
    private String oid = null;
    private String sigAlgName = null;
    private String msgDigestName = null;

    SHAwithRSA(String sigAlgName, String oid, String msgDigestName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            Object[] parms = new Object[]{sigAlgName, oid, msgDigestName};
            debug.entry(Debug.TYPE_FINE, (Object)className, "SHAwithRSA", parms);
        }
        this.oid = oid;
        this.sigAlgName = sigAlgName;
        this.msgDigestName = msgDigestName;
        this.dataSHA = Security.getProvider("IBMJCECCA") == null ? (Security.getProvider("IBMJCE4758") == null ? MessageDigest.getInstance(this.msgDigestName, "IBMJCA4758") : MessageDigest.getInstance(this.msgDigestName, "IBMJCE4758")) : MessageDigest.getInstance(this.msgDigestName, "IBMJCECCA");
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "SHAwithRSA");
        }
    }

    @Override
    protected void engineSetParameter(String key, Object param) throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSetParameter", key, param);
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetParameter", "engineSetParameter has no meaning in hardware");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object engineGetParameter(String key) throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameter", key);
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameter", "engineGetParameter has no meaning in hardware");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInitSign", privateKey);
        }
        if (privateKey instanceof RSAPrivateHWKey) {
            this.privKeyLabel = ((RSAPrivateHWKey)privateKey).getToken();
            this.privExtKeyToken = ((RSAPrivateHWKey)privateKey).getExternalKeyToken();
            this.cachePrivKeyToken = null;
            this.dataSHA.reset();
        } else if (privateKey instanceof PKCS11RSAPrivateKey && Boolean.TRUE.equals(((PKCS11RSAPrivateKey)privateKey).getSensitive())) {
            if (!PKCS11Utils.isSecureKey((PKCS11Key)((PKCS11RSAPrivateKey)privateKey))) {
                InvalidKeyException ike = new InvalidKeyException("Private key is a sensitive key, but not a secure key");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw ike;
            }
            String p11Label = PKCS11Utils.getSecureKeyLabel((PKCS11Key)((PKCS11RSAPrivateKey)privateKey));
            if (p11Label == null) {
                InvalidKeyException ike = new InvalidKeyException("Not a valid RSA private key, unable to retrieve secure key label");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw ike;
            }
            this.privKeyLabel = p11Label.getBytes(StandardCharsets.ISO_8859_1);
            this.cachePrivKeyToken = null;
            this.dataSHA.reset();
        } else if (privateKey instanceof RSAPrivateKey) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitSign", "Do automatic migration of IBMJCE private key to IBMJCECCA");
            }
            try {
                RSAPrivateHWKey migKey = new RSAPrivateHWKey(privateKey.getEncoded());
                this.privKeyLabel = migKey.getToken();
                this.cachePrivKeyToken = null;
                this.dataSHA.reset();
            }
            catch (Exception e) {
                InvalidKeyException ike = new InvalidKeyException(e.getMessage(), e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw ike;
            }
        } else {
            InvalidKeyException ike = new InvalidKeyException("Not a RSA private key: " + privateKey);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
            }
            throw ike;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInitVerify", publicKey);
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey pub = (RSAPublicKey)publicKey;
            this.pubKeyToken = pub.getToken();
            this.dataSHA.reset();
        } else if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            RSAPublicKey migKey = new RSAPublicKey(publicKey.getEncoded());
            this.pubKeyToken = migKey.getToken();
            this.dataSHA.reset();
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitVerify", "Key " + publicKey + "is not a RSA public key");
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
            }
            throw new InvalidKeyException("not a RSA public key: " + publicKey);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", new Byte(b));
        }
        this.dataSHA.update(b);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) throws SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{data, new Integer(off), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        this.dataSHA.update(data, off, len);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSign");
        }
        byte[] messageDigest = this.dataSHA.digest();
        if (debug != null) {
            System.err.print("messageDigest = ");
            for (int i = 0; i < messageDigest.length; ++i) {
                System.err.print(messageDigest[i] + " ");
            }
        }
        Crypto crypto = new Crypto();
        byte[] result = null;
        try {
            result = this.cachePrivKeyToken != null ? crypto.sign(this.cachePrivKeyToken, messageDigest, 0, messageDigest.length, Crypto.Algorithm.RSA, true, this.oid) : crypto.sign(this.privKeyLabel, messageDigest, 0, messageDigest.length, Crypto.Algorithm.RSA, true, this.oid);
        }
        catch (JCECCARuntimeException e) {
            if (e.getReturnCode() == 8 && e.getReasonCode() == 48 && this.privExtKeyToken != null && this.privKeyLabel.length > 64) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSign", e);
                    debug.text(Debug.TYPE_FINE, className, "engineSign", "One or more keys has a master key verification pattern that is not valid");
                    debug.text(Debug.TYPE_FINE, className, "engineSign", "Refreshing internal token representation of CLEAR key and trying sign again");
                }
                KeyPairUtils util = new KeyPairUtils();
                this.cachePrivKeyToken = util.importExternalToken(this.privExtKeyToken, KeyPairUtils.KeyPairAlgorithm.RSA);
                result = crypto.sign(this.cachePrivKeyToken, messageDigest, 0, messageDigest.length, Crypto.Algorithm.RSA, true, this.oid);
            }
            throw e;
        }
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSign", (Object)result);
        }
        return result;
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineVerify", (Object)signature);
        }
        byte[] messageDigest = this.dataSHA.digest();
        if (debug != null) {
            String md = new String("messageDigest=");
            for (int i = 0; i < messageDigest.length; ++i) {
                md = md + messageDigest[i] + " ";
            }
            debug.text(Debug.TYPE_PUBLIC, className, "engineVerify", md);
        }
        Crypto crypto = new Crypto();
        boolean result = crypto.verify(this.pubKeyToken, messageDigest, 0, messageDigest.length, signature, 0, signature.length, Crypto.Algorithm.RSA, true, this.oid);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineVerify", "PublicToken " + this.pubKeyToken.toString());
            debug.text(Debug.TYPE_PUBLIC, className, "engineVerify", "PublicToken length" + this.pubKeyToken.length);
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineVerify", result);
        }
        return result;
    }
}

