/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Crypto;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.DSAPublicKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public class SHA1withDSA
extends SignatureSpi {
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_SIGN = 1;
    private static final int STATE_VERIFY = 2;
    private int state = 0;
    private MessageDigest sha;
    private static final String[] STATE_DESCRIPTION = new String[]{"UNINITIALIZED", "SIGN", "VERIFY"};
    private byte[] privKeyLabel;
    private byte[] pubKeyToken;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.SHA1withDSA";

    public SHA1withDSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "SHA1withDSA");
        }
        this.sha = Security.getProvider("IBMJCECCA") == null ? (Security.getProvider("IBMJCE4758") == null ? MessageDigest.getInstance("SHA", "IBMJCA4758") : MessageDigest.getInstance("SHA", "IBMJCE4758")) : MessageDigest.getInstance("SHA", "IBMJCECCA");
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "SHA1withDSA");
        }
    }

    @Override
    protected Object engineGetParameter(String param) throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameter", param);
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameter", "engineGetParameter has no meaning in hardware");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInitSign", privateKey);
        }
        if (!(privateKey instanceof DSAPrivateHWKey)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitSign", "Key " + privateKey + " is not a DSA private key");
            }
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        this.state = 1;
        DSAPrivateHWKey priv = (DSAPrivateHWKey)((Object)privateKey);
        this.privKeyLabel = priv.getToken();
        this.sha.reset();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInitVerify", publicKey);
        }
        if (publicKey instanceof DSAPublicKey) {
            this.state = 2;
            DSAPublicKey pub = (DSAPublicKey)publicKey;
            this.pubKeyToken = pub.getToken();
            this.sha.reset();
        } else if (publicKey instanceof java.security.interfaces.DSAPublicKey) {
            DSAPublicKey migKey = new DSAPublicKey(publicKey.getEncoded());
            this.state = 2;
            this.pubKeyToken = migKey.getToken();
            this.sha.reset();
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitVerify", "Key " + publicKey + " is not a DSA public key");
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
            }
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
        }
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSetParameter", param, value);
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetParameter", "engineSetParameter has no meaning in hardware");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSign");
        }
        byte[] messageDigest = this.sha.digest();
        Crypto crypto = new Crypto();
        byte[] result = crypto.sign(this.privKeyLabel, messageDigest, 0, messageDigest.length, Crypto.Algorithm.DSA, true, new String());
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineSign", result);
        }
        return result;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", new Byte(b));
        }
        this.sha.update(b);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected void engineUpdate(byte[] buffer, int offset, int length) throws SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{buffer, new Integer(offset), new Integer(length)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        this.sha.update(buffer, offset, length);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineVerify", (Object)sigBytes);
        }
        byte[] digest = this.sha.digest();
        Crypto crypto = new Crypto();
        boolean result = crypto.verify(this.pubKeyToken, digest, 0, digest.length, sigBytes, 0, sigBytes.length, Crypto.Algorithm.DSA, true, new String());
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineVerify", new Boolean(result));
        }
        return result;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "toString");
        }
        StringBuffer result = new StringBuffer(128);
        result.append(" DSA Signature (");
        result.append(STATE_DESCRIPTION[this.state]);
        result.append(')');
        if (this.state == 0) {
            return result.toString();
        }
        result.append("\n");
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "toString", result.toString());
        }
        return result.toString();
    }
}

