/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Security;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Serializable {
    static final long serialVersionUID = 5424059953276639461L;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private byte[] token;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSAPublicKey";

    public RSAPublicKey(BigInteger m, BigInteger p) throws InvalidKeyException, InternalError {
        this((AlgorithmId)new AlgIdRSA(), m, p);
    }

    public RSAPublicKey(AlgorithmId algId, BigInteger m, BigInteger p) throws InvalidKeyException, InternalError {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "RSAPublicKey", m, p);
        }
        KeyPairUtils utils = new KeyPairUtils();
        boolean pss = false;
        if (algId != null && algId.getOID().equals(AlgorithmId.RSAPSS_oid)) {
            pss = true;
        }
        this.algid = new AlgIdRSA();
        this.modulus = m;
        this.publicExponent = p;
        try {
            DerValue[] value = new DerValue[]{new DerValue(2, m.toByteArray()), new DerValue(2, p.toByteArray())};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            this.encode();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RSAPublicKey", e);
            }
            throw new InvalidKeyException("could not DER encode: " + e.getMessage());
        }
        try {
            KeyPairUtils.KeyPairAlgorithm keyPairAlgorithm = pss ? KeyPairUtils.KeyPairAlgorithm.RSAPSS : KeyPairUtils.KeyPairAlgorithm.RSA;
            utils.initializeRSA(m.bitLength(), null, null, null, keyPairAlgorithm);
        }
        catch (InvalidParameterException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RSAPublicKey", e);
            }
            throw new InternalError("Invalid RSA parameters specified.");
        }
        this.token = utils.generateToken(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "RSAPublicKey");
        }
    }

    public RSAPublicKey(byte[] encoded) throws InvalidKeyException, InternalError {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "RSAPublicKey", (Object)encoded);
        }
        KeyPairUtils utils = new KeyPairUtils();
        this.decode(encoded);
        boolean pss = false;
        if (this.algid != null && this.algid.getOID().equals(AlgorithmId.RSAPSS_oid)) {
            pss = true;
        }
        this.algid = new AlgIdRSA();
        try {
            KeyPairUtils.KeyPairAlgorithm keyPairAlgorithm = pss ? KeyPairUtils.KeyPairAlgorithm.RSAPSS : KeyPairUtils.KeyPairAlgorithm.RSA;
            utils.initializeRSA(this.getModulus().bitLength(), null, null, null, keyPairAlgorithm);
        }
        catch (InvalidParameterException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RSAPublicKey", e);
            }
            throw new InternalError("Invalid DSA parameters specified.");
        }
        this.token = utils.generateToken(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "RSAPublicKey");
        }
    }

    @Override
    public BigInteger getModulus() {
        BigInteger result = this.modulus;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getModulus");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getModulus", result);
        }
        return result;
    }

    @Override
    public BigInteger getPublicExponent() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPublicExponent");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getPublicExponent", this.publicExponent);
        }
        return this.publicExponent;
    }

    public byte[] getToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getToken");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getToken", this.token);
        }
        return this.token;
    }

    public String toString() {
        String prov = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "toString");
        }
        prov = Security.getProvider("IBMJCECCA") == null && Security.getProvider("IBMJCE4758") == null ? new String("IBMJCA4758") : new String("IBMJCECCA");
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "toString");
        }
        return prov + " RSA Public Key:\nmodulus:\n" + this.modulus.toString() + "\npublic exponent:\n" + this.publicExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
        try {
            DerInputStream in = new DerInputStream(this.key);
            DerValue[] value = in.getSequence(2);
            this.modulus = value[0].getInteger();
            this.publicExponent = value[1].getInteger();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", e);
            }
            throw new InvalidKeyException("Invalid key value \n" + e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
    }
}

