/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import java.security.spec.KeySpec;

public class RSAPrivateHWKeySpec
implements KeySpec {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKeySpec";
    private byte[] keyToken;
    private RSAKeyHWAttributes attribs = null;

    public RSAPrivateHWKeySpec(byte[] keyToken, byte type) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKeySpec", keyToken, new Byte(type));
        }
        this.keyToken = (byte[])keyToken.clone();
        this.attribs = type != 0 && type != 1 && type != 2 ? new RSAKeyHWAttributes(2, 4) : new RSAKeyHWAttributes(type, 4);
        if (debug != null) {
            debug.exit(8192L, className, "RSAPrivateHWKeySpec");
        }
    }

    public RSAPrivateHWKeySpec(byte[] keyToken, byte type, byte usage) {
        if (debug != null) {
            Object[] parms = new Object[]{keyToken, new Byte((byte)type), new Byte(usage)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "RSAPrivateHWKeySpec", parms);
        }
        int keyType = type;
        byte keyUsage = usage;
        this.keyToken = (byte[])keyToken.clone();
        if (type != 0 && type != 1 && type != 2) {
            keyType = 2;
        }
        if (usage != 3 && usage != 4) {
            keyUsage = 4;
        }
        this.attribs = new RSAKeyHWAttributes((byte)keyType, keyUsage);
        if (debug != null) {
            debug.exit(8192L, className, "RSAPrivateHWKeySpec");
        }
    }

    public byte[] getToken() {
        if (debug != null) {
            debug.exit(8192L, className, "getToken");
            debug.exit(8192L, (Object)className, "getToken", this.keyToken.clone());
        }
        return (byte[])this.keyToken.clone();
    }

    public RSAKeyHWAttributes getAttributes() {
        if (debug != null) {
            debug.exit(8192L, className, "getAttributes");
            debug.exit(8192L, (Object)className, "getAttributes", this.attribs);
        }
        return this.attribs;
    }
}

