/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import java.security.spec.AlgorithmParameterSpec;

public class RSAKeyParameterSpec
implements AlgorithmParameterSpec {
    private RSAKeyHWAttributes attribs = null;
    private int keysize;
    private byte[] keyToken = null;
    private boolean support4096 = false;
    private int maxModulusLength = 2048;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String classname = "com.ibm.crypto.hdwrCCA.provider.RSAKeyParameterSpec";

    public RSAKeyParameterSpec(int strength, byte type) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", new Integer(strength), new Byte(type));
        }
        if (type != 0 && type != 2 && type != 1) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "Invalid Key pair type");
            }
            throw new IllegalArgumentException("Invalid key pair type");
        }
        this.support4096 = HardwareProfile.getIs4096RNGLSupported();
        if (this.support4096) {
            this.maxModulusLength = 4096;
        }
        if (strength < 512 || strength > this.maxModulusLength) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "Modulus size must be in the range 512 to " + this.maxModulusLength + ".");
            }
            throw new IllegalArgumentException("Modulus size must be in the range 512 to " + this.maxModulusLength + ".");
        }
        this.attribs = new RSAKeyHWAttributes(type, 4);
        this.keysize = strength;
        this.keyToken = null;
        if (debug != null) {
            String info = new String(HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + this.support4096);
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "RSAKeyParameterSpec", info);
        }
    }

    public RSAKeyParameterSpec(int strength, byte type, byte usage) throws IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(strength), new Byte(type), new Byte(usage)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)classname, "RSAKeyParameterSpec", parms);
        }
        if (type != 0 && type != 2 && type != 1) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "Invalid Key pair type");
            }
            throw new IllegalArgumentException("Invalid key pair type");
        }
        if (usage != 3 && usage != 4) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "Invalid Key pair usage");
            }
            throw new IllegalArgumentException("Invalid key pair usage");
        }
        this.support4096 = HardwareProfile.getIs4096RNGLSupported();
        if (this.support4096) {
            this.maxModulusLength = 4096;
        }
        if (strength < 512 || strength > this.maxModulusLength) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "Modulus size must be in the range 512 to " + this.maxModulusLength + ".");
            }
            throw new IllegalArgumentException("Modulus size must be in the range 512 to " + this.maxModulusLength + ".");
        }
        this.attribs = new RSAKeyHWAttributes(type, usage);
        this.keysize = strength;
        this.keyToken = null;
        if (debug != null) {
            String info = new String(HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + this.support4096);
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "RSAKeyParameterSpec", info);
        }
    }

    public RSAKeyParameterSpec(int strength, byte type, byte usage, String label) throws IllegalArgumentException {
        this(strength, type, usage, label.getBytes(PlatformUtilities.CHARSET_ISO_8859_1));
    }

    @Deprecated
    public RSAKeyParameterSpec(int strength, byte type, byte usage, byte[] label) throws IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(strength), new Byte(type), new Byte(usage), label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)classname, "RSAKeyParameterSpec", parms);
        }
        if (type != 0 && type != 2 && type != 1) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "Invalid Key pair type");
            }
            throw new IllegalArgumentException("Invalid key pair type");
        }
        if (usage != 3 && usage != 4) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "Invalid Key pair usage");
            }
            throw new IllegalArgumentException("Invalid key pair usage");
        }
        if (label != null && label.length > 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "key label myst be 64 bytes long");
            }
            throw new IllegalArgumentException("key label has a maximum length of 64 bytes");
        }
        this.support4096 = HardwareProfile.getIs4096RNGLSupported();
        if (this.support4096) {
            this.maxModulusLength = 4096;
        }
        if (strength < 512 || strength > this.maxModulusLength) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, classname, "RSAKeyParameterSpec", "Modulus size must be in the range 512 to " + this.maxModulusLength + ".");
            }
            throw new IllegalArgumentException("Modulus size must be in the range 512 to " + this.maxModulusLength + ".");
        }
        this.attribs = new RSAKeyHWAttributes(type, usage);
        this.keysize = strength;
        this.keyToken = (byte[])label.clone();
        if (debug != null) {
            String info = new String(HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + this.support4096);
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "RSAKeyParameterSpec", info);
        }
    }

    public RSAKeyHWAttributes getAttributes() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, classname, "getAttributes");
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getAttributes", this.attribs);
        }
        return this.attribs;
    }

    public int getKeySize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, classname, "getKeySize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getKeySize", this.keysize);
        }
        return this.keysize;
    }

    public byte[] getToken() {
        byte[] result = null;
        if (this.keyToken != null) {
            result = (byte[])this.keyToken.clone();
        }
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, classname, "getToken");
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getToken", result);
        }
        return result;
    }

    public String getLabelString() {
        String returnLabel = null;
        if (this.keyToken != null) {
            returnLabel = new String(this.keyToken, PlatformUtilities.CHARSET_ISO_8859_1);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getLabelString", returnLabel);
        }
        return returnLabel;
    }
}

