/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import java.security.InvalidParameterException;

public class RSAKeyHWAttributes
implements KeyHWAttributes {
    byte keyType = 0;
    byte keyUsage = 0;
    static final long serialVersionUID = -3356106334989837048L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes";

    public RSAKeyHWAttributes(byte keyType, byte keyUsage) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "RSAKeyHwAttributes", keyType, keyUsage);
        }
        if (keyType != 0 && keyType != 1 && keyType != 2) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "RSAKeyHwAttributes", "Key Type must be KeyHWAttributeValues.PKDS, KeyHWAttributeValues.RETAIN or KeyHWAttributeValues.CLEAR for RSA keys.");
            }
            throw new InvalidParameterException("Key Type must be KeyHWAttributeValues.PKDS, KeyHWAttributeValues.RETAIN or KeyHWAttributeValues.CLEAR for RSA keys.");
        }
        if (keyUsage != 3 && keyUsage != 4) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "RSAKeyHwAttributes", "Key Usage must be KeyHWAttributeValues.SIGNATURE, or KeyHWAttributeValues.KEYMANAGEMNET for RSA keys.");
            }
            throw new InvalidParameterException("Key Usage must be KeyHWAttributeValues.SIGNATURE, or KeyHWAttributeValues.KEYMANAGEMNET for RSA keys.");
        }
        this.keyType = keyType;
        this.keyUsage = keyUsage;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "RSAKeyHwAttributes");
        }
    }

    @Override
    public byte getKeyType() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeyType");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyType", this.keyType);
        }
        return this.keyType;
    }

    @Override
    public byte getKeyUsage() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeyUsage");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyUsage", this.keyUsage);
        }
        return this.keyUsage;
    }

    public String toString() {
        String str = "RSAKeyHWAttributes [Key Type: ";
        str = this.keyType == 2 ? str + "CLEAR, " : (this.keyType == 0 ? str + "PKDS, " : (this.keyType == 1 ? str + "RETAIN, " : str + "UNKNOWN, "));
        str = str + "Key Usage: ";
        str = this.keyUsage == 4 ? str + "KEYMANAGEMENT" : (this.keyUsage == 3 ? str + "SIGNATURE" : str + "UNKNOWN");
        str = str + "]";
        return str;
    }
}

