/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryRACF;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.KeyProtector;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RACF;
import com.ibm.crypto.hdwrCCA.provider.RACFResults;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryRACF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Vector;

public class RACFOutputStream
extends OutputStream {
    private static final int JCERACFKS_MAGIC = 306006735;
    private static final String EYE_CATCHER = "JCECCARACFKS";
    private static final int VERSION_1 = 1;
    ByteArrayOutputStream m_baos = null;
    private static Debug debug = Debug.getInstance("ibmjceracf");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RACFOutputStream";
    private boolean m_stream_open = false;
    private String m_userID = null;
    private String m_ringid = null;
    private byte[] m_userIDBytes = null;
    private byte[] m_ringidBytes = null;
    private char[] m_password = null;
    private static final int MIN_RINGID_LENGTH = 1;
    private static final int MAX_RINGID_LENGTH = 237;
    private static final int MAX_USERID_LENGTH = 8;

    public RACFOutputStream(String userID, String ringid, char[] passwd) throws IOException {
        IllegalArgumentException iae;
        if (debug != null) {
            Object[] parms = new Object[]{userID, ringid, passwd};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "RACFOutputStream", parms);
        }
        if (!PlatformUtilities.isZOS()) {
            throw new UnsupportedOperationException("RACF is only supported on z/OS");
        }
        if (ringid == null) {
            iae = new IllegalArgumentException("ringid can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RACFOutputStream", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "RACFOutputStream");
            }
            throw iae;
        }
        if (ringid.length() < 1) {
            iae = new IllegalArgumentException("ringid length must be at least 1");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RACFOutputStream", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "RACFOutputStream");
            }
            throw iae;
        }
        if (ringid.length() > 237) {
            iae = new IllegalArgumentException("ringid length must be no greater than 237");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RACFOutputStream", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "RACFOutputStream");
            }
            throw iae;
        }
        this.m_ringid = new String(ringid);
        this.m_password = passwd == null ? "password".toCharArray() : (char[])passwd.clone();
        this.m_userID = userID == null ? new String("") : new String(userID.toUpperCase());
        if (this.m_userID.length() > 8) {
            iae = new IllegalArgumentException("userid length must be no greater than 8");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RACFOutputStream", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "RACFOutputStream");
            }
            throw iae;
        }
        this.m_userIDBytes = this.m_userID.getBytes(PlatformUtilities.CHARSET_IBM_1047);
        this.m_ringidBytes = this.m_ringid.getBytes(PlatformUtilities.CHARSET_IBM_1047);
        this.m_baos = new ByteArrayOutputStream();
        this.m_stream_open = true;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "RACFOutputStream");
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{b};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "write", parms);
        }
        if (!this.m_stream_open) {
            IOException ioe = new IOException("RACFOutputStream is closed");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "write", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "write");
            }
            throw ioe;
        }
        this.m_baos.write(b);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "write");
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (debug != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            String indata = null;
            indata = null == b ? "" : encoder.encodeBuffer(b);
            Object[] parms = new Object[]{indata};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "write", parms);
        }
        if (!this.m_stream_open) {
            IOException ioe = new IOException("RACFOutputStream is closed");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "write", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "write");
            }
            throw ioe;
        }
        this.m_baos.write(b);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "write");
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (debug != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            String indata = null;
            indata = null == b ? "" : encoder.encodeBuffer(b);
            Object[] parms = new Object[]{indata, off, len};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "write", parms);
        }
        if (!this.m_stream_open) {
            IOException ioe = new IOException("RACFOutputStream is closed");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "write", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "write");
            }
            throw ioe;
        }
        this.m_baos.write(b, off, len);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "write");
        }
    }

    @Override
    public void close() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "close");
        }
        if (this.m_stream_open) {
            this.m_stream_open = false;
            if (this.m_baos != null) {
                this.m_baos.close();
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "close");
        }
    }

    @Override
    public void flush() throws IOException {
        int putCount;
        int deleteCount;
        int xVersion;
        int xMagic;
        String eyeCatcher;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "flush");
        }
        if (!this.m_stream_open) {
            IOException ioe = new IOException("RACFOutputStream is closed");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "flush");
            }
            throw ioe;
        }
        if (this.m_baos == null) {
            IOException ioe = new IOException("Output Stream is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "flush");
            }
            throw ioe;
        }
        if (this.m_baos.size() == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "flush", "Output Stream contains no data: m_baos has a length of 0");
                debug.exit(Debug.TYPE_PUBLIC, className, "flush");
            }
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.m_baos.toByteArray());
        MessageDigest md = null;
        try {
            md = this.getPreKeyedHash(this.m_password);
        }
        catch (NoSuchAlgorithmException nsae) {
            IOException ioe = new IOException("NoSuchAlgorithmException caught: " + nsae.getMessage(), nsae);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", nsae);
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "flush");
            }
            throw ioe;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new DigestInputStream(bais, md));
        }
        catch (Exception e) {
            IOException ioe = new IOException("Exception caught instantiating ObjectInputStream from the internal buffer: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "flush");
            }
            throw ioe;
        }
        try {
            eyeCatcher = (String)ois.readObject();
            xMagic = ois.readInt();
            xVersion = ois.readInt();
            deleteCount = ois.readInt();
            putCount = ois.readInt();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Exception caught reading header data from the internal buffer: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "flush");
            }
            throw ioe;
        }
        int totalCount = deleteCount + putCount;
        if (xMagic != 306006735 || xVersion != 1 || !eyeCatcher.equals(EYE_CATCHER)) {
            IOException ioe = new IOException("Invalid keystore format");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "flush", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "flush");
            }
            throw ioe;
        }
        ByteArrayOutputStream jni_baos = new ByteArrayOutputStream();
        DataOutputStream jni_dos = new DataOutputStream(jni_baos);
        Vector<Certificate> entryCerts = new Vector<Certificate>();
        Vector<Certificate> chainCerts = new Vector<Certificate>();
        for (int i = 0; i < totalCount; ++i) {
            Object obj;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "flush", "flush processing entry: i [" + i + "]");
            }
            try {
                obj = ois.readObject();
            }
            catch (Exception e) {
                IOException ioe = new IOException("Exception caught reading an entry from the internal buffer: " + e.getMessage(), e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "flush", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "flush", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "flush");
                }
                throw ioe;
            }
            if (i < deleteCount) {
                this.addDeleteEntry(obj, jni_dos);
                continue;
            }
            this.addPutEntry(obj, jni_dos, entryCerts, chainCerts);
        }
        if (this.m_password != null && totalCount != 0) {
            byte[] computed = md.digest();
            byte[] actual = new byte[computed.length];
            ois.readFully(actual);
            for (int i = 0; i < computed.length; ++i) {
                if (computed[i] == actual[i]) continue;
                IOException ioe = new IOException("Keystore was tampered with, or password was incorrect");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "flush", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "flush");
                }
                throw ioe;
            }
        }
        this.m_baos.reset();
        this.callRacfPutRecords(jni_baos, deleteCount, putCount += this.addChainCerts(jni_dos, entryCerts, chainCerts));
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "flush");
        }
    }

    private void addDeleteEntry(Object obj, DataOutputStream jni_dos) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{obj, jni_dos};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "addDeleteEntry", parms);
        }
        String alias = null;
        String certOwner = null;
        if (obj instanceof TrustedCertEntryRACF) {
            TrustedCertEntryRACF tcer = (TrustedCertEntryRACF)obj;
            certOwner = tcer.certOwner;
            alias = tcer.alias;
        } else if (obj instanceof HWKeyEntryRACF) {
            HWKeyEntryRACF hker = (HWKeyEntryRACF)obj;
            certOwner = hker.certOwner;
            alias = hker.alias;
        } else {
            IOException ioe = new IOException("Unsupported entry format");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "addDeleteEntry", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "addDeleteEntry");
            }
            throw ioe;
        }
        this.writeEntry(jni_dos, 0, certOwner, alias, null, null);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "addDeleteEntry");
        }
    }

    private void addPutEntry(Object obj, DataOutputStream jni_dos, Vector<Certificate> entryCerts, Vector<Certificate> chainCerts) throws IOException {
        int usage;
        if (debug != null) {
            Object[] parms = new Object[]{obj, jni_dos, entryCerts, chainCerts};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "addPutEntry", parms);
        }
        int numCerts = 1;
        Certificate[] certChain = null;
        Certificate mainCert = null;
        byte[] encodedCert = null;
        String alias = null;
        byte[] encodedKey = null;
        if (obj instanceof TrustedCertEntryRACF) {
            TrustedCertEntryRACF tcer = (TrustedCertEntryRACF)obj;
            usage = 2;
            alias = tcer.alias;
            mainCert = tcer.cert;
        } else if (obj instanceof HWKeyEntryRACF) {
            HWKeyEntryRACF hker = (HWKeyEntryRACF)obj;
            usage = 8;
            alias = hker.alias;
            numCerts = hker.chain.length;
            mainCert = hker.chain[0];
            certChain = hker.chain;
            encodedKey = this.getEncodedPrivateKey(hker);
        } else {
            IOException ioe = new IOException("Unsupported entry format");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "addPutEntry", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "addPutEntry");
            }
            throw ioe;
        }
        try {
            encodedCert = mainCert.getEncoded();
        }
        catch (CertificateEncodingException cee) {
            IOException ioe = new IOException("CertificateEncodingException caught while getting the encoded certificate: " + cee.getMessage(), cee);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "addPutEntry", cee);
                debug.exception(Debug.TYPE_PUBLIC, className, "addPutEntry", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "addPutEntry");
            }
            throw ioe;
        }
        entryCerts.add(mainCert);
        for (int x = 1; x < numCerts; ++x) {
            chainCerts.add(certChain[x]);
        }
        this.writeEntry(jni_dos, usage, null, alias, encodedCert, encodedKey);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "addPutEntry");
        }
    }

    private byte[] getEncodedPrivateKey(HWKeyEntryRACF hker) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getEncodedPrivateKey", hker);
        }
        byte[] recoveredKey = null;
        byte[] encodedPrivateKey = null;
        KeyProtector keyProtector = new KeyProtector(this.m_password);
        if (hker.keyType == 2 || hker.keyType == 3 || hker.keyType == 9) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", "Hardware key detected. keytype = " + hker.keyType);
            }
            try {
                recoveredKey = keyProtector.recover(hker.encToken);
            }
            catch (UnrecoverableKeyException uke) {
                IOException ioe = new IOException("UnrecoverableKeyException caught while recovering the private key: " + uke.getMessage(), uke);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", uke);
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey");
                }
                throw ioe;
            }
            catch (NoSuchAlgorithmException nsae) {
                IOException ioe = new IOException("NoSuchAlgorithmException caught while recovering the private key: " + nsae.getMessage(), nsae);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", nsae);
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey");
                }
                throw ioe;
            }
            encodedPrivateKey = PlatformUtilities.convertBytesATOE(recoveredKey);
        } else {
            try {
                encodedPrivateKey = keyProtector.recover(hker.encodedPrivateKey);
            }
            catch (UnrecoverableKeyException uke) {
                IOException ioe = new IOException("UnrecoverableKeyException caught while recovering the private key: " + uke.getMessage(), uke);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", uke);
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey");
                }
                throw ioe;
            }
            catch (NoSuchAlgorithmException nsae) {
                IOException ioe = new IOException("NoSuchAlgorithmException caught while recovering the private key: " + nsae.getMessage(), nsae);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", nsae);
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "getEncodedPrivateKey");
                }
                throw ioe;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncodedPrivateKey", encodedPrivateKey);
        }
        return encodedPrivateKey;
    }

    private int addChainCerts(DataOutputStream jni_dos, Vector<Certificate> entryCerts, Vector<Certificate> chainCerts) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{jni_dos, entryCerts, chainCerts};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "addChainCerts", parms);
        }
        int count = 0;
        for (int i = 0; i < chainCerts.size(); ++i) {
            if (entryCerts.contains(chainCerts.elementAt(i))) continue;
            ++count;
            entryCerts.add(chainCerts.elementAt(i));
            byte[] encodedCert = null;
            try {
                encodedCert = chainCerts.elementAt(i).getEncoded();
            }
            catch (CertificateEncodingException cee) {
                IOException ioe = new IOException("CertificateEncodingException caught while getting the encoded certificate: " + cee.getMessage(), cee);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "addChainCerts", cee);
                    debug.exception(Debug.TYPE_PUBLIC, className, "addChainCerts", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "addChainCerts");
                }
                throw ioe;
            }
            this.writeEntry(jni_dos, 2, null, null, encodedCert, null);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "addChainCerts", count);
        }
        return count;
    }

    private void writeEntry(DataOutputStream jni_dos, int usage, String certOwner, String alias, byte[] encodedCert, byte[] encodedKey) throws IOException {
        int keyLength;
        if (debug != null) {
            Object[] parms = new Object[]{jni_dos, usage, alias, certOwner, alias, encodedCert, encodedKey};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "writeEntry", parms);
        }
        int certOwnerLength = certOwner == null ? 0 : certOwner.length();
        int aliasLength = alias == null ? 0 : alias.length();
        int certLength = encodedCert == null ? 0 : encodedCert.length;
        int n = keyLength = encodedKey == null ? 0 : encodedKey.length;
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "writeEntry", "Writing entry - alias: [" + alias + "] usage: [" + usage + "] certOwner: [" + certOwner + "] certOwnerLength: [" + certOwnerLength + "] aliasLength: [" + aliasLength + "] certLength: [" + certLength + "] keyLength: [" + keyLength + "]");
        }
        jni_dos.writeInt(usage);
        jni_dos.writeInt(certOwnerLength);
        jni_dos.writeInt(aliasLength);
        jni_dos.writeInt(certLength);
        jni_dos.writeInt(keyLength);
        if (certOwnerLength > 0) {
            jni_dos.write(certOwner.getBytes(PlatformUtilities.CHARSET_IBM_1047), 0, certOwner.length());
        }
        if (aliasLength > 0) {
            jni_dos.write(alias.getBytes(PlatformUtilities.CHARSET_IBM_1047), 0, alias.length());
        }
        if (certLength > 0) {
            jni_dos.write(encodedCert, 0, encodedCert.length);
        }
        if (keyLength > 0) {
            jni_dos.write(encodedKey, 0, keyLength);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "writeEntry");
        }
    }

    private void callRacfPutRecords(ByteArrayOutputStream jni_baos, int deleteCount, int putCount) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{jni_baos.getClass(), new Integer(deleteCount), new Integer(putCount)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "callRacfPutRecords", parms);
        }
        RACFResults results = new RACFResults();
        RACF racf = new RACF();
        if (debug != null) {
            racf.setDebug(true);
        }
        int rc = 0;
        try {
            rc = racf.putRecords(results, this.m_userIDBytes, this.m_ringidBytes, deleteCount, putCount, jni_baos.toByteArray());
        }
        catch (Exception e) {
            IOException ioe = new IOException("Exception caught calling native method RACF.putRecords: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "callRacfPutRecords", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "callRacfPutRecords", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "callRacfPutRecords");
            }
            throw ioe;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "callRacfPutRecords", "putRecords rc = " + rc);
        }
        results.checkResults();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "callRacfPutRecords");
        }
    }

    private MessageDigest getPreKeyedHash(char[] password) throws NoSuchAlgorithmException {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getPreKeyedHash", (Object)password);
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA", "IBMJCECCA");
        }
        catch (NoSuchProviderException nspe) {
            try {
                md = MessageDigest.getInstance("SHA", "IBMJCE4758");
            }
            catch (NoSuchProviderException nspe2) {
                md = MessageDigest.getInstance("SHA");
            }
        }
        byte[] passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (i = 0; i < password.length; ++i) {
            passwdBytes[j++] = (byte)(password[i] >> 8);
            passwdBytes[j++] = (byte)password[i];
        }
        md.update(passwdBytes);
        for (i = 0; i < passwdBytes.length; ++i) {
            passwdBytes[i] = 0;
        }
        md.update("Mighty Aphrodite".getBytes(PlatformUtilities.CHARSET_UTF8));
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getPreKeyedHash", md);
        }
        return md;
    }
}

