/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CustomCertPathBuilder;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKeySpec;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryRACF;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyProtector;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RACF;
import com.ibm.crypto.hdwrCCA.provider.RACFObject;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPSSKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKeySpec;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryRACF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class RACFInputStream
extends InputStream {
    private static final int JCERACFKS_MAGIC = 306006735;
    private static final String EYE_CATCHER = "JCECCARACFKS";
    private static final int VERSION_1 = 1;
    Vector entries = null;
    ByteArrayOutputStream baos = null;
    ObjectOutputStream oos = null;
    byte[] ba = null;
    int current = 0;
    CertificateFactory cf = null;
    private static Debug debug = Debug.getInstance("ibmjceracf");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RACFInputStream";

    public RACFInputStream(String userID, String ringid, char[] passwd) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{userID, ringid, passwd};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "RACFInputStream", parms);
        }
        if (!PlatformUtilities.isZOS()) {
            throw new UnsupportedOperationException("RACF is only supported on z/OS");
        }
        char[] password = null;
        password = passwd == null ? "password".toCharArray() : (char[])passwd.clone();
        MessageDigest md = null;
        String userid = null;
        if (userID != null) {
            userid = userID.toUpperCase();
        }
        if (ringid != null) {
            this.baos = new ByteArrayOutputStream();
            if (password != null) {
                try {
                    md = this.getPreKeyedHash(password);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "RACFInputStream", e);
                    }
                    throw new IOException(e.getMessage(), e);
                }
            }
            try {
                this.cf = CertificateFactory.getInstance("X.509");
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "RACFInputStream", e);
                }
                throw new IOException(e.getMessage(), e);
            }
            this.oos = password != null ? new ObjectOutputStream(new DigestOutputStream(this.baos, md)) : new ObjectOutputStream(this.baos);
            this.entries = this.getEntries(userid, ringid, password);
            this.oos.writeObject(EYE_CATCHER);
            this.oos.writeInt(306006735);
            this.oos.writeInt(1);
            this.oos.writeInt(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                this.oos.writeObject(this.entries.elementAt(i));
            }
            if (password != null) {
                byte[] digest = md.digest();
                this.oos.write(digest);
            }
            this.oos.flush();
            this.ba = this.baos.toByteArray();
            this.oos.close();
        }
        if (this.ba == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "RACFInputStream", "Byte array is null");
            }
            throw new IOException("Byte array is null");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "RACFInputStream");
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{buffer};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "read", parms);
        }
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{buffer, new Integer(offset), new Integer(count)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "read", parms);
        }
        if (buffer.length < count) {
            return -1;
        }
        System.arraycopy(this.ba, this.current, buffer, offset, count);
        this.current += count;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "read", count);
        }
        return count;
    }

    @Override
    public int read() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "read");
        }
        if (this.ba.length < this.current) {
            return -1;
        }
        int result = this.ba[this.current] & 0xFF;
        ++this.current;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "read", result);
        }
        return result;
    }

    @Override
    public int available() {
        return this.ba.length - this.current;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.baos.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("reset/mark not supported");
    }

    private Vector getEntries(String userid, String ringid, char[] password) throws IOException {
        Hashtable racfs = null;
        Vector<Object> tmpResult = new Vector<Object>();
        Vector result = new Vector();
        Object entry = null;
        if (debug != null) {
            Object[] parms = new Object[]{userid, ringid};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getEntries", parms);
        }
        RACF racf = new RACF();
        if (debug != null) {
            racf.setDebug(true);
        }
        int rc = 0;
        try {
            rc = racf.getRecords(userid, "<null>", ringid);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getEntries", e);
            }
            throw new IOException(e.getMessage(), e);
        }
        if (rc <= 8) {
            racfs = racf.getRACFHashtable();
            Enumeration racfkeys = racfs.keys();
            while (racfkeys.hasMoreElements()) {
                String aKey = (String)racfkeys.nextElement();
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "key = " + aKey);
                }
                if ((entry = this.getEntry(racfs, aKey, password)) != null) {
                    tmpResult.addElement(entry);
                    continue;
                }
                if (debug == null) continue;
                debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "entry for key = " + aKey + " is <null>");
            }
        }
        racf = null;
        try {
            Object obj;
            ArrayList<Certificate> certs = new ArrayList<Certificate>();
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            Enumeration e = tmpResult.elements();
            while (e.hasMoreElements()) {
                obj = e.nextElement();
                if (obj instanceof HWKeyEntryRACF) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "certificate class is " + ((HWKeyEntryRACF)obj).chain[0].getClass().getName());
                        debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "add entry for " + ((HWKeyEntryRACF)obj).alias);
                    }
                    certs.add(((HWKeyEntryRACF)obj).chain[0]);
                    continue;
                }
                if (!(obj instanceof TrustedCertEntryRACF)) continue;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "certificate class is " + ((TrustedCertEntryRACF)obj).cert.getClass().getName());
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "add entry for " + ((TrustedCertEntryRACF)obj).alias);
                }
                TrustAnchor ata = new TrustAnchor((X509Certificate)((TrustedCertEntryRACF)obj).cert, null);
                trustAnchors.add(ata);
                certs.add(((TrustedCertEntryRACF)obj).cert);
            }
            e = tmpResult.elements();
            while (e.hasMoreElements()) {
                obj = e.nextElement();
                if (obj instanceof HWKeyEntryRACF) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "building certpath for " + ((HWKeyEntryRACF)obj).alias);
                    }
                    try {
                        X509Certificate targetCertificate = (X509Certificate)((HWKeyEntryRACF)obj).chain[0];
                        CustomCertPathBuilder jcp = new CustomCertPathBuilder();
                        jcp.build(targetCertificate, certs);
                        if (jcp != null) {
                            if (obj instanceof HWKeyEntryRACF) {
                                List jcpcerts = jcp.getCertificates();
                                int i = 0;
                                ((HWKeyEntryRACF)obj).chain = new X509Certificate[jcpcerts.size() + 1];
                                Iterator jcpIterator = jcpcerts.iterator();
                                while (jcpIterator.hasNext()) {
                                    ((HWKeyEntryRACF)obj).chain[i++] = (X509Certificate)jcpIterator.next();
                                }
                                ((HWKeyEntryRACF)obj).chain[i] = jcp.getTrustedCert();
                            }
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "add entry for key " + ((HWKeyEntryRACF)obj).alias);
                            }
                            result.addElement(obj);
                            continue;
                        }
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "add entry for key " + ((HWKeyEntryRACF)obj).alias);
                        }
                        result.addElement(obj);
                    }
                    catch (CertificateException ce) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "getEntries", ce);
                            debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "could not build CertPath for certificate " + ce.getMessage());
                        }
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "add entry for key " + ((HWKeyEntryRACF)obj).alias);
                        }
                        result.addElement(obj);
                    }
                    continue;
                }
                if (!(obj instanceof TrustedCertEntryRACF)) continue;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "add entry for trustedcert " + ((TrustedCertEntryRACF)obj).alias);
                }
                result.addElement(obj);
            }
        }
        catch (InvalidAlgorithmParameterException iape) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getEntries", iape);
                debug.text(Debug.TYPE_PUBLIC, className, "getEntries", "Failed validating certificate paths");
            }
            throw new IOException("Failed validating certificate paths", iape);
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getEntries", ex);
                debug.text(Debug.TYPE_PUBLIC, className, "getEntries", ex.getMessage());
            }
            throw new IOException(ex.getMessage(), ex);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEntries", result);
        }
        return result;
    }

    String x2c(byte[] data) {
        StringBuffer traceString = new StringBuffer(data.length + 100);
        String blanks = "                                       ";
        traceString.append("Data length is " + data.length + " bytes\r\n");
        for (int i = 0; i < data.length; ++i) {
            int byteValue = new Byte(data[i]).intValue();
            if ((byteValue &= 0xFF) < 16) {
                traceString.append("0");
            }
            traceString.append(Integer.toHexString(byteValue));
            if (i % 16 == 15) {
                traceString.append("      " + new String(data, i - 15, 16, PlatformUtilities.CHARSET_ISO_8859_1) + "\r\n");
                continue;
            }
            if (i + 1 == data.length) {
                traceString.append(blanks.substring(i % 16 * 2 + i % 16 / 4));
                traceString.append(new String(data, i - i % 16, i % 16 + 1, PlatformUtilities.CHARSET_ISO_8859_1) + "\r\n");
                continue;
            }
            if (i % 4 != 3) continue;
            traceString.append(" ");
        }
        return traceString.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getEntry(Hashtable racfs, String key, char[] passwd) throws IOException {
        X509Certificate x509certificate = null;
        KeyProtector keyProtector = null;
        HWKeyEntryRACF hker = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEntry", racfs, key);
        }
        char[] password = passwd == null ? "password".toCharArray() : passwd;
        RACFObject obj = (RACFObject)racfs.get(key);
        if (obj == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "no entry found for key " + key);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEntry_1", null);
            }
            return null;
        }
        if (obj.getCert() == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "no certificate found for key " + key);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEntry_2", null);
            }
            return null;
        }
        try {
            x509certificate = (X509Certificate)this.cf.generateCertificate(new ByteArrayInputStream(obj.getCert()));
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "exception " + e.toString() + " caught creating X509Certificate");
                debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", e);
            }
            throw new IOException(e.getMessage(), e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "entry for key = " + key + " has a certificate");
            debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "entry for key = " + key + " usage is " + obj.getUsage());
        }
        if (obj.getUsage() == 2) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "entry for key = " + key + " is a CA");
            }
            TrustedCertEntryRACF tcer = new TrustedCertEntryRACF();
            tcer.alias = new String(key);
            tcer.certOwner = obj.getCertOwner();
            tcer.date = new Date();
            tcer.cert = x509certificate;
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEntry_3", tcer);
            }
            return tcer;
        }
        if (obj.getUsage() == 8) {
            if (obj.getKeyLength() == 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "The private key of " + key + " is not available or no authority to access the private key ");
                }
                throw new IOException("The private key of " + key + " is not available or no authority to access the private key ");
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "entry for key = " + key + " has a private key");
            }
            if (obj.getKeyType() == 2 || obj.getKeyType() == 3) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "entry for key = " + key + ", keytype = " + obj.getKeyType() + ", has a hardware private key");
                }
                byte[] label = PlatformUtilities.convertBytesETOA(obj.getKey());
                hker = new HWKeyEntryRACF();
                hker.date = new Date();
                hker.alias = new String(key);
                hker.certOwner = obj.getCertOwner();
                hker.chain = new X509Certificate[1];
                hker.chain[0] = x509certificate;
                hker.keyType = obj.getKeyType();
                try {
                    RSAPrivateHWKeySpec keyspec = new RSAPrivateHWKeySpec(label, 0);
                    KeyFactory keyFactory = Security.getProvider("IBMJCECCA") == null ? KeyFactory.getInstance("RSA", "IBMJCE4758") : KeyFactory.getInstance("RSASSA-PSS", "IBMJCECCA");
                    PrivateKey akey = keyFactory.generatePrivate(keyspec);
                    keyProtector = new KeyProtector(password);
                    hker.encToken = keyProtector.protect(((RSAPrivateHWKey)akey).getToken());
                    hker.keyAttribs = new RSAPSSKeyHWAttributes(((RSAPrivateHWKey)akey).getType(), ((RSAPrivateHWKey)akey).getUsage());
                    hker.externalKeyToken = null;
                    hker.encodedPrivateKey = null;
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", e);
                    }
                    throw new IOException(e.getMessage(), e);
                }
            }
            if (obj.getKeyType() == 9) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "entry for key = " + key + ", keytype = " + obj.getKeyType() + ", has a hardware private key");
                }
                byte[] label = PlatformUtilities.convertBytesETOA(obj.getKey());
                hker = new HWKeyEntryRACF();
                hker.date = new Date();
                hker.alias = new String(key);
                hker.certOwner = obj.getCertOwner();
                hker.chain = new X509Certificate[1];
                hker.chain[0] = x509certificate;
                hker.keyType = obj.getKeyType();
                try {
                    ECPublicKey publicKey = (ECPublicKey)x509certificate.getPublicKey();
                    ECParameterSpec paramSpec = publicKey.getParams();
                    ECPrivateHWKeySpec keyspec = new ECPrivateHWKeySpec(label, paramSpec, 0);
                    KeyFactory keyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
                    ECPrivateHWKey akey = (ECPrivateHWKey)keyFactory.generatePrivate(keyspec);
                    keyProtector = new KeyProtector(password);
                    hker.encToken = keyProtector.protect(akey.getToken());
                    hker.keyAttribs = new ECHWKeyAttributes(akey.getType(), akey.getUsage());
                    hker.externalKeyToken = null;
                    hker.encodedPrivateKey = null;
                }
                catch (Exception e) {
                    IOException ioe = new IOException(e.getMessage(), e);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", e);
                        debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", ioe);
                        debug.exit(Debug.TYPE_PUBLIC, className, "getEntry");
                    }
                    throw ioe;
                }
            }
            if (obj.getKeyType() == 1) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "entry for key = " + key + " has a software private key");
                }
                try {
                    KeyPairUtils.KeyPairAlgorithm keyPairAlgorithm;
                    hker = new HWKeyEntryRACF();
                    hker.date = new Date();
                    hker.alias = new String(key);
                    hker.certOwner = obj.getCertOwner();
                    hker.chain = new X509Certificate[1];
                    hker.chain[0] = x509certificate;
                    hker.keyType = obj.getKeyType();
                    PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(obj.getKey());
                    KeyFactory keyFactory = null;
                    PrivateKey akey = null;
                    try {
                        keyFactory = KeyFactory.getInstance("RSA", "IBMJCE");
                        akey = keyFactory.generatePrivate(keyspec);
                        keyPairAlgorithm = KeyPairUtils.KeyPairAlgorithm.RSA;
                    }
                    catch (GeneralSecurityException e) {
                        keyFactory = KeyFactory.getInstance("RSASSA-PSS", "IBMJCE");
                        akey = keyFactory.generatePrivate(keyspec);
                        keyPairAlgorithm = KeyPairUtils.KeyPairAlgorithm.RSAPSS;
                    }
                    KeyPairUtils kpu = new KeyPairUtils();
                    kpu.initializeRSA(((RSAPrivateKey)akey).getPrivateExponent().bitLength(), null, new RSAKeyHWAttributes(2, 4), null, keyPairAlgorithm);
                    RSAPrivateHWKey newKey = (RSAPrivateHWKey)kpu.generatePrivateHWKey(x509certificate.getPublicKey(), akey);
                    hker.keyAttribs = keyPairAlgorithm == KeyPairUtils.KeyPairAlgorithm.RSAPSS ? new RSAPSSKeyHWAttributes(newKey.getType(), newKey.getUsage()) : new RSAKeyHWAttributes(newKey.getType(), newKey.getUsage());
                    keyProtector = new KeyProtector(password);
                    hker.encToken = keyProtector.protect(newKey.getToken());
                    byte[] myExternalToken = newKey.getExternalKeyToken();
                    if (myExternalToken != null) {
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "Storing external key token for use with clear key");
                        }
                        hker.externalKeyToken = keyProtector.protect(myExternalToken);
                    } else {
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "No external key token was saved must not be a clear key");
                        }
                        hker.externalKeyToken = null;
                    }
                    hker.encodedPrivateKey = keyProtector.protect(obj.getKey());
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "exception " + e.toString() + " caught creating RSA private key");
                        debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", e);
                    }
                    throw new IOException(e.getMessage(), e);
                }
            }
            if (obj.getKeyType() == 7) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "entry for key = " + key + " has a software private key");
                }
                try {
                    hker = new HWKeyEntryRACF();
                    hker.date = new Date();
                    hker.alias = new String(key);
                    hker.certOwner = obj.getCertOwner();
                    hker.chain = new X509Certificate[1];
                    hker.chain[0] = x509certificate;
                    hker.keyType = obj.getKeyType();
                    PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(obj.getKey());
                    KeyFactory keyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
                    ECPrivateHWKey migratedKey = (ECPrivateHWKey)keyFactory.generatePrivate(keyspec);
                    hker.keyAttribs = new ECHWKeyAttributes(migratedKey.getType(), migratedKey.getUsage());
                    keyProtector = new KeyProtector(password);
                    hker.encToken = keyProtector.protect(migratedKey.getToken());
                    byte[] myExternalToken = migratedKey.getExternalKeyToken();
                    if (myExternalToken != null) {
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "Storing external key token for use with clear key");
                        }
                        hker.externalKeyToken = keyProtector.protect(myExternalToken);
                    } else {
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "No external key token was saved must not be a clear key");
                        }
                        hker.externalKeyToken = null;
                    }
                    hker.encodedPrivateKey = keyProtector.protect(obj.getKey());
                }
                catch (Exception e) {
                    IOException ioe = new IOException(e.getMessage(), e);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "getEntry", "exception " + e.toString() + " caught creating EC private key");
                        debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", e);
                        debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", ioe);
                        debug.exit(Debug.TYPE_PUBLIC, className, "getEntry");
                    }
                    throw ioe;
                }
            } else {
                if (obj.getKeyType() == 4 || obj.getKeyType() == 6) {
                    IOException ioe = new IOException("The private key of " + key + " is a software DSA or DH key. Error creating key entry because DSA and DH keys are not supported.");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", ioe);
                        debug.exit(Debug.TYPE_PUBLIC, className, "getEntry");
                    }
                    throw ioe;
                }
                if (obj.getKeyType() == 14 || obj.getKeyType() == 11 || obj.getKeyType() == 13) {
                    IOException ioe = new IOException("The private key of " + key + " is a PKCS#11 secure TKDS key. Error creating key entry because PKCS#11 secure TKDS keys are not supported.");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", ioe);
                        debug.exit(Debug.TYPE_PUBLIC, className, "getEntry");
                    }
                    throw ioe;
                }
                IOException ioe = new IOException("The private key of " + key + " is not a software or ICSF key. Error creating key entry because private key is not available.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "getEntry");
                }
                throw ioe;
            }
        }
        IOException ioe = new IOException("The key " + key + " is not connected as a PERSONAL or CERTAUTH certificate. Certificates connected as SITE certificates are not supported.");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "getEntry", ioe);
            debug.exit(Debug.TYPE_PUBLIC, className, "getEntry");
        }
        throw ioe;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEntry", hker);
        }
        return hker;
    }

    private MessageDigest getPreKeyedHash(char[] password) throws NoSuchAlgorithmException {
        int i;
        MessageDigest md = null;
        try {
            md = Security.getProvider("IBMJCECCA") == null ? MessageDigest.getInstance("SHA", "IBMJCE4758") : MessageDigest.getInstance("SHA", "IBMJCECCA");
        }
        catch (NoSuchProviderException nspe) {
            md = MessageDigest.getInstance("SHA");
        }
        byte[] passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (i = 0; i < password.length; ++i) {
            passwdBytes[j++] = (byte)(password[i] >> 8);
            passwdBytes[j++] = (byte)password[i];
        }
        md.update(passwdBytes);
        for (i = 0; i < passwdBytes.length; ++i) {
            passwdBytes[i] = 0;
        }
        md.update("Mighty Aphrodite".getBytes(PlatformUtilities.CHARSET_UTF8));
        return md;
    }

    static String hexToString(byte[] b, int linelen, boolean RAW) {
        String result = new String();
        for (int i = 0; i < b.length; ++i) {
            int j;
            if (i % linelen == 0 && !RAW) {
                result = result.concat(Integer.toHexString(i & 0xFFFF | 0x10000).substring(1, 5) + " - ");
            }
            result = result.concat(Integer.toHexString(b[i] & 0xFF | 0x100).substring(1, 3));
            if (i > 1 & (i + 1) % 4 == 0) {
                result = result.concat(" ");
            }
            if (i % linelen != linelen - 1 && i != b.length - 1) continue;
            for (j = linelen - i % linelen; j > 1; --j) {
                result = result.concat("  ");
                if (j % 4 != 0) continue;
                result = result.concat(" ");
            }
            if (!RAW) {
                result = result.concat(" - ");
            }
            int start = i / linelen * linelen;
            int end = b.length < i + 1 ? b.length : i + 1;
            j = start;
            while (j < end & !RAW) {
                result = b[j] >= 32 && b[j] <= 126 ? result.concat(String.valueOf((char)b[j])) : result.concat(".");
                ++j;
            }
            result = result.concat("\n");
        }
        result = result.concat("\n");
        return result;
    }
}

