/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKey;
import com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKeySpec;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public final class PKCS5DerivedKeyFactory
extends SecretKeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKeyFactory";

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", keySpec);
        }
        if (keySpec == null || !(keySpec instanceof PKCS5DerivedKeySpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "Invalid key spec");
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", new PKCS5DerivedKey((PKCS5DerivedKeySpec)keySpec));
        }
        return new PKCS5DerivedKey((PKCS5DerivedKeySpec)keySpec);
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpecCl) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetKeySpec", key, keySpecCl);
        }
        try {
            if (key != null && key instanceof SecretKey && key.getFormat().equalsIgnoreCase("PKCS5_DERIVED_KEY")) {
                Class<?> pbeKeySpecCl = Class.forName("com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKeySpec");
                if (keySpecCl != null && pbeKeySpecCl.isAssignableFrom(keySpecCl)) {
                    String func;
                    int keyLen;
                    int iCount;
                    byte[] saltBytes;
                    byte[] passwdBytes;
                    DerInputStream derIn;
                    try {
                        byte[] keyEncoding = key.getEncoded();
                        derIn = new DerInputStream(keyEncoding);
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    try {
                        byte[] keyBytes = derIn.getOctetString();
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    try {
                        passwdBytes = derIn.getOctetString();
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    char[] passwdChars = new char[passwdBytes.length];
                    for (int i = 0; i < passwdChars.length; ++i) {
                        passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                    }
                    try {
                        saltBytes = derIn.getOctetString();
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    try {
                        iCount = derIn.getInteger().intValue();
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    try {
                        keyLen = derIn.getInteger().intValue();
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    try {
                        DerValue derFunc = derIn.getDerValue();
                        func = derFunc.getPrintableString();
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    PKCS5DerivedKeySpec ret = new PKCS5DerivedKeySpec(passwdChars, saltBytes, iCount, keyLen, func);
                    Arrays.fill(passwdChars, ' ');
                    Arrays.fill(passwdBytes, (byte)0);
                    return ret;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Invalid key spec");
                }
                throw new InvalidKeySpecException("Invalid key spec");
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Invalid key");
            }
            throw new InvalidKeySpecException("Invalid key");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
            }
            throw new InvalidKeySpecException("Unsupported key spec: " + e.getMessage());
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
        }
        try {
            if (key != null) {
                if (key instanceof PKCS5DerivedKey) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey_1", key);
                    }
                    return key;
                }
                PKCS5DerivedKeySpec pbeKeySpec = (PKCS5DerivedKeySpec)this.engineGetKeySpec(key, (Class)PKCS5DerivedKeySpec.class);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey_2", this.engineGenerateSecret(pbeKeySpec));
                }
                return this.engineGenerateSecret(pbeKeySpec);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey_2", "Invalid key");
            }
            throw new InvalidKeyException("Invalid key");
        }
        catch (InvalidKeySpecException ikse) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey_2", ikse);
            }
            throw new InvalidKeyException("Cannot translate key: " + ikse.getMessage());
        }
    }
}

