/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKeySpec;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;

class PKCS5DerivedKey
implements SecretKey {
    static final long serialVersionUID = 463050993315590179L;
    private String IBM_PROVIDER = "IBMJCECCA";
    private byte[] key;
    private byte[] pwd;
    private byte[] salt;
    private int iCount;
    private int keyLen;
    private String encrFunction;
    private String algorithm;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKey";

    public PKCS5DerivedKey(PKCS5DerivedKeySpec keySpec) throws InvalidKeySpecException {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "PKCS5DerivedKey", keySpec);
        }
        char[] passwd = keySpec.getPassword();
        for (i = 0; i < passwd.length; ++i) {
            if (passwd[i] >= ' ' && passwd[i] <= '~') continue;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DerivedKey", "Password is not ASCII");
            }
            throw new InvalidKeySpecException("Password is not ASCII");
        }
        this.pwd = new byte[passwd.length];
        for (i = 0; i < passwd.length; ++i) {
            this.pwd[i] = (byte)(passwd[i] & 0x7F);
        }
        Arrays.fill(passwd, ' ');
        this.salt = keySpec.getSalt();
        this.iCount = keySpec.getIterationCount();
        this.keyLen = keySpec.getKeyLength();
        this.encrFunction = keySpec.getEncryptionFunction();
        this.algorithm = null;
        this.key = this.encrFunction.equals("MD2") || this.encrFunction.equals("MD5") || this.encrFunction.equals("SHA1") ? this.PBKDF1() : this.PBKDF2();
        if (this.key == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DerivedKey", "Key encryption algorithm not found");
            }
            throw new InvalidKeySpecException("Key encryption algorithm not found");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "PKCS5DerivedKey");
        }
    }

    private byte[] PBKDF1() {
        MessageDigest md;
        if (debug != null) {
            debug.entry(8192L, className, "PBKDF1");
        }
        byte[] concat = new byte[this.pwd.length + this.salt.length];
        System.arraycopy(this.pwd, 0, concat, 0, this.pwd.length);
        System.arraycopy(this.salt, 0, concat, this.pwd.length, this.salt.length);
        try {
            md = Security.getProvider(this.IBM_PROVIDER) == null ? MessageDigest.getInstance(this.encrFunction, "IBMJCE4758") : MessageDigest.getInstance(this.encrFunction, this.IBM_PROVIDER);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "PBKDF1", e);
            }
            try {
                md = MessageDigest.getInstance(this.encrFunction);
            }
            catch (Exception e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "PBKDF1", e);
                    debug.exit(8192L, (Object)className, "PBKDF1_1", null);
                }
                return null;
            }
        }
        md.update(concat);
        byte[] digest = md.digest();
        for (int i = 1; i < this.iCount; ++i) {
            md.update(digest);
            digest = md.digest();
        }
        Arrays.fill(concat, (byte)0);
        byte[] encodedKey = new byte[this.keyLen];
        System.arraycopy(digest, 0, encodedKey, 0, this.keyLen);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "PBKDF1_2", encodedKey);
        }
        return encodedKey;
    }

    private byte[] PBKDF2() {
        if (debug != null) {
            debug.entry(8192L, className, "PBKDF2");
            debug.exit(8192L, (Object)className, "PBKDF2", null);
        }
        return null;
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
        if (this.pwd != null) {
            Arrays.fill(this.pwd, (byte)0);
            this.pwd = null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
    }

    @Override
    public byte[] getEncoded() {
        DerOutputStream out = new DerOutputStream();
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncoded");
        }
        try {
            out.putOctetString(this.key);
            out.putOctetString(this.pwd);
            out.putOctetString(this.salt);
            out.putInteger(BigInteger.valueOf(this.iCount));
            out.putInteger(BigInteger.valueOf(this.keyLen));
            out.putPrintableString(this.encrFunction);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getEncoded", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", null);
            }
            return null;
        }
        byte[] result = out.toByteArray();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", result);
        }
        return result;
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAlgorithm");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAlgorithm", null);
        }
        return null;
    }

    public String getEncryptionFunction() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncryptionFunction");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncryptionFunction", new String(this.encrFunction));
        }
        return new String(this.encrFunction);
    }

    public byte[] getEncodedKey() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncodedKey");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncodedKey", (byte[])this.key.clone());
        }
        return (byte[])this.key.clone();
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFormat");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", "PKCS5_DERIVED_KEY");
        }
        return "PKCS5_DERIVED_KEY";
    }

    public int hashCode() {
        int i;
        int retval = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "hashCode");
        }
        for (i = 1; i < this.key.length; ++i) {
            retval += this.key[i] * i;
        }
        for (i = 1; i < this.salt.length; ++i) {
            retval += this.salt[i] * i;
        }
        retval ^= this.iCount;
        retval ^= this.keyLen;
        retval ^= this.getEncryptionFunction().toLowerCase().hashCode();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals", true);
            }
            return true;
        }
        if (!(obj instanceof SecretKey)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals", false);
            }
            return false;
        }
        SecretKey that = (SecretKey)obj;
        byte[] thatEncoded = that.getEncoded();
        boolean ret = Arrays.equals(this.getEncoded(), thatEncoded);
        Arrays.fill(thatEncoded, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals", ret);
        }
        return ret;
    }
}

