/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPublicKey;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

final class PKA
extends CipherSpi {
    private byte[] buffer = null;
    private ByteArrayOutputStream bArray;
    private Cipher cipher = null;
    private boolean decrypting = false;
    private BigInteger modulus = BigInteger.ZERO;
    private byte[] token = null;
    private hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private HIKM hikm = null;
    private byte[] exitData = new byte[0];
    private byte[] pkaEncipheredkey;
    private boolean longBuffers = false;
    private int maxEncipheredKeyLength = 256;
    private hikmNativeInteger textLength;
    private hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
    private hikmNativeInteger datastructureLength = new hikmNativeInteger(0);
    private hikmNativeInteger pkaEncipheredKeyLength = new hikmNativeInteger(0);
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKA";

    public PKA() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "PKA");
        }
        IBMJCECCA.verifyJceJar();
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKA", "The IBMJCECCA provider may have been tampered.");
            }
            throw new SecurityException("The IBMJCECCA provider may have been tampered.");
        }
        this.hikm = new HIKM();
        this.longBuffers = HardwareProfile.getIs4096RNGLSupported();
        if (this.longBuffers) {
            this.maxEncipheredKeyLength = 512;
        }
        this.pkaEncipheredkey = new byte[this.maxEncipheredKeyLength];
        if (debug != null) {
            String info = new String(HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + this.longBuffers);
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "PKA", info);
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineSetMode", mode);
        }
        if (mode != null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Mode: " + mode + " not implemented");
            }
            throw new NoSuchAlgorithmException("Mode: " + mode + " not implemented");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineSetMode");
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineSetPadding", paddingScheme);
        }
        if (paddingScheme.equalsIgnoreCase("PKCS1Padding")) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, "engineSetPadding");
            }
            return;
        }
        if (paddingScheme == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "null padding");
            }
            throw new NoSuchPaddingException("null padding");
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "Padding: " + paddingScheme + " not implemented");
        }
        throw new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
    }

    @Override
    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineGetBlockSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetBlockSize", 0);
        }
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineGetOutputSize", new Integer(inputLen));
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetOutputSize", 256);
        }
        return 256;
    }

    @Override
    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineGetIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetIV", null);
        }
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineGetParameters");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetParameters", null);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.buffer = null;
        this.bArray = new ByteArrayOutputStream();
        this.cipher = null;
        if (PKA.debug != null) {
            parms = new Object[]{new Integer(opmode), key, random};
            PKA.debug.entry(Debug.TYPE_PUBLIC, (Object)PKA.className, "engineInit", parms);
        }
        if (opmode == 4 || opmode == 3) {
            if (PKA.debug != null) {
                PKA.debug.text(Debug.TYPE_PUBLIC, PKA.className, "engineInit", "Invalid operation mode only Encrypt and Decrypt mode is supported.");
            }
            throw new InvalidParameterException("Invalid operation mode only Encrypt and Decrypt mode is supported.");
        }
        this.decrypting = opmode == 2;
        if (key == null) {
            if (PKA.debug != null) {
                PKA.debug.text(Debug.TYPE_PUBLIC, PKA.className, "engineInit", "No key given");
            }
            throw new InvalidKeyException("No key given");
        }
        if (!(key instanceof RSAKey)) {
            pszkey = key.getAlgorithm();
            if (PKA.debug != null) {
                PKA.debug.text(Debug.TYPE_PUBLIC, PKA.className, "engineInit", "Not a RSA key.  Key algorithm is " + pszkey + ".");
            }
            throw new InvalidKeyException("Not a RSA key.  Key algorithm is " + pszkey + ".");
        }
        if (key instanceof PublicKey) {
            if (this.decrypting) {
                if (PKA.debug != null) {
                    PKA.debug.text(Debug.TYPE_PUBLIC, PKA.className, "engineInit", "Public Key cannot be used to decrypt.");
                }
                throw new InvalidKeyException("Public Key cannot be used to decrypt.");
            }
            try {
                this.modulus = ((RSAPublicKey)key).getModulus();
                this.token = ((RSAPublicKey)key).getToken();
                if (!PlatformUtilities.isZOS()) ** GOTO lbl54
                this.token = PlatformUtilities.convertBytesIfKeyLabelATOE(this.token);
            }
            catch (Exception ex) {
                if (PKA.debug != null) {
                    PKA.debug.exception(Debug.TYPE_PUBLIC, PKA.className, "engineInit", ex);
                }
                throw new InvalidKeyException("Bad key encoding");
            }
        } else if (key instanceof PrivateKey) {
            if (!this.decrypting) {
                if (PKA.debug != null) {
                    PKA.debug.text(Debug.TYPE_PUBLIC, PKA.className, "engineInit", "Private key cannot be used to encrypt.");
                }
                throw new InvalidKeyException("Private key cannot be used to encrypt.");
            }
            try {
                priv = (RSAPrivateHWKey)key;
                this.token = priv.getToken();
                if (!PlatformUtilities.isZOS()) ** GOTO lbl54
                this.token = PlatformUtilities.convertBytesIfKeyLabelATOE(this.token);
            }
            catch (Exception ex) {
                if (PKA.debug != null) {
                    PKA.debug.exception(Debug.TYPE_PUBLIC, PKA.className, "engineInit", ex);
                }
                throw new InvalidKeyException("Bad key encoding");
            }
        } else {
            if (PKA.debug != null) {
                PKA.debug.text(Debug.TYPE_PUBLIC, PKA.className, "engineInit", "Must be either public key or private key.");
            }
            throw new InvalidKeyException("Must be either public key or private key.");
        }
lbl54:
        // 4 sources

        if (PKA.debug != null) {
            PKA.debug.exit(Debug.TYPE_PUBLIC, PKA.className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineUpdate", parms);
        }
        if (input != null) {
            this.bArray.write(input, inputOffset, inputLen);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineUpdate", new byte[0]);
        }
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineUpdate", parms);
        }
        if (input != null) {
            this.bArray.write(input, inputOffset, inputLen);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineUpdate");
        }
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineDoFinal", parms);
        }
        if (input != null) {
            this.bArray.write(input, inputOffset, inputLen);
        }
        this.buffer = this.bArray.toByteArray();
        byte[] result = this.rsa(this.buffer, this.buffer.length);
        if (result == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Not PKCS#1 block type 2 padding");
            }
            throw new BadPaddingException("Not PKCS#1 block type 2 padding");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineDoFinal", result);
        }
        return result;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_PUBLIC, className, "engineDoFinal");
        }
        if (input != null) {
            this.bArray.write(input, inputOffset, inputLen);
        }
        this.buffer = this.bArray.toByteArray();
        byte[] result = this.rsa(this.buffer, this.buffer.length);
        if (result == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Not PKCS#1 block type 2 padding");
            }
            throw new BadPaddingException("Not PKCS#1 block type 2 padding");
        }
        if (result.length > output.length - outputOffset) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + result.length + " bytes needed");
            }
            throw new ShortBufferException("Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + result.length + " bytes needed");
        }
        System.arraycopy(result, 0, output, outputOffset, result.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineDoFinal", result.length);
        }
        return result.length;
    }

    private byte[] rsa(byte[] data, int len) {
        String exitDataString;
        HexDumpEncoder encoder = null;
        if (debug != null) {
            debug.entry(8192L, className, "rsa", data, new Integer(len));
            encoder = new HexDumpEncoder();
        }
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        hikmNativeInteger dataLength = new hikmNativeInteger(len);
        hikmNativeInteger tokenLength = new hikmNativeInteger(this.token.length);
        hikmNativeInteger dataStructureLength = new hikmNativeInteger(0);
        byte[] dataStructure = new byte[]{};
        String ruleText = null;
        ruleText = new String("PKCS-1.2");
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
        this.pkaEncipheredKeyLength.setValue(this.pkaEncipheredkey.length);
        if (!this.decrypting) {
            String exitDataString2;
            try {
                if (null != debug) {
                    exitDataString2 = "\n" + encoder.encodeBuffer(this.exitData);
                    String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                    String dataString = "\n" + encoder.encodeBuffer(data);
                    String tokenString = "\n" + encoder.encodeBuffer(this.token);
                    String parmsReport = "\nKeyPairUtils: CSNDPKE INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString2 + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    dataLength     : " + dataLength.getValue() + "\n    data           : " + dataString + "\n    dataStructLen  : " + dataStructureLength.getValue() + "\n    tokenLength    : " + tokenLength.getValue() + "\n    token          : " + tokenString + "\n    pkaEncphrKeyLen: " + this.pkaEncipheredKeyLength.getValue() + "\n";
                    debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
                }
                this.hikm.CSNDPKEJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, dataLength, data, dataStructureLength, dataStructure, tokenLength, this.token, this.pkaEncipheredKeyLength, this.pkaEncipheredkey);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(8192L, className, "rsa", e);
                }
                throw new RuntimeException("Hardware error from call CSNDPKE " + e);
            }
            if (null != debug) {
                exitDataString2 = "\n" + encoder.encodeBuffer(this.exitData);
                String pkaEncipheredkeyString = "\n" + encoder.encodeBuffer(this.pkaEncipheredkey);
                String parmsReport = "\nKeyPairUtils: CSNDPKE RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString2 + "\n    pkaEncphrKeyLen: " + this.pkaEncipheredKeyLength.getValue() + "\n    pkaEncipherkey : " + pkaEncipheredkeyString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "rsa", "CSNDPKE Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
            }
            if (this.returnCode.getValue() != 0) {
                if (debug != null) {
                    debug.text(8192L, className, "rsa", "Hardware error from call CSNDPKE returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
                }
                throw new JCECCARuntimeException(1, "CSNKPKE", "Hardware error from call CSNDPKE returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
            byte[] result = new byte[this.pkaEncipheredKeyLength.getValue()];
            System.arraycopy(this.pkaEncipheredkey, 0, result, 0, this.pkaEncipheredKeyLength.getValue());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "rsa_1", result);
            }
            return result;
        }
        try {
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                String dataString = "\n" + encoder.encodeBuffer(data);
                String tokenString = "\n" + encoder.encodeBuffer(this.token);
                String parmsReport = "\nKeyPairUtils: CSNDPKD INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    dataLength     : " + dataLength.getValue() + "\n    data           : " + dataString + "\n    tokenLength    : " + tokenLength.getValue() + "\n    token          : " + tokenString + "\n    pkaDecphrKeyLen: " + this.pkaEncipheredKeyLength.getValue() + "\n";
                debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
            }
            this.hikm.CSNDPKDJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, dataLength, data, dataStructureLength, dataStructure, tokenLength, this.token, this.pkaEncipheredKeyLength, this.pkaEncipheredkey);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Hardware error from call CSNDPKD " + e);
        }
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String pkaEncipheredkeyString = "\n" + encoder.encodeBuffer(this.pkaEncipheredkey);
            String parmsReport = "\nKeyPairUtils: CSNDPKD RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    pkaDecphrKeyLen: " + this.pkaEncipheredKeyLength.getValue() + "\n    pkaDecipherkey : " + pkaEncipheredkeyString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "rsa", "CSNDPKD Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
        }
        if (this.returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(8192L, className, "rsa", "Hardware error from call CSNDPKD returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "CSNDPKD", "Hardware error from call CSNDPKD returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        byte[] result = new byte[this.pkaEncipheredKeyLength.getValue()];
        System.arraycopy(this.pkaEncipheredkey, 0, result, 0, this.pkaEncipheredKeyLength.getValue());
        if (debug != null) {
            debug.exit(8192L, (Object)className, "rsa_2", result);
        }
        return result;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineGetKeySize", key);
        }
        if (key instanceof PublicKey) {
            try {
                BigInteger n = ((RSAPublicKey)key).getModulus();
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetKeySize", (n.bitLength() + 1) / 2);
                }
                return (n.bitLength() + 1) / 2;
            }
            catch (Exception ex) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySize", ex);
                }
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        if (key instanceof PrivateKey) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySize", "Information not available for protected private keys.");
            }
            throw new InvalidKeyException("Information not available for protected private keys.");
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySize", "Must be either public key or private key.");
        }
        throw new InvalidKeyException("Must be either public key or private key.");
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineWrap", key);
            debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Key wrapping not supported.");
        }
        throw new InvalidKeyException("Key wrapping not supported.");
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{wrappedKey, wrappedKeyAlgorithm, new Integer(wrappedKeyType)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineUnwrap", parms);
            debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Key wrapping not supported.");
        }
        throw new InvalidKeyException("Key wrapping not supported.");
    }
}

