/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.misc.Debug;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyRep;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

final class PBKDF2KeyImpl
implements PBEKey {
    static final long serialVersionUID = -2234868909660948157L;
    private static Debug debug = Debug.getInstance((String)"ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PBKDF2KeyImpl";
    private static HexDumpEncoder encoder = debug != null ? new HexDumpEncoder() : null;
    private char[] passwd;
    private byte[] salt;
    private int iterCount;
    private byte[] key;
    private Mac prf;

    private static byte[] getPasswordBytes(char[] passwd) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getPasswordBytes");
        }
        Charset utf8 = Charset.forName("UTF-8");
        CharBuffer cb = CharBuffer.wrap(passwd);
        ByteBuffer bb = utf8.encode(cb);
        int len = bb.limit();
        byte[] passwdBytes = new byte[len];
        bb.get(passwdBytes, 0, len);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPasswordBytes");
        }
        return passwdBytes;
    }

    PBKDF2KeyImpl(PBEKeySpec keySpec, String prfAlgo) throws InvalidKeySpecException {
        char[] passwd;
        if (debug != null) {
            Object[] parms = new Object[]{keySpec, prfAlgo};
            debug.entry(16384L, (Object)className, "PBKDF2KeyImpl", parms);
        }
        this.passwd = (passwd = keySpec.getPassword()) == null ? new char[0] : (char[])passwd.clone();
        byte[] passwdBytes = PBKDF2KeyImpl.getPasswordBytes(this.passwd);
        this.salt = keySpec.getSalt();
        if (this.salt == null) {
            InvalidKeySpecException iks = new InvalidKeySpecException("Salt not found");
            if (debug != null) {
                debug.text(16384L, (Object)className, "PBKDF2KeyImpl", "Salt not found");
                debug.exception(16384L, (Object)className, "PBKDF2KeyImpl", (Throwable)iks);
            }
            throw iks;
        }
        this.iterCount = keySpec.getIterationCount();
        if (this.iterCount == 0) {
            InvalidKeySpecException iks = new InvalidKeySpecException("Iteration count not found");
            if (debug != null) {
                debug.text(16384L, (Object)className, "PBKDF2KeyImpl", "Iteration count not found");
                debug.exception(16384L, (Object)className, "PBKDF2KeyImpl", (Throwable)iks);
            }
            throw iks;
        }
        if (this.iterCount < 0) {
            InvalidKeySpecException iks = new InvalidKeySpecException("Iteration count is negative");
            if (debug != null) {
                debug.text(16384L, (Object)className, "PBKDF2KeyImpl", "Iteration count is negative");
                debug.exception(16384L, (Object)className, "PBKDF2KeyImpl", (Throwable)iks);
            }
            throw iks;
        }
        int keyLength = keySpec.getKeyLength();
        if (keyLength == 0) {
            InvalidKeySpecException iks = new InvalidKeySpecException("Key length not found");
            if (debug != null) {
                debug.text(16384L, (Object)className, "PBKDF2KeyImpl", "Key length not found");
                debug.exception(16384L, (Object)className, "PBKDF2KeyImpl", (Throwable)iks);
            }
            throw iks;
        }
        if (keyLength < 0) {
            InvalidKeySpecException iks = new InvalidKeySpecException("Key length is negative");
            if (debug != null) {
                debug.text(16384L, (Object)className, "PBKDF2KeyImpl", "Key length is negative");
                debug.exception(16384L, (Object)className, "PBKDF2KeyImpl", (Throwable)iks);
            }
            throw iks;
        }
        try {
            this.prf = Mac.getInstance(prfAlgo, "IBMJCECCA");
        }
        catch (NoSuchAlgorithmException nsae) {
            InvalidKeySpecException ike = new InvalidKeySpecException();
            ike.initCause(nsae);
            if (debug != null) {
                debug.exception(16384L, (Object)className, "PBKDF2KeyImpl", (Throwable)ike);
            }
            throw ike;
        }
        catch (NoSuchProviderException nspe) {
            InvalidKeySpecException ike = new InvalidKeySpecException();
            ike.initCause(nspe);
            if (debug != null) {
                debug.exception(16384L, (Object)className, "PBKDF2KeyImpl", (Throwable)ike);
            }
            throw ike;
        }
        this.key = PBKDF2KeyImpl.deriveKey(this.prf, passwdBytes, this.salt, this.iterCount, keyLength);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "PBKDF2KeyImpl");
        }
    }

    private static byte[] deriveKey(final Mac prf, final byte[] password, byte[] salt, int iterCount, int keyLengthInBit) {
        if (debug != null) {
            String pwByteString = "";
            if (null != password) {
                pwByteString = encoder.encodeBuffer(password);
            }
            String saltString = "";
            if (null != salt) {
                saltString = encoder.encodeBuffer(salt);
            }
            Object[] parms = new Object[]{prf, pwByteString, saltString, new Integer(iterCount), new Integer(keyLengthInBit)};
            debug.entry(16384L, (Object)className, "deriveKey", parms);
        }
        int keyLength = keyLengthInBit / 8;
        byte[] key = new byte[keyLength];
        try {
            int hlen = prf.getMacLength();
            int intL = (keyLength + hlen - 1) / hlen;
            int intR = keyLength - (intL - 1) * hlen;
            byte[] ui = new byte[hlen];
            byte[] ti = new byte[hlen];
            SecretKey macKey = new SecretKey(){

                @Override
                public String getAlgorithm() {
                    return prf.getAlgorithm();
                }

                @Override
                public String getFormat() {
                    return "RAW";
                }

                @Override
                public synchronized byte[] getEncoded() {
                    return password;
                }

                public int hashCode() {
                    return Arrays.hashCode(password) * 41 + prf.getAlgorithm().toLowerCase().hashCode();
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    SecretKey sk = (SecretKey)obj;
                    return prf.getAlgorithm().equalsIgnoreCase(sk.getAlgorithm()) && Arrays.equals(password, sk.getEncoded());
                }
            };
            prf.init(macKey);
            byte[] ibytes = new byte[4];
            for (int i = 1; i <= intL; ++i) {
                prf.update(salt);
                ibytes[3] = (byte)i;
                ibytes[2] = (byte)(i >> 8 & 0xFF);
                ibytes[1] = (byte)(i >> 16 & 0xFF);
                ibytes[0] = (byte)(i >> 24 & 0xFF);
                prf.update(ibytes);
                prf.doFinal(ui, 0);
                System.arraycopy(ui, 0, ti, 0, ui.length);
                for (int j = 2; j <= iterCount; ++j) {
                    prf.update(ui);
                    prf.doFinal(ui, 0);
                    for (int k = 0; k < ui.length; ++k) {
                        int n = k;
                        ti[n] = (byte)(ti[n] ^ ui[k]);
                    }
                }
                if (i == intL) {
                    System.arraycopy(ti, 0, key, (i - 1) * hlen, intR);
                    continue;
                }
                System.arraycopy(ti, 0, key, (i - 1) * hlen, hlen);
            }
        }
        catch (GeneralSecurityException gse) {
            RuntimeException rte = new RuntimeException("Error deriving PBKDF2 keys");
            if (debug != null) {
                debug.text(16384L, (Object)className, "PBEKey", "Error deriving PBKDF2 keys");
                debug.exception(16384L, (Object)className, "PBEKey", (Throwable)rte);
            }
            throw rte;
        }
        if (debug != null) {
            String keyByteString = "";
            if (null != key) {
                keyByteString = encoder.encodeBuffer(key);
            }
            debug.exit(16384L, (Object)className, "deriveKey", (Object)keyByteString);
        }
        return key;
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (debug != null) {
            String keyByteString = "";
            if (null != this.key) {
                keyByteString = encoder.encodeBuffer(this.key);
            }
            debug.exit(16384L, (Object)className, "getEncoded", (Object)keyByteString);
        }
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAlgorithm", (Object)new String("PBKDF2With" + this.prf.getAlgorithm()));
        }
        return "PBKDF2With" + this.prf.getAlgorithm();
    }

    @Override
    public int getIterationCount() {
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIterationCount", this.iterCount);
        }
        return this.iterCount;
    }

    @Override
    public synchronized char[] getPassword() {
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPassword", (Object)new String(this.passwd));
        }
        return (char[])this.passwd.clone();
    }

    @Override
    public byte[] getSalt() {
        if (debug != null) {
            String saltByteString = "";
            if (null != this.salt) {
                saltByteString = encoder.encodeBuffer(this.salt);
            }
            debug.exit(16384L, (Object)className, "getSalt", (Object)saltByteString);
        }
        return (byte[])this.salt.clone();
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getFormat", (Object)"RAW");
        }
        return "RAW";
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 1; i < this.key.length; ++i) {
            retval += this.key[i] * i;
        }
        return retval ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SecretKey)) {
            return false;
        }
        SecretKey that = (SecretKey)obj;
        if (!that.getAlgorithm().equalsIgnoreCase(this.getAlgorithm())) {
            return false;
        }
        if (!that.getFormat().equalsIgnoreCase("RAW")) {
            return false;
        }
        byte[] thatEncoded = that.getEncoded();
        boolean ret = Arrays.equals(this.key, that.getEncoded());
        Arrays.fill(thatEncoded, (byte)0);
        return ret;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    protected void finalize() throws Throwable {
        try {
            if (this.passwd != null) {
                Arrays.fill(this.passwd, '0');
                this.passwd = null;
            }
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

