/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.ConstructKeys;
import com.ibm.crypto.hdwrCCA.provider.DESCipher;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEWithMD5AndDESCipher
extends CipherSpi {
    protected DESCipher desCipher;
    protected byte[] salt;
    protected int iCount = 10;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PBEWithMD5AndDESCipher";

    public PBEWithMD5AndDESCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "PBEWithMD5AndDESCipher");
        }
        IBMJCECCA.verifyJceJar();
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PBEWithMD5AndDESCipher", "The IBMJCECCA provider may have been tampered.");
            }
            throw new SecurityException("The IBMJCECCA provider may have been tampered.");
        }
        this.desCipher = new DESCipher("CBC", "PKCS5Padding");
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "PBEWithMD5AndDESCipher");
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetMode", mode);
        }
        if (mode != null && !mode.equalsIgnoreCase("CBC")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Invalid cipher mode: " + mode);
            }
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + mode);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetPadding", paddingScheme);
        }
        if (paddingScheme != null && !paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "Invalid padding scheme: " + paddingScheme);
            }
            throw new NoSuchPaddingException("Invalid padding scheme: " + paddingScheme);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetBlockSize");
        }
        int result = this.desCipher.engineGetBlockSize();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetBlockSize", result);
        }
        return result;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", new Integer(inputLen));
        }
        int result = this.desCipher.engineGetOutputSize(inputLen);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", result);
        }
        return result;
    }

    @Override
    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetIV");
        }
        byte[] result = this.desCipher.engineGetIV();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetIV", result);
        }
        return result;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetParameters");
        }
        AlgorithmParameters params = null;
        if (this.salt == null) {
            return null;
        }
        PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iCount);
        String provider = "IBMJCECCA";
        if (Security.getProvider("IBMJCECCA") == null) {
            provider = "IBMJCE4758";
        }
        try {
            params = AlgorithmParameters.getInstance("PBE", provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", nsae);
            }
            throw new RuntimeException("IBMJCECCA called, but not configured");
        }
        catch (NoSuchProviderException nspe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", nspe);
            }
            throw new RuntimeException("IBMJCECCA called, but not configured");
        }
        try {
            params.init(pbeSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", ipse);
            }
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", params);
        }
        return params;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        if (opmode == 2 || opmode == 4) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Parameters missing");
            }
            throw new InvalidKeyException("Parameters missing");
        }
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
            }
            throw new RuntimeException(iape.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        if ((opmode == 2 || opmode == 4) && params == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Parameters missing");
            }
            throw new InvalidAlgorithmParameterException("Parameters missing");
        }
        try {
            if (key == null || !key.getAlgorithm().toUpperCase().startsWith("PBE")) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Missing password");
                }
                throw new InvalidKeyException("Missing password");
            }
            if (params == null) {
                this.salt = new byte[8];
                random.nextBytes(this.salt);
            } else {
                if (!(params instanceof PBEParameterSpec)) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Wrong parameter type");
                    }
                    throw new InvalidAlgorithmParameterException("Wrong parameter type");
                }
                this.salt = ((PBEParameterSpec)params).getSalt();
                if (this.salt.length != 8) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Salt must be 8 bytes long");
                    }
                    throw new InvalidAlgorithmParameterException("Salt must be 8 bytes long");
                }
                this.iCount = ((PBEParameterSpec)params).getIterationCount();
            }
            byte[] passwdBytes = key.getEncoded();
            byte[] concat = new byte[passwdBytes.length + this.salt.length];
            System.arraycopy(passwdBytes, 0, concat, 0, passwdBytes.length);
            Arrays.fill(passwdBytes, (byte)0);
            System.arraycopy(this.salt, 0, concat, passwdBytes.length, this.salt.length);
            MessageDigest md = null;
            md = Security.getProvider("IBMJCECCA") == null ? MessageDigest.getInstance("MD5", "IBMJCE4758") : MessageDigest.getInstance("MD5", "IBMJCECCA");
            byte[] toBeHashed = concat;
            for (int i = 0; i < this.iCount; ++i) {
                md.update(toBeHashed);
                toBeHashed = md.digest();
            }
            Arrays.fill(concat, (byte)0);
            DESKey desKey = new DESKey(toBeHashed);
            IvParameterSpec paramSpec = new IvParameterSpec(toBeHashed, 8, 8);
            this.desCipher.engineInit(opmode, (Key)desKey, paramSpec, random);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
            }
            throw new RuntimeException(e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        PBEParameterSpec pbeSpec = null;
        if (params != null) {
            try {
                pbeSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Wrong parameter type: PBE expected");
                }
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
        }
        this.engineInit(opmode, key, pbeSpec, random);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        byte[] result = this.desCipher.engineUpdate(input, inputOffset, inputLen);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdate", result);
        }
        return result;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        int result = this.desCipher.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdate", result);
        }
        return result;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDoFinal", parms);
        }
        byte[] result = this.desCipher.engineDoFinal(input, inputOffset, inputLen);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", result);
        }
        return result;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDoFinal", parms);
        }
        int result = this.desCipher.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", result);
        }
        return result;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return this.desCipher.engineGetKeySize(key);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result;
        block15: {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineWrap", key);
            }
            result = null;
            if (null == key) {
                InvalidKeyException ike3 = new InvalidKeyException("The key specified to wrap() must not be null.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike3);
                }
                throw ike3;
            }
            if (key instanceof PublicKey) {
                InvalidKeyException ike1 = new InvalidKeyException("PublicKey is not a key type supported by wrap() in this cipher.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike1);
                }
                throw ike1;
            }
            if (key instanceof PrivateKey) {
                InvalidKeyException ike2 = new InvalidKeyException("PrivateKey is not a key type supported by wrap() in this cipher.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike2);
                }
                throw ike2;
            }
            try {
                String keyType = key.getFormat();
                if (!"RAW".equalsIgnoreCase(keyType)) {
                    String ikeMsg = "This cipher can only wrap RAW keys. Specified key is type " + keyType + ".";
                    InvalidKeyException ike = new InvalidKeyException(ikeMsg);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", ikeMsg);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                    }
                    throw ike;
                }
                byte[] encodedKey = key.getEncoded();
                if (encodedKey == null || encodedKey.length == 0) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Cannot get an encoding of the key to be wrapped");
                    }
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Cannot get an encoding of the key to be wrapped");
                    }
                    throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
                }
                result = this.engineDoFinal(encodedKey, 0, encodedKey.length);
            }
            catch (BadPaddingException e) {
                if (debug == null) break block15;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineWrap", result);
        }
        return result;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        SecretKey result = null;
        if (debug != null) {
            Object[] parms = new Object[]{wrappedKey, wrappedKeyAlgorithm, new Integer(wrappedKeyType)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUnwrap", parms);
        }
        if (null == wrappedKeyAlgorithm || "".equals(wrappedKeyAlgorithm)) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("The wrappedKeyAlgorithm name specified to unwrap() must not be null or empty.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", nsae);
            }
            throw nsae;
        }
        if (null == wrappedKey || 0 == wrappedKey.length) {
            InvalidKeyException ike = new InvalidKeyException("The wrapped key specified to unwrap() must not be null or empty.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike);
            }
            throw ike;
        }
        try {
            encodedKey = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException ePadding) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ePadding);
            }
            throw new InvalidKeyException();
        }
        catch (IllegalBlockSizeException eBlockSize) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", eBlockSize);
            }
            throw new InvalidKeyException();
        }
        switch (wrappedKeyType) {
            case 3: {
                result = ConstructKeys.constructSecretKey(encodedKey, wrappedKeyAlgorithm);
                break;
            }
            case 2: {
                IllegalArgumentException iae1 = new IllegalArgumentException("Cipher.PRIVATE_KEY is not a key type supported by unwrap() in this cipher.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", iae1);
                }
                throw iae1;
            }
            case 1: {
                IllegalArgumentException iae2 = new IllegalArgumentException("Cipher.PUBLIC_KEY is not a key type supported by unwrap() in this cipher.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", iae2);
                }
                throw iae2;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUnwrap", result);
        }
        return result;
    }
}

