/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEParameters
extends AlgorithmParametersSpi {
    private byte[] salt;
    private int iCount;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PBEParameters";

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", paramSpec);
        }
        if (!(paramSpec instanceof PBEParameterSpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Inappropriate parameter specification");
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBEParameterSpec)paramSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)paramSpec).getIterationCount();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", (Object)encoded);
        }
        try {
            DerValue val = new DerValue(encoded);
            if (val.getTag() != 48) {
                throw new IOException("PBE parameter parsing error: not a sequence");
            }
            val.getData().reset();
            this.salt = val.getData().getOctetString();
            this.iCount = val.getData().getInteger().intValue();
            if (val.getData().available() != 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "PBE parameter parsing error: extra data");
                }
                throw new IOException("PBE parameter parsing error: extra data");
            }
        }
        catch (NumberFormatException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
            }
            throw new IOException("iteration count too big");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", encoded, decodingMethod);
        }
        this.engineInit(encoded);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        try {
            Class<?> pbeParamSpec;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", paramSpec);
            }
            if ((pbeParamSpec = Class.forName("javax.crypto.spec.PBEParameterSpec")).isAssignableFrom(paramSpec)) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", new PBEParameterSpec(this.salt, this.iCount));
                }
                return new PBEParameterSpec(this.salt, this.iCount);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", "Inappropriate parameter specification");
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", e);
            }
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetEncoded");
        }
        bytes.putOctetString(this.salt);
        bytes.putInteger(BigInteger.valueOf(this.iCount));
        out.write((byte)48, bytes);
        byte[] result = out.toByteArray();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", result);
        }
        return result;
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodingMethod);
        }
        byte[] result = this.engineGetEncoded();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", result);
        }
        return result;
    }

    @Override
    protected String engineToString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineToString");
        }
        String saltString = "\n    salt:\n[";
        HexDumpEncoder encoder = new HexDumpEncoder();
        saltString = saltString + encoder.encodeBuffer(this.salt);
        saltString = saltString + "]";
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineToString", saltString + "\n    iterationCount:\n" + BigInteger.valueOf(this.iCount).toString() + "\n");
        }
        return saltString + "\n    iterationCount:\n" + BigInteger.valueOf(this.iCount).toString() + "\n";
    }
}

