/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.FeedbackCipher;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;

class OutputFeedback
extends SymmetricCipher
implements FeedbackCipher {
    private static final String MODE_NAME = "OFB";
    private byte[] iv = null;
    private byte[] k;
    private SymmetricCipher embeddedCipher;
    private byte[] register = null;
    private int blockSize = -1;
    private int numBytes = 8;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.OutputFeedback";

    public OutputFeedback() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "OutputFeedback");
            debug.exit(Debug.TYPE_PUBLIC, className, "OutputFeedback");
        }
    }

    public OutputFeedback(int numBytes) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "OutputFeedback", new Integer(numBytes));
        }
        this.numBytes = numBytes;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "OutputFeedback");
        }
    }

    @Override
    public String getFeedback() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFeedback");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFeedback", MODE_NAME);
        }
        return MODE_NAME;
    }

    void setEmbeddedCipher(SymmetricCipher embeddedCipher) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setEmbeddedCipher", embeddedCipher);
        }
        if (embeddedCipher == null || (this.blockSize = embeddedCipher.getBlockSize()) <= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher", "Incompatible algorithm type and mode");
            }
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = embeddedCipher;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
        if (this.numBytes > this.blockSize) {
            this.numBytes = this.blockSize;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher");
        }
    }

    @Override
    public byte[] getIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", this.iv);
        }
        return this.iv;
    }

    @Override
    public int getBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getBlockSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", this.blockSize);
        }
        return this.blockSize;
    }

    public int getStreamUnitSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", new Integer(this.numBytes * 8));
        }
        return this.numBytes * 8;
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        if (!key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            this.embeddedCipher.init(key);
        }
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "init", e);
            }
            random = new SecureRandom();
        }
        byte[] iv = new byte[this.blockSize];
        random.nextBytes(iv);
        System.arraycopy(iv, 0, this.register, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        if (!key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            this.embeddedCipher.init(key);
        }
        if (params != null && params instanceof IvParameterSpec) {
            IvParameterSpec ivSpec = (IvParameterSpec)params;
            this.iv = ivSpec.getIV();
            if (this.iv == null || this.iv.length != this.blockSize) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length: must be " + this.blockSize + " bytes long");
                }
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
            }
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong parameter type: IV expected");
            }
            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
        }
        System.arraycopy(this.iv, 0, this.register, 0, this.register.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    public void reset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "reset");
        }
        System.arraycopy(this.iv, 0, this.register, 0, this.register.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "reset");
        }
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        int len = this.blockSize - this.numBytes;
        int endIndex = plainOffset + plainLen;
        int loopCount = plainLen / this.numBytes;
        int oddBytes = plainLen % this.numBytes;
        if (debug != null) {
            Object[] parms = new Object[]{plain, new Integer(plainOffset), new Integer(plainLen), cipher, new Integer(cipherOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "encrypt", parms);
        }
        if (len == 0) {
            int i;
            while (loopCount > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (i = 0; i < this.numBytes; ++i) {
                    cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                }
                System.arraycopy(this.k, 0, this.register, 0, this.numBytes);
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (i = 0; i < oddBytes; ++i) {
                    cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                }
                System.arraycopy(this.k, 0, this.register, 0, this.numBytes);
            }
        } else {
            int i;
            while (loopCount > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (i = 0; i < this.numBytes; ++i) {
                    cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                }
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                System.arraycopy(this.k, 0, this.register, len, this.numBytes);
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (i = 0; i < oddBytes; ++i) {
                    cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                }
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                System.arraycopy(this.k, 0, this.register, len, this.numBytes);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
        }
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        int len = this.blockSize - this.numBytes;
        int endIndex = cipherOffset + cipherLen;
        int loopCount = cipherLen / this.numBytes;
        int oddBytes = cipherLen % this.numBytes;
        if (debug != null) {
            Object[] parms = new Object[]{cipher, new Integer(cipherOffset), new Integer(cipherLen), plain, new Integer(plainOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "decrypt", parms);
        }
        if (len == 0) {
            int i;
            while (loopCount > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (i = 0; i < this.numBytes; ++i) {
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                System.arraycopy(this.k, 0, this.register, 0, this.numBytes);
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (i = 0; i < oddBytes; ++i) {
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                System.arraycopy(this.k, 0, this.register, 0, this.numBytes);
            }
        } else {
            int i;
            while (loopCount > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (i = 0; i < this.numBytes; ++i) {
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                System.arraycopy(this.k, 0, this.register, len, this.numBytes);
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (i = 0; i < oddBytes; ++i) {
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                System.arraycopy(this.k, 0, this.register, len, this.numBytes);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
        }
    }
}

