/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.DSAPublicKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECNamedCurve;
import com.ibm.crypto.hdwrCCA.provider.ECParameters;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPublicKey;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.LabelUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPublicKey;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class KeyPairUtils {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.KeyPairUtils";
    private static HexDumpEncoder encoder = debug != null ? new HexDumpEncoder() : null;
    private ECNamedCurve.CurveType curveType;
    private int keySize;
    private SecureRandom random;
    private DSAParameterSpec params;
    private KeyPairAlgorithm keyPairAlgorithm;
    private KeyHWAttributes keyAttribs;
    private hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private HIKM hikm = null;
    private byte[] exitData = new byte[0];
    private byte[] token = null;
    private byte[] genKeyToken = null;
    private byte[] targetKeyToken = null;
    private boolean longBuffers = false;
    private int maxTokenLength = 2500;
    private byte[] keyLabel;
    private hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
    private hikmNativeInteger keyTokenLength = null;
    private hikmNativeInteger targetKeyTokenLength = null;
    private hikmNativeInteger genKeyTokenLength = null;
    private hikmNativeInteger sourceKeyIdentifierLength = null;
    private AlgorithmId rsaPssAlgId = null;

    public KeyPairUtils() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "KeyPairUtils");
        }
        this.longBuffers = HardwareProfile.getIs4096RNGLSupported();
        if (this.longBuffers) {
            this.maxTokenLength = 3500;
        }
        this.token = new byte[this.maxTokenLength];
        this.genKeyToken = new byte[this.maxTokenLength];
        this.targetKeyToken = new byte[this.maxTokenLength];
        this.keyTokenLength = new hikmNativeInteger(this.maxTokenLength);
        this.targetKeyTokenLength = new hikmNativeInteger(this.maxTokenLength);
        this.genKeyTokenLength = new hikmNativeInteger(this.maxTokenLength);
        if (debug != null) {
            String info = new String(HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + this.longBuffers);
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "KeyPairUtils", info);
        }
    }

    void initializeDSA(int keySize, SecureRandom random, DSAKeyHWAttributes attribs, byte[] keyLabel, DSAParameterSpec params) throws InvalidParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(keySize), random, attribs, keyLabel, params};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initializeDSA", parms);
        }
        if (keySize < 512 || keySize > 1024 || keySize % 64 != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initializeDSA", "Modulus size must be from 512 to 1024 and be a multiple of 64");
            }
            throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
        }
        this.keySize = keySize;
        this.random = random == null ? new SecureRandom() : random;
        if (keyLabel == null) {
            this.keyLabel = null;
        } else {
            String upperCaseKeyLabel = new String(keyLabel, PlatformUtilities.CHARSET_ISO_8859_1).toUpperCase();
            this.keyLabel = LabelUtils.padLabel(upperCaseKeyLabel.getBytes(PlatformUtilities.CHARSET_ISO_8859_1), PlatformUtilities.CHARSET_ISO_8859_1);
        }
        this.params = params;
        this.hikm = new HIKM();
        this.keyAttribs = attribs;
        this.keyPairAlgorithm = KeyPairAlgorithm.DSA;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "initializeDSA");
        }
    }

    void initializeRSA(int keySize, SecureRandom random, RSAKeyHWAttributes attribs, byte[] keyLabel) {
        if (debug != null) {
            Object[] parms = new Object[]{keySize, random, attribs, keyLabel};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initializeRSA", parms);
        }
        this.initRsaAndPss(keySize, random, attribs, keyLabel, KeyPairAlgorithm.RSA);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "initializeRSA");
        }
    }

    void initializeRSA(int keySize, SecureRandom random, RSAKeyHWAttributes attribs, byte[] keyLabel, KeyPairAlgorithm keyPairAlgorithm) {
        if (debug != null) {
            Object[] parms = new Object[]{keySize, random, attribs, keyLabel, keyPairAlgorithm};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initializeRSA", parms);
        }
        this.initRsaAndPss(keySize, random, attribs, keyLabel, keyPairAlgorithm);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "initializeRSA");
        }
    }

    private void initRsaAndPss(int keySize, SecureRandom random, RSAKeyHWAttributes attribs, byte[] keyLabel, KeyPairAlgorithm keyPairAlgorithm) {
        if (debug != null) {
            Object[] parms = new Object[]{keySize, random, attribs, keyLabel, keyPairAlgorithm};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initRsaAndPss", parms);
        }
        this.keySize = keySize;
        this.random = random == null ? new SecureRandom() : random;
        if (keyLabel == null) {
            this.keyLabel = null;
        } else {
            String upperCaseKeyLabel = new String(keyLabel, PlatformUtilities.CHARSET_ISO_8859_1).toUpperCase();
            this.keyLabel = LabelUtils.padLabel(upperCaseKeyLabel.getBytes(PlatformUtilities.CHARSET_ISO_8859_1), PlatformUtilities.CHARSET_ISO_8859_1);
        }
        this.hikm = new HIKM();
        this.keyAttribs = attribs;
        this.keyPairAlgorithm = keyPairAlgorithm;
        this.params = null;
        this.rsaPssAlgId = keyPairAlgorithm == KeyPairAlgorithm.RSAPSS ? RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.PSS, null) : new AlgIdRSA();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "initRsaAndPss");
        }
    }

    void initializeEC(ECNamedCurve.CurveType curveType, int keySize, SecureRandom random, ECHWKeyAttributes attribs, String keyLabel) {
        if (debug != null) {
            Object[] parms = new Object[]{curveType, new Integer(keySize), random, attribs, keyLabel};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initializeEC", parms);
        }
        this.curveType = curveType;
        this.keySize = keySize;
        this.keyAttribs = attribs;
        this.random = random == null ? new SecureRandom() : random;
        if (keyLabel == null) {
            this.keyLabel = null;
        } else {
            String upperCaseKeyLabel = keyLabel.toUpperCase();
            this.keyLabel = LabelUtils.padLabel(upperCaseKeyLabel.getBytes(PlatformUtilities.CHARSET_ISO_8859_1), PlatformUtilities.CHARSET_ISO_8859_1);
        }
        this.hikm = new HIKM();
        this.keyPairAlgorithm = KeyPairAlgorithm.EC;
        this.params = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "initializeEC");
        }
    }

    private hikmNativeInteger generateExternalTokenDSA(byte[] token, DSAPublicKey key) {
        int i = 0;
        BigInteger y = BigInteger.ZERO;
        int modLenBytes = 0;
        int qLenBytes = 0;
        int gLenBytes = 0;
        int yLenBytes = 0;
        if (debug != null) {
            Object[] parms = new Object[]{token, key};
            debug.entry(8192L, (Object)className, "generateExternalTokenDSA", parms);
        }
        if (key != null) {
            y = key.getY();
        }
        BigInteger p = this.params.getP();
        BigInteger g = this.params.getG();
        BigInteger q = this.params.getQ();
        this.copyShortToArray((short)this.keySize, token, i);
        modLenBytes = (this.keySize + 7) / 8;
        this.copyShortToArray((short)modLenBytes, token, i += 2);
        qLenBytes = (q.bitLength() + 7) / 8;
        this.copyShortToArray((short)qLenBytes, token, i += 2);
        gLenBytes = (g.bitLength() + 7) / 8;
        this.copyShortToArray((short)gLenBytes, token, i += 2);
        i += 2;
        if (key == null) {
            this.copyShortToArray((short)0, token, i);
        } else {
            yLenBytes = (y.bitLength() + 7) / 8;
            this.copyShortToArray((short)yLenBytes, token, i);
        }
        this.copyShortToArray((short)0, token, i += 2);
        System.arraycopy(p.toByteArray(), p.toByteArray().length - modLenBytes, token, i += 2, modLenBytes);
        System.arraycopy(q.toByteArray(), q.toByteArray().length - qLenBytes, token, i += modLenBytes, qLenBytes);
        System.arraycopy(g.toByteArray(), g.toByteArray().length - gLenBytes, token, i += qLenBytes, gLenBytes);
        i += gLenBytes;
        if (key != null) {
            System.arraycopy(y.toByteArray(), y.toByteArray().length - yLenBytes, token, i, yLenBytes);
            i += yLenBytes;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "generateExternalTokenDSA", new hikmNativeInteger(i));
        }
        return new hikmNativeInteger(i);
    }

    private hikmNativeInteger generateExternalTokenRSA(byte[] token, RSAPublicKey key) {
        int i = 0;
        if (debug != null) {
            Object[] parms = new Object[]{token, key};
            debug.entry(8192L, (Object)className, "generateExternalTokenRSA", parms);
        }
        if (key != null) {
            BigInteger p = key.getPublicExponent();
            BigInteger modulus = key.getModulus();
            this.copyShortToArray((short)this.keySize, token, i);
            int modLenBytes = (this.keySize + 7) / 8;
            this.copyShortToArray((short)modLenBytes, token, i += 2);
            int expLenBytes = (p.bitLength() + 7) / 8;
            this.copyShortToArray((short)expLenBytes, token, i += 2);
            this.copyShortToArray((short)0, token, i += 2);
            System.arraycopy(modulus.toByteArray(), modulus.toByteArray().length - modLenBytes, token, i += 2, modLenBytes);
            System.arraycopy(p.toByteArray(), p.toByteArray().length - expLenBytes, token, i += modLenBytes, expLenBytes);
            i += expLenBytes;
        } else {
            this.copyShortToArray((short)this.keySize, token, i);
            this.copyShortToArray((short)0, token, i += 2);
            this.copyShortToArray((short)3, token, i += 2);
            this.copyShortToArray((short)0, token, i += 2);
            this.copyShortToArray((short)0, token, i += 2);
            this.copyShortToArray((short)0, token, i += 2);
            this.copyShortToArray((short)0, token, i += 2);
            this.copyShortToArray((short)0, token, i += 2);
            this.copyShortToArray((short)0, token, i += 2);
            System.arraycopy(new BigInteger("65537").toByteArray(), 0, token, i += 2, 3);
            i += 3;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "generateExternalTokenRSA", new hikmNativeInteger(i));
        }
        return new hikmNativeInteger(i);
    }

    private hikmNativeInteger generateKeyValueStructureEC(byte[] structure, ECPublicKey key) {
        if (debug != null) {
            debug.entry(8192L, className, "generateKeyValueStructureEC", structure, key);
        }
        int i = 0;
        if (key != null) {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.put(this.curveType.byteValue());
            bb.put((byte)0);
            this.copyShortToArray(bb.getShort(0), structure, i);
            this.copyShortToArray((short)this.keySize, structure, i += 2);
            i += 2;
            ECPoint w = key.getW();
            byte[] qVal = null;
            try {
                qVal = ECParameters.encodePoint(w, ECNamedCurve.getECParameterSpec(this.curveType, this.keySize).getCurve());
            }
            catch (IOException e) {
                RuntimeException re = new RuntimeException("Unable to constructs key value structure for Elliptic Curve PKA key", e);
                if (debug != null) {
                    debug.exception(8192L, className, "generateKeyValueStructureEC", e);
                    debug.exception(8192L, className, "generateKeyValueStructureEC", re);
                    debug.exit(8192L, className, "generateKeyValueStructureEC");
                }
                throw re;
            }
            this.copyShortToArray((short)qVal.length, structure, i);
            System.arraycopy(qVal, 0, structure, i += 2, qVal.length);
            i += qVal.length;
        } else {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.put(this.curveType.byteValue());
            bb.put((byte)0);
            this.copyShortToArray(bb.getShort(0), structure, i);
            this.copyShortToArray((short)this.keySize, structure, i += 2);
            this.copyShortToArray((short)0, structure, i += 2);
            this.copyShortToArray((short)0, structure, i += 2);
            i += 2;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "generateKeyValueStructureEC", new hikmNativeInteger(i));
        }
        return new hikmNativeInteger(i);
    }

    protected byte[] generateToken(Key key) throws InternalError, RuntimeException {
        byte[] ruleArray;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "generateToken", key);
        }
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        hikmNativeInteger keyValueStructureLength = null;
        hikmNativeInteger privateKeyNameLength = new hikmNativeInteger(0);
        hikmNativeInteger userDefDataLen = new hikmNativeInteger(0);
        hikmNativeInteger reserved2Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved3Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved4Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved5Length = new hikmNativeInteger(0);
        byte[] privateKeyName = null;
        byte[] userDefData = new byte[]{};
        byte[] reserved2 = new byte[]{};
        byte[] reserved3 = new byte[]{};
        byte[] reserved4 = new byte[]{};
        byte[] reserved5 = new byte[]{};
        byte[] keyValueStructure = new byte[this.maxTokenLength];
        if (this.keyPairAlgorithm == KeyPairAlgorithm.DSA) {
            ruleArray = key == null ? PlatformUtilities.getBytesPlatform("DSS-PRIV") : PlatformUtilities.getBytesPlatform("DSS-PUBL");
            keyValueStructureLength = this.generateExternalTokenDSA(keyValueStructure, (DSAPublicKey)key);
        } else if (this.keyPairAlgorithm == KeyPairAlgorithm.RSA || this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS) {
            if (key == null) {
                if (this.keyAttribs.getKeyUsage() == 3) {
                    ruleArray = this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS ? PlatformUtilities.getBytesPlatform("RSA-AESCSIG-ONLY") : PlatformUtilities.getBytesPlatform("RSA-CRT SIG-ONLY");
                } else if (this.keyAttribs.getKeyUsage() == 4) {
                    ruleArray = this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS ? PlatformUtilities.getBytesPlatform("RSA-AESCKEY-MGMT") : PlatformUtilities.getBytesPlatform("RSA-CRT KEY-MGMT");
                } else {
                    throw new InternalError("Unknown RSA key usage value: " + this.keyAttribs.getKeyUsage());
                }
                ruleArrayCount.setValue(2);
            } else {
                ruleArray = PlatformUtilities.getBytesPlatform("RSA-PUBL");
            }
            keyValueStructureLength = this.generateExternalTokenRSA(keyValueStructure, (RSAPublicKey)key);
        } else {
            if (key == null) {
                if (this.keyAttribs.getKeyUsage() == 3) {
                    ruleArray = PlatformUtilities.getBytesPlatform("ECC-PAIRSIG-ONLY");
                } else if (this.keyAttribs.getKeyUsage() == 4) {
                    if (!HardwareProfile.isECCDiffieHellmanSupported()) {
                        InternalError ie = new InternalError("Key management functionalities are not supported for Elliptic Curve keys on current level of ICSF");
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "generateToken", ie);
                            debug.exit(Debug.TYPE_PUBLIC, className, "generateToken");
                        }
                        throw ie;
                    }
                    ruleArray = PlatformUtilities.getBytesPlatform("ECC-PAIRKEY-MGMT");
                } else {
                    InternalError ie = new InternalError("Unknown EC key usage value: " + this.keyAttribs.getKeyUsage());
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateToken", ie);
                        debug.exit(Debug.TYPE_PUBLIC, className, "generateToken");
                    }
                    throw ie;
                }
                ruleArrayCount.setValue(2);
            } else {
                ruleArray = PlatformUtilities.getBytesPlatform("ECC-PUBL");
            }
            keyValueStructureLength = this.generateKeyValueStructureEC(keyValueStructure, (ECPublicKey)key);
        }
        privateKeyName = new byte[]{};
        keyValueStructure = this.trimToken(keyValueStructure, keyValueStructureLength.getValue());
        if (null != debug) {
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String keyValStructString = "\n" + encoder.encodeBuffer(keyValueStructure);
            String privKeyNameString = "\n" + encoder.encodeBuffer(privateKeyName);
            String userDefDataString = encoder.encodeBuffer(userDefData);
            String parmsReport = "\nKeyPairUtils: CSNDPKB INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    keyValStructLen: " + keyValueStructureLength.getValue() + "\n    keyValStruct   : " + keyValStructString + "\n    privKeyNameLen : " + privateKeyNameLength.getValue() + "\n    privKeyName    : " + privKeyNameString + "\n    keyTokenLength : " + this.keyTokenLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateToken", parmsReport);
        }
        try {
            this.hikm.CSNDPKBJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, keyValueStructureLength, keyValueStructure, privateKeyNameLength, privateKeyName, userDefDataLen, userDefData, reserved2Length, reserved2, reserved3Length, reserved3, reserved4Length, reserved4, reserved5Length, reserved5, this.keyTokenLength, this.token);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateToken", e);
            }
            throw new RuntimeException("Hardware error from call CSNDPKB " + e, e);
        }
        this.token = this.trimToken(this.token, this.keyTokenLength.getValue());
        if (null != debug) {
            String tokenString = "\n" + encoder.encodeBuffer(this.token);
            String parmsReport = "\nKeyPairUtils: CSNDPKB RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    keyTokenLength : " + this.keyTokenLength.getValue() + "\n    token          : " + tokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateToken", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "generateToken", "CSNDPKB Rtn = " + this.returnCode.getValue() + ", reason = " + this.reasonCode.getValue());
        }
        if (this.returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "generateToken", "Hardware error from call CSNDPKB, returnCode = " + this.returnCode.getValue() + ", reasonCode = " + this.reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "CSNDPKB", "Hardware error from call CSNDPKB returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateToken", this.token);
        }
        return this.token;
    }

    protected byte[] generateKeysFromSkeletonToken(byte[] token) throws InternalError {
        String exitDataString;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "generateKeysFromSkeletonToken", (Object)token);
        }
        hikmNativeInteger regenerationDataLength = new hikmNativeInteger(0);
        byte[] newLabelName = new byte[64];
        byte[] ruleArray = new byte[]{};
        byte[] transportKeyIdentifier = new byte[64];
        byte[] regenerationData = new byte[]{};
        if (this.keyAttribs.getKeyType() == 1) {
            ruleArray = PlatformUtilities.getBytesPlatform("RETAIN  ");
        } else if (this.keyAttribs.getKeyType() == 0) {
            ruleArray = PlatformUtilities.getBytesPlatform("MASTER  ");
        } else if (this.keyAttribs.getKeyType() == 2) {
            ruleArray = PlatformUtilities.getBytesPlatform("CLEAR   ");
        } else {
            throw new InternalError("Unknown key type value: " + this.keyAttribs.getKeyType());
        }
        this.genKeyTokenLength = new hikmNativeInteger(this.genKeyToken.length);
        this.arrayFill(transportKeyIdentifier, (byte)0);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        hikmNativeInteger tokenLength = new hikmNativeInteger(token.length);
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String regenDataString = "\n" + encoder.encodeBuffer(regenerationData);
            String tokenString = "\n" + encoder.encodeBuffer(token);
            String transKeyIdString = "\n" + encoder.encodeBuffer(transportKeyIdentifier);
            String parmsReport = "\nKeyPairUtils: CSNDPKG INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    regenDataLength: " + regenerationDataLength.getValue() + "\n    regenData      : " + regenDataString + "\n    tokenLen       : " + tokenLength.getValue() + "\n    tokenData      : " + tokenString + "\n    transportKeyId : " + transKeyIdString + "\n    genKeyTokenLen : " + this.genKeyTokenLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateKeysFromSkeletonToken", parmsReport);
        }
        try {
            this.hikm.CSNDPKGJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, regenerationDataLength, regenerationData, tokenLength, token, transportKeyIdentifier, this.genKeyTokenLength, this.genKeyToken);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateKeysFromSkeletonToken", e);
            }
            throw new RuntimeException("Hardware error from call CSNDPKG " + e, e);
        }
        this.genKeyToken = this.trimToken(this.genKeyToken, this.genKeyTokenLength.getValue());
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String gentokenString = "\n" + encoder.encodeBuffer(this.genKeyToken);
            String parmsReport = "\nKeyPairUtils: CSNDPKG RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    genKeyTokenLen : " + this.genKeyTokenLength.getValue() + "\n    genKeyToken    : " + gentokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateKeysFromSkeletonToken", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "generateKeysFromSkeletonToken", "CSNDPKG Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
        }
        if (this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 16036) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "generateKeysFromSkeletonToken", "Hardware error from call CSNDPKG a key label name already exists returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "CSNDPKG", "Hardware error from call CSNDPKG a key label name already exists. returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        if (this.returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "generateKeysFromSkeletonToken", "Hardware error from call CSNDPKG returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "CSNDPKG", "Hardware error from call CSNDPKG returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        if (this.keyAttribs.getKeyType() == 0) {
            String parmsReport;
            String gentokenString;
            String newLabelNameString;
            if (this.keyLabel == null) {
                this.keyLabel = LabelUtils.genLabelName().getBytes(PlatformUtilities.CHARSET_ISO_8859_1);
            }
            this.arrayFill(newLabelName, (byte)32);
            System.arraycopy(this.keyLabel, 0, newLabelName, 0, this.keyLabel.length);
            ruleArrayCount = new hikmNativeInteger(0);
            if (PlatformUtilities.isZOS()) {
                newLabelName = PlatformUtilities.convertBytesIfKeyLabelATOE(newLabelName);
            }
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                newLabelNameString = "\n" + encoder.encodeBuffer(newLabelName);
                gentokenString = "\n" + encoder.encodeBuffer(this.genKeyToken);
                parmsReport = "\nKeyPairUtils: CSNDKRC INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    newLabelName   : " + newLabelNameString + "\n    genKeyTokenLen : " + this.genKeyTokenLength.getValue() + "\n    genKeyToken    : " + gentokenString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "generateKeysFromSkeletonToken", parmsReport);
            }
            try {
                this.hikm.CSNDKRCJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, newLabelName, this.genKeyTokenLength, this.genKeyToken);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "generateKeysFromSkeletonToken", e);
                }
                throw new RuntimeException("Hardware error from call CSNDKRC " + e, e);
            }
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                newLabelNameString = "\n" + encoder.encodeBuffer(newLabelName);
                gentokenString = "\n" + encoder.encodeBuffer(this.genKeyToken);
                parmsReport = "\nKeyPairUtils: CSNDKRC RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "generateKeysFromSkeletonToken", parmsReport);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "generateKeysFromSkeletonToken", "CSNDKRC Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
            }
            if (this.returnCode.getValue() == 8 && (this.reasonCode.getValue() == 16036 || this.reasonCode.getValue() == 44)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generateKeysFromSkeletonToken", "Hardware error from call CSNDKRC key label name already exists returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue());
                }
                throw new JCECCARuntimeException(1, "CSNDKRC", "Hardware error from call CSNDKRC key label name already exists. returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
            if (this.returnCode.getValue() != 0) {
                if (debug != null) {
                    debug.entry(Debug.TYPE_PUBLIC, (Object)className, "generateKeysFromSkeletonToken", "Hardware error from call CSNDPKG returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue());
                }
                throw new JCECCARuntimeException(1, "CSNDKRC", "Hardware error from call CSNDKRC returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
        }
        byte[] tempToken = new byte[this.genKeyTokenLength.getValue()];
        System.arraycopy(this.genKeyToken, 0, tempToken, 0, this.genKeyTokenLength.getValue());
        this.arrayFill(this.genKeyToken, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateKeysFromSkeletonToken", tempToken);
        }
        return tempToken;
    }

    protected KeyPair generateKeyPairFromInternalToken(byte[] token) throws RuntimeException {
        PrivateKeyInfo priv;
        X509Key pub;
        block40: {
            String exitDataString;
            pub = null;
            priv = null;
            hikmNativeInteger ruleArrayCount = new hikmNativeInteger(0);
            byte[] ruleArray = new byte[]{};
            byte[] temp1Array = new byte[2];
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, (Object)className, "generateKeyPairFromInternalToken", (Object)token);
            }
            this.genKeyToken = (byte[])token.clone();
            this.genKeyTokenLength = new hikmNativeInteger(token.length);
            if (PlatformUtilities.isZOS()) {
                this.genKeyToken = PlatformUtilities.convertBytesIfKeyLabelATOE(this.genKeyToken);
            }
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                String gentokenString = "\n" + encoder.encodeBuffer(this.genKeyToken);
                String targettokenString = "\n" + encoder.encodeBuffer(this.targetKeyToken);
                String parmsReport = "\nKeyPairUtils: CSNDPKX INPUT PARAMETERS \n    returnCode        : " + this.returnCode.getValue() + "\n    reasonCode        : " + this.reasonCode.getValue() + "\n    exitDataLen       : " + this.exitDataLength.getValue() + "\n    exitData          : " + exitDataString + "\n    ruleArrayCount    : " + ruleArrayCount.getValue() + "\n    ruleArray         : " + ruleArrayString + "\n    genKeyTokenLen    : " + this.genKeyTokenLength.getValue() + "\n    genKeyToken       : " + gentokenString + "\n    targetKeyTokenLen : " + this.targetKeyTokenLength.getValue() + "\n";
                debug.text(Debug.TYPE_FINEST, className, "generateKeyPairFromInternalToken", parmsReport);
            }
            try {
                this.hikm.CSNDPKXJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, this.genKeyTokenLength, this.genKeyToken, this.targetKeyTokenLength, this.targetKeyToken);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", e);
                }
                throw new RuntimeException("Hardware error from call CSNDPKX " + e, e);
            }
            this.targetKeyToken = this.trimToken(this.targetKeyToken, this.targetKeyTokenLength.getValue());
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                String gentokenString = "\n" + encoder.encodeBuffer(this.genKeyToken);
                String targettokenString = "\n" + encoder.encodeBuffer(this.targetKeyToken);
                String parmsReport = "\nKeyPairUtils: CSNDPKX RETURN PARAMETERS \n    returnCode        : " + this.returnCode.getValue() + "\n    reasonCode        : " + this.reasonCode.getValue() + "\n    exitDataLen       : " + this.exitDataLength.getValue() + "\n    exitData          : " + exitDataString + "\n    genKeyTokenLen    : " + this.genKeyTokenLength.getValue() + "\n    genKeyToken       : " + gentokenString + "\n    targetKeyTokenLen : " + this.targetKeyTokenLength.getValue() + "\n    targetKeyToken    : " + targettokenString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "generateKeyPairFromInternalToken", parmsReport);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "generateKeyPairFromInternalToken", "CSNDPKX Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
            }
            if (this.returnCode.getValue() != 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", "Hardware error from call CSNDPKX returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue());
                }
                throw new JCECCARuntimeException(1, "CSNDPKX", "Hardware error from call CSNDPKX returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
            this.arrayFill(this.genKeyToken, (byte)0);
            if (this.keyPairAlgorithm == KeyPairAlgorithm.DSA) {
                if (this.targetKeyToken[8] != 3 && this.targetKeyToken[9] != 0) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", "Public key token is of unknown type id=" + this.targetKeyToken[8] + " version=" + this.targetKeyToken[9]);
                    }
                    throw new RuntimeException("Public key token is of unknown type. id = " + this.targetKeyToken[8] + " version = " + this.targetKeyToken[9]);
                }
                temp1Array[0] = this.targetKeyToken[10];
                temp1Array[1] = this.targetKeyToken[11];
                BigInteger temp = new BigInteger(temp1Array);
                short secLen = temp.shortValue();
                temp1Array[0] = this.targetKeyToken[20];
                temp1Array[1] = this.targetKeyToken[21];
                temp = new BigInteger(temp1Array);
                short yLen = temp.shortValue();
                byte[] temp2Array = new byte[yLen];
                System.arraycopy(this.targetKeyToken, secLen + 8 - yLen, temp2Array, 0, yLen);
                BigInteger y = new BigInteger(1, temp2Array);
                try {
                    priv = new DSAPrivateHWKey(this.keyLabel, this.params.getP(), this.params.getQ(), this.params.getG(), (DSAKeyHWAttributes)this.keyAttribs);
                    pub = new DSAPublicKey(y, this.params.getP(), this.params.getQ(), this.params.getG());
                }
                catch (InvalidKeyException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", e);
                    }
                    break block40;
                }
            }
            if (this.keyPairAlgorithm == KeyPairAlgorithm.RSA || this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS) {
                if (this.targetKeyToken[8] != 4 && this.targetKeyToken[9] != 0) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", "Public key token is of unknown type id=" + this.targetKeyToken[8] + " version=" + this.targetKeyToken[9]);
                    }
                    throw new RuntimeException("Public key token is of unknown type. id = " + this.targetKeyToken[8] + " version = " + this.targetKeyToken[9]);
                }
                temp1Array[0] = this.targetKeyToken[14];
                temp1Array[1] = this.targetKeyToken[15];
                BigInteger temp = new BigInteger(temp1Array);
                short pubLen = temp.shortValue();
                temp1Array[0] = this.targetKeyToken[18];
                temp1Array[1] = this.targetKeyToken[19];
                temp = new BigInteger(temp1Array);
                short modLen = temp.shortValue();
                byte[] exp = new byte[pubLen + 1];
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", "publen " + pubLen);
                    debug.text(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", "modlen " + modLen);
                }
                exp[0] = 0;
                System.arraycopy(this.targetKeyToken, 20, exp, 1, pubLen);
                byte[] mod = new byte[modLen + 1];
                mod[0] = 0;
                System.arraycopy(this.targetKeyToken, 20 + pubLen, mod, 1, modLen);
                try {
                    if (this.keyAttribs.getKeyType() == 2) {
                        byte[] iToken = this.importExternalToken(token, KeyPairAlgorithm.RSA);
                        priv = new RSAPrivateHWKey(this.rsaPssAlgId, iToken, token, (RSAKeyHWAttributes)this.keyAttribs);
                    } else {
                        priv = new RSAPrivateHWKey(this.rsaPssAlgId, this.keyLabel, (RSAKeyHWAttributes)this.keyAttribs);
                    }
                    pub = new RSAPublicKey(this.rsaPssAlgId, new BigInteger(mod), new BigInteger(exp));
                }
                catch (InvalidKeyException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", e);
                    }
                    break block40;
                }
            }
            if (this.keyPairAlgorithm == KeyPairAlgorithm.EC) {
                RuntimeException re;
                ECPoint w;
                if (this.targetKeyToken[8] != 33 || this.targetKeyToken[9] != 0) {
                    RuntimeException re2 = new RuntimeException("Public key token is of unknown type. id = " + this.targetKeyToken[8] + " version = " + this.targetKeyToken[9]);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", re2);
                        debug.exit(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken");
                    }
                    throw re2;
                }
                ByteBuffer bb = ByteBuffer.allocate(2);
                bb.put(this.targetKeyToken[20]).put(this.targetKeyToken[21]);
                short qLen = bb.getShort(0);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", "qLen " + qLen);
                }
                byte[] qVal = new byte[qLen];
                System.arraycopy(this.targetKeyToken, 22, qVal, 0, qLen);
                ECParameterSpec parameterSpec = ECNamedCurve.getECParameterSpec(this.curveType, this.keySize);
                try {
                    w = ECParameters.decodePoint(qVal, parameterSpec.getCurve());
                }
                catch (IOException ioe) {
                    re = new RuntimeException("Invalid Elliptic Curve key", ioe);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", "Invalid Elliptic Curve key, public key Q field : " + encoder.encodeBuffer(qVal));
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", ioe);
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", re);
                        debug.exit(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken");
                    }
                    throw re;
                }
                try {
                    if (this.keyAttribs.getKeyType() == 2) {
                        byte[] iToken = this.importExternalToken(token, KeyPairAlgorithm.EC);
                        priv = new ECPrivateHWKey(token, iToken, parameterSpec, (ECHWKeyAttributes)this.keyAttribs);
                    } else {
                        priv = new ECPrivateHWKey(this.keyLabel, parameterSpec, (ECHWKeyAttributes)this.keyAttribs);
                    }
                    pub = new ECPublicKey(this.targetKeyToken, w, parameterSpec);
                }
                catch (InvalidKeyException ike) {
                    re = new RuntimeException("Invalid Elliptic Curve key", ike);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", ike);
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", re);
                        debug.exit(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken");
                    }
                    throw re;
                }
                catch (InvalidParameterSpecException ipse) {
                    re = new RuntimeException("Invalid Elliptic Curve parameters", ipse);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", ipse);
                        debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken", re);
                        debug.exit(Debug.TYPE_PUBLIC, className, "generateKeyPairFromInternalToken");
                    }
                    throw re;
                }
            }
        }
        KeyPair result = new KeyPair((PublicKey)pub, (PrivateKey)priv);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateKeyPairFromInternalToken", result);
        }
        return result;
    }

    private void copyShortToArray(short s, byte[] array, int offset) {
        int i = 0;
        Short sTemp = new Short(s);
        BigInteger temp = new BigInteger(sTemp.toString());
        if (temp.toByteArray().length != 2) {
            array[offset] = 0;
            i = offset + 1;
        } else {
            i = offset;
        }
        System.arraycopy(temp.toByteArray(), 0, array, i, temp.toByteArray().length);
    }

    private void arrayFill(byte[] array, byte ch) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = ch;
        }
    }

    private hikmNativeInteger generateExternalTokenDSA(byte[] token, java.security.interfaces.DSAPublicKey publickey, DSAPrivateKey privatekey) {
        int i = 0;
        BigInteger y = BigInteger.ZERO;
        BigInteger x = BigInteger.ZERO;
        int modLenBytes = 0;
        int qLenBytes = 0;
        int gLenBytes = 0;
        int yLenBytes = 0;
        int xLenBytes = 0;
        if (debug != null) {
            Object[] parms = new Object[]{token, publickey, privatekey};
            debug.entry(8192L, (Object)className, "generateExternalTokenDSA", parms);
        }
        if (publickey != null) {
            y = publickey.getY();
        }
        if (privatekey != null) {
            x = privatekey.getX();
        }
        BigInteger p = this.params.getP();
        BigInteger g = this.params.getG();
        BigInteger q = this.params.getQ();
        this.copyShortToArray((short)this.keySize, token, i);
        modLenBytes = (this.keySize + 7) / 8;
        this.copyShortToArray((short)modLenBytes, token, i += 2);
        qLenBytes = (q.bitLength() + 7) / 8;
        this.copyShortToArray((short)qLenBytes, token, i += 2);
        gLenBytes = (g.bitLength() + 7) / 8;
        this.copyShortToArray((short)gLenBytes, token, i += 2);
        i += 2;
        if (publickey == null) {
            this.copyShortToArray((short)0, token, i);
        } else {
            yLenBytes = (y.bitLength() + 7) / 8;
            this.copyShortToArray((short)yLenBytes, token, i);
        }
        i += 2;
        if (privatekey == null) {
            this.copyShortToArray((short)0, token, i);
        } else {
            xLenBytes = (x.bitLength() + 7) / 8;
            this.copyShortToArray((short)xLenBytes, token, i);
        }
        System.arraycopy(p.toByteArray(), p.toByteArray().length - modLenBytes, token, i += 2, modLenBytes);
        System.arraycopy(q.toByteArray(), q.toByteArray().length - qLenBytes, token, i += modLenBytes, qLenBytes);
        System.arraycopy(g.toByteArray(), g.toByteArray().length - gLenBytes, token, i += qLenBytes, gLenBytes);
        i += gLenBytes;
        if (publickey != null) {
            System.arraycopy(y.toByteArray(), y.toByteArray().length - yLenBytes, token, i, yLenBytes);
            i += yLenBytes;
        }
        if (privatekey != null) {
            System.arraycopy(x.toByteArray(), x.toByteArray().length - xLenBytes, token, i, xLenBytes);
            i += xLenBytes;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "generateExternalToken", i);
        }
        return new hikmNativeInteger(i);
    }

    private hikmNativeInteger generateExternalTokenRSA(byte[] token, java.security.interfaces.RSAPublicKey publickey, RSAPrivateKey privatekey) {
        int i = 0;
        if (publickey != null && privatekey != null) {
            BigInteger pubexp = publickey.getPublicExponent();
            BigInteger pubmodulus = publickey.getModulus();
            BigInteger privexp = privatekey.getPrivateExponent();
            BigInteger privmodulus = privatekey.getModulus();
            this.copyShortToArray((short)this.keySize, token, i);
            int modLenBytes = (this.keySize + 7) / 8;
            this.copyShortToArray((short)modLenBytes, token, i += 2);
            int expLenBytes = (pubexp.bitLength() + 7) / 8;
            this.copyShortToArray((short)expLenBytes, token, i += 2);
            expLenBytes = (privexp.bitLength() + 7) / 8;
            this.copyShortToArray((short)expLenBytes, token, i += 2);
            System.arraycopy(pubmodulus.toByteArray(), pubmodulus.toByteArray().length - modLenBytes, token, i += 2, modLenBytes);
            expLenBytes = (pubexp.bitLength() + 7) / 8;
            System.arraycopy(pubexp.toByteArray(), pubexp.toByteArray().length - expLenBytes, token, i += modLenBytes, expLenBytes);
            i += expLenBytes;
            expLenBytes = (privexp.bitLength() + 7) / 8;
            System.arraycopy(privexp.toByteArray(), privexp.toByteArray().length - expLenBytes, token, i, expLenBytes);
            i += expLenBytes;
        }
        return new hikmNativeInteger(i);
    }

    private hikmNativeInteger generateExternalTokenRSACRT(byte[] token, java.security.interfaces.RSAPublicKey publickey, RSAPrivateCrtKey privatekey) {
        int i = 0;
        if (publickey != null && privatekey != null) {
            BigInteger pubexp = publickey.getPublicExponent();
            BigInteger pubmodulus = publickey.getModulus();
            BigInteger privexp = privatekey.getPrivateExponent();
            BigInteger privmodulus = privatekey.getModulus();
            this.copyShortToArray((short)privmodulus.bitLength(), token, i);
            int modLenBytes = (privmodulus.bitLength() + 7) / 8;
            this.copyShortToArray((short)modLenBytes, token, i += 2);
            int expLenBytes = (pubexp.bitLength() + 7) / 8;
            this.copyShortToArray((short)expLenBytes, token, i += 2);
            this.copyShortToArray((short)0, token, i += 2);
            BigInteger primeP = privatekey.getPrimeP();
            int primePLenBytes = (primeP.bitLength() + 7) / 8;
            this.copyShortToArray((short)primePLenBytes, token, i += 2);
            BigInteger primeQ = privatekey.getPrimeQ();
            int primeQLenBytes = (primeQ.bitLength() + 7) / 8;
            this.copyShortToArray((short)primeQLenBytes, token, i += 2);
            BigInteger pexpP = privatekey.getPrimeExponentP();
            int pexpPLenBytes = (pexpP.bitLength() + 7) / 8;
            this.copyShortToArray((short)pexpPLenBytes, token, i += 2);
            BigInteger pexpQ = privatekey.getPrimeExponentQ();
            int pexpQLenBytes = (pexpQ.bitLength() + 7) / 8;
            this.copyShortToArray((short)pexpQLenBytes, token, i += 2);
            BigInteger U = privatekey.getCrtCoefficient();
            int ULenBytes = (U.bitLength() + 7) / 8;
            this.copyShortToArray((short)ULenBytes, token, i += 2);
            System.arraycopy(privmodulus.toByteArray(), privmodulus.toByteArray().length - modLenBytes, token, i += 2, modLenBytes);
            expLenBytes = (pubexp.bitLength() + 7) / 8;
            System.arraycopy(pubexp.toByteArray(), pubexp.toByteArray().length - expLenBytes, token, i += modLenBytes, expLenBytes);
            System.arraycopy(primeP.toByteArray(), primeP.toByteArray().length - primePLenBytes, token, i += expLenBytes, primePLenBytes);
            System.arraycopy(primeQ.toByteArray(), primeQ.toByteArray().length - primeQLenBytes, token, i += primePLenBytes, primeQLenBytes);
            System.arraycopy(pexpP.toByteArray(), pexpP.toByteArray().length - pexpPLenBytes, token, i += primeQLenBytes, pexpPLenBytes);
            System.arraycopy(pexpQ.toByteArray(), pexpQ.toByteArray().length - pexpQLenBytes, token, i += pexpPLenBytes, pexpQLenBytes);
            System.arraycopy(U.toByteArray(), U.toByteArray().length - ULenBytes, token, i += pexpQLenBytes, ULenBytes);
            i += ULenBytes;
        }
        return new hikmNativeInteger(i);
    }

    protected byte[] generateToken(Key publickey, Key privatekey) throws InternalError, RuntimeException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "generateToken", publickey, privatekey);
        }
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        hikmNativeInteger keyValueStructureLength = null;
        hikmNativeInteger privateKeyNameLength = new hikmNativeInteger(0);
        hikmNativeInteger userDefDataLen = new hikmNativeInteger(0);
        hikmNativeInteger reserved2Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved3Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved4Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved5Length = new hikmNativeInteger(0);
        byte[] privateKeyName = null;
        byte[] userDefData = new byte[]{};
        byte[] reserved2 = new byte[]{};
        byte[] reserved3 = new byte[]{};
        byte[] reserved4 = new byte[]{};
        byte[] reserved5 = new byte[]{};
        byte[] keyValueStructure = new byte[this.maxTokenLength];
        byte[] ruleArray = null;
        if (this.keyPairAlgorithm == KeyPairAlgorithm.DSA) {
            if ((privatekey != null || publickey != null) && privatekey != null) {
                ruleArray = PlatformUtilities.getBytesPlatform("DSS-PRIV");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generateToken", "ruleArray=" + new String(ruleArray));
                }
                keyValueStructureLength = this.generateExternalTokenDSA(keyValueStructure, (java.security.interfaces.DSAPublicKey)publickey, (DSAPrivateKey)privatekey);
            }
        } else if (!(this.keyPairAlgorithm != KeyPairAlgorithm.RSA && this.keyPairAlgorithm != KeyPairAlgorithm.RSAPSS || privatekey == null || publickey == null || privatekey instanceof RSAPrivateHWKey)) {
            if (privatekey instanceof RSAPrivateCrtKey) {
                if (this.keyAttribs.getKeyUsage() == 3) {
                    ruleArray = this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS ? PlatformUtilities.getBytesPlatform("RSA-AESCSIG-ONLY") : PlatformUtilities.getBytesPlatform("RSA-CRT SIG-ONLY");
                } else if (this.keyAttribs.getKeyUsage() == 4) {
                    ruleArray = this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS ? PlatformUtilities.getBytesPlatform("RSA-AESCKEY-MGMT") : PlatformUtilities.getBytesPlatform("RSA-CRT KEY-MGMT");
                } else {
                    throw new InternalError("Unknown RSA key usage value: " + this.keyAttribs.getKeyUsage());
                }
                ruleArrayCount.setValue(2);
                keyValueStructureLength = this.generateExternalTokenRSACRT(keyValueStructure, (java.security.interfaces.RSAPublicKey)publickey, (RSAPrivateCrtKey)privatekey);
            } else if (privatekey instanceof RSAPrivateKey) {
                if (this.keyAttribs == null) {
                    ruleArray = this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS ? PlatformUtilities.getBytesPlatform("RSA-AESM") : PlatformUtilities.getBytesPlatform("RSA-PRIV");
                    ruleArrayCount.setValue(1);
                } else if (this.keyAttribs.getKeyUsage() == 3) {
                    ruleArray = this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS ? PlatformUtilities.getBytesPlatform("RSA-AESMSIG-ONLY") : PlatformUtilities.getBytesPlatform("RSA-PRIVSIG-ONLY");
                    ruleArrayCount.setValue(2);
                } else if (this.keyAttribs.getKeyUsage() == 4) {
                    ruleArray = this.keyPairAlgorithm == KeyPairAlgorithm.RSAPSS ? PlatformUtilities.getBytesPlatform("RSA-AESMKEY-MGMT") : PlatformUtilities.getBytesPlatform("RSA-PRIVKEY-MGMT");
                    ruleArrayCount.setValue(2);
                } else {
                    throw new InternalError("Unknown RSA key usage value: " + this.keyAttribs.getKeyUsage());
                }
                keyValueStructureLength = this.generateExternalTokenRSA(keyValueStructure, (java.security.interfaces.RSAPublicKey)publickey, (RSAPrivateKey)privatekey);
            }
        }
        if (this.keyAttribs == null || this.keyAttribs.getKeyType() == 0 || this.keyAttribs.getKeyType() == 2) {
            privateKeyName = new byte[]{};
        } else {
            if (this.keyLabel == null) {
                this.keyLabel = LabelUtils.genLabelName().getBytes(PlatformUtilities.CHARSET_ISO_8859_1);
            }
            privateKeyName = new byte[64];
            System.arraycopy(this.keyLabel, 0, privateKeyName, 0, this.keyLabel.length);
            privateKeyNameLength.setValue(this.keyLabel.length);
        }
        keyValueStructure = this.trimToken(keyValueStructure, keyValueStructureLength.getValue());
        if (PlatformUtilities.isZOS()) {
            privateKeyName = PlatformUtilities.convertBytesIfKeyLabelATOE(privateKeyName);
        }
        if (null != debug) {
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String keyValStructString = "\n" + encoder.encodeBuffer(keyValueStructure);
            String privKeyNameString = "\n" + encoder.encodeBuffer(privateKeyName);
            String userDefDataString = encoder.encodeBuffer(userDefData);
            String parmsReport = "\nKeyPairUtils: CSNDPKB INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    keyValStructLen: " + keyValueStructureLength.getValue() + "\n    keyValStruct   : " + keyValStructString + "\n    privKeyNameLen : " + privateKeyNameLength.getValue() + "\n    privKeyName    : " + privKeyNameString + "\n    userDefDataLen : " + userDefDataLen + "\n    userDefData    : " + userDefDataString + "\n    keyTokenLength : " + this.keyTokenLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateToken", parmsReport);
        }
        try {
            this.hikm.CSNDPKBJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, keyValueStructureLength, keyValueStructure, privateKeyNameLength, privateKeyName, userDefDataLen, userDefData, reserved2Length, reserved2, reserved3Length, reserved3, reserved4Length, reserved4, reserved5Length, reserved5, this.keyTokenLength, this.token);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateToken", e);
            }
            throw new RuntimeException("Hardware error from call CSNDPKB " + e, e);
        }
        if (null != debug) {
            String tokenString = "\n" + encoder.encodeBuffer(this.token);
            String parmsReport = "\nKeyPairUtils: CSNDPKB RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    keyTokenLength : " + this.keyTokenLength.getValue() + "\n    token          : " + tokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateToken", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "generateToken", "CSNDPKB Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
        }
        if (this.returnCode.getValue() != 0) {
            throw new JCECCARuntimeException(1, "CSNDPKB", "Hardware error from call CSNDPKB returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateToken", this.token);
        }
        return this.token;
    }

    public byte[] importExternalToken(byte[] eToken, KeyPairAlgorithm alg) {
        String exitDataString;
        hikmNativeInteger internalTokenLength;
        byte[] internalToken;
        byte[] importerKeyIdentifier;
        block9: {
            importerKeyIdentifier = new byte[64];
            internalToken = new byte[this.maxTokenLength];
            internalTokenLength = new hikmNativeInteger(0);
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, (Object)className, "importExternalToken", (Object)eToken);
            }
            hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
            byte[] ruleArray = null;
            ruleArray = alg == KeyPairAlgorithm.RSA || alg == KeyPairAlgorithm.RSAPSS ? PlatformUtilities.getBytesPlatform("RSA     ") : (alg == KeyPairAlgorithm.EC ? PlatformUtilities.getBytesPlatform("ECC     ") : PlatformUtilities.getBytesPlatform("DSA     "));
            this.arrayFill(internalToken, (byte)0);
            internalTokenLength = new hikmNativeInteger(internalToken.length);
            this.sourceKeyIdentifierLength = new hikmNativeInteger(eToken.length);
            this.arrayFill(importerKeyIdentifier, (byte)0);
            if (null == this.hikm) {
                this.hikm = new HIKM();
            }
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                String eTokenString = "\n" + encoder.encodeBuffer(eToken);
                String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                String importerKeyIdentifierString = "\n" + encoder.encodeBuffer(importerKeyIdentifier);
                String internalTokenString = "\n" + encoder.encodeBuffer(internalToken);
                String parmsReport = "\nKeyPairUtils: CSNDPKI INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    sourceKeyIdLen : " + this.sourceKeyIdentifierLength.getValue() + "\n    eToken         : " + eTokenString + "\n    importerKeyId  : " + importerKeyIdentifierString + "\n    internalTokLen : " + internalTokenLength.getValue() + "\n";
                debug.text(Debug.TYPE_FINEST, className, "importExternalToken", parmsReport);
            }
            try {
                this.hikm.CSNDPKIJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, this.sourceKeyIdentifierLength, eToken, importerKeyIdentifier, internalTokenLength, internalToken);
            }
            catch (Exception ex) {
                System.out.println(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
                if (null == debug) break block9;
                ex.printStackTrace();
            }
        }
        internalToken = this.trimToken(internalToken, internalTokenLength.getValue());
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String importerKeyIdentifierString = "\n" + encoder.encodeBuffer(importerKeyIdentifier);
            String internalTokenString = "\n" + encoder.encodeBuffer(internalToken);
            String parmsReport = "\nKeyPairUtils: CSNDPKI RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    importerKeyId  : " + importerKeyIdentifierString + "\n    internalTokLen : " + internalTokenLength.getValue() + "\n    internalToken  : " + internalTokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "importExternalToken", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "importExternalToken", "CSNDPKI Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
        }
        if (this.returnCode.getValue() != 0) {
            throw new JCECCARuntimeException(1, "CSNDPKI", "Hardware error from call CSNDPKI returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "importExternalToken", internalToken);
        }
        return internalToken;
    }

    public Key generatePrivateHWKey(PublicKey publickey, PrivateKey privatekey) {
        byte[] labelName = new byte[64];
        PrivateKeyInfo phwk = null;
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        byte[] ruleArray = new byte[]{};
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "generatePrivateHWKey", publickey, privatekey);
        }
        byte[] externalToken = this.generateToken(publickey, privatekey);
        if (privatekey instanceof DSAPrivateKey) {
            String exitDataString;
            if (debug != null) {
                debug.text(8192L, className, "generatePrivateHWKey", "The private key is a DSA key.");
            }
            byte[] token = this.importExternalToken(externalToken, KeyPairAlgorithm.DSA);
            byte[] label = LabelUtils.genLabelName().getBytes(PlatformUtilities.CHARSET_ISO_8859_1);
            this.arrayFill(labelName, (byte)32);
            System.arraycopy(label, 0, labelName, 0, label.length);
            ruleArrayCount = new hikmNativeInteger(0);
            hikmNativeInteger tokenLength = new hikmNativeInteger(token.length);
            if (debug != null) {
                debug.text(8192L, className, "generatePrivateHWKey", "Calling hikm.CSNKDRCJ() to create a pkds record.");
            }
            if (PlatformUtilities.isZOS()) {
                labelName = PlatformUtilities.convertBytesIfKeyLabelATOE(labelName);
            }
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                String labelNameString = "\n" + encoder.encodeBuffer(labelName);
                String tokenString = "\n" + encoder.encodeBuffer(token);
                String parmsReport = "\nKeyPairUtils: CSNDKRC INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    labelName      : " + labelNameString + "\n    tokenLength    : " + tokenLength.getValue() + "\n    token          : " + tokenString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "generatePrivateHWKey", parmsReport);
            }
            try {
                this.hikm.CSNDKRCJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, labelName, tokenLength, token);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(8192L, className, "generatePrivateHWKey", e);
                }
                throw new RuntimeException("Hardware error from call CSNDKRC " + e, e);
            }
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                String parmsReport = "\nKeyPairUtils: CSNDKRC RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "generatePrivateHWKey", parmsReport);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "generatePrivateHWKey", "hikm.CSNKDRCJ() returnCode = " + this.returnCode + "  reasonCode = " + this.reasonCode);
            }
            if (this.returnCode.getValue() != 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generatePrivateHWKey", "Hardware error from call CSNDKRC returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue());
                }
                throw new JCECCARuntimeException(1, "CSNDKRC", "Hardware error from call CSNDKRC returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
            try {
                if (debug != null) {
                    debug.text(8192L, className, "generatePrivateHWKey", "Creating the private key as a Secure key");
                }
                phwk = new DSAPrivateHWKey(label, this.params.getP(), this.params.getQ(), this.params.getG(), (DSAKeyHWAttributes)this.keyAttribs);
            }
            catch (InvalidKeyException ike) {
                if (debug != null) {
                    debug.exception(8192L, className, "generatePrivateHWKey", ike);
                }
                throw new RuntimeException("Invalid Key error from new DSAPrivateHWKey " + ike, ike);
            }
        }
        if (debug != null) {
            debug.text(8192L, className, "generatePrivateHWKey", "The private key is an RSA key.");
        }
        byte[] token = this.importExternalToken(externalToken, KeyPairAlgorithm.RSA);
        if (this.keyAttribs.getKeyType() == 0) {
            String exitDataString;
            byte[] label = LabelUtils.genLabelName().getBytes(PlatformUtilities.CHARSET_ISO_8859_1);
            this.arrayFill(labelName, (byte)32);
            System.arraycopy(label, 0, labelName, 0, label.length);
            ruleArrayCount = new hikmNativeInteger(0);
            hikmNativeInteger tokenLength = new hikmNativeInteger(token.length);
            if (debug != null) {
                debug.text(8192L, className, "generatePrivateHWKey", "Calling hikm.CSNDKRCJ() to create a pkds record.");
            }
            if (PlatformUtilities.isZOS()) {
                labelName = PlatformUtilities.convertBytesIfKeyLabelATOE(labelName);
            }
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                String labelNameString = "\n" + encoder.encodeBuffer(labelName);
                String tokenString = "\n" + encoder.encodeBuffer(token);
                String parmsReport = "\nKeyPairUtils: CSNDKRC INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    labelName      : " + labelNameString + "\n    tokenLength    : " + tokenLength.getValue() + "\n    token          : " + tokenString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "generatePrivateHWKey", parmsReport);
            }
            try {
                this.hikm.CSNDKRCJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, labelName, tokenLength, token);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(8192L, className, "generatePrivateHWKey", e);
                }
                throw new RuntimeException("Hardware error from call CSNDKRC (1) " + e, e);
            }
            if (null != debug) {
                exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                String parmsReport = "\nKeyPairUtils: CSNDKRC RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "generatePrivateHWKey", parmsReport);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "generatePrivateHWKey", "CSNDKRC Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
            }
            if (this.returnCode.getValue() != 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generatePrivateHWKey", "Hardware error from call CSNDKRC returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue());
                }
                throw new JCECCARuntimeException(1, "CSNDKRC", "Hardware error from call CSNDKRC returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
            try {
                if (this.keyAttribs.getKeyType() == 2) {
                    if (debug != null) {
                        debug.text(8192L, className, "generatePrivateHWKey", "Creating the private key as a CLEAR key");
                    }
                    phwk = new RSAPrivateHWKey(this.rsaPssAlgId, label, externalToken, (RSAKeyHWAttributes)this.keyAttribs);
                }
                if (debug != null) {
                    debug.text(8192L, className, "generatePrivateHWKey", "Creating the private key as a Secure key");
                }
                phwk = new RSAPrivateHWKey(this.rsaPssAlgId, label, (RSAKeyHWAttributes)this.keyAttribs);
            }
            catch (InvalidKeyException ike) {
                if (debug != null) {
                    debug.exception(8192L, className, "generatePrivateHWKey", ike);
                }
                throw new RuntimeException("InvalidKey error from new RSAPrivateHWKey (1) " + ike, ike);
            }
        } else {
            try {
                if (this.keyAttribs.getKeyType() == 2) {
                    if (debug != null) {
                        debug.text(8192L, className, "generatePrivateHWKey", "Creating the private key as a CLEAR key");
                    }
                    phwk = new RSAPrivateHWKey(this.rsaPssAlgId, token, externalToken, (RSAKeyHWAttributes)this.keyAttribs);
                } else {
                    if (debug != null) {
                        debug.text(8192L, className, "generatePrivateHWKey", "Creating the private key as a Secure key");
                    }
                    phwk = new RSAPrivateHWKey(this.rsaPssAlgId, token, (RSAKeyHWAttributes)this.keyAttribs);
                }
            }
            catch (InvalidKeyException ike) {
                if (debug != null) {
                    debug.exception(8192L, className, "generatePrivateHWKey", ike);
                }
                throw new RuntimeException("InvalidKey error from new RSAPrivateHWKey " + ike, ike);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generatePrivateHWKey", phwk);
        }
        return phwk;
    }

    public static void icsfDeletePKDSEntry(byte[] pkdsLabel) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntry");
        }
        int[] rcrsn = KeyPairUtils.icsfDeletePKDSEntryWithRC(pkdsLabel);
        int deleteReturnCode = rcrsn[0];
        int deleteReasonCode = rcrsn[1];
        if (deleteReturnCode != 0) {
            RuntimeException newException = new RuntimeException("Hardware error from call CSNDKRD returnCode " + deleteReturnCode + " reasonCode " + deleteReasonCode);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntry", "Error from call CSNDKRD returnCode=" + deleteReturnCode + " reasonCode=" + deleteReasonCode);
                debug.exception(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntry", newException);
            }
            throw newException;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntry");
        }
    }

    public static int[] icsfDeletePKDSEntryWithRC(byte[] pkdsLabel) {
        String exitDataString;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntryWithRC");
        }
        int[] result = new int[]{0, 0};
        HIKM hikm = new HIKM();
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = null;
        ruleArray = PlatformUtilities.getBytesPlatform("LABEL-DL");
        if (PlatformUtilities.isZOS()) {
            pkdsLabel = PlatformUtilities.convertBytesIfKeyLabelATOE(pkdsLabel);
        }
        try {
            if (debug != null) {
                exitDataString = "\n" + encoder.encodeBuffer(exitData);
                String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                String pkdsLabelString = "\n" + encoder.encodeBuffer(pkdsLabel);
                String parmsReport = "\n KeyPairUtils: CSNDKRD INPUT PARAMETERS \n   returnCode       : " + returnCode.getValue() + "\n   reasonCode       : " + reasonCode.getValue() + "\n   exitDataLength   : " + exitDataLength.getValue() + "\n   exitData         : " + exitDataString + "\n   ruleArrayCount   : " + ruleArrayCount.getValue() + "\n   ruleArray        : " + ruleArrayString + "\n   pkdsLabel        : " + pkdsLabelString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "icsfDeletePKDSEntryWithRC", parmsReport);
            }
            hikm.CSNDKRDJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, pkdsLabel);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntryWithRC", e);
            }
            throw new RuntimeException("Hardware error from call CSNDKRD " + e, e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "icsfDeletePKDSEntryWithRC", "CSNDKRD: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (debug != null) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String parmsReport = "\nKeyPairUtils: CSNDKRD RETURN PARAMETERS \n   returnCode       : " + returnCode.getValue() + "\n   reasonCode       : " + reasonCode.getValue() + "\n   exitDataLength   : " + exitDataLength.getValue() + "\n   exitData         : " + exitDataString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "icsfDeletePKDSEntryWithRC", parmsReport);
        }
        result[0] = returnCode.getValue();
        result[1] = reasonCode.getValue();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntryWithRC");
        }
        return result;
    }

    protected static void deletePKDSEntry(byte[] pkdsLabel) {
        String parmsReport;
        String pkdsLabelString;
        String ruleArrayString;
        String exitDataString;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
        }
        HIKM hikm = new HIKM();
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = null;
        try {
            ruleArray = PlatformUtilities.getBytesPlatform("LABEL-DL");
            if (PlatformUtilities.isZOS()) {
                pkdsLabel = PlatformUtilities.convertBytesIfKeyLabelATOE(pkdsLabel);
            }
            if (debug != null) {
                exitDataString = "\n" + encoder.encodeBuffer(exitData);
                ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                pkdsLabelString = "\n" + encoder.encodeBuffer(pkdsLabel);
                parmsReport = "\n KeyPairUtils: CSNDKRD INPUT PARAMETERS \n   returnCode       : " + returnCode.getValue() + "\n   reasonCode       : " + reasonCode.getValue() + "\n   exitDataLength   : " + exitDataLength.getValue() + "\n   exitData         : " + exitDataString + "\n   ruleArrayCount   : " + ruleArrayCount.getValue() + "\n   ruleArray        : " + ruleArrayString + "\n   pkdsLabel        : " + pkdsLabelString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "deletePKDSEntry", parmsReport);
            }
            hikm.CSNDKRDJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, pkdsLabel);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", e);
            }
            throw new RuntimeException("Hardware error from call CSNDKRD " + e, e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "deletePKDSEntry", "CSNDKRD: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (debug != null) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            pkdsLabelString = "\n" + encoder.encodeBuffer(pkdsLabel);
            parmsReport = "\nKeyPairUtils: CSNDKRD RETURN PARAMETERS \n   returnCode       : " + returnCode.getValue() + "\n   reasonCode       : " + reasonCode.getValue() + "\n   exitDataLength   : " + exitDataLength.getValue() + "\n   exitData         : " + exitDataString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "deletePKDSEntry", parmsReport);
        }
        int retCode = returnCode.getValue();
        int reasCode = reasonCode.getValue();
        if (retCode != 0) {
            RuntimeException newException = new RuntimeException("Hardware error from call CSNDKRD returnCode " + retCode + " reasonCode " + reasCode);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntry", "Error from call CSNDKRD returnCode=" + retCode + " reasonCode=" + reasCode);
                debug.exception(Debug.TYPE_PUBLIC, className, "icsfDeletePKDSEntry", newException);
            }
            throw newException;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
        }
    }

    private byte[] trimToken(byte[] byteArray, int length) {
        if (debug != null) {
            Object[] parms = new Object[]{byteArray, new Integer(length)};
            debug.entry(8192L, (Object)className, "trimToken", parms);
        }
        if (length > byteArray.length || length < 0) {
            RuntimeException runtimeException = new RuntimeException("Invalid length for token trim: current token length: " + byteArray.length + ". Real token length: " + length);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "trimToken", runtimeException);
            }
            throw runtimeException;
        }
        if (length == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "trimToken", "Trim length is 0 so we are returning the old array.");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "trimToken", byteArray);
            }
            return byteArray;
        }
        byte[] newByteArray = new byte[length];
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "trimToken", "byteArray size before trim: " + byteArray.length);
        }
        System.arraycopy(byteArray, 0, newByteArray, 0, length);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "trimToken", "newByteArray size after trim: " + newByteArray.length);
        }
        this.arrayFill(byteArray, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "trimToken", newByteArray);
        }
        return newByteArray;
    }

    protected static enum KeyPairAlgorithm {
        EC,
        RSA,
        DSA,
        RSAPSS;

    }
}

