/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;

final class JcaKeyProtector {
    private static final int SALT_LEN = 20;
    private static final String DIGEST_ALG = "SHA";
    private static final int DIGEST_LEN = 20;
    private byte[] passwdBytes;
    private MessageDigest md;
    private static Debug debug = Debug.getInstance("ibmjce4758");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.JcaKeyProtector";

    public JcaKeyProtector(char[] password) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "JcaKeyProtector", (Object)password);
        }
        if (password == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "JcaKeyProtector", "Password can't be null");
            }
            throw new IllegalArgumentException("password can't be null");
        }
        try {
            this.md = MessageDigest.getInstance(DIGEST_ALG, "IBMJCA4758");
        }
        catch (NoSuchProviderException nspe) {
            this.md = MessageDigest.getInstance(DIGEST_ALG);
        }
        this.passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (int i = 0; i < password.length; ++i) {
            this.passwdBytes[j++] = (byte)(password[i] >> 8);
            this.passwdBytes[j++] = (byte)password[i];
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "JcaKeyProtector");
        }
    }

    protected void finalize() {
        if (this.passwdBytes != null) {
            Arrays.fill(this.passwdBytes, (byte)0);
            this.passwdBytes = null;
        }
    }

    public byte[] protect(byte[] token) throws KeyStoreException {
        int encrKeyOffset = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "protect", (Object)token);
        }
        if (token == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "protect", "Plaintext key can't be null");
            }
            throw new IllegalArgumentException("plaintext key can't be null");
        }
        int numRounds = token.length / 20;
        if (token.length % 20 != 0) {
            ++numRounds;
        }
        byte[] salt = new byte[20];
        SecureRandom random = new SecureRandom();
        random.nextBytes(salt);
        byte[] xorKey = new byte[token.length];
        int i = 0;
        int xorOffset = 0;
        byte[] digest = salt;
        while (i < numRounds) {
            this.md.update(this.passwdBytes);
            this.md.update(digest);
            digest = this.md.digest();
            this.md.reset();
            if (i < numRounds - 1) {
                System.arraycopy(digest, 0, xorKey, xorOffset, digest.length);
            } else {
                System.arraycopy(digest, 0, xorKey, xorOffset, xorKey.length - xorOffset);
            }
            ++i;
            xorOffset += 20;
        }
        byte[] tmpKey = new byte[token.length];
        for (i = 0; i < tmpKey.length; ++i) {
            tmpKey[i] = (byte)(token[i] ^ xorKey[i]);
        }
        byte[] encrKey = new byte[salt.length + tmpKey.length + 20];
        System.arraycopy(salt, 0, encrKey, encrKeyOffset, salt.length);
        System.arraycopy(tmpKey, 0, encrKey, encrKeyOffset += salt.length, tmpKey.length);
        encrKeyOffset += tmpKey.length;
        this.md.update(this.passwdBytes);
        Arrays.fill(this.passwdBytes, (byte)0);
        this.passwdBytes = null;
        this.md.update(token);
        digest = this.md.digest();
        this.md.reset();
        System.arraycopy(digest, 0, encrKey, encrKeyOffset, digest.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "protect", encrKey);
        }
        return encrKey;
    }

    public byte[] recover(byte[] encrInfo) throws UnrecoverableKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "recover", (Object)encrInfo);
        }
        byte[] salt = new byte[20];
        System.arraycopy(encrInfo, 0, salt, 0, 20);
        int encrKeyLen = encrInfo.length - 20 - 20;
        int numRounds = encrKeyLen / 20;
        if (encrKeyLen % 20 != 0) {
            ++numRounds;
        }
        byte[] encrKey = new byte[encrKeyLen];
        System.arraycopy(encrInfo, 20, encrKey, 0, encrKeyLen);
        byte[] xorKey = new byte[encrKey.length];
        int i = 0;
        int xorOffset = 0;
        byte[] digest = salt;
        while (i < numRounds) {
            this.md.update(this.passwdBytes);
            this.md.update(digest);
            digest = this.md.digest();
            this.md.reset();
            if (i < numRounds - 1) {
                System.arraycopy(digest, 0, xorKey, xorOffset, digest.length);
            } else {
                System.arraycopy(digest, 0, xorKey, xorOffset, xorKey.length - xorOffset);
            }
            ++i;
            xorOffset += 20;
        }
        byte[] plainKey = new byte[encrKey.length];
        for (i = 0; i < plainKey.length; ++i) {
            plainKey[i] = (byte)(encrKey[i] ^ xorKey[i]);
        }
        this.md.update(this.passwdBytes);
        Arrays.fill(this.passwdBytes, (byte)0);
        this.passwdBytes = null;
        this.md.update(plainKey);
        digest = this.md.digest();
        this.md.reset();
        for (i = 0; i < digest.length; ++i) {
            if (digest[i] == encrInfo[20 + encrKeyLen + i]) continue;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "recover", "Cannot recover key");
            }
            throw new UnrecoverableKeyException("Cannot recover key");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "recover", plainKey);
        }
        return plainKey;
    }
}

