/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.DSAPublicKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPublicKey;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.JarVerifier;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPublicKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.spec.SecretKeySpec;

public final class IBMJCECCA
extends Provider {
    static final long serialVersionUID = 1798769492039881162L;
    private static String info = "IBMJCECCA Provider implements the following: HMAC-SHA1, HMAC-MD5, HMAC-MD2, MD2, MD5, SHA, MD2withRSA, MD5withRSA, SHA1withRSA, RSA, SHA1withDSA*, SHA1withECDSA, EC, ECDH \nimplements the following:\nSignature algorithms               : SHA1withDSA* , SHA1withRSA, MD5withRSA, MD2withRSA, \n                                       SHA224withRSA**, SHA2withRSA**, SHA384withRSA***, SHA512withRSA***, \n                                       SHA1withECDSA, SHA224withECDSA**, SHA2withECDSA**, SHA384withECDSA***, SHA512withECDSA***, RSAPSS \nCipher algorithms                  : DES, TripleDES, AES, PBEWithMD2AndDES, \n                                       PBEWithMD2AndTripleDES, \n                                       PBEWithMD5AndDES, PBEWithMD5AndTripleDES, \n                                       PBEWithSHA1AndDES, \n                                       PBEWithSHA1AndTripleDES, \n                                       PBEWithSHAAnd2KeyTripleDES, PBEWithSHAAnd3KeyTripleDES, \n                                       RSA\nMessage authentication code (MAC)  : HmacSHA1, HmacMD2, HmacMD5, HmacSHA224**, HmacSHA256**, HmacSHA384***, HmacSHA512***\nKey (pair) generator               : DSA*, DES, TripleDES, HmacMD2, \n                                       HmacMD5, HmacSHA1, RSA, RSAPSS, \n                                       HmacSHA224**, HmacSHA256**, HmacSHA384***, HmacSHA512***, EC\nMessage digest                     : MD2, MD5, SHA-1, SHA-224**, SHA-256**, SHA-384***, SHA-512***\nAlgorithm parameter generator      : DSA*, EC\nAlgorithm parameter                : DES, TripleDES, DSA, AES*, \n                                       PBEwithMD5AndDES, EC, RSAPSS\nKey factory                        : DSA*, RSA, EC, RSAPSS\nSecret key factory                 : DES, TripleDES, AES, \n                                     PKCS5Key, PBKDF1 and PBKDF2(PKCS5Derived Key),\n                                     HmacSHA1, HmacSHA224, HmacSHA256, HmacSHA384, HmacSHA512\nCertificate                        : X.509\nSecure random                      : IBMSecureRandom\nKey store                          : JCECCAKS, JCECCARACFKS****\nNote *   - Only Supported By Pre Trex Machines (IBM 2084 eServer zSeries 900)\nNote **  - Supported starting with IBM System z9 EC and z9 BC machines\nNote *** - Supported starting with System z10 Enterprise Class machinesNote **** - Only Support on zOS Not on Linux.";
    private static boolean verifiedJce = false;
    private static boolean verifiedSelfIntegrity = false;
    private static X509Certificate[] trustedCaCerts = null;
    private static final byte[][] bytesOfTrustedCaCerts = new byte[][]{{48, -126, 3, -83, 48, -126, 2, -107, -96, 3, 2, 1, 2, 2, 4, 96, -119, -107, -75, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 48, 98, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 26, 48, 24, 6, 3, 85, 4, 11, 19, 17, 73, 66, 77, 32, 74, 97, 118, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 49, 29, 48, 27, 6, 3, 85, 4, 3, 19, 20, 73, 66, 77, 32, 74, 97, 118, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 32, 67, 65, 48, 30, 23, 13, 50, 49, 48, 52, 50, 56, 49, 55, 48, 52, 53, 51, 90, 23, 13, 52, 49, 48, 52, 50, 51, 49, 55, 48, 52, 53, 51, 90, 48, 98, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 26, 48, 24, 6, 3, 85, 4, 11, 19, 17, 73, 66, 77, 32, 74, 97, 118, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 49, 29, 48, 27, 6, 3, 85, 4, 3, 19, 20, 73, 66, 77, 32, 74, 97, 118, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 32, 67, 65, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -48, 18, -42, -33, -58, -103, 84, -116, -96, 95, -48, -112, -11, 22, 53, -26, -26, 16, -42, 94, -124, 6, -37, -8, 89, -22, 115, 94, -8, -12, -86, 113, 3, 79, 11, 80, -98, -128, -100, -80, -69, 83, -117, 11, -90, -126, 114, 114, 123, 118, 103, 88, 103, 79, 13, -111, 127, 80, -84, -103, 97, 6, -41, -48, 26, -3, -69, -81, 106, 111, -76, -97, 124, 115, -7, -39, 31, 20, -58, 33, -12, 61, -57, -127, 63, -73, 31, 66, 41, -79, 59, 38, -103, 2, -59, 74, -18, 68, 35, -82, 56, 73, 8, 58, 75, 13, -97, -16, 59, -122, -107, 115, 18, -7, -79, 60, -24, 94, 0, 112, -95, -20, -29, 23, 29, 27, -25, 46, 110, 78, -121, 82, 42, 126, 99, 121, 78, 57, 5, 89, 113, -72, 62, -108, -61, 56, -101, -111, -109, 95, -65, 90, 86, -85, 102, -53, -35, -45, 9, -106, -123, 93, 118, -119, 121, -82, 55, 11, -25, 87, 21, -21, 89, 75, 114, -127, -89, -54, 32, 88, 27, 25, -120, 85, 85, -103, -3, 0, -33, 10, -31, -36, 120, 6, -6, -58, -31, 90, -83, -85, -29, -110, -26, -13, -103, 110, -24, -85, 14, 21, 64, -86, 47, 81, -42, 59, 54, -12, -66, -78, -59, 44, -24, -21, 20, 30, 65, -101, 113, -73, 60, -9, 40, -31, 100, 78, -110, -104, 26, -90, 119, -29, -113, -38, -58, -58, -112, 68, -81, 104, 39, 25, 122, 124, 114, 1, 2, 3, 1, 0, 1, -93, 107, 48, 105, 48, 43, 6, 3, 85, 29, 35, 4, 36, 48, 34, -128, 32, 90, -37, -6, -31, -49, -124, 60, -104, -42, -82, 78, -106, -91, -115, 84, -53, 45, -2, 87, 117, 75, 65, -82, -93, 74, 100, -123, 115, -6, 34, 103, 36, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 41, 6, 3, 85, 29, 14, 4, 34, 4, 32, 90, -37, -6, -31, -49, -124, 60, -104, -42, -82, 78, -106, -91, -115, 84, -53, 45, -2, 87, 117, 75, 65, -82, -93, 74, 100, -123, 115, -6, 34, 103, 36, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 3, -126, 1, 1, 0, 45, -112, 114, 108, -101, 63, 117, -95, 82, -35, -99, -1, -110, -96, 104, 77, -83, -89, 118, -68, -21, 71, -41, 13, 83, 112, -65, 93, -35, 0, -7, 49, -110, -66, -34, 53, 44, 23, -71, 90, 7, -3, 114, -65, -107, 46, -17, 93, 124, -21, 50, -20, -25, 113, -87, 58, -67, -120, -128, 109, -86, -22, -90, -108, 14, -34, 71, 111, -22, 4, -91, -110, 27, 113, 32, 121, -53, -114, 123, -20, 83, 1, -15, 10, -22, 15, -38, 116, 72, -122, 105, 22, 96, 82, 84, 91, -24, 113, 42, 65, 51, -42, -28, -97, 122, -69, -65, 27, -38, -69, -71, 118, 123, 34, -84, -92, -43, 51, 39, -73, -36, -13, -56, -113, -44, 62, 32, -72, -42, 75, -11, 54, -33, 50, -17, -29, 105, -65, -73, -98, -42, 6, -30, -128, 19, 105, 41, -126, 111, 7, 2, 93, 113, 54, -67, -121, 59, -76, -58, -86, 15, 121, -94, 113, -22, -127, 24, 125, 32, -50, -42, 14, -43, -41, -117, 50, 95, 60, -5, -128, -10, 121, -10, -58, 73, -10, -55, -35, -101, 122, 119, -111, -13, -70, -109, -70, -33, 60, 42, 61, 123, 17, -9, -3, -29, -15, -109, -98, 110, 58, -1, 9, 79, -103, -29, 75, -37, -59, -102, -12, -71, 120, -77, -103, 127, 9, 105, 80, -32, -25, -105, -125, -95, -7, -99, -21, -14, -10, -70, -112, -15, 8, 94, -45, 28, -122, 36, 75, -114, -60, -26, 12, 21, 110, -85, -76}, {48, -126, 3, 79, 48, -126, 3, 13, -96, 3, 2, 1, 2, 2, 4, 57, 36, -91, 85, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 53, 49, 57, 48, 50, 50, 50, 49, 51, 90, 23, 13, 48, 54, 48, 53, 49, 56, 48, 50, 50, 50, 49, 51, 90, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -22, 107, 0, -57, -33, 16, 59, -71, 116, 53, -89, -31, 109, 102, -126, 77, -9, 91, 86, 113, -62, 38, 69, 39, 114, 61, 81, 16, 98, -1, -77, -36, 16, -55, -5, 81, 19, -44, -83, -117, -88, 37, 110, 93, -55, 120, -46, 91, 39, -45, 19, 65, 71, 20, 6, 124, -53, -126, 56, 94, -58, 11, 97, -96, 76, -125, 45, -108, -52, -116, 46, -124, -112, 58, -113, 66, 10, 105, 82, -45, 116, 38, 119, -92, 20, 125, 42, 113, 65, -120, -119, 119, -90, 45, 98, -102, -95, 88, -104, 109, 108, -49, -50, -88, -22, -70, -35, -24, -95, 16, 68, -116, -124, 66, -63, -72, 31, 43, -76, -68, -77, 93, 116, 96, -128, -115, 66, 84, -93, 83, 48, 81, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 28, -17, -10, -64, 92, -19, -109, 112, 34, -31, 75, -55, 15, -16, -99, 122, 9, -18, -122, -122, 2, 20, 18, 119, 71, 98, -62, -97, 25, 97, -36, 41, -6, -71, 73, -91, 25, -42, -91, -68, 69, 77}, {48, -126, 3, -64, 48, -126, 3, 126, -96, 3, 2, 1, 2, 2, 1, 1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 23, 13, 48, 54, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -73, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -21, -81, 55, 4, 30, -54, 81, 30, 105, 93, -80, -14, -113, -10, -75, 73, 31, -58, -92, -103, 5, -41, 41, -65, 116, -73, 106, -11, 25, -40, 30, -28, 27, -8, 10, 1, -102, -104, -1, 112, -85, -30, 74, 86, -122, 108, 83, -77, -4, -31, -56, -127, -116, 49, -16, -60, -13, -80, -117, -26, 112, 6, -20, -9, 105, 104, -37, -125, 76, 114, 41, -119, 41, 54, 23, 92, 59, 74, 7, -96, 32, 2, 42, 70, -105, 81, 29, 112, -56, 8, 24, 11, -50, 12, 110, -101, 118, -9, 5, -29, -25, -5, -45, 97, 121, -31, 96, -102, 36, -115, 6, -107, -125, 60, 81, 32, -31, 48, -49, 56, 87, -126, -90, 26, 114, 13, -50, -45, 2, 21, 0, -124, 37, 69, -31, -70, -71, -87, 98, -85, 121, -24, 91, 48, -72, -119, 107, 27, -1, 123, 117, 2, -127, -127, 0, -85, -55, 116, 123, 116, -17, -18, 66, -75, 106, 83, 77, 59, -35, -112, 6, 114, 104, -111, 15, 11, -92, 41, 118, 46, 85, 59, -43, -82, 77, 101, 92, 126, 42, 58, 4, -90, 103, -90, -48, 113, -86, -91, -41, -73, -30, -63, 114, 13, -92, -47, -86, 30, -110, 84, 76, 32, 0, 9, -94, -80, 9, 65, 25, 51, 0, -78, -61, 92, -82, 66, -8, -79, -117, -54, 124, -106, -40, 16, 127, 55, 68, 91, -86, -52, 120, -56, -41, 114, 118, 55, 107, 64, -103, -88, 85, 102, -6, -88, 3, 30, -117, 74, 17, 2, 105, -53, 76, -72, 37, 6, 28, -96, 119, -46, -55, -84, -46, 61, -23, 10, 16, -6, 118, 112, -73, -5, -36, 3, -127, -124, 0, 2, -127, -128, 45, 9, -104, 92, -84, -72, -100, -57, -103, 126, -18, 32, 25, 42, 52, -112, -7, -41, -85, -85, -82, -35, 107, 114, -107, 13, 102, -8, -17, 39, -113, 68, -78, -19, 40, 68, -57, -2, -81, -80, -90, 39, 111, 0, 103, 69, -126, 91, 7, -88, 86, 86, 59, -46, 41, 81, 97, 94, 105, 57, -41, 46, 116, 119, 18, -49, 25, 74, -11, 45, -56, -53, 114, 97, -60, 78, 111, -6, 71, 67, 63, 20, -69, -6, -68, 24, 102, 40, -62, -39, 102, -117, 122, 45, 47, -62, 96, -110, 75, 20, -2, 88, 62, 33, 127, 104, 98, -66, 108, 72, 73, -7, -96, 75, 94, -123, -99, 25, 16, -7, 21, 69, 81, 27, 113, -44, -9, 11, -93, 102, 48, 100, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 36, -97, 2, -61, -5, 49, -43, -111, 59, -7, 126, 86, 111, -106, -33, 100, 10, 4, -104, -76, 2, 20, 110, 121, -124, -89, -18, 104, -93, 2, 114, 49, 99, -37, 67, -85, 8, -20, 77, -17, 22, 58}};
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static final String className = IBMJCECCA.class.getCanonicalName();
    private static String buildLevelJCECCA = null;
    private static String buildDateJCECCA = null;
    private static String implementationVersionJCEFW = null;
    private static final String BUILD_DATE_NOT_AVAILABLE = "Build Date Not Available In Manifest";
    private static final String PROPERTY_NOT_SET = "Property NOT Set";
    private static final String PATH_PROPERTY = "com.ibm.oti.vm.bootstrap.library.path";
    private static final String LIBPATH_PROPERTY = "java.library.path";
    private static final String CLASSPATH_PROPERTY = "java.class.path";
    private static final String OPERATING_SYSTEM_PROPERTY = "os.name";
    private static final String OPERATING_SYSTEM_VERSION_PROPERTY = "os.version";
    private static final String OPERATING_SYSTEM_ARCHITECTURE_PROPERTY = "os.arch";
    private static final HardwareProfile hwprof = new HardwareProfile();

    public IBMJCECCA() {
        super("IBMJCECCA", 1.2, info);
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "IBMJCECCA");
            IBMJCECCA.printEnvironment();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IBMJCECCA.this.setupSupportedServices();
                return null;
            }
        });
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "IBMJCECCA");
        }
    }

    private static void printEnvironment() {
        debug.text(40960L, className, "printEnvironment()", "IBMJCECCA.jar Build-Level: " + IBMJCECCA.getBuildLevelJCECCA());
        debug.text(40960L, className, "printEnvironment()", "IBMJCECCA.jar Build-Date: " + IBMJCECCA.getBuildDateJCECCA());
        debug.text(40960L, className, "printEnvironment()", "IBMJCEFW.jar Build-Level: " + IBMJCECCA.getImplementationVersionJCEFW());
        debug.text(40960L, className, "printEnvironment()", "IBMJCECCAProvider com.ibm.oti.vm.bootstrap.library.path: " + System.getProperty(PATH_PROPERTY, PROPERTY_NOT_SET));
        debug.text(40960L, className, "printEnvironment()", "IBMJCECCAProvider java.library.path: " + System.getProperty(LIBPATH_PROPERTY, PROPERTY_NOT_SET));
        debug.text(40960L, className, "printEnvironment()", "IBMJCECCAProvider java.class.path: " + System.getProperty(CLASSPATH_PROPERTY, PROPERTY_NOT_SET));
        debug.text(40960L, className, "printEnvironment()", "IBMJCECCAProvider os.name: " + System.getProperty(OPERATING_SYSTEM_PROPERTY, PROPERTY_NOT_SET));
        debug.text(40960L, className, "printEnvironment()", "IBMJCECCAProvider os.version: " + System.getProperty(OPERATING_SYSTEM_VERSION_PROPERTY, PROPERTY_NOT_SET));
        debug.text(40960L, className, "printEnvironment()", "IBMJCECCAProvider os.arch: " + System.getProperty(OPERATING_SYSTEM_ARCHITECTURE_PROPERTY, PROPERTY_NOT_SET));
        debug.text(40960L, className, "printEnvironment()", "\nIBMJCECCAProvider For the provider list, search the trace for 'Current security provider list:'\n");
    }

    private static String getBuildDateJCECCA() {
        if (buildDateJCECCA == null) {
            IBMJCECCA.setBuildDateAndLevelJCECCA();
        }
        return buildDateJCECCA;
    }

    private static String getBuildLevelJCECCA() {
        if (buildLevelJCECCA == null) {
            IBMJCECCA.setBuildDateAndLevelJCECCA();
        }
        return buildLevelJCECCA;
    }

    private static synchronized void setBuildDateAndLevelJCECCA() {
        String implementationVersion;
        buildLevelJCECCA = implementationVersion = IBMJCECCA.getImplementationVersion(IBMJCECCA.class);
        buildDateJCECCA = implementationVersion;
        String buildLevelExp = ".*level\\s*(\\d{6}).*";
        boolean buildLevelGroup = true;
        Pattern buildLevelPattern = Pattern.compile(".*level\\s*(\\d{6}).*", 2);
        Matcher buildLevelMatcher = buildLevelPattern.matcher(implementationVersion);
        if (buildLevelMatcher.matches() && buildLevelMatcher.groupCount() >= 1) {
            buildLevelJCECCA = buildLevelMatcher.group(1);
        }
        String buildDateExp = ".*build\\s*(\\d{6}\\s*\\d{2}:\\d{2}).*";
        boolean buildDateGroup = true;
        Pattern buildDatePattern = Pattern.compile(".*build\\s*(\\d{6}\\s*\\d{2}:\\d{2}).*", 2);
        Matcher buildDateMatcher = buildDatePattern.matcher(implementationVersion);
        if (buildDateMatcher.matches() && buildDateMatcher.groupCount() >= 1) {
            buildDateJCECCA = buildDateMatcher.group(1);
        }
    }

    private static synchronized String getImplementationVersionJCEFW() {
        if (implementationVersionJCEFW == null) {
            implementationVersionJCEFW = IBMJCECCA.getImplementationVersion(SecretKeySpec.class);
        }
        return implementationVersionJCEFW;
    }

    private static String getImplementationVersion(Class theClass) {
        String implementationVersion = BUILD_DATE_NOT_AVAILABLE;
        Package thisPackage = theClass.getPackage();
        if (thisPackage == null) {
            implementationVersion = BUILD_DATE_NOT_AVAILABLE;
        } else {
            implementationVersion = thisPackage.getImplementationVersion();
            if (implementationVersion == null) {
                implementationVersion = BUILD_DATE_NOT_AVAILABLE;
            }
        }
        return implementationVersion;
    }

    void setupSupportedServices() {
        String env;
        boolean useicsfcache;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setupSupportedServices", null);
        }
        String[] aliases = null;
        String usesslProperty = System.getProperty("ibm.hwrandom.usessl");
        String useicsfcacheProperty = System.getProperty("ibm.hwrandom.useicsfcache");
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "setupSupportedServices", "Value of ibm.hwrandom.usesslProperty: " + usesslProperty);
            debug.text(Debug.TYPE_FINE, className, "setupSupportedServices", "Value of ibm.hwrandom.useicsfcacheProperty: " + useicsfcacheProperty);
        }
        boolean usessl = usesslProperty == null ? false : usesslProperty.equalsIgnoreCase("true");
        boolean bl = useicsfcache = useicsfcacheProperty == null ? false : useicsfcacheProperty.equalsIgnoreCase("true");
        if (usessl && useicsfcache) {
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "setupSupportedServices", "Both ibm.hwrandom.usessl and ibm.hwrandom.useicsfcache values are set to true. Using ICSF With Caching Version of IBMSecureRandom.");
            }
            this.putService(new JCECCAService(this, "SecureRandom", "IBMSecureRandom", "com.ibm.crypto.hdwrCCA.provider.SecureRandomWithCache", null));
        } else if (usessl) {
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "setupSupportedServices", "Using System SSL Version of IBMSecureRandom.");
            }
            this.putService(new JCECCAService(this, "SecureRandom", "IBMSecureRandom", "com.ibm.crypto.hdwrCCA.provider.SecureRandomGSK", null));
        } else if (useicsfcache) {
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "setupSupportedServices", "Using ICSF With Caching Version of IBMSecureRandom.");
            }
            this.putService(new JCECCAService(this, "SecureRandom", "IBMSecureRandom", "com.ibm.crypto.hdwrCCA.provider.SecureRandomWithCache", null));
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "setupSupportedServices", "Using ICSF Version of IBMSecureRandom.");
            }
            this.putService(new JCECCAService(this, "SecureRandom", "IBMSecureRandom", "com.ibm.crypto.hdwrCCA.provider.SecureRandom", null));
        }
        aliases = new String[]{"SHA-1withRSA", "SHA-1/RSA", "SHA1/RSA", "SHA/RSA", "RSA", "OID.1.2.840.113549.1.1.5", "1.2.840.113549.1.1.5"};
        this.putService(new JCECCAService(this, "Signature", "SHA1withRSA", "com.ibm.crypto.hdwrCCA.provider.SHA1withRSA", aliases));
        aliases = new String[]{"NoHashwithRSA"};
        this.putService(new JCECCAService(this, "Signature", "RSAforSSL", "com.ibm.crypto.hdwrCCA.provider.DatawithRSA", aliases));
        if (!hwprof.getIsCryptoAssistPresent()) {
            if (!hwprof.getIsPCIXCCPresent()) {
                aliases = new String[]{"NoHashwithDSA"};
                this.putService(new JCECCAService(this, "Signature", "DSAforSSL", "com.ibm.crypto.hdwrCCA.provider.DatawithDSA", aliases));
            }
        }
        aliases = new String[]{"MD2/RSA", "OID.1.2.840.113549.1.1.2", "1.2.840.113549.1.1.2", "OID.1.3.14.3.2.24", "1.3.14.3.2.24"};
        this.putService(new JCECCAService(this, "Signature", "MD2withRSA", "com.ibm.crypto.hdwrCCA.provider.MD2withRSA", aliases));
        aliases = new String[]{"MD5/RSA", "OID.1.2.840.113549.1.1.4", "1.2.840.113549.1.1.4", "OID.1.3.14.3.2.25", "1.3.14.3.2.25"};
        this.putService(new JCECCAService(this, "Signature", "MD5withRSA", "com.ibm.crypto.hdwrCCA.provider.MD5withRSA", aliases));
        if (!hwprof.getIsCryptoAssistPresent()) {
            if (!hwprof.getIsPCIXCCPresent()) {
                aliases = new String[]{"SHA-1withDSA", "SHA-1/DSA", "SHA1/DSA", "SHA/DSA", "DSA", "DSS", "SHAwithDSA", "DSAWithSHA1", "OID.1.2.840.10040.4.3", "1.2.840.10040.4.3", "OID.1.3.14.3.2.13", "1.3.14.3.2.13", "OID.1.3.14.3.2.27", "1.3.14.3.2.27"};
                this.putService(new JCECCAService(this, "Signature", "SHA1withDSA", "com.ibm.crypto.hdwrCCA.provider.SHA1withDSA", aliases));
            }
        }
        if (hwprof.getIsSHA256CryptoAssistPresent()) {
            aliases = new String[]{"SHA224/RSA", "OID.2.16.840.1.101.3.4.2.4", "2.16.840.1.101.3.4.2.4", "OID.1.2.840.113549.1.1.14", "1.2.840.113549.1.1.14"};
            this.putService(new JCECCAService(this, "Signature", "SHA224withRSA", "com.ibm.crypto.hdwrCCA.provider.SHA224withRSA", aliases));
            aliases = new String[]{"SHA256withRSA", "SHA2/RSA", "OID.1.2.840.113549.1.1.11", "1.2.840.113549.1.1.11"};
            this.putService(new JCECCAService(this, "Signature", "SHA2withRSA", "com.ibm.crypto.hdwrCCA.provider.SHA2withRSA", aliases));
        }
        if (hwprof.getIsSHA512CryptoAssistPresent()) {
            aliases = new String[]{"SHA384withRSA", "SHA3/RSA", "OID.1.2.840.113549.1.1.12", "1.2.840.113549.1.1.12"};
            this.putService(new JCECCAService(this, "Signature", "SHA3withRSA", "com.ibm.crypto.hdwrCCA.provider.SHA3withRSA", aliases));
            aliases = new String[]{"SHA512withRSA", "SHA5/RSA", "OID.1.2.840.113549.1.1.13", "1.2.840.113549.1.1.13"};
            this.putService(new JCECCAService(this, "Signature", "SHA5withRSA", "com.ibm.crypto.hdwrCCA.provider.SHA5withRSA", aliases));
        }
        if (HardwareProfile.getIsPCICAPresent() || HardwareProfile.getIsPCICCPresent() || HardwareProfile.getIsPCIXCCPresent()) {
            aliases = new String[]{"RSA-PSS", "RSASSA-PSS", "RSASA-PSS", "OID.1.2.840.113549.1.1.10", "1.2.840.113549.1.1.10"};
            this.putService(new JCECCAService(this, "Signature", "RSAPSS", "com.ibm.crypto.hdwrCCA.provider.RSAPSSSignature", aliases));
        }
        if (HardwareProfile.isInternalECCKeysSupported()) {
            aliases = new String[]{"NONEwithECDSA"};
            this.putService(new JCECCAService(this, "Signature", "ECDSAforSSL", "com.ibm.crypto.hdwrCCA.provider.DatawithECDSA", aliases));
            aliases = new String[]{"SHAwithECDSA", "SHA-1withECDSA", "SHA/ECDSA", "SHA-1/ECDSA", "OID.1.2.840.10045.4.1", "1.2.840.10045.4.1"};
            this.putService(new JCECCAService(this, "Signature", "SHA1withECDSA", "com.ibm.crypto.hdwrCCA.provider.SHA1withECDSA", aliases));
            if (HardwareProfile.getIsSHA256CryptoAssistPresent()) {
                aliases = new String[]{"SHA224/ECDSA", "OID.1.2.840.10045.4.3.1", "1.2.840.10045.4.3.1"};
                this.putService(new JCECCAService(this, "Signature", "SHA224withECDSA", "com.ibm.crypto.hdwrCCA.provider.SHA224withECDSA", aliases));
                aliases = new String[]{"SHA256withECDSA", "ECDSA", "EC", "SHA2/ECDSA", "OID.1.2.840.10045.4.3.2", "1.2.840.10045.4.3.2"};
                this.putService(new JCECCAService(this, "Signature", "SHA2withECDSA", "com.ibm.crypto.hdwrCCA.provider.SHA2withECDSA", aliases));
            }
            if (HardwareProfile.getIsSHA512CryptoAssistPresent()) {
                aliases = new String[]{"SHA384withECDSA", "SHA3/ECDSA", "OID.1.2.840.10045.4.3.3", "1.2.840.10045.4.3.3"};
                this.putService(new JCECCAService(this, "Signature", "SHA3withECDSA", "com.ibm.crypto.hdwrCCA.provider.SHA3withECDSA", aliases));
                aliases = new String[]{"SHA512withECDSA", "SHA5/ECDSA", "OID.1.2.840.10045.4.3.4", "1.2.840.10045.4.3.4"};
                this.putService(new JCECCAService(this, "Signature", "SHA5withECDSA", "com.ibm.crypto.hdwrCCA.provider.SHA5withECDSA", aliases));
            }
        }
        this.putService(new JCECCAService(this, "Cipher", "AES", "com.ibm.crypto.hdwrCCA.provider.AESCipher", null));
        this.putService(new JCECCAService(this, "Cipher", "AES/CBC/NoPadding", "com.ibm.crypto.hdwrCCA.provider.AESCBCNoPadding", null));
        this.putService(new JCECCAService(this, "Cipher", "AES/CBC/PKCS5Padding", "com.ibm.crypto.hdwrCCA.provider.AESCBCPKCS5Padding", null));
        this.putService(new JCECCAService(this, "Cipher", "AES/ECB/NoPadding", "com.ibm.crypto.hdwrCCA.provider.AESECBNoPadding", null));
        this.putService(new JCECCAService(this, "Cipher", "AES/ECB/PKCS5Padding", "com.ibm.crypto.hdwrCCA.provider.AESECBPKCS5Padding", null));
        if (HardwareProfile.getIsHCR7790OrLaterPresent()) {
            this.putService(new JCECCAService(this, "Cipher", "AESKeyWrap", "com.ibm.crypto.hdwrCCA.provider.AESKeyWrap", null));
        }
        this.putService(new JCECCAService(this, "Cipher", "DES/CBC/NoPadding", "com.ibm.crypto.hdwrCCA.provider.DCNP", null));
        aliases = new String[]{"DESede/CBC/NoPadding"};
        this.putService(new JCECCAService(this, "Cipher", "TripleDES/CBC/NoPadding", "com.ibm.crypto.hdwrCCA.provider.TDCNP", aliases));
        this.putService(new JCECCAService(this, "Cipher", "DES", "com.ibm.crypto.hdwrCCA.provider.DESCipher", null));
        aliases = new String[]{"TripleDES", "3DES"};
        this.putService(new JCECCAService(this, "Cipher", "DESede", "com.ibm.crypto.hdwrCCA.provider.DESedeCipher", aliases));
        this.putService(new JCECCAService(this, "Cipher", "DESedeKeyWrap", "com.ibm.crypto.hdwrCCA.provider.DESedeKeyWrap", null));
        this.putService(new JCECCAService(this, "Cipher", "DESedeTR31KeyWrap", "com.ibm.crypto.hdwrCCA.provider.DESedeTR31KeyWrap", null));
        this.putService(new JCECCAService(this, "Cipher", "PBEWithMD2AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithMD2AndDESCipher", null));
        aliases = new String[]{"PBEWithMD2And3DES"};
        this.putService(new JCECCAService(this, "Cipher", "PBEWithMD2AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithMD2AndTripleDESCipher", aliases));
        this.putService(new JCECCAService(this, "Cipher", "PBEWithMD5AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithMD5AndDESCipher", null));
        aliases = new String[]{"PBEWithMD5And3DES", "PBEWithMD5AndDESede"};
        this.putService(new JCECCAService(this, "Cipher", "PBEWithMD5AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithMD5AndTripleDESCipher", aliases));
        aliases = new String[]{"PBEWithSHAAndDES", "PBEWithSHA-1AndDES"};
        this.putService(new JCECCAService(this, "Cipher", "PBEWithSHA1AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithSHA1AndDESCipher", aliases));
        aliases = new String[]{"PBEWithSHAAndTripleDES", "PBEWithSHA-1AndTripleDES", "PBEWithSHA1And3DES", "PBEWithSHAAnd3DES", "PBEWithSHA-1And3DES", "PBEWithSHA1AndDESede", "PBEWithSHAAndDESede", "PBEWithSHA-1AndDESede"};
        this.putService(new JCECCAService(this, "Cipher", "PBEWithSHA1AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithSHA1AndTripleDESCipher", aliases));
        this.putService(new JCECCAService(this, "Cipher", "RSA", "com.ibm.crypto.hdwrCCA.provider.RSA", null));
        this.putService(new JCECCAService(this, "Cipher", "RSAforSSL", "com.ibm.crypto.hdwrCCA.provider.RSA", null));
        this.putService(new JCECCAService(this, "Cipher", "RSA/ECB/PKCS1Padding", "com.ibm.crypto.hdwrCCA.provider.RSA", null));
        this.putService(new JCECCAService(this, "Cipher", "RSA/SSL/PKCS1Padding", "com.ibm.crypto.hdwrCCA.provider.RSA", null));
        aliases = new String[]{"PBEWithSHA1And2KeyTripleDES", "PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2Key3DES", "PBEWithSHA1And2Key3DES", "PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyDESede", "PBEWithSHA1And2KeyDESede", "PBEWithSHA-1And2KeyDESede"};
        this.putService(new JCECCAService(this, "Cipher", "PBEWithSHAAnd2KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithSHAAnd2KeyTripleDESCipher", aliases));
        aliases = new String[]{"PBEWithSHA1And3KeyTripleDES", "PBEWithSHA-1And3KeyTripleDES", "PBEWithSHAAnd3Key3DES", "PBEWithSHA1And3Key3DES", "PBEWithSHA-1And3Key3DES", "PBEWithSHAAnd3KeyDESede", "PBEWithSHA1And3KeyDESede", "PBEWithSHA-1And3KeyDESede"};
        this.putService(new JCECCAService(this, "Cipher", "PBEWithSHAAnd3KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithSHAAnd3KeyTripleDESCipher", aliases));
        this.putService(new JCECCAService(this, "KeyGenerator", "DES", "com.ibm.crypto.hdwrCCA.provider.DESKeyGenerator", null));
        aliases = new String[]{"TripleDES", "3DES"};
        this.putService(new JCECCAService(this, "KeyGenerator", "DESede", "com.ibm.crypto.hdwrCCA.provider.DESedeKeyGenerator", aliases));
        this.putService(new JCECCAService(this, "KeyGenerator", "AES", "com.ibm.crypto.hdwrCCA.provider.AESKeyGenerator", null));
        aliases = new String[]{"HMACwithMD2"};
        this.putService(new JCECCAService(this, "KeyGenerator", "HmacMD2", "com.ibm.crypto.hdwrCCA.provider.HmacMD2KeyGenerator", aliases));
        aliases = new String[]{"HMACwithMD5"};
        this.putService(new JCECCAService(this, "KeyGenerator", "HmacMD5", "com.ibm.crypto.hdwrCCA.provider.HmacMD5KeyGenerator", aliases));
        aliases = new String[]{"HMACwithSHA1"};
        this.putService(new JCECCAService(this, "KeyGenerator", "HmacSHA1", "com.ibm.crypto.hdwrCCA.provider.HmacSHA1KeyGenerator", aliases));
        aliases = new String[]{"OID.1.2.5.8.1.1", "1.2.5.8.1.1"};
        this.putService(new JCECCAService(this, "KeyPairGenerator", "RSA", "com.ibm.crypto.hdwrCCA.provider.RSAKeyPairGenerator", aliases));
        if (HardwareProfile.getIsPCICAPresent() || HardwareProfile.getIsPCICCPresent() || HardwareProfile.getIsPCIXCCPresent()) {
            aliases = new String[]{"RSA-PSS", "RSASSA-PSS", "RSASA-PSS", "OID.1.2.840.113549.1.1.10", "1.2.840.113549.1.1.10"};
            this.putService(new JCECCAService(this, "KeyPairGenerator", "RSAPSS", "com.ibm.crypto.hdwrCCA.provider.RSAKeyPairGenerator$PSS", aliases));
        }
        if (HardwareProfile.isInternalECCKeysSupported()) {
            aliases = new String[]{"OID.1.2.840.10045.2.1", "1.2.840.10045.2.1"};
            this.putService(new JCECCAService(this, "KeyPairGenerator", "EC", "com.ibm.crypto.hdwrCCA.provider.ECKeyPairGenerator", aliases));
        }
        if (!hwprof.getIsCryptoAssistPresent()) {
            if (!hwprof.getIsPCIXCCPresent()) {
                aliases = new String[]{"OID.1.2.840.10040.4.1", "1.2.840.10040.4.1", "OID.1.3.14.3.2.12", "1.3.14.3.2.12"};
                this.putService(new JCECCAService(this, "KeyPairGenerator", "DSA", "com.ibm.crypto.hdwrCCA.provider.DSAKeyPairGenerator", aliases));
            }
        }
        if (hwprof.getIsSHA256CryptoAssistPresent()) {
            aliases = new String[]{"HMACwithSHA224"};
            this.putService(new JCECCAService(this, "KeyGenerator", "HmacSHA224", "com.ibm.crypto.hdwrCCA.provider.HmacSHA224KeyGenerator", aliases));
            aliases = new String[]{"HMACwithSHA256"};
            this.putService(new JCECCAService(this, "KeyGenerator", "HmacSHA256", "com.ibm.crypto.hdwrCCA.provider.HmacSHA256KeyGenerator", aliases));
        }
        if (hwprof.getIsSHA512CryptoAssistPresent()) {
            aliases = new String[]{"HMACwithSHA384"};
            this.putService(new JCECCAService(this, "KeyGenerator", "HmacSHA384", "com.ibm.crypto.hdwrCCA.provider.HmacSHA384KeyGenerator", aliases));
            aliases = new String[]{"HMACwithSHA512"};
            this.putService(new JCECCAService(this, "KeyGenerator", "HmacSHA512", "com.ibm.crypto.hdwrCCA.provider.HmacSHA512KeyGenerator", aliases));
        }
        if ((env = System.getProperty("ibm.hwmd5.usejce")) != null) {
            if (env.equalsIgnoreCase("true")) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE | 0x8000L, className, "Using IBMJCE Version of MD5", ".");
                }
                this.putService(new JCECCAService(this, "MessageDigest", "MD5", "com.ibm.crypto.provider.MD5", null));
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE | 0x8000L, className, "Using IBMJCECCA Version of MD5", ".");
                }
                this.putService(new JCECCAService(this, "MessageDigest", "MD5", "com.ibm.crypto.hdwrCCA.provider.MD5", null));
            }
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_FINE | 0x8000L, className, "Using IBMJCECCA Version of MD5", ".");
            }
            this.putService(new JCECCAService(this, "MessageDigest", "MD5", "com.ibm.crypto.hdwrCCA.provider.MD5", null));
        }
        aliases = new String[]{"SHA-1", "SHA1"};
        this.putService(new JCECCAService(this, "MessageDigest", "SHA", "com.ibm.crypto.hdwrCCA.provider.FullHardwareSHA", aliases));
        this.putService(new JCECCAService(this, "MessageDigest", "MD2", "com.ibm.crypto.hdwrCCA.provider.MD2", null));
        aliases = new String[]{"SHA-224", "SHA224", "OID.2.16.840.1.101.3.4.2.4", "2.16.840.1.101.3.4.2.4"};
        this.putService(new JCECCAService(this, "MessageDigest", "SHA224", "com.ibm.crypto.hdwrCCA.provider.FullHardwareSHA224", aliases));
        aliases = new String[]{"SHA-2", "SHA-256", "SHA256", "OID.2.16.840.1.101.3.4.2.1", "2.16.840.1.101.3.4.2.1"};
        this.putService(new JCECCAService(this, "MessageDigest", "SHA2", "com.ibm.crypto.hdwrCCA.provider.FullHardwareSHA256", aliases));
        aliases = new String[]{"SHA-3", "SHA-384", "SHA384", "OID.2.16.840.1.101.3.4.2.2", "2.16.840.1.101.3.4.2.2"};
        this.putService(new JCECCAService(this, "MessageDigest", "SHA3", "com.ibm.crypto.hdwrCCA.provider.FullHardwareSHA384", aliases));
        aliases = new String[]{"SHA-5", "SHA-512", "SHA512", "OID.2.16.840.1.101.3.4.2.3", "2.16.840.1.101.3.4.2.3"};
        this.putService(new JCECCAService(this, "MessageDigest", "SHA5", "com.ibm.crypto.hdwrCCA.provider.FullHardwareSHA512", aliases));
        if (!hwprof.getIsCryptoAssistPresent()) {
            if (!hwprof.getIsPCIXCCPresent()) {
                this.putService(new JCECCAService(this, "AlgorithmParameterGenerator", "DSA", "com.ibm.crypto.hdwrCCA.provider.DSAParameterGenerator", null));
            }
        }
        if (HardwareProfile.isInternalECCKeysSupported()) {
            this.putService(new JCECCAService(this, "AlgorithmParameterGenerator", "EC", "com.ibm.crypto.hdwrCCA.provider.ECParameterGenerator", null));
        }
        if (HardwareProfile.isECCDiffieHellmanSupported()) {
            aliases = null;
            this.putService(new JCECCAService(this, "KeyAgreement", "ECDH", "com.ibm.crypto.hdwrCCA.provider.ECDHKeyAgreement", aliases));
        }
        this.putService(new JCECCAService(this, "AlgorithmParameters", "DES", "com.ibm.crypto.hdwrCCA.provider.DESParameters", null));
        aliases = new String[]{"TripleDES", "3DES"};
        this.putService(new JCECCAService(this, "AlgorithmParameters", "DESede", "com.ibm.crypto.hdwrCCA.provider.DESedeParameters", aliases));
        this.putService(new JCECCAService(this, "AlgorithmParameters", "AES", "com.ibm.crypto.hdwrCCA.provider.AESParameters", null));
        aliases = new String[]{"PBEWithMD2AndDES", "PBEWithMD2AndTripleDES", "PBEWithMD2And3DES", "PBEWithMD2AndDESede", "PBEWithMD5AndDES", "PBEWithMD5AndTripleDES", "PBEWithMD5And3DES", "PBEWithMD5AndDESede", "PBEWithSHAAndDES", "PBEWithSHA1AndDES", "PBEWithSHA-1AndDES", "PBEWithSHAAndTripleDES", "PBEWithSHA1AndTripleDES", "PBEWithSHA-1AndTripleDES", "PBEWithSHAAnd3DES", "PBEWithSHA1And3DES", "PBEWithSHA-1And3DES", "PBEWithSHAAndDESede", "PBEWithSHA1AndDESede", "PBEWithSHA-1AndDESede", "PBEWithSHAAnd2KeyTripleDES", "PBEWithSHA1And2KeyTripleDES", "PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2Key3DES", "PBEWithSHA1And2Key3DES", "PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyDESede", "PBEWithSHA1And2KeyDESede", "PBEWithSHA-1And2KeyDESede", "PBEWithSHAAnd3KeyTripleDES", "PBEWithSHA1And3KeyTripleDES", "PBEWithSHA-1And3KeyTripleDES", "PBEWithSHAAnd3Key3DES", "PBEWithSHA1And3Key3DES", "PBEWithSHA-1And3Key3DES", "PBEWithSHAAnd3KeyDESede", "PBEWithSHA1And3KeyDESede", "PBEWithSHA-1And3KeyDESede"};
        this.putService(new JCECCAService(this, "AlgorithmParameters", "PBE", "com.ibm.crypto.hdwrCCA.provider.PBEParameters", aliases));
        aliases = new String[]{"1.2.840.113533.7.66.13", "OID.1.2.840.113533.7.66.13", "PasswordBasedMac"};
        this.putService(new JCECCAService(this, "AlgorithmParameters", "PBM", "com.ibm.crypto.hdwrCCA.provider.PBMParameters", aliases));
        if (!hwprof.getIsCryptoAssistPresent()) {
            if (!hwprof.getIsPCIXCCPresent()) {
                aliases = new String[]{"1.3.14.3.2.12", "1.2.840.10040.4.1"};
                this.putService(new JCECCAService(this, "AlgorithmParameters", "DSA", "com.ibm.crypto.hdwrCCA.provider.DSAParameters", aliases));
            }
        }
        if (HardwareProfile.isInternalECCKeysSupported()) {
            aliases = new String[]{"OID.1.2.840.10045.2.1", "1.2.840.10045.2.1"};
            this.putService(new JCECCAService(this, "AlgorithmParameters", "EC", "com.ibm.crypto.hdwrCCA.provider.ECParameters", aliases));
        }
        this.putService(new JCECCAService(this, "AlgorithmParameters", "OAEP", "com.ibm.crypto.hdwrCCA.provider.OAEPParameters", null));
        if (HardwareProfile.getIsPCICAPresent() || HardwareProfile.getIsPCICCPresent() || HardwareProfile.getIsPCIXCCPresent()) {
            aliases = new String[]{"RSA-PSS", "RSASSA-PSS", "RSASA-PSS", "OID.1.2.840.113549.1.1.10", "1.2.840.113549.1.1.10"};
            this.putService(new JCECCAService(this, "AlgorithmParameters", "RSAPSS", "com.ibm.crypto.hdwrCCA.provider.PSSParameters", aliases));
        }
        aliases = new String[]{"OID.1.2.5.8.1.1", "1.2.5.8.1.1", "OID.1.2.840.113549.1.1.1", "1.2.840.113549.1.1.1"};
        this.putService(new JCECCAService(this, "KeyFactory", "RSA", "com.ibm.crypto.hdwrCCA.provider.RSAKeyFactory", aliases));
        if (HardwareProfile.getIsPCICAPresent() || HardwareProfile.getIsPCICCPresent() || HardwareProfile.getIsPCIXCCPresent()) {
            aliases = new String[]{"RSA-PSS", "RSASSA-PSS", "RSASA-PSS", "OID.1.2.840.113549.1.1.10", "1.2.840.113549.1.1.10"};
            this.putService(new JCECCAService(this, "KeyFactory", "RSAPSS", "com.ibm.crypto.hdwrCCA.provider.RSAKeyFactory$PSS", aliases));
        }
        if (!hwprof.getIsCryptoAssistPresent()) {
            if (!hwprof.getIsPCIXCCPresent()) {
                aliases = new String[]{"OID.1.3.14.3.2.12", "1.3.14.3.2.12", "OID.1.2.840.10040.4.1", "1.2.840.10040.4.1"};
                this.putService(new JCECCAService(this, "KeyFactory", "DSA", "com.ibm.crypto.hdwrCCA.provider.DSAKeyFactory", aliases));
            }
        }
        if (HardwareProfile.isInternalECCKeysSupported()) {
            aliases = new String[]{"OID.1.2.840.10045.2.1", "1.2.840.10045.2.1"};
            this.putService(new JCECCAService(this, "KeyFactory", "EC", "com.ibm.crypto.hdwrCCA.provider.ECKeyFactory", aliases));
        }
        aliases = new String[]{"HMACwithSHA1", "HmacSHA1"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "HMACSHA1", "com.ibm.crypto.hdwrCCA.provider.HMACSHA1KeyFactory", aliases));
        aliases = new String[]{"HMACwithSHA224", "HmacSHA224"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "HMACSHA224", "com.ibm.crypto.hdwrCCA.provider.HMACSHA224KeyFactory", aliases));
        aliases = new String[]{"HMACwithSHA256", "HmacSHA256"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "HMACSHA256", "com.ibm.crypto.hdwrCCA.provider.HMACSHA256KeyFactory", aliases));
        aliases = new String[]{"HMACwithSHA384", "HmacSHA384"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "HMACSHA384", "com.ibm.crypto.hdwrCCA.provider.HMACSHA384KeyFactory", aliases));
        aliases = new String[]{"HMACwithSHA512", "HmacSHA512"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "HMACSHA512", "com.ibm.crypto.hdwrCCA.provider.HMACSHA512KeyFactory", aliases));
        this.putService(new JCECCAService(this, "SecretKeyFactory", "DES", "com.ibm.crypto.hdwrCCA.provider.DESKeyFactory", null));
        aliases = new String[]{"TripleDES", "3DES"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "DESede", "com.ibm.crypto.hdwrCCA.provider.DESedeKeyFactory", aliases));
        this.putService(new JCECCAService(this, "SecretKeyFactory", "AES", "com.ibm.crypto.hdwrCCA.provider.AESKeyFactory", null));
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithMD2AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithMD2AndDES", null));
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithMD5AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithMD5AndDES", null));
        aliases = new String[]{"PBEWithSHA1AndDES", "PBEWithSHA-1AndDES"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithSHAAndDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithSHAAndDES", aliases));
        aliases = new String[]{"PBEWithSHA1AndTripleDES", "PBEWithSHA-1AndTripleDES", "PBEWithSHAAnd3DES", "PBEWithSHA1And3DES", "PBEWithSHA-1And3DES", "PBEWithSHAAndDESede", "PBEWithSHA1AndDESede", "PBEWithSHA-1AndDESede"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithSHAAndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithSHAAndTripleDES", aliases));
        aliases = new String[]{"PBEWithSHAAnd2Key3DES", "PBEWithSHAAnd2KeyDESede", "PBEWithSHA1And2KeyTripleDES", "PBEWithSHA1And2Key3DES", "PBEWithSHA1And2KeyDESede", "PBEWithSHA-1And2KeyTripleDES", "PBEWithSHA-1And2Key3DES", "PBEWithSHA-1And2KeyDESede"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithSHAAnd2KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithSHAAnd2KeyTripleDES", aliases));
        aliases = new String[]{"PBEWithSHAAnd3Key3DES", "PBEWithSHAAnd3KeyDESede", "PBEWithSHA1And3KeyTripleDES", "PBEWithSHA1And3Key3DES", "PBEWithSHA1And3KeyDESede", "PBEWithSHA1And3KeyTripleDES", "PBEWithSHA1And3Key3DES", "PBEWithSHA1And3KeyDESede"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithSHAAnd3KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithSHAAnd3KeyTripleDES", aliases));
        aliases = new String[]{"PBEWithMD2AndDESede"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithMD2AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithMD2AndTripleDES", aliases));
        aliases = new String[]{"PBEWithMD5AndDESede"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithMD5AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithMD5AndTripleDES", aliases));
        aliases = new String[]{"PBEWithSHA1And2KeyTripleDES", "PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2Key3DES", "PBEWithSHA1And2Key3DES", "PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyDESede", "PBEWithSHA1And2KeyDESede", "PBEWithSHA-1And2KeyDESede"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithSHAAnd2KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithSHAAnd2KeyTripleDES", aliases));
        aliases = new String[]{"PBEWithSHA1And3KeyTripleDES", "PBEWithSHA-1And3KeyTripleDES", "PBEWithSHAAnd3Key3DES", "PBEWithSHA1And3Key3DES", "PBEWithSHA-1And3Key3DES", "PBEWithSHAAnd3KeyDESede", "PBEWithSHA1And3KeyDESede", "PBEWithSHA-1And3KeyDESede"};
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBEWithSHAAnd3KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory$PBEWithSHAAnd3KeyTripleDES", aliases));
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PKCS5Key", "com.ibm.crypto.hdwrCCA.provider.PKCS5KeyFactory", null));
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBKDF1", "com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKeyFactory", null));
        this.putService(new JCECCAService(this, "SecretKeyFactory", "PBKDF2", "com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKeyFactory", null));
        aliases = new String[]{"HMACwithMD2"};
        this.putService(new JCECCAService(this, "Mac", "HmacMD2", "com.ibm.crypto.hdwrCCA.provider.HmacMD2", aliases));
        aliases = new String[]{"HMACwithMD5"};
        this.putService(new JCECCAService(this, "Mac", "HmacMD5", "com.ibm.crypto.hdwrCCA.provider.HmacMD5", aliases));
        aliases = new String[]{"HMACwithSHA1"};
        this.putService(new JCECCAService(this, "Mac", "HmacSHA1", "com.ibm.crypto.hdwrCCA.provider.HmacSHA1", aliases));
        aliases = new String[]{"1.2.840.113533.7.66.13", "OID.1.2.840.113533.7.66.13", "PasswordBasedMac"};
        this.putService(new JCECCAService(this, "Mac", "PBM", "com.ibm.crypto.hdwrCCA.provider.PBM", aliases));
        if (hwprof.getIsSHA256CryptoAssistPresent()) {
            aliases = new String[]{"HMACwithSHA224"};
            this.putService(new JCECCAService(this, "Mac", "HmacSHA224", "com.ibm.crypto.hdwrCCA.provider.HmacSHA224", aliases));
            aliases = new String[]{"HMACwithSHA256"};
            this.putService(new JCECCAService(this, "Mac", "HmacSHA256", "com.ibm.crypto.hdwrCCA.provider.HmacSHA256", aliases));
        }
        if (hwprof.getIsSHA512CryptoAssistPresent()) {
            aliases = new String[]{"HMACwithSHA384"};
            this.putService(new JCECCAService(this, "Mac", "HmacSHA384", "com.ibm.crypto.hdwrCCA.provider.HmacSHA384", aliases));
            aliases = new String[]{"HMACwithSHA512"};
            this.putService(new JCECCAService(this, "Mac", "HmacSHA512", "com.ibm.crypto.hdwrCCA.provider.HmacSHA512", aliases));
        }
        aliases = new String[]{"X.509"};
        this.putService(new JCECCAService(this, "CertificateFactory", "X509", "com.ibm.crypto.hdwrCCA.provider.X509Factory", aliases));
        aliases = new String[]{"JCE4758KS"};
        this.putService(new JCECCAService(this, "KeyStore", "JCECCAKS", "com.ibm.crypto.hdwrCCA.provider.JceCCAKeyStore", aliases));
        this.putService(new JCECCAService(this, "KeyStore", "JCA4758KS", "com.ibm.crypto.hdwrCCA.provider.Jca4758KeyStore", null));
        if (PlatformUtilities.isZOS()) {
            aliases = new String[]{"JCE4758RACFKS"};
            this.putService(new JCECCAService(this, "KeyStore", "JCECCARACFKS", "com.ibm.crypto.hdwrCCA.provider.JceRACFKeyStore", aliases));
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "setupSupportedServices", null);
        }
    }

    static final void verifyJceJar() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC | 0x8000L, className, "verifyJceJar");
        }
        if (verifiedJce) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC | 0x8000L, className, "verifyJceJar_1");
            }
            return;
        }
        if (debug != null) {
            Provider[] providers = Security.getProviders();
            int order = 1;
            debug.text(40960L, className, "verifyJceJar", "Current security provider list:");
            String message = "There are " + providers.length + " providers in the current list.\n";
            StringBuffer buf = new StringBuffer();
            for (Provider provider : providers) {
                buf.append("\t[" + order + "] " + provider.getName() + " " + provider.getVersion() + "\n");
                ++order;
            }
            String s = buf.toString();
            debug.text(40960L, className, "verifyJceJar", message + s);
        }
        String javaVersion = System.getProperty("java.version");
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC | 0x8000L, className, "***check java version", ".");
        }
        if (javaVersion.compareTo("1.4") >= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC | 0x8000L, className, "javaVersion > 1.4", ".");
            }
            verifiedJce = true;
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC | 0x8000L, className, "verifyJceJar_3");
            }
            return;
        }
        IBMJCECCA.doVerifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC | 0x8000L, className, "verifyJceJar_2");
        }
    }

    private static final synchronized void doVerifyJceJar() {
        JarFile jf;
        if (debug != null) {
            debug.entry(40960L, className, "doVerifyJceJar");
        }
        if (verifiedJce) {
            if (debug != null) {
                debug.exit(40960L, className, "doVerifyJceJar_1");
            }
            return;
        }
        URL jceJarURL = null;
        try {
            Class<IBMJCECCA> c = IBMJCECCA.class;
            final ClassLoader cl = c.getClassLoader();
            URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getResource("javax/crypto/Cipher.class");
                }
            });
            if (url == null) {
                if (debug != null) {
                    debug.text(40960L, className, "doVerifyJceJar", "Cannot get the JCE framework URL. Check that IBMJCECCA can read the JCE framework");
                }
                throw new SecurityException("Cannot get the JCE framework URL. Check that IBMJCECCA can read the JCE framework");
            }
            int bang = IBMJCECCA.indexOfBang(url.toString());
            if (bang == -1) {
                if (debug != null) {
                    debug.text(40960L, className, "doVerifyJceJar", "The JCE framework is invalid");
                }
                throw new SecurityException("The JCE framework is invalid");
            }
            jceJarURL = new URL(url.toString().substring(0, bang + 1));
            int beginIndex = 4;
            URL jceURL = new URL(url.toString().substring(beginIndex, bang - 1));
            if (!jceURL.getProtocol().equalsIgnoreCase("file")) {
                if (debug != null) {
                    debug.text(40960L, className, "doVerifyJceJar", "JCE should be deployed as an installed extension");
                }
                throw new SecurityException("JCE should be deployed as an installed extension");
            }
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(40960L, className, "doVerifyJceJar", ioe);
            }
            throw new SecurityException("The provider IBMJCECCA cannot authenticate JCE framework" + ioe);
        }
        try {
            final URL url = jceJarURL;
            jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ((JarURLConnection)url.openConnection()).getJarFile();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (debug != null) {
                debug.exception(40960L, className, "doVerifyJceJar", pae);
            }
            throw new SecurityException("Cannot authenticate JCE framework " + pae);
        }
        try {
            IBMJCECCA.verifySingleJarFile(jf);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(40960L, className, "doVerifyJceJar", e);
            }
            throw new SecurityException("Cannot authenticate JCE framework " + e);
        }
        verifiedJce = true;
        if (debug != null) {
            debug.exit(40960L, className, "doVerifyJceJar");
        }
    }

    private static void verifySingleJarFile(JarFile jf) throws IOException, CertificateException {
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = jf.entries();
        if (debug != null) {
            debug.entry(40960L, (Object)className, "verifySingleJarFile", jf);
        }
        while (entries.hasMoreElements()) {
            int n;
            JarEntry je = entries.nextElement();
            entriesVec.addElement(je);
            InputStream is = jf.getInputStream(je);
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            }
            is.close();
        }
        Manifest man = jf.getManifest();
        if (man == null) {
            if (debug != null) {
                debug.text(40960L, className, "verifySingleJarFile", "The JCE framework is not signed");
            }
            throw new SecurityException("The JCE framework is not signed");
        }
        trustedCaCerts = IBMJCECCA.setupTrustedCaCerts();
        Vector verifiedRootCache = new Vector(2);
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            JarEntry je = (JarEntry)e.nextElement();
            if (je.isDirectory()) continue;
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                if (debug != null) {
                    debug.text(40960L, className, "verifySingleJarFile", "The JCE framework has unsigned class files.");
                }
                throw new SecurityException("The JCE framework has unsigned class files.");
            }
            Certificate[] chainRoots = IBMJCECCA.getChainRoots(certs);
            boolean signedAsExpected = false;
            for (int i = 0; i < chainRoots.length; ++i) {
                if (verifiedRootCache.contains((X509Certificate)chainRoots[i])) {
                    signedAsExpected = true;
                    break;
                }
                if (!IBMJCECCA.isTrusted((X509Certificate)chainRoots[i])) continue;
                signedAsExpected = true;
                break;
            }
            if (signedAsExpected) continue;
            if (debug != null) {
                debug.text(40960L, className, "verifySingleJarFile", "JCE framework is not signed by a trusted signer");
            }
            throw new SecurityException("JCE framework is not signed by a trusted signer");
        }
        if (debug != null) {
            debug.exit(40960L, className, "verifySingleJarFile");
        }
    }

    private static boolean isTrusted(X509Certificate cert) {
        int i;
        if (debug != null) {
            debug.entry(40960L, (Object)className, "isTrusted", cert);
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getSubjectDN().equals(trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            if (debug != null) {
                debug.exit(40960L, (Object)className, "isTrusted_1", true);
            }
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getIssuerDN().equals(trustedCaCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                if (debug != null) {
                    debug.exit(40960L, (Object)className, "isTrusted_2", true);
                }
                return true;
            }
            catch (Exception e) {
                if (debug == null) continue;
                debug.exception(40960L, className, "isTrusted", e);
            }
        }
        if (debug != null) {
            debug.exit(40960L, (Object)className, "isTrusted_3", false);
        }
        return false;
    }

    private static Certificate[] getChainRoots(Certificate[] certs) {
        Vector<Certificate> result = new Vector<Certificate>(3);
        if (debug != null) {
            debug.entry(40960L, (Object)className, "getChainRoots", certs);
        }
        for (int i = 0; i < certs.length - 1; ++i) {
            if (((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN())) continue;
            result.addElement(certs[i]);
        }
        result.addElement(certs[certs.length - 1]);
        Object[] ret = new Certificate[result.size()];
        result.copyInto(ret);
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getChainRoots", ret);
        }
        return ret;
    }

    private static X509Certificate[] setupTrustedCaCerts() throws IOException, CertificateException {
        if (debug != null) {
            debug.entry(40960L, className, "setupTrustedCaCerts");
        }
        int numberOfTrustedCas = bytesOfTrustedCaCerts.length;
        X509Certificate[] certs = new X509Certificate[numberOfTrustedCas];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < numberOfTrustedCas; ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytesOfTrustedCaCerts[i]);
            certs[i] = (X509Certificate)cf.generateCertificate(inStream);
            inStream.close();
        }
        if (debug != null) {
            debug.exit(40960L, (Object)className, "setupTrustedCaCerts", certs);
        }
        return certs;
    }

    private static int indexOfBang(String spec) {
        int indexOfBang;
        if (debug != null) {
            debug.entry(40960L, (Object)className, "indexOfBang", spec);
        }
        if ((indexOfBang = spec.lastIndexOf(".jar!/")) > 0) {
            if (debug != null) {
                debug.exit(40960L, (Object)className, "indexOfBang_1", indexOfBang + 5);
            }
            return indexOfBang + 5;
        }
        if (debug != null) {
            debug.exit(40960L, (Object)className, "indexOfBang_1", -1);
        }
        return -1;
    }

    static final boolean verifySelfIntegrity(Class c) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC | 0x8000L, (Object)className, "verifySelfIntegrity", c);
        }
        if (verifiedSelfIntegrity) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC | 0x8000L, (Object)className, "verifySelfIntegrity_1", true);
            }
            return true;
        }
        boolean retValue = IBMJCECCA.doSelfVerification(c);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC | 0x8000L, (Object)className, "verifySelfIntegrity_2", retValue);
        }
        return retValue;
    }

    private static final synchronized boolean doSelfVerification(Class c) {
        Class cc;
        URL url;
        if (debug != null) {
            debug.entry(40960L, (Object)className, "doSelfVerification", c);
        }
        if (verifiedSelfIntegrity) {
            if (debug != null) {
                debug.exit(40960L, (Object)className, "doSelfVerification_1", true);
            }
            return true;
        }
        if (trustedCaCerts == null) {
            try {
                trustedCaCerts = IBMJCECCA.setupTrustedCaCerts();
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exit(40960L, (Object)className, "doSelfVerification_2", true);
                }
                return false;
            }
        }
        if ((url = (URL)AccessController.doPrivileged(new PrivilegedAction(cc = c){
            final /* synthetic */ Class val$cc;
            {
                this.val$cc = clazz;
            }

            public Object run() {
                CodeSource s1 = this.val$cc.getProtectionDomain().getCodeSource();
                return s1.getLocation();
            }
        })) == null) {
            if (debug != null) {
                debug.exit(40960L, (Object)className, "doSelfVerification_2", false);
            }
            return false;
        }
        JarVerifier jv = new JarVerifier(url);
        try {
            jv.verify(trustedCaCerts);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(40960L, className, "doSelfVerification", e);
                debug.exit(40960L, (Object)className, "doSelfVerification_3", false);
            }
            return false;
        }
        verifiedSelfIntegrity = true;
        if (debug != null) {
            debug.exit(40960L, (Object)className, "doSelfVerification_4", true);
        }
        return true;
    }

    private static Certificate[] getSignerCertificates(Class c) {
        final Class cc = c;
        if (debug != null) {
            debug.entry(40960L, (Object)className, "getSignedCertificates", c);
        }
        Certificate[] certs = (Certificate[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource s1 = cc.getProtectionDomain().getCodeSource();
                return s1.getCertificates();
            }
        });
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getSignedCertificates", certs);
        }
        return certs;
    }

    private static class JCECCAService
    extends Provider.Service {
        private static String className = "com.ibm.crypto.hdwrCCA.provider.IBMJCECCA.JCECCAService";

        JCECCAService(Provider provider, String type, String algorithm, String className, String[] aliases) {
            super(provider, type, algorithm, className, JCECCAService.toList(aliases), null);
        }

        private static List<String> toList(String[] aliases) {
            return aliases == null ? null : Arrays.asList(aliases);
        }

        @Override
        public boolean supportsParameter(Object param) {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter", param);
            }
            boolean isSupported = false;
            if (param == null) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter1", false);
                }
                return false;
            }
            if (!(param instanceof Key)) {
                InvalidParameterException ipe = new InvalidParameterException("Parameter must be a Key");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "supportsParameter", ipe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "supportsParameter");
                }
                throw ipe;
            }
            String algorithm = this.getAlgorithm();
            String type = this.getType();
            Key key = (Key)param;
            String keyAlg = key.getAlgorithm();
            if (type.equals("Signature") && (algorithm.toUpperCase().contains("PSS") || algorithm.contains("1.2.840.113549.1.1.10"))) {
                if (!keyAlg.startsWith("RSA")) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter10", false);
                    }
                    return false;
                }
                boolean bl = isSupported = key instanceof RSAPrivateHWKey || key instanceof RSAPrivateKey || key instanceof RSAPublicKey || key instanceof java.security.interfaces.RSAPublicKey;
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter11", isSupported);
                }
                return isSupported;
            }
            if (type.equals("Cipher") && algorithm.startsWith("RSA") || type.equals("Signature") && (algorithm.startsWith("RSA") || algorithm.endsWith("RSA"))) {
                if (!keyAlg.equals("RSA")) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter2", false);
                    }
                    return false;
                }
                boolean bl = isSupported = key instanceof RSAPrivateHWKey || key instanceof RSAPrivateKey || key instanceof RSAPublicKey || key instanceof java.security.interfaces.RSAPublicKey;
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter3", isSupported);
                }
                return isSupported;
            }
            if (type.equals("Signature") && (algorithm.startsWith("ECDSA") || algorithm.endsWith("ECDSA") || algorithm.startsWith("EC") || algorithm.endsWith("1.2.840.10045.4.1") || algorithm.endsWith("1.2.840.10045.4.3.2") || algorithm.endsWith("1.2.840.10045.4.3.3") || algorithm.endsWith("1.2.840.10045.4.3.4")) || type.equals("KeyAgreement") && algorithm.startsWith("ECDH")) {
                if (!keyAlg.equals("EC")) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter7", false);
                    }
                    return false;
                }
                boolean bl = isSupported = key instanceof ECPrivateHWKey || key instanceof ECPrivateKey || key instanceof ECPublicKey || key instanceof java.security.interfaces.ECPublicKey;
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter8", isSupported);
                }
                return isSupported;
            }
            if (type.equals("Signature") && (algorithm.startsWith("DSA") || algorithm.endsWith("DSA"))) {
                if (!keyAlg.equals("DSA")) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter4", false);
                    }
                    return false;
                }
                hwprof;
                if (!HardwareProfile.getIsCryptoAssistPresent()) {
                    hwprof;
                    if (!HardwareProfile.getIsPCIXCCPresent()) {
                        boolean bl = isSupported = key instanceof DSAPrivateHWKey || key instanceof java.security.interfaces.DSAPublicKey || key instanceof DSAPublicKey;
                        if (debug != null) {
                            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter5", isSupported);
                        }
                        return isSupported;
                    }
                }
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter6", false);
                }
                return false;
            }
            if (type == "Cipher" || type == "Mac") {
                boolean bl = isSupported = "RAW".equals(key.getFormat()) || "PKCS5_DERIVED_KEY".equals(key.getFormat()) || "PKCS5_KEY".equals(key.getFormat());
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "supportsParameter9", isSupported);
                }
                return isSupported;
            }
            AssertionError ae = new AssertionError((Object)("IBMJCECCA error: " + type + ", " + algorithm));
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "supportsParameter", (Throwable)((Object)ae));
                debug.exit(Debug.TYPE_PUBLIC, className, "supportsParameter");
            }
            throw ae;
        }
    }
}

