/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class HmacSHAKeyGenerator
extends KeyGeneratorSpi {
    private String SHAalgName = null;
    private String SHAdisplayName = null;
    private int keysize = 0;
    private SecureRandom random = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.HmacSHAKeyGenerator";

    public HmacSHAKeyGenerator(String SHAalgName, String SHAdisplayName, int keysize) {
        if (debug != null) {
            Object[] parms = new Object[]{SHAalgName, SHAdisplayName, new Integer(keysize)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "HmacSHAKeyGenerator", parms);
        }
        IBMJCECCA.verifyJceJar();
        this.SHAalgName = SHAalgName;
        this.SHAdisplayName = SHAdisplayName;
        this.keysize = keysize;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "HmacSHAKeyGenerator");
        }
    }

    @Override
    protected void engineInit(SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", random);
        }
        this.random = random;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", params, random);
            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", this.SHAdisplayName + " key generation does not take any parameters");
        }
        throw new InvalidAlgorithmParameterException(this.SHAdisplayName + " key generation does not take any parameters");
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", new Integer(keysize), random);
        }
        this.keysize = (keysize + 7) / 8;
        this.engineInit(random);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGenerateKey");
        }
        if (this.random == null) {
            try {
                this.random = SecureRandom.getInstance("IBMSecureRandom");
            }
            catch (NoSuchAlgorithmException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", e);
                }
                this.random = new SecureRandom();
            }
        }
        byte[] keyBytes = new byte[this.keysize];
        this.random.nextBytes(keyBytes);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, this.SHAalgName);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateKey", secretKey);
        }
        return secretKey;
    }
}

