/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HMACKey;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

class HmacSHA
extends MacSpi
implements Cloneable {
    private MessageDigest sha;
    private byte[] k_ipad;
    private byte[] k_opad;
    private int SHA_Length = 0;
    private int SHA_Block_Length = 0;
    private String msg_Digest_Name = null;
    private String ccaKeyLabel = null;
    private Segment currentSegment = Segment.FIRST;
    private byte[] buffer = null;
    private int bufferIndex;
    private int bufferLeft;
    private byte[] mac = null;
    private byte[] chaining_vector = new byte[128];
    private HIKM hikm = new HIKM();
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.HmacSHA";
    private static HexDumpEncoder encoder = new HexDumpEncoder();

    public HmacSHA(String msgDigestName, int ShaLength, int ShaBlockLength) throws NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{msgDigestName, ShaLength, ShaBlockLength};
            debug.entry(Debug.TYPE_FINE, (Object)className, "HmacSHA", parms);
        }
        this.msg_Digest_Name = msgDigestName;
        this.SHA_Length = ShaLength;
        this.SHA_Block_Length = ShaBlockLength;
        this.buffer = new byte[ShaBlockLength];
        this.bufferIndex = 0;
        this.bufferLeft = ShaBlockLength;
        Arrays.fill(this.chaining_vector, (byte)0);
        Arrays.fill(this.buffer, (byte)0);
        try {
            this.sha = Security.getProvider("IBMJCECCA") == null ? MessageDigest.getInstance(this.msg_Digest_Name, "IBMJCE4758") : MessageDigest.getInstance(this.msg_Digest_Name, "IBMJCECCA");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "HmacSHA", e);
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "HmacSHA", e);
            }
            throw new RuntimeException(e.getMessage());
        }
        this.k_ipad = new byte[this.SHA_Block_Length];
        this.k_opad = new byte[this.SHA_Block_Length];
        IBMJCECCA.verifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "HmacSHA");
        }
    }

    @Override
    protected int engineGetMacLength() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetMacLength");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetMacLength", this.sha.getDigestLength());
        }
        return this.sha.getDigestLength();
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.bufferIndex = 0;
        this.bufferLeft = this.SHA_Block_Length;
        Arrays.fill(this.chaining_vector, (byte)0);
        Arrays.fill(this.buffer, (byte)0);
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", key, params);
        }
        if (key == null) {
            InvalidKeyException ike = new InvalidKeyException("Key is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
            }
            throw ike;
        }
        if (!(key instanceof SecretKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key is not an instance of SecretKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
            }
            throw ike;
        }
        if (key instanceof HMACKey) {
            this.ccaKeyLabel = ((HMACKey)key).getLabelString();
        } else {
            int i;
            if (!key.getFormat().equalsIgnoreCase("RAW")) {
                InvalidKeyException ike = new InvalidKeyException("Any key that is not a com.ibm.crypto.hdwrCCA.provider.HMACKey must be a RAW format SecretKey");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                    debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
                }
                throw ike;
            }
            byte[] secret = key.getEncoded();
            if (secret == null || secret.length == 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Missing key data");
                }
                throw new InvalidKeyException("Missing key data");
            }
            if (secret.length > this.SHA_Block_Length) {
                secret = this.sha.digest(secret);
            }
            byte[] k = null;
            if (secret.length == this.SHA_Block_Length) {
                k = secret;
            } else {
                k = new byte[this.SHA_Block_Length];
                System.arraycopy(secret, 0, k, 0, secret.length);
                for (i = secret.length; i < this.SHA_Block_Length; ++i) {
                    k[i] = 0;
                }
            }
            for (i = 0; i < this.SHA_Block_Length; ++i) {
                this.k_ipad[i] = (byte)(k[i] ^ 0x36);
                this.k_opad[i] = (byte)(k[i] ^ 0x5C);
            }
            for (i = 0; i < secret.length; ++i) {
                secret[i] = 0;
            }
            if (k != secret) {
                for (i = 0; i < k.length; ++i) {
                    k[i] = 0;
                }
            }
            secret = null;
            k = null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        byte[] byteAsByteArray = new byte[]{input};
        this.engineUpdate(byteAsByteArray, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (this.ccaKeyLabel != null) {
            this.bufferLeft = this.SHA_Block_Length - this.bufferIndex;
            for (int inputUsed = 0; inputUsed < len; inputUsed += this.bufferLeft) {
                if (this.bufferLeft <= len - inputUsed) {
                    System.arraycopy(input, inputUsed + offset, this.buffer, this.bufferIndex, this.bufferLeft);
                    if (this.currentSegment == Segment.FIRST) {
                        this.computeHMACUsingCCA(this.buffer, this.buffer.length, Segment.FIRST);
                        this.currentSegment = Segment.MIDDLE;
                    } else {
                        this.computeHMACUsingCCA(this.buffer, this.buffer.length, this.currentSegment);
                    }
                    this.bufferIndex = 0;
                    this.bufferLeft = this.SHA_Block_Length;
                    continue;
                }
                System.arraycopy(input, inputUsed + offset, this.buffer, this.bufferIndex, len - inputUsed);
                this.bufferIndex += len - inputUsed;
                this.bufferLeft = this.SHA_Block_Length - this.bufferIndex;
                inputUsed = len;
                break;
            }
        } else {
            if (this.currentSegment == Segment.FIRST) {
                this.sha.update(this.k_ipad);
                this.currentSegment = Segment.MIDDLE;
            }
            this.sha.update(input, offset, len);
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineDoFinal");
        }
        byte[] result = null;
        if (this.ccaKeyLabel != null) {
            result = this.currentSegment == Segment.FIRST ? this.computeHMACUsingCCA(this.buffer, this.bufferIndex, Segment.ONLY) : this.computeHMACUsingCCA(this.buffer, this.bufferIndex, Segment.LAST);
        } else {
            if (this.currentSegment == Segment.FIRST) {
                this.sha.update(this.k_ipad);
            } else {
                this.currentSegment = Segment.FIRST;
            }
            byte[] innerDigest = this.sha.digest();
            this.sha.update(this.k_opad);
            result = this.sha.digest(innerDigest);
        }
        this.engineReset();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", result);
        }
        return result;
    }

    @Override
    protected void engineReset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineReset");
        }
        if (this.ccaKeyLabel != null) {
            this.currentSegment = Segment.FIRST;
        } else {
            this.sha.reset();
            this.currentSegment = Segment.FIRST;
        }
        this.bufferIndex = 0;
        this.bufferLeft = this.SHA_Block_Length;
        Arrays.fill(this.chaining_vector, (byte)0);
        Arrays.fill(this.buffer, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineReset");
        }
    }

    @Override
    public Object clone() {
        HmacSHA that = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "clone");
        }
        try {
            that = (HmacSHA)super.clone();
            that.sha = (MessageDigest)this.sha.clone();
            that.k_ipad = (byte[])this.k_ipad.clone();
            that.k_opad = (byte[])this.k_opad.clone();
            that.currentSegment = this.currentSegment;
            that.ccaKeyLabel = this.ccaKeyLabel;
            that.buffer = (byte[])this.buffer.clone();
            that.mac = this.mac;
            that.bufferIndex = this.bufferIndex;
            that.bufferLeft = this.bufferLeft;
            that.chaining_vector = (byte[])this.chaining_vector.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "clone", e);
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "clone", that);
            }
            return that;
        }
    }

    protected byte[] computeHMACUsingCCA(byte[] text, int length, Segment segment) {
        String parmsReport;
        String macString;
        String chainingVectorString;
        String textString;
        String keyIdentifierString;
        String ruleArrayString;
        String exitDataString;
        hikmNativeInteger return_code = new hikmNativeInteger(0);
        hikmNativeInteger reason_code = new hikmNativeInteger(0);
        hikmNativeInteger exit_data_length = new hikmNativeInteger(0);
        byte[] exit_data = new byte[]{};
        hikmNativeInteger rule_array_count = new hikmNativeInteger(3);
        byte[] rule_array = null;
        hikmNativeInteger key_identifier_length = new hikmNativeInteger(this.ccaKeyLabel.length());
        byte[] key_identifier = PlatformUtilities.getBytesPlatform(this.ccaKeyLabel);
        hikmNativeInteger text_length = new hikmNativeInteger(length);
        hikmNativeInteger chaining_vector_length = new hikmNativeInteger(128);
        hikmNativeInteger mac_length = new hikmNativeInteger(64);
        byte[] mac = new byte[64];
        String rule = "HMAC    ";
        if (this.msg_Digest_Name.equalsIgnoreCase("SHA1")) {
            rule = rule + "SHA-1   ";
        } else if (this.msg_Digest_Name.equalsIgnoreCase("SHA224")) {
            rule = rule + "SHA-224 ";
        } else if (this.msg_Digest_Name.equalsIgnoreCase("SHA2")) {
            rule = rule + "SHA-256 ";
        } else if (this.msg_Digest_Name.equalsIgnoreCase("SHA3")) {
            rule = rule + "SHA-384 ";
        } else if (this.msg_Digest_Name.equalsIgnoreCase("SHA5")) {
            rule = rule + "SHA-512 ";
        } else {
            throw new RuntimeException("Invalid digest name used.");
        }
        if (segment == Segment.FIRST) {
            rule = rule + "FIRST   ";
        } else if (segment == Segment.MIDDLE) {
            rule = rule + "MIDDLE  ";
        } else if (segment == Segment.LAST) {
            rule = rule + "LAST    ";
        } else if (segment == Segment.ONLY) {
            rule = rule + "ONLY    ";
        } else {
            throw new RuntimeException("Invalid segment used.");
        }
        rule_array = PlatformUtilities.getBytesPlatform(rule);
        if (segment == Segment.FIRST) {
            Arrays.fill(this.chaining_vector, (byte)0);
        }
        if (null != debug) {
            exitDataString = null;
            ruleArrayString = null;
            keyIdentifierString = null;
            textString = null;
            chainingVectorString = null;
            macString = null;
            if (null != exit_data) {
                exitDataString = encoder.encodeBuffer(exit_data);
            }
            if (null != rule_array) {
                ruleArrayString = encoder.encodeBuffer(rule_array);
            }
            if (null != key_identifier) {
                keyIdentifierString = encoder.encodeBuffer(key_identifier);
            }
            if (null != text) {
                textString = encoder.encodeBuffer(text);
            }
            if (null != this.chaining_vector) {
                chainingVectorString = encoder.encodeBuffer(this.chaining_vector);
            }
            if (null != mac) {
                macString = encoder.encodeBuffer(mac);
            }
            parmsReport = "\nHMACSHA: CSNBHMG INPUT PARAMETERS \n    return_code: " + return_code.getValue() + "\n    reason_code: " + reason_code.getValue() + "\n    exit_data_length: " + exit_data_length.getValue() + "\n    exit_data:\n" + exitDataString + "\n    rule_array_count: " + rule_array_count.getValue() + "\n    rule_array:\n" + ruleArrayString + "\n    key_identifier_length: " + key_identifier_length.getValue() + "\n    key_identifier:\n" + keyIdentifierString + "\n    text_length: " + text_length.getValue() + "\n    text:\n" + textString + "\n    chaining_vector_length: " + chaining_vector_length.getValue() + "\n    chaining_vector:\n" + chainingVectorString + "\n    mac_length: " + mac_length.getValue() + "\n    mac:\n" + macString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "computeHMACUsingCCA", parmsReport);
        }
        this.hikm.CSNBHMGJ(return_code, reason_code, exit_data_length, exit_data, rule_array_count, rule_array, key_identifier_length, key_identifier, text_length, text, chaining_vector_length, this.chaining_vector, mac_length, mac);
        if (null != debug) {
            exitDataString = null;
            ruleArrayString = null;
            keyIdentifierString = null;
            textString = null;
            chainingVectorString = null;
            macString = null;
            if (null != exit_data) {
                exitDataString = encoder.encodeBuffer(exit_data);
            }
            if (null != rule_array) {
                ruleArrayString = encoder.encodeBuffer(rule_array);
            }
            if (null != key_identifier) {
                keyIdentifierString = encoder.encodeBuffer(key_identifier);
            }
            if (null != text) {
                textString = encoder.encodeBuffer(text);
            }
            if (null != this.chaining_vector) {
                chainingVectorString = encoder.encodeBuffer(this.chaining_vector);
            }
            if (null != mac) {
                macString = encoder.encodeBuffer(mac);
            }
            parmsReport = "\nHMACSHA: CSNBHMG OUTPUT PARAMETERS \n    return_code: " + return_code.getValue() + "\n    reason_code: " + reason_code.getValue() + "\n    exit_data_length: " + exit_data_length.getValue() + "\n    exit_data:\n" + exitDataString + "\n    rule_array_count: " + rule_array_count.getValue() + "\n    rule_array:\n" + ruleArrayString + "\n    key_identifier_length: " + key_identifier_length.getValue() + "\n    key_identifier:\n" + keyIdentifierString + "\n    text_length: " + text_length.getValue() + "\n    text:\n" + textString + "\n    chaining_vector_length: " + chaining_vector_length.getValue() + "\n    chaining_vector:\n" + chainingVectorString + "\n    mac_length: " + mac_length.getValue() + "\n    mac:\n" + macString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "computeHMACUsingCCA", parmsReport);
        }
        if (return_code.getValue() != 0) {
            String exMsg = "Hardware error from call CSNBHMG returnCode=" + return_code.getValue() + " reasonCode=" + reason_code.getValue();
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "computeHMACUsingCCA", exMsg);
                debug.exit(Debug.TYPE_FINE, className, "computeHMACUsingCCA");
            }
            throw new JCECCARuntimeException(1, "CSNBHMG", exMsg, return_code.getValue(), reason_code.getValue());
        }
        if (segment == Segment.LAST || segment == Segment.ONLY) {
            byte[] return_value = new byte[mac_length.getValue()];
            System.arraycopy(mac, 0, return_value, 0, mac_length.getValue());
            if (null != debug) {
                String returnString = encoder.encodeBuffer(return_value);
                debug.text(Debug.TYPE_FINEST, className, "computeHMACUsingCCA", "Return Mac:\n" + returnString);
                debug.exit(Debug.TYPE_FINER, className, "computeHMACUsingCCA");
            }
            return return_value;
        }
        if (null != debug) {
            debug.text(Debug.TYPE_FINEST, className, "computeHMACUsingCCA", "Return null");
            debug.exit(Debug.TYPE_FINER, className, "computeHMACUsingCCA");
        }
        return null;
    }

    private static enum Segment {
        FIRST,
        MIDDLE,
        LAST,
        ONLY;

    }
}

