/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AbstractFullHardwareSHA;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;

final class HardwareProfile {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.HardwareProfile";
    private static boolean IsPCICAPresent = false;
    private static boolean IsPCIXCCPresent = false;
    private static boolean IsPCICCPresent = false;
    private static boolean IsCryptoAssistPresent = false;
    private static boolean IsDESCryptoAssistPresent = false;
    private static boolean Is3DESCryptoAssistPresent = false;
    private static boolean IsICSFPresent = false;
    private static boolean IsSHACryptoAssistPresent = false;
    private static boolean Is4096RNGLSupported = false;
    private static String ICSFlevel = "";
    private static boolean IsSHA256CryptoAssistPresent = false;
    private static boolean IsSHA512CryptoAssistPresent = false;
    private static boolean IsSHA1jitOptimzationAvailable = false;
    private static boolean IsSHA224jitOptimzationAvailable = false;
    private static boolean IsSHA256jitOptimzationAvailable = false;
    private static boolean IsSHA384jitOptimzationAvailable = false;
    private static boolean IsSHA512jitOptimzationAvailable = false;
    private static boolean IsAES128CryptoAssistPresent = false;
    private static boolean IsAES192CryptoAssistPresent = false;
    private static boolean IsAES256CryptoAssistPresent = false;
    private static boolean IsHCR77A1OrLaterPresent = false;
    private static boolean IsHCR7790OrLaterPresent = false;
    private static boolean IsHCR7780OrLaterPresent = false;
    private static boolean IsHCR7770OrLaterPresent = false;
    private static boolean IsHCR7751OrLaterPresent = false;
    private static boolean Is64Bit = false;
    private static boolean IsEnhancedWrappingPresent = false;
    private static boolean IsOfbCfbGcmSupported = false;
    private static boolean IsInternalECCKeysSupported = false;
    private static boolean IsECCDiffieHellmanSupported = false;
    private static boolean IsSpectreHardend = false;
    private static HIKM hikm = new HIKM();
    private static HexDumpEncoder encoder = null;

    public HardwareProfile() {
        String hwDetectMessages;
        if (PlatformUtilities.isLinux()) {
            IsPCICAPresent = true;
            IsPCIXCCPresent = true;
            IsPCICCPresent = true;
            IsCryptoAssistPresent = true;
            IsDESCryptoAssistPresent = true;
            Is3DESCryptoAssistPresent = true;
            IsICSFPresent = true;
            IsSHACryptoAssistPresent = true;
            Is4096RNGLSupported = true;
            ICSFlevel = "";
            IsSHA256CryptoAssistPresent = true;
            IsSHA512CryptoAssistPresent = true;
            IsAES128CryptoAssistPresent = true;
            IsAES192CryptoAssistPresent = true;
            IsAES256CryptoAssistPresent = true;
            IsHCR77A1OrLaterPresent = true;
            IsHCR7790OrLaterPresent = true;
            IsHCR7780OrLaterPresent = true;
            IsHCR7770OrLaterPresent = true;
            IsHCR7751OrLaterPresent = true;
            Is64Bit = true;
            IsEnhancedWrappingPresent = true;
            IsOfbCfbGcmSupported = true;
            IsInternalECCKeysSupported = true;
            IsECCDiffieHellmanSupported = true;
            hikm.CheckSpectreHardend(this);
        }
        byte[] fmidBytes = new byte[8];
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "HardwareProfile");
            encoder = new HexDumpEncoder();
        }
        if (PlatformUtilities.isZOS()) {
            hikm.SetupCardInformation(this, fmidBytes);
        }
        if (PlatformUtilities.isZOS()) {
            HardwareProfile.getWRAPMTHD();
        }
        if (PlatformUtilities.isZOS()) {
            HardwareProfile.getICSFSTAT();
        }
        if (PlatformUtilities.isZOS()) {
            HardwareProfile.getICSFST2();
        }
        if (PlatformUtilities.isZOS()) {
            ICSFlevel = new String(fmidBytes, PlatformUtilities.CHARSET_IBM_1047);
            IsHCR7751OrLaterPresent = HardwareProfile.isICSFVersionOrLaterPresent("7751");
            IsHCR7770OrLaterPresent = HardwareProfile.isICSFVersionOrLaterPresent("7770");
            IsHCR7780OrLaterPresent = HardwareProfile.isICSFVersionOrLaterPresent("7780");
            IsHCR7790OrLaterPresent = HardwareProfile.isICSFVersionOrLaterPresent("7790");
            IsHCR77A1OrLaterPresent = HardwareProfile.isICSFVersionOrLaterPresent("77A1");
        }
        IsSHA1jitOptimzationAvailable = AbstractFullHardwareSHA.isSupportedByHardware("SHA-1");
        IsSHA224jitOptimzationAvailable = AbstractFullHardwareSHA.isSupportedByHardware("SHA-256");
        IsSHA256jitOptimzationAvailable = AbstractFullHardwareSHA.isSupportedByHardware("SHA-256");
        IsSHA384jitOptimzationAvailable = AbstractFullHardwareSHA.isSupportedByHardware("SHA-512");
        IsSHA512jitOptimzationAvailable = AbstractFullHardwareSHA.isSupportedByHardware("SHA-512");
        if (debug != null) {
            String profileString = new String("\n  Crypto hardware status at load time\n    ICSF On? " + HardwareProfile.getIsICSFPresent() + "\n    ICSF Level? " + HardwareProfile.getICSFlevel() + "\n    Crypto Assist On? " + HardwareProfile.getIsCryptoAssistPresent() + "\n    Crypto Assist with DES avail? " + HardwareProfile.getIsDESCryptoAssistPresent() + "\n    Crypto Assist with 3DES avail? " + HardwareProfile.getIs3DESCryptoAssistPresent() + "\n    Crypto Assist with SHA avail? " + HardwareProfile.getIsSHACryptoAssistPresent() + "\n    4096 RSA and RNG long avail? " + HardwareProfile.getIs4096RNGLSupported() + "\n    PCICA card present? " + HardwareProfile.getIsPCICAPresent() + "\n    PCICC card present? " + HardwareProfile.getIsPCICCPresent() + "\n    PCIXCC card present? " + HardwareProfile.getIsPCIXCCPresent() + "\n    Crypto Assist with SHA256 avail? " + HardwareProfile.getIsSHA256CryptoAssistPresent() + "\n    Crypto Assist with SHA512 avail? " + HardwareProfile.getIsSHA512CryptoAssistPresent() + "\n    IsSHA1jitOptimzationAvailable?  " + HardwareProfile.getIsSHA1jitOptimzationAvailable() + "\n    IsSHA224jitOptimzationAvailable?  " + HardwareProfile.getIsSHA224jitOptimzationAvailable() + "\n    IsSHA256jitOptimzationAvailable?  " + HardwareProfile.getIsSHA256jitOptimzationAvailable() + "\n    IsSHA384jitOptimzationAvailable?  " + HardwareProfile.getIsSHA384jitOptimzationAvailable() + "\n    IsSHA512jitOptimzationAvailable?  " + HardwareProfile.getIsSHA512jitOptimzationAvailable() + "\n    Crypto Assist with AES128 avail? " + HardwareProfile.getIsAES128CryptoAssistPresent() + "\n    Crypto Assist with AES192 avail? " + HardwareProfile.getIsAES192CryptoAssistPresent() + "\n    Crypto Assist with AES256 avail? " + HardwareProfile.getIsAES256CryptoAssistPresent() + "\n    ICSF fmid HCR77A1 or later?  " + HardwareProfile.getIsHCR77A1OrLaterPresent() + "\n    ICSF fmid HCR7790 or later?  " + HardwareProfile.getIsHCR7790OrLaterPresent() + "\n    ICSF fmid HCR7780 or later?  " + HardwareProfile.getIsHCR7780OrLaterPresent() + "\n    ICSF fmid HCR7770 or later?  " + HardwareProfile.getIsHCR7770OrLaterPresent() + "\n    ICSF fmid HCR7751 or later?  " + HardwareProfile.getIsHCR7751OrLaterPresent() + "\n    Is 64 bit? " + HardwareProfile.getIs64Bit() + "\n    Enhanced Token Wrapping Present? " + HardwareProfile.getIsEnhancedWrappingPresent() + "\n    OFB, CFB and GCM mode supported? " + HardwareProfile.getIsOfbCfbGcmSupported() + "\n    Internal ECC keys supported? " + HardwareProfile.isInternalECCKeysSupported() + "\n    ECC Diffie-Hellman avail? " + HardwareProfile.isECCDiffieHellmanSupported() + "\n    Is Spectre Hardend? " + HardwareProfile.getIsSpectreHardend());
            debug.text(Debug.TYPE_FINE, className, "HardwareProfile", profileString);
        }
        if ((hwDetectMessages = System.getProperty("HJV_JCECCA_HW_DETECT_MESSAGE", "OFF")).compareToIgnoreCase("On") == 0 || hwDetectMessages.compareToIgnoreCase("True") == 0) {
            System.out.println("IBMJCECCA: Crypto hardware status at load time");
            System.out.println("IBMJCECCA: ICSF On? " + HardwareProfile.getIsICSFPresent());
            System.out.println("IBMJCECCA: ICSF Level? " + HardwareProfile.getICSFlevel());
            System.out.println("IBMJCECCA: Crypto Assist On? " + HardwareProfile.getIsCryptoAssistPresent());
            System.out.println("IBMJCECCA: Crypto Assist with DES avail? " + HardwareProfile.getIsDESCryptoAssistPresent());
            System.out.println("IBMJCECCA: Crypto Assist with 3DES avail? " + HardwareProfile.getIs3DESCryptoAssistPresent());
            System.out.println("IBMJCECCA: Crypto Assist with SHA avail? " + HardwareProfile.getIsSHACryptoAssistPresent());
            System.out.println("IBMJCECCA: 4096 RSA and RNG long avail? " + HardwareProfile.getIs4096RNGLSupported());
            System.out.println("IBMJCECCA: PCICA card present? " + HardwareProfile.getIsPCICAPresent());
            System.out.println("IBMJCECCA: PCICC card present? " + HardwareProfile.getIsPCICCPresent());
            System.out.println("IBMJCECCA: PCIXCC card present? " + HardwareProfile.getIsPCIXCCPresent());
            System.out.println("IBMJCECCA: Crypto Assist with SHA256 avail? " + HardwareProfile.getIsSHA256CryptoAssistPresent());
            System.out.println("IBMJCECCA: Crypto Assist with SHA512 avail? " + HardwareProfile.getIsSHA512CryptoAssistPresent());
            System.out.println("IBMJCECCA: JIT optimization for SHA1 avail? " + HardwareProfile.getIsSHA1jitOptimzationAvailable());
            System.out.println("IBMJCECCA: JIT optimization for SHA224 avail? " + HardwareProfile.getIsSHA224jitOptimzationAvailable());
            System.out.println("IBMJCECCA: JIT optimization for SHA256 avail? " + HardwareProfile.getIsSHA256jitOptimzationAvailable());
            System.out.println("IBMJCECCA: JIT optimization for SHA384 avail? " + HardwareProfile.getIsSHA384jitOptimzationAvailable());
            System.out.println("IBMJCECCA: JIT optimization for SHA512 avail? " + HardwareProfile.getIsSHA512jitOptimzationAvailable());
            System.out.println("IBMJCECCA: Crypto Assist with AES128 avail? " + HardwareProfile.getIsAES128CryptoAssistPresent());
            System.out.println("IBMJCECCA: Crypto Assist with AES192 avail? " + HardwareProfile.getIsAES192CryptoAssistPresent());
            System.out.println("IBMJCECCA: Crypto Assist with AES256 avail? " + HardwareProfile.getIsAES256CryptoAssistPresent());
            System.out.println("IBMJCECCA: ICSF fmid HCR77A1 or later? " + HardwareProfile.getIsHCR77A1OrLaterPresent());
            System.out.println("IBMJCECCA: ICSF fmid HCR7790 or later? " + HardwareProfile.getIsHCR7790OrLaterPresent());
            System.out.println("IBMJCECCA: ICSF fmid HCR7780 or later? " + HardwareProfile.getIsHCR7780OrLaterPresent());
            System.out.println("IBMJCECCA: ICSF fmid HCR7770 or later? " + HardwareProfile.getIsHCR7770OrLaterPresent());
            System.out.println("IBMJCECCA: ICSF fmid HCR7751 or later? " + HardwareProfile.getIsHCR7751OrLaterPresent());
            System.out.println("IBMJCECCA: Is 64 bit? " + HardwareProfile.getIs64Bit());
            System.out.println("IBMJCECCA: Enhanced Token Wrapping Present? " + HardwareProfile.getIsEnhancedWrappingPresent());
            System.out.println("IBMJCECCA: OFB, CFB and GCM mode supported? " + HardwareProfile.getIsOfbCfbGcmSupported());
            System.out.println("IBMJCECCA: Are internal ECC keys supported? " + HardwareProfile.isInternalECCKeysSupported());
            System.out.println("IBMJCECCA: Is ECC Diffie-Hellman avail? " + HardwareProfile.isECCDiffieHellmanSupported());
            System.out.println("IBMJCECCA: Is Spectre Hardend?" + HardwareProfile.getIsSpectreHardend());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "HardwareProfile");
        }
    }

    public static boolean getIsPCICAPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsPCICAPresent", IsPCICAPresent);
        }
        return IsPCICAPresent;
    }

    public static boolean getIsPCIXCCPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsPCIXCCPresent", IsPCIXCCPresent);
        }
        return IsPCIXCCPresent;
    }

    public static boolean getIsPCICCPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsPCICCPresent", IsPCICCPresent);
        }
        return IsPCICCPresent;
    }

    public static boolean getIsCryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsCryptoAssistPresent", IsCryptoAssistPresent);
        }
        return IsCryptoAssistPresent;
    }

    public static boolean getIsICSFPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsICSFPresent", IsICSFPresent);
        }
        return IsICSFPresent;
    }

    public static boolean getIsDESCryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsDESCryptoAssistPresent", IsDESCryptoAssistPresent);
        }
        return IsDESCryptoAssistPresent;
    }

    public static boolean getIs3DESCryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIs3DESCryptoAssistPresent", Is3DESCryptoAssistPresent);
        }
        return Is3DESCryptoAssistPresent;
    }

    public static boolean getIsSHACryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSHACryptoAssistPresent", IsSHACryptoAssistPresent);
        }
        return IsSHACryptoAssistPresent;
    }

    public static boolean getIs4096RNGLSupported() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIs4096RNGLSupported", Is4096RNGLSupported);
        }
        return Is4096RNGLSupported;
    }

    public static String getICSFlevel() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getICSFlevel", ICSFlevel);
        }
        return ICSFlevel;
    }

    public static boolean getIsSHA256CryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSHA256CryptoAssistPresent", IsSHA256CryptoAssistPresent);
        }
        return IsSHA256CryptoAssistPresent;
    }

    public static boolean getIsSHA512CryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSHA512CryptoAssistPresent", IsSHA512CryptoAssistPresent);
        }
        return IsSHA512CryptoAssistPresent;
    }

    public static boolean getIsSHA1jitOptimzationAvailable() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSHA1jitOptimzationAvailable", IsSHA1jitOptimzationAvailable);
        }
        return IsSHA1jitOptimzationAvailable;
    }

    public static boolean getIsSHA224jitOptimzationAvailable() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSHA224jitOptimzationAvailable", IsSHA224jitOptimzationAvailable);
        }
        return IsSHA224jitOptimzationAvailable;
    }

    public static boolean getIsSHA256jitOptimzationAvailable() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSHA256jitOptimzationAvailable", IsSHA256jitOptimzationAvailable);
        }
        return IsSHA256jitOptimzationAvailable;
    }

    public static boolean getIsSHA384jitOptimzationAvailable() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSHA384jitOptimzationAvailable", IsSHA384jitOptimzationAvailable);
        }
        return IsSHA384jitOptimzationAvailable;
    }

    public static boolean getIsSHA512jitOptimzationAvailable() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSHA512jitOptimzationAvailable", IsSHA512jitOptimzationAvailable);
        }
        return IsSHA512jitOptimzationAvailable;
    }

    public static boolean getIsAES128CryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsAES128CryptoAssistPresent", IsAES128CryptoAssistPresent);
        }
        return IsAES128CryptoAssistPresent;
    }

    public static boolean getIsAES192CryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsAES192CryptoAssistPresent", IsAES192CryptoAssistPresent);
        }
        return IsAES192CryptoAssistPresent;
    }

    public static boolean getIsAES256CryptoAssistPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsAES256CryptoAssistPresent", IsAES256CryptoAssistPresent);
        }
        return IsAES256CryptoAssistPresent;
    }

    public static boolean getIsHCR7751OrLaterPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsHCR7751OrLaterPresent", IsHCR7751OrLaterPresent);
        }
        return IsHCR7751OrLaterPresent;
    }

    public static boolean getIsHCR7770OrLaterPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsHCR7770OrLaterPresent", IsHCR7770OrLaterPresent);
        }
        return IsHCR7770OrLaterPresent;
    }

    public static boolean getIsHCR7780OrLaterPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsHCR7780OrLaterPresent", IsHCR7780OrLaterPresent);
        }
        return IsHCR7780OrLaterPresent;
    }

    public static boolean getIsHCR7790OrLaterPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsHCR7790OrLaterPresent", IsHCR7790OrLaterPresent);
        }
        return IsHCR7790OrLaterPresent;
    }

    public static boolean getIsHCR77A1OrLaterPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsHCR77A1OrLaterPresent", IsHCR77A1OrLaterPresent);
        }
        return IsHCR77A1OrLaterPresent;
    }

    private static boolean getIsSpectreHardend() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsSpectreHardend", IsSpectreHardend);
        }
        return IsSpectreHardend;
    }

    private static boolean isICSFVersionOrLaterPresent(String compareICSFLevelString) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "isICSFVersionOrLaterPresent", compareICSFLevelString);
        }
        boolean result = false;
        String currentICSFLevelString = HardwareProfile.getICSFlevel().substring(3, 7);
        int currentICSFLevel = 0;
        int compareICSFLevel = 0;
        try {
            if (null != debug) {
                debug.text(Debug.TYPE_PUBLIC, className, "isICSFVersionOrLaterPresent", "Parsing String into an Integer for current level: " + currentICSFLevelString);
                debug.text(Debug.TYPE_PUBLIC, className, "isICSFVersionOrLaterPresent", "Parsing String into an Integer for comparision level: " + compareICSFLevelString);
            }
            currentICSFLevel = Integer.parseInt(currentICSFLevelString, 16);
            compareICSFLevel = Integer.parseInt(compareICSFLevelString, 16);
            if (null != debug) {
                debug.text(Debug.TYPE_PUBLIC, className, "isICSFVersionOrLaterPresent", "Integer successfully parsed for current level: " + currentICSFLevel);
                debug.text(Debug.TYPE_PUBLIC, className, "isICSFVersionOrLaterPresent", "Integer successfully parsed for comparision level: " + compareICSFLevel);
            }
        }
        catch (NumberFormatException e) {
            if (null != debug) {
                debug.text(Debug.TYPE_PUBLIC, className, "isICSFVersionOrLaterPresent", "A NumberFormatException occured. Ignore this and return false.");
                debug.exit(40960L, (Object)className, "isICSFVersionOrLaterPresent", result);
            }
            result = false;
            return result;
        }
        result = currentICSFLevel >= compareICSFLevel;
        if (debug != null) {
            debug.exit(40960L, (Object)className, "isICSFVersionOrLaterPresent", result);
        }
        return result;
    }

    public static boolean getIs64Bit() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIs64Bit", Is64Bit);
        }
        return Is64Bit;
    }

    public static boolean getIsOfbCfbGcmSupported() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsOfbCfbGcmSupported", IsOfbCfbGcmSupported);
        }
        return IsOfbCfbGcmSupported;
    }

    public static boolean getIsEnhancedWrappingPresent() {
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getIsEnhancedWrappingPresent", IsEnhancedWrappingPresent);
        }
        return IsEnhancedWrappingPresent;
    }

    static boolean isInternalECCKeysSupported() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC | 0x8000L, className, "isInternalECCKeysSupported");
            debug.exit(Debug.TYPE_PUBLIC | 0x8000L, (Object)className, "isInternalECCKeysSupported", IsInternalECCKeysSupported);
        }
        return IsInternalECCKeysSupported;
    }

    static boolean isECCDiffieHellmanSupported() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC | 0x8000L, className, "isECCDiffieHellmanSupported");
            debug.exit(Debug.TYPE_PUBLIC | 0x8000L, (Object)className, "isECCDiffieHellmanSupported", IsECCDiffieHellmanSupported);
        }
        return IsECCDiffieHellmanSupported;
    }

    private static void getWRAPMTHD() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getWRAPMTHD");
        }
        byte[] returnedData = new byte[16];
        for (int x = 0; x < returnedData.length; ++x) {
            returnedData[x] = 0;
        }
        try {
            HardwareProfile.callCSFIQF("WRAPMTHD", returnedData, 1);
        }
        catch (JCECCARuntimeException e) {
            IsEnhancedWrappingPresent = false;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getWRAPMTHD", "\nEnhanced wrapping is NOT available.");
                debug.exit(40960L, className, "getWRAPMTHD");
            }
            return;
        }
        IsEnhancedWrappingPresent = true;
        if (debug != null) {
            String firstElement = null;
            String secondElement = null;
            firstElement = new String(returnedData, 0, 8, PlatformUtilities.CHARSET_IBM_1047);
            secondElement = new String(returnedData, 8, 8, PlatformUtilities.CHARSET_IBM_1047);
            firstElement = firstElement.equalsIgnoreCase("0       ") ? firstElement + "- Keys will be wrapped with the original method." : (firstElement.equalsIgnoreCase("1       ") ? firstElement + "- Keys will be wrapped with the enhanced X9.24 method." : firstElement + "- Unknown.");
            secondElement = secondElement.equalsIgnoreCase("0       ") ? secondElement + "- Keys will be wrapped with the original method." : (secondElement.equalsIgnoreCase("1       ") ? secondElement + "- Keys will be wrapped with the enhanced X9.24 method." : secondElement + "- Unknown.");
            debug.text(Debug.TYPE_PUBLIC, className, "getWRAPMTHD", "\nEnhanced wrapping is available.\nElement number 1. Internal Token Default Wrapping Mode: " + firstElement + "\nElement number 2. External Token Default Wrapping Mode: " + secondElement + "\n");
        }
        if (debug != null) {
            debug.exit(40960L, className, "getWRAPMTHD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getICSFSTAT() {
        int CPACFSupport = 0;
        String ruleArrayString = new String("ICSFSTAT");
        byte[] returnDataArray = new byte[96];
        int ruleArrayCount = 1;
        int elementNumber = 4;
        int elementSize = 8;
        if (debug != null) {
            debug.entry(40960L, className, "getICSFSTAT");
        }
        try {
            HardwareProfile.callCSFIQF(ruleArrayString, returnDataArray, ruleArrayCount);
            String queryResult = new String(returnDataArray, (elementNumber - 1) * elementSize, elementSize, PlatformUtilities.CHARSET_IBM_1047);
            queryResult = queryResult.trim();
            Integer queryResultInt = new Integer(queryResult);
            CPACFSupport = queryResultInt;
            if (CPACFSupport >= 8) {
                if (null != debug) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getICSFSTAT", "CPACFSupport: " + CPACFSupport);
                }
                IsOfbCfbGcmSupported = true;
            }
        }
        catch (JCECCARuntimeException ccaEx) {
            IsOfbCfbGcmSupported = false;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, (Object)className, "getICSFSTAT", "getICSFSTAT", " caught exception.  IsOfbCfbGcmSupported is set to false.");
            }
        }
        finally {
            if (debug != null) {
                debug.exit(40960L, className, "getICSFSTAT");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getICSFST2() {
        if (debug != null) {
            debug.entry(40960L, className, "getICSFST2");
        }
        int ruleArrayCount = 1;
        String ruleArrayString = new String("ICSFST2 ");
        byte[] returnDataArray = new byte[96];
        int elementSize = 8;
        int elementNumberECC = 8;
        try {
            HardwareProfile.callCSFIQF(ruleArrayString, returnDataArray, ruleArrayCount);
            String queryResult = new String(returnDataArray, (elementNumberECC - 1) * elementSize, elementSize, PlatformUtilities.CHARSET_IBM_1047).trim();
            int statusFieldValue = new Integer(queryResult);
            if (statusFieldValue == 2) {
                if (null != debug) {
                    debug.text(40960L, className, "getICSFST2", "statusFieldValue: " + statusFieldValue);
                }
                IsInternalECCKeysSupported = true;
            } else if (statusFieldValue == 3) {
                if (null != debug) {
                    debug.text(40960L, className, "getICSFST2", "statusFieldValue: " + statusFieldValue);
                }
                IsInternalECCKeysSupported = true;
                IsECCDiffieHellmanSupported = true;
            }
        }
        catch (JCECCARuntimeException ccaEx) {
            IsInternalECCKeysSupported = false;
            IsECCDiffieHellmanSupported = false;
            if (debug != null) {
                debug.text(40960L, className, "getICSFST2", "Caught exception. IsInternalECCKeysSupported and IsECCDiffieHellmanSupported are set to false");
            }
        }
        catch (NumberFormatException nfe) {
            IsInternalECCKeysSupported = false;
            IsECCDiffieHellmanSupported = false;
            if (debug != null) {
                debug.text(40960L, className, "getICSFST2", "ICSF Status Field 6 is blank. IsInternalECCKeysSupported and IsECCDiffieHellmanSupported are set to false. Continue anyway.");
            }
        }
        finally {
            if (debug != null) {
                debug.exit(40960L, className, "getICSFST2");
            }
        }
    }

    private static void callCSFIQF(String ruleArrayString, byte[] returnedData, int ruleArrayCnt) {
        if (debug != null) {
            Object[] parms = new Object[]{ruleArrayString, returnedData, new Integer(ruleArrayCnt)};
            debug.entry(40960L, (Object)className, "callCSFIQF", parms);
            debug.text(40960L, className, "callCSFIQF", "Input parameters.\nruleArrayString: " + ruleArrayString + "\nreturnedData: " + encoder.encodeBuffer(returnedData) + "\nruleArrayCnt: " + ruleArrayCnt);
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(ruleArrayCnt);
        byte[] ruleArray = new byte[]{};
        hikmNativeInteger returnedDataLength = new hikmNativeInteger(returnedData.length);
        hikmNativeInteger reservedDataLength = new hikmNativeInteger(0);
        byte[] reservedData = new byte[]{};
        ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayString);
        if (null != debug) {
            ruleArrayString = encoder.encodeBuffer(ruleArray);
            String parmsReport = "\nHardwareProfile: CSFIQF INPUT PARAMETERS \n    returnCode         : " + returnCode.getValue() + "\n    reasonCode         : " + reasonCode.getValue() + "\n    ruleArrayCount     : " + ruleArrayCount.getValue() + "\n    ruleArray          :\n" + ruleArrayString + "\n    returnedDataLength : " + returnedDataLength.getValue() + "\n    reservedDataLength : " + reservedDataLength.getValue() + "\n";
            debug.text(40960L, className, "callCSFIQF", parmsReport);
        }
        hikm.CSFIQF(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, returnedDataLength, returnedData, reservedDataLength, reservedData);
        int rc = returnCode.getValue();
        int rsn = reasonCode.getValue();
        if (null != debug) {
            ruleArrayString = encoder.encodeBuffer(ruleArray);
            String returnedDataString = encoder.encodeBuffer(returnedData);
            String parmsReport = "\nHardwareProfile: CSFIQF RETURN PARAMETERS \n    returnCode         : " + rc + "\n    reasonCode         : " + rsn + "\n    returnedDataLength : " + returnedDataLength.getValue() + "\n    returnedData       :\n" + returnedDataString + "\n";
            debug.text(40960L, className, "callCSFIQF", parmsReport);
        }
        if (rc != 0 || rsn != 0) {
            JCECCARuntimeException rte = new JCECCARuntimeException(1, "callCSFIQF", "Hardware error from call CSFIQF. RC = " + rc + " RSN = " + rsn, rc, rsn);
            if (debug != null) {
                debug.text(40960L, className, "callCSFIQF", "Hardware error from call CSFIQF returnCode = " + rc + " reasonCode = " + rsn);
                debug.exit(40960L, className, "callCSFIQF");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(40960L, className, "callCSFIQF");
        }
    }
}

