/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;

class ElectronicCodeBook
extends SymmetricCipher {
    private SymmetricCipher embeddedCipher = null;
    private int blockSize = -1;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ElectronicCodeBook";

    ElectronicCodeBook() {
    }

    void setEmbeddedCipher(SymmetricCipher embeddedCipher) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setEmbeddedCipher", embeddedCipher);
        }
        if (embeddedCipher == null || (this.blockSize = embeddedCipher.getBlockSize()) <= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher", "Incompatible algorithm type and mode");
            }
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = embeddedCipher;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher");
        }
    }

    @Override
    int getBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getBlockSize");
        }
        if (this.embeddedCipher == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBlockSize", -1);
            }
            return -1;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBlockSize", this.embeddedCipher.getBlockSize());
        }
        return this.embeddedCipher.getBlockSize();
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        if (!key.getFormat().equalsIgnoreCase("CKDSLabel") && !key.getFormat().equalsIgnoreCase("ICSFToken")) {
            this.embeddedCipher.init(key);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        this.init(key);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        int endIndex = plainOffset + plainLen;
        if (debug != null) {
            Object[] parms = new Object[]{plain, new Integer(plainOffset), new Integer(plainLen), cipher, new Integer(cipherOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "encrypt", parms);
        }
        while (plainOffset < endIndex) {
            this.embeddedCipher.encrypt(plain, plainOffset, this.blockSize, cipher, cipherOffset);
            plainOffset += this.blockSize;
            cipherOffset += this.blockSize;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
        }
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        int endIndex = cipherOffset + cipherLen;
        if (debug != null) {
            Object[] parms = new Object[]{cipher, new Integer(cipherOffset), new Integer(cipherLen), plain, new Integer(plainOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "decrypt", parms);
        }
        while (cipherOffset < endIndex) {
            this.embeddedCipher.decrypt(cipher, cipherOffset, this.blockSize, plain, plainOffset);
            plainOffset += this.blockSize;
            cipherOffset += this.blockSize;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
        }
    }

    @Override
    byte[] getIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", null);
        }
        return null;
    }
}

