/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

final class ECUtils {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECUtils";

    ECUtils() {
    }

    static ECPoint multiply(BigInteger k, ECPoint P, EllipticCurve curve) {
        if (debug != null) {
            Object[] parms = new Object[]{k, P, curve};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "multiply", parms);
        }
        BigInteger two = new BigInteger("2");
        ECPoint res = P;
        ECPoint previous = P;
        if (k.compareTo(two) != 1) {
            ECPoint result = ECUtils.multiplyIteratively(k, P, curve);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "multiply", result);
            }
            return result;
        }
        String bitString = k.toString(2);
        char[] bits = bitString.toCharArray();
        int kLength = bitString.length();
        for (int i = 0; i < kLength; ++i) {
            if (i == 0) continue;
            previous = bits[i] == '0' ? ECUtils.add(previous, previous, curve) : ECUtils.add(P, ECUtils.add(previous, previous, curve), curve);
        }
        res = previous;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "multiply", res);
        }
        return res;
    }

    private static ECPoint negate(ECPoint point, EllipticCurve curve) {
        if (debug != null) {
            debug.entry(8192L, className, "negate", point, curve);
        }
        ECFieldFp field = (ECFieldFp)curve.getField();
        BigInteger p = field.getP();
        ECPoint result = new ECPoint(point.getAffineX(), point.getAffineY().negate().mod(p));
        if (debug != null) {
            debug.exit(8192L, (Object)className, "negate", result);
        }
        return result;
    }

    private static ECPoint add(ECPoint P, ECPoint Q, EllipticCurve curve) {
        BigInteger t;
        BigInteger s;
        if (debug != null) {
            Object[] parms = new Object[]{P, Q, curve};
            debug.entry(8192L, (Object)className, "add", parms);
        }
        ECFieldFp ecfield = (ECFieldFp)curve.getField();
        BigInteger p = ecfield.getP();
        BigInteger lambda = new BigInteger("0");
        if (Q == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "add", P);
            }
            return P;
        }
        if (P == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "add", Q);
            }
            return Q;
        }
        ECPoint negQ = ECUtils.negate(Q, curve);
        if (P.equals(negQ)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "add", null);
            }
            return null;
        }
        if (!P.equals(Q)) {
            s = Q.getAffineY().subtract(P.getAffineY());
            t = Q.getAffineX().subtract(P.getAffineX()).modInverse(p);
            lambda = s.multiply(t).mod(p);
        } else if (P.equals(Q) && P.getAffineY().compareTo(BigInteger.ZERO) != 0) {
            s = P.getAffineX().modPow(new BigInteger("2"), p).multiply(new BigInteger("3")).add(curve.getA());
            t = P.getAffineY().multiply(new BigInteger("2")).modInverse(p);
            lambda = s.multiply(t).mod(p);
        } else {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "add", null);
            }
            return null;
        }
        BigInteger xR = lambda.modPow(new BigInteger("2"), p).subtract(P.getAffineX()).subtract(Q.getAffineX()).mod(p);
        BigInteger yR = lambda.multiply(P.getAffineX().subtract(xR)).subtract(P.getAffineY()).mod(p);
        ECPoint sum = new ECPoint(xR, yR);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "add", sum);
        }
        return sum;
    }

    private static ECPoint multiplyIteratively(BigInteger k, ECPoint P, EllipticCurve curve) {
        if (debug != null) {
            Object[] parms = new Object[]{k, P, curve};
            debug.entry(8192L, (Object)className, "multiplyIteratively", parms);
        }
        ECPoint t = new ECPoint(P.getAffineX(), P.getAffineY());
        ECPoint s = new ECPoint(P.getAffineX(), P.getAffineY());
        BigInteger k1 = k.subtract(BigInteger.ONE);
        BigInteger i = BigInteger.ZERO;
        while (i.compareTo(k1) < 0) {
            s = ECUtils.add(t, s, curve);
            i = i.add(BigInteger.ONE);
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "multiplyIteratively", s);
        }
        return s;
    }

    static String pointAsString(ECPoint toString) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "pointAsString", toString);
        }
        StringBuffer buf = new StringBuffer("[");
        buf.append(toString.getAffineX().toString());
        buf.append(",");
        buf.append(toString.getAffineY().toString());
        buf.append("]");
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "pointAsString");
        }
        return buf.toString();
    }

    static String curveAsString(EllipticCurve toString) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "curveAsString", toString);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("#EllipticCurve ");
        buf.append(ECUtils.fieldAsString(toString.getField()));
        buf.append("\ta: " + toString.getA());
        buf.append("\tb: " + toString.getB());
        buf.append("#");
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "curveAsString");
        }
        return buf.toString();
    }

    static String fieldAsString(ECField toString) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "fieldAsString", toString);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("{ECField \tsize: " + toString.getFieldSize());
        if (toString instanceof ECFieldFp) {
            ECFieldFp fp = (ECFieldFp)toString;
            buf.append("\tp: " + fp.getP());
        } else if (toString instanceof ECFieldF2m) {
            ECFieldF2m f2m = (ECFieldF2m)toString;
            buf.append("\tm: " + f2m.getM());
            buf.append("\treduction polynomial: " + f2m.getReductionPolynomial());
        }
        buf.append("}");
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "fieldAsString");
        }
        return buf.toString();
    }
}

