/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECNamedCurve;
import com.ibm.crypto.hdwrCCA.provider.ECUtils;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public final class ECParameters
extends AlgorithmParametersSpi {
    private int cofactor;
    private EllipticCurve curve;
    private ECPoint generator;
    private BigInteger order;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECParameters";

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        int cofactor;
        BigInteger order;
        ECPoint ecPoint;
        EllipticCurve curve;
        ECParameterSpec params;
        ObjectIdentifier oid;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetEncoded");
        }
        if ((oid = ECNamedCurve.getOid(params = new ECParameterSpec(curve = this.curve, ecPoint = this.generator, order = this.order, cofactor = this.cofactor))) != null) {
            byte[] encodedOid = ECNamedCurve.getEncoded(oid);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetEncoded", "This set of Elliptic Curve parameters can be encoded as a single OID value");
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodedOid);
            }
            return encodedOid;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetEncoded", "Encoding individual Elliptic Curve parameter pieces");
        }
        ECField ecField = curve.getField();
        DerOutputStream out = new DerOutputStream();
        try {
            out.putInteger(1);
            if (!(ecField instanceof ECFieldFp)) {
                IOException ioe = new IOException("ECFieldF2m encountered. ECFieldF2m is not currently supported");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGetEncoded", ioe);
                    debug.exit(Debug.TYPE_FINE, className, "engineGetEncoded");
                }
                throw ioe;
            }
            DerValue encodedPrimeFieldType = ECParameters.encodePrimeFieldType((ECFieldFp)ecField);
            out.putDerValue(encodedPrimeFieldType);
            DerValue encodedEllipticCurve = ECParameters.encodeEllipticCurve(curve);
            out.putDerValue(encodedEllipticCurve);
            byte[] encodedECPoint = ECParameters.encodePoint(ecPoint, curve);
            out.putOctetString(encodedECPoint);
            out.putInteger(order);
            out.putInteger(cofactor);
            DerValue val = new DerValue(48, out.toByteArray());
            byte[] encodedBytes = val.toByteArray();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodedBytes);
            }
            return encodedBytes;
        }
        catch (IOException e) {
            IOException ioe = new IOException("Exception in engineGetEncoded: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetEncoded", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetEncoded", ioe);
                debug.exit(Debug.TYPE_FINE, className, "engineGetEncoded");
            }
            throw ioe;
        }
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", format);
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetEncoded", "The specified encoding format '" + format + "' is ignored. Using ASN.1 instead");
        }
        byte[] encodedBytes = this.engineGetEncoded();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodedBytes);
        }
        return encodedBytes;
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", paramSpec);
        }
        if (paramSpec == null) {
            NullPointerException npe = new NullPointerException("The transparent specification class must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineGetParameterSpec");
            }
            throw npe;
        }
        if (paramSpec.isAssignableFrom(ECParameterSpec.class)) {
            ECParameterSpec parameterSpec = new ECParameterSpec(this.curve, this.generator, this.order, this.cofactor);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", parameterSpec);
            }
            return (T)((AlgorithmParameterSpec)paramSpec.cast(parameterSpec));
        }
        if (paramSpec.isAssignableFrom(ECGenParameterSpec.class)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, "className", "engineGetParameterSpec", "spec is ECGenParameterSpec - will create.");
            }
            ECParameterSpec parameterSpec = new ECParameterSpec(this.curve, this.generator, this.order, this.cofactor);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, "className", "engineGetParameterSpec", "Generated ECParameterSpec: " + parameterSpec);
            }
            String name = ECNamedCurve.getName(parameterSpec);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, "className", "engineGetParameterSpec", "Curve Name: " + name);
            }
            ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec(name);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)"className", "engineGetParameterSpec", ecGenParameterSpec);
            }
            return (T)((AlgorithmParameterSpec)paramSpec.cast(ecGenParameterSpec));
        }
        InvalidParameterSpecException ipse = new InvalidParameterSpecException("Inappropriate parameter specification");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", ipse);
            debug.exit(Debug.TYPE_FINE, className, "engineGetParameterSpec");
        }
        throw ipse;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", paramSpec);
        }
        if (!(paramSpec instanceof ECParameterSpec) && !(paramSpec instanceof ECGenParameterSpec)) {
            InvalidParameterSpecException ipse = new InvalidParameterSpecException("Inappropriate parameter specification");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "paramSpec is neither an instance of ECParameterSpec nor ECGenParameterSpec");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipse);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipse;
        }
        ECParameterSpec ecParamSpec = null;
        if (paramSpec instanceof ECParameterSpec) {
            ecParamSpec = (ECParameterSpec)paramSpec;
        } else {
            String stdName = ((ECGenParameterSpec)paramSpec).getName();
            ecParamSpec = ECNamedCurve.getECParameterSpec(stdName);
            if (ecParamSpec == null) {
                InvalidParameterSpecException ipse = new InvalidParameterSpecException("Inappropriate parameter specification: " + stdName);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipse);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw ipse;
            }
        }
        this.curve = ecParamSpec.getCurve();
        this.generator = ecParamSpec.getGenerator();
        this.order = ecParamSpec.getOrder();
        this.cofactor = ecParamSpec.getCofactor();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(byte[] params) throws IOException {
        ECParameterSpec ecParameterSpec;
        block14: {
            ecParameterSpec = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", (Object)params);
            }
            if (params == null) {
                NullPointerException npe = new NullPointerException("The supplied encoded parameters must not be null");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", npe);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw npe;
            }
            try {
                DerInputStream in = new DerInputStream(params);
                DerValue derValue = in.getDerValue();
                if (derValue.getTag() != 48) {
                    if (derValue.getTag() == 6) {
                        String oid = derValue.getOID().toString();
                        ecParameterSpec = ECNamedCurve.getECParameterSpec(oid);
                        if (ecParameterSpec == null) {
                            IOException ioe = new IOException("Inappropriate parameter specification");
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ioe);
                                debug.exit(Debug.TYPE_FINE, className, "engineInit");
                            }
                            throw ioe;
                        }
                        break block14;
                    } else {
                        IOException ioe = new IOException("Not a SEQUENCE or an OID");
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ioe);
                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                        }
                        throw ioe;
                    }
                }
                DerInputStream data = derValue.getData();
                data.getInteger();
                DerValue encodedFieldID = data.getDerValue();
                ECFieldFp fieldID = ECParameters.decodePrimeFieldType(encodedFieldID);
                DerValue encodedEllipticCurve = data.getDerValue();
                EllipticCurve curve = ECParameters.decodeEllipticCurve(encodedEllipticCurve, fieldID);
                byte[] encodedECPoint = data.getOctetString();
                ECPoint ecPoint = ECParameters.decodePoint(encodedECPoint, curve);
                BigInteger order = data.getBigInteger();
                int cofactor = 0;
                boolean haveCofactor = false;
                if (data.available() != 0) {
                    haveCofactor = true;
                    cofactor = data.getInteger().intValue();
                }
                ecParameterSpec = haveCofactor ? new ECParameterSpec(curve, ecPoint, order, cofactor) : new ECParameterSpec(curve, ecPoint, order, 0);
            }
            catch (IOException e) {
                IOException ioe = new IOException("Exception in engineInit: Unable to parse the encoded parameters", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ioe);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw ioe;
            }
        }
        this.curve = ecParameterSpec.getCurve();
        this.generator = ecParameterSpec.getGenerator();
        this.order = ecParameterSpec.getOrder();
        this.cofactor = ecParameterSpec.getCofactor();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", params, format);
            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "The specified decoding format '" + format + "' is ignored. Using ASN.1 instead");
        }
        this.engineInit(params);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected String engineToString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineToString");
        }
        String parameters = "\n\tcurve: \n\t\ta: " + this.curve.getA() + "\n\t\tb: " + this.curve.getB() + "\n\t\tsize: " + this.curve.getField().getFieldSize() + "\n\tgenerator: \n\t\t" + ECUtils.pointAsString(this.generator) + "\n\torder: \n\t\t" + this.order.toString() + "\n\tcofactor: " + this.cofactor + "\n";
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineToString", parameters);
        }
        return parameters;
    }

    static byte[] encodePoint(ECPoint point, EllipticCurve curve) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "encodePoint", point, curve);
        }
        if (point == null || curve == null) {
            NullPointerException npe = new NullPointerException("The supplied Elliptic Curve point and curve values must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "encodePoint", npe);
                debug.exit(Debug.TYPE_FINE, className, "encodePoint");
            }
            throw npe;
        }
        int n = curve.getField().getFieldSize() + 7 >> 3;
        byte[] xb = ECParameters.trimZeroes(point.getAffineX().toByteArray());
        byte[] yb = ECParameters.trimZeroes(point.getAffineY().toByteArray());
        if (xb.length > n || yb.length > n) {
            IOException ioe = new IOException("Point coordinates do not match field size");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "encodePoint", ioe);
                debug.exit(Debug.TYPE_FINE, className, "encodePoint");
            }
            throw ioe;
        }
        byte[] b = new byte[1 + (n << 1)];
        b[0] = 4;
        System.arraycopy(xb, 0, b, n - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, b, b.length - yb.length, yb.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "encodePoint", b);
        }
        return b;
    }

    static ECPoint decodePoint(byte[] data, EllipticCurve curve) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "decodePoint", data, curve);
        }
        if (data == null || curve == null) {
            NullPointerException npe = new NullPointerException("The supplied Elliptic Curve encoded data and curve values must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "decodePoint", npe);
                debug.exit(Debug.TYPE_FINE, className, "decodePoint");
            }
            throw npe;
        }
        if (data.length == 0 || data[0] != 4) {
            IOException ioe = new IOException("Only uncompressed point format supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "decodePoint", ioe);
                debug.exit(Debug.TYPE_FINE, className, "decodePoint");
            }
            throw ioe;
        }
        int n = curve.getField().getFieldSize() + 7 >> 3;
        if (data.length != n * 2 + 1) {
            IOException ioe = new IOException("Point does not match field size");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "decodePoint", ioe);
                debug.exit(Debug.TYPE_FINE, className, "decodePoint");
            }
            throw ioe;
        }
        byte[] xb = new byte[n];
        byte[] yb = new byte[n];
        System.arraycopy(data, 1, xb, 0, n);
        System.arraycopy(data, n + 1, yb, 0, n);
        ECPoint point = new ECPoint(new BigInteger(1, xb), new BigInteger(1, yb));
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "decodePoint", point);
        }
        return point;
    }

    private static byte[] trimZeroes(byte[] b) {
        int i = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "trimZeroes", (Object)b);
        }
        if (b == null) {
            if (debug != null) {
                debug.text(8192L, className, "trimZeroes", "The specified byte array is null");
                debug.exit(Debug.TYPE_FINE, (Object)className, "trimZeroes", null);
            }
            return null;
        }
        while (i < b.length - 1 && b[i] == 0) {
            ++i;
        }
        if (i == 0) {
            if (debug != null) {
                debug.text(8192L, className, "trimZeroes", "No leading zeros");
                debug.exit(Debug.TYPE_FINE, (Object)className, "trimZeroes", b);
            }
            return b;
        }
        byte[] t = new byte[b.length - i];
        System.arraycopy(b, i, t, 0, t.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "trimZeroes", t);
        }
        return t;
    }

    private static DerValue encodeEllipticCurve(EllipticCurve curve) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "encodeEllipticCurve", curve);
        }
        if (curve == null) {
            NullPointerException npe = new NullPointerException("Unable to encode Elliptic Curve because the curve is null");
            if (debug != null) {
                debug.exception(8192L, className, "encodeEllipticCurve", npe);
                debug.exit(Debug.TYPE_FINE, className, "encodeEllipticCurve");
            }
            throw npe;
        }
        try {
            byte[] aByteArray = ECParameters.trimZeroes(curve.getA().toByteArray());
            byte[] bByteArray = ECParameters.trimZeroes(curve.getB().toByteArray());
            byte[] seed = curve.getSeed();
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(aByteArray);
            out.putOctetString(bByteArray);
            if (seed != null) {
                out.putBitString(seed);
            }
            DerValue val = new DerValue(48, out.toByteArray());
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "encodeEllipticCurve", val);
            }
            return val;
        }
        catch (IOException e) {
            IOException ioe = new IOException("Error while encoding Elliptic Curve: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(8192L, className, "encodeEllipticCurve", e);
                debug.exception(8192L, className, "encodeEllipticCurve", ioe);
                debug.exit(Debug.TYPE_FINE, className, "encodeEllipticCurve");
            }
            throw ioe;
        }
    }

    private static EllipticCurve decodeEllipticCurve(DerValue encodedEllipticCurve, ECField ecField) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "decodeEllipticCurve", encodedEllipticCurve, ecField);
        }
        if (encodedEllipticCurve == null || ecField == null) {
            NullPointerException npe = new NullPointerException("Unable to decode because either the encoded curve or the finite field is null");
            if (debug != null) {
                debug.exception(8192L, className, "decodeEllipticCurve", npe);
                debug.exit(Debug.TYPE_FINE, className, "decodeEllipticCurve");
            }
            throw npe;
        }
        try {
            if (encodedEllipticCurve.getTag() != 48) {
                IOException ioe = new IOException("Not a SEQUENCE");
                if (debug != null) {
                    debug.exception(8192L, className, "decodeEllipticCurve", ioe);
                    debug.exit(Debug.TYPE_FINE, className, "decodeEllipticCurve");
                }
                throw ioe;
            }
            DerInputStream data = encodedEllipticCurve.getData();
            byte[] aByteArray = data.getOctetString();
            BigInteger a = new BigInteger(1, aByteArray);
            byte[] bByteArray = data.getOctetString();
            BigInteger b = new BigInteger(1, bByteArray);
            byte[] seed = null;
            if (data.available() != 0) {
                seed = data.getBitString();
            }
            EllipticCurve ellipticCurve = null;
            ellipticCurve = seed == null ? new EllipticCurve(ecField, a, b) : new EllipticCurve(ecField, a, b, seed);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "decodeEllipticCurve", ellipticCurve);
            }
            return ellipticCurve;
        }
        catch (IOException e) {
            IOException ioe = new IOException("Error while encoding EllipticCurve: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(8192L, className, "decodeEllipticCurve", e);
                debug.exception(8192L, className, "decodeEllipticCurve", ioe);
                debug.exit(Debug.TYPE_FINE, className, "decodeEllipticCurve");
            }
            throw ioe;
        }
    }

    private static DerValue encodePrimeFieldType(ECFieldFp fieldID) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "encodePrimeFieldType", fieldID);
        }
        if (fieldID == null) {
            NullPointerException npe = new NullPointerException("Unable to encode because the Elliptic Curve prime finite field is null");
            if (debug != null) {
                debug.exception(8192L, className, "encodePrimeFieldType", npe);
                debug.exit(Debug.TYPE_FINE, className, "encodePrimeFieldType");
            }
            throw npe;
        }
        try {
            int[] primeFieldType_data = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier primeFieldTypeOID = new ObjectIdentifier(primeFieldType_data);
            BigInteger p = fieldID.getP();
            DerOutputStream out = new DerOutputStream();
            out.putOID(primeFieldTypeOID);
            out.putInteger(p);
            DerValue val = new DerValue(48, out.toByteArray());
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "encodePrimeFieldType", val);
            }
            return val;
        }
        catch (IOException e) {
            IOException ioe = new IOException("Error encoding PrimeFieldType: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(8192L, className, "encodePrimeFieldType", e);
                debug.exception(8192L, className, "encodePrimeFieldType", ioe);
                debug.exit(Debug.TYPE_FINE, className, "encodePrimeFieldType");
            }
            throw ioe;
        }
    }

    private static ECFieldFp decodePrimeFieldType(DerValue encodedPrimeFieldType) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "decodePrimeFieldType", encodedPrimeFieldType);
        }
        if (encodedPrimeFieldType == null) {
            NullPointerException npe = new NullPointerException("Unable to decode because the encoded Elliptic Curve prime finite field is null");
            if (debug != null) {
                debug.exception(8192L, className, "decodePrimeFieldType", npe);
                debug.exit(Debug.TYPE_FINE, className, "decodePrimeFieldType");
            }
            throw npe;
        }
        int[] primeFieldType_data = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier primeFieldTypeOID = new ObjectIdentifier(primeFieldType_data);
        try {
            if (encodedPrimeFieldType.getTag() != 48) {
                IOException ioe = new IOException("Not a SEQUENCE");
                if (debug != null) {
                    debug.exception(8192L, className, "decodePrimeFieldType", ioe);
                    debug.exit(Debug.TYPE_FINE, className, "decodePrimeFieldType");
                }
                throw ioe;
            }
            DerInputStream data = encodedPrimeFieldType.getData();
            ObjectIdentifier decodedPrimeFieldTypeOID = data.getOID();
            if (!decodedPrimeFieldTypeOID.equals(primeFieldTypeOID)) {
                IOException ioe = new IOException("Incorrect OID encountered during decodePrimeFieldType");
                if (debug != null) {
                    debug.exception(8192L, className, "decodePrimeFieldType", ioe);
                    debug.exit(Debug.TYPE_FINE, className, "decodePrimeFieldType");
                }
                throw ioe;
            }
            BigInteger p = data.getInteger();
            ECFieldFp myFieldID = new ECFieldFp(p);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "decodePrimeFieldType", myFieldID);
            }
            return myFieldID;
        }
        catch (IOException e) {
            IOException ioe = new IOException("Error decoding PrimeFieldType: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(8192L, className, "decodePrimeFieldType", e);
                debug.exception(8192L, className, "decodePrimeFieldType", ioe);
                debug.exit(Debug.TYPE_FINE, className, "decodePrimeFieldType");
            }
            throw ioe;
        }
    }

    static AlgorithmParameters getAlgorithmParameters(ECParameterSpec spec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "getAlgorithmParameters", spec);
        }
        AlgorithmParameters params = null;
        try {
            params = AlgorithmParameters.getInstance("EC", "IBMJCECCA");
            params.init(spec);
        }
        catch (NoSuchAlgorithmException e) {
            RuntimeException re = new RuntimeException("Internal error, no EC algorithm", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getAlgorithmParameters", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "getAlgorithmParameters", re);
                debug.exit(Debug.TYPE_FINE, className, "getAlgorithmParameters");
            }
            throw re;
        }
        catch (NoSuchProviderException e) {
            RuntimeException re = new RuntimeException("Internal error, no IBMJCECCA provider", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getAlgorithmParameters", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "getAlgorithmParameters", re);
                debug.exit(Debug.TYPE_FINE, className, "getAlgorithmParameters");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "getAlgorithmParameters", params);
        }
        return params;
    }
}

