/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECNamedCurve;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class ECParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private AlgorithmParameterSpec parameterSpec = null;
    private AlgorithmParameters generatedParameters = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECParameterGenerator";

    @Override
    protected void engineInit(int size, SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", new Integer(size), random);
        }
        this.generatedParameters = null;
        this.parameterSpec = ECNamedCurve.getECParameterSpec(size);
        if (this.parameterSpec == null) {
            InvalidParameterException ipe = new InvalidParameterException("Key size is not supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipe;
        }
        try {
            this.generateParameters();
        }
        catch (InvalidAlgorithmParameterException e) {
            this.parameterSpec = null;
            InvalidParameterException ipe = new InvalidParameterException("Unable to initialize this generator using key size: " + size);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipe;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", genParamSpec, random);
        }
        this.generatedParameters = null;
        this.parameterSpec = genParamSpec;
        if (this.parameterSpec == null) {
            NullPointerException npe = new NullPointerException("The supplied parameter generation values must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw npe;
        }
        try {
            this.generateParameters();
        }
        catch (InvalidAlgorithmParameterException e) {
            this.parameterSpec = null;
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Unable to initialize this generator with the supplied parameter generation values", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw iape;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGenerateParameters");
        }
        if (this.generatedParameters == null) {
            try {
                this.generateParameters();
            }
            catch (InvalidAlgorithmParameterException e) {
                RuntimeException re = new RuntimeException("Unable to generate Elliptic Curve parameters", e);
                if (debug != null) {
                    debug.exception(8192L, className, "engineGenerateParameters", e);
                    debug.exception(8192L, className, "engineGenerateParameters", re);
                    debug.exit(Debug.TYPE_FINE, className, "engineGenerateParameters");
                }
                throw re;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateParameters", this.generatedParameters);
        }
        return this.generatedParameters;
    }

    private void generateParameters() throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateParameters");
        }
        AlgorithmParameterSpec spec = null;
        spec = this.parameterSpec != null ? this.parameterSpec : ECNamedCurve.getECParameterSpec(ECNamedCurve.DEFAULT_CURVE_TYPE, 256);
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC", "IBMJCECCA");
            parameters.init(spec);
            this.generatedParameters = parameters;
            if (debug != null) {
                debug.text(8192L, className, "generateParameters", "Algorithm parameters: " + this.generatedParameters);
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.generatedParameters = null;
            RuntimeException re = new RuntimeException("Internal error, no EC algorithm", e);
            if (debug != null) {
                debug.exception(8192L, className, "generateParameters", e);
                debug.exception(8192L, className, "generateParameters", re);
                debug.exit(Debug.TYPE_FINE, className, "generateParameters");
            }
            throw re;
        }
        catch (NoSuchProviderException e) {
            this.generatedParameters = null;
            RuntimeException re = new RuntimeException("Internal error, no IBMJCECCA provider", e);
            if (debug != null) {
                debug.exception(8192L, className, "generateParameters", e);
                debug.exception(8192L, className, "generateParameters", re);
                debug.exit(Debug.TYPE_FINE, className, "generateParameters");
            }
            throw re;
        }
        catch (InvalidParameterSpecException e) {
            this.generatedParameters = null;
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException(e.getMessage(), e);
            if (debug != null) {
                debug.text(8192L, className, "generateParameters", "Unable to initialize the Elliptic Curve parameters");
                debug.exception(8192L, className, "generateParameters", e);
                debug.exception(8192L, className, "generateParameters", iape);
                debug.exit(Debug.TYPE_FINE, className, "generateParameters");
            }
            throw iape;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "generateParameters");
        }
    }
}

