/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKeySpec;
import com.ibm.crypto.hdwrCCA.provider.ECPublicKey;
import com.ibm.crypto.hdwrCCA.provider.ECUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyFactoryUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyStoreUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECKeyFactory
extends KeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECKeyFactory";

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", keySpec);
        }
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
                ECPublicKey publicKey = new ECPublicKey(encoded);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", "keySpec is an instance of X509EncodedKeySpec");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", publicKey);
                }
                return publicKey;
            }
            if (keySpec instanceof ECPublicKeySpec) {
                ECPoint w = ((ECPublicKeySpec)keySpec).getW();
                ECParameterSpec params = ((ECPublicKeySpec)keySpec).getParams();
                ECPublicKey publicKey = new ECPublicKey(w, params);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", "keySpec is an instance of ECPublicKeySpec");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", publicKey);
                }
                return publicKey;
            }
            if (keySpec instanceof KeyLabelKeySpec) {
                String label = new String(((KeyLabelKeySpec)keySpec).getLabelBytes(), PlatformUtilities.CHARSET_IBM_1047);
                byte[] asciiLabelBytes = label.getBytes(StandardCharsets.ISO_8859_1);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", "keySpec is an instance of KeyLabelKeySpec");
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", "Creating public key for key label: " + label);
                }
                ECPublicKey publicKey = KeyFactoryUtils.extractPublicKeyEC(asciiLabelBytes);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", publicKey);
                }
                return publicKey;
            }
            InvalidKeySpecException ike = new InvalidKeySpecException("Cannot generate public key. Unsupported key specification");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineGeneratePublic");
            }
            throw ike;
        }
        catch (InvalidParameterSpecException ipse) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot generate public key. " + ipse.getMessage(), ipse);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", ipse);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGeneratePublic");
            }
            throw ikse;
        }
        catch (InvalidKeyException ike) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot generate public key. " + ike.getMessage(), ike);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", ike);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGeneratePublic");
            }
            throw ikse;
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", keySpec);
        }
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateHWKey privateKey = new ECPrivateHWKey(encoded);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "keySpec is an instance of PKCS8EncodedKeySpec");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", privateKey);
                }
                return privateKey;
            }
            if (keySpec instanceof ECPrivateKeySpec) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "keySpec is an instance of ECPrivateKeySpec");
                }
                BigInteger s = ((ECPrivateKeySpec)keySpec).getS();
                ECParameterSpec params = ((ECPrivateKeySpec)keySpec).getParams();
                ECPoint w = ECUtils.multiply(s, params.getGenerator(), params.getCurve());
                ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(w, params);
                ECHWKeyAttributes keyAttributes = new ECHWKeyAttributes(2, ECHWKeyAttributes.DEFAULT_USAGE);
                byte[] externalKeyToken = KeyFactoryUtils.buildExternalPrivateKeyTokenEC(publicKeySpec, (ECPrivateKeySpec)keySpec, keyAttributes);
                KeyPairUtils util = new KeyPairUtils();
                byte[] internalKeyToken = util.importExternalToken(externalKeyToken, KeyPairUtils.KeyPairAlgorithm.EC);
                ECPrivateHWKey privateKey = new ECPrivateHWKey(externalKeyToken, internalKeyToken, params, keyAttributes);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", privateKey);
                }
                return privateKey;
            }
            if (keySpec instanceof KeyLabelKeySpec) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "keySpec is an instance of KeyLabelKeySpec");
                }
                ECHWKeyAttributes keyAttribs = new ECHWKeyAttributes(0, ECHWKeyAttributes.DEFAULT_USAGE);
                String label = new String(((KeyLabelKeySpec)keySpec).getLabelBytes(), PlatformUtilities.CHARSET_IBM_1047);
                byte[] asciiLabelBytes = label.getBytes(PlatformUtilities.CHARSET_ISO_8859_1);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Creating private key for key label: " + label);
                }
                ECPublicKey publicKey = KeyFactoryUtils.extractPublicKeyEC(asciiLabelBytes);
                ECPrivateHWKey privateKey = new ECPrivateHWKey(asciiLabelBytes, publicKey.getParams(), keyAttribs);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", privateKey);
                }
                return privateKey;
            }
            if (keySpec instanceof ECPrivateHWKeySpec) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "keySpec is an instance of ECPrivateHWKeySpec");
                }
                ECPrivateHWKeySpec hwKeySpec = (ECPrivateHWKeySpec)keySpec;
                ECPrivateHWKey privateKey = new ECPrivateHWKey(hwKeySpec.getToken(), hwKeySpec.getParams(), hwKeySpec.getAttributes());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", privateKey);
                }
                return privateKey;
            }
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot generate private key. Unsupported key specification");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGeneratePrivate");
            }
            throw ikse;
        }
        catch (InvalidParameterSpecException ipse) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot generate private key. " + ipse.getMessage(), ipse);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", ipse);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGeneratePrivate");
            }
            throw ikse;
        }
        catch (InvalidKeyException ike) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot generate private key. " + ike.getMessage(), ike);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", ike);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGeneratePrivate");
            }
            throw ikse;
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetKeySpec", key, keySpec);
        }
        if (key instanceof java.security.interfaces.ECPublicKey) {
            if (keySpec.isAssignableFrom(ECPublicKeySpec.class)) {
                ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(((java.security.interfaces.ECPublicKey)key).getW(), ((java.security.interfaces.ECPublicKey)key).getParams());
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "keySpec is assignable from ECPublicKeySpec");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", publicKeySpec);
                }
                return (T)((KeySpec)keySpec.cast(publicKeySpec));
            }
            if (keySpec.isAssignableFrom(X509EncodedKeySpec.class)) {
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key.getEncoded());
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "keySpec is assignable from X509EncodedKeySpec");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", x509KeySpec);
                }
                return (T)((KeySpec)keySpec.cast(x509KeySpec));
            }
            InvalidKeySpecException ikse = new InvalidKeySpecException("Inappropriate key specification");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
            }
            throw ikse;
        }
        if (key instanceof ECPrivateHWKey) {
            if (keySpec.isAssignableFrom(ECPrivateHWKeySpec.class)) {
                ECPrivateHWKeySpec hwKeySpec = null;
                hwKeySpec = ((ECPrivateHWKey)key).getType() == 0 ? new ECPrivateHWKeySpec(((ECPrivateHWKey)key).getToken(), ((ECPrivateHWKey)key).getParams(), ((ECPrivateHWKey)key).getType(), ((ECPrivateHWKey)key).getUsage()) : new ECPrivateHWKeySpec(((ECPrivateHWKey)key).getExternalKeyToken(), ((ECPrivateHWKey)key).getParams(), ((ECPrivateHWKey)key).getType(), ((ECPrivateHWKey)key).getUsage());
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "keySpec is assignable from ECPrivateHWKeySpec");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", hwKeySpec);
                }
                return (T)((KeySpec)keySpec.cast(hwKeySpec));
            }
            if (keySpec.isAssignableFrom(KeyLabelKeySpec.class)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "keySpec is assignable from KeyLabelKeySpec");
                }
                if (((ECPrivateHWKey)key).getType() != 0) {
                    InvalidKeySpecException ikse = new InvalidKeySpecException("Inappropriate key specification. Key must be PKDS key type");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", ikse);
                        debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
                    }
                    throw ikse;
                }
                byte[] asciiLabelBytes = ((ECPrivateHWKey)key).getToken();
                String label = new String(asciiLabelBytes, StandardCharsets.ISO_8859_1);
                KeyLabelKeySpec labelKeySpec = new KeyLabelKeySpec(label);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", labelKeySpec);
                }
                return (T)((KeySpec)keySpec.cast(labelKeySpec));
            }
            if (keySpec.isAssignableFrom(ECPrivateKeySpec.class)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "keySpec is assignable from ECPrivateKeySpec");
                }
                if (((ECPrivateHWKey)key).getType() != 2) {
                    InvalidKeySpecException ikse = new InvalidKeySpecException("Inappropriate key specification. Key must be CLEAR key type");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", ikse);
                        debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
                    }
                    throw ikse;
                }
                ECPrivateKeySpec privateKeySpec = null;
                try {
                    privateKeySpec = KeyStoreUtils.generateECPrivateKeySpec((ECPrivateHWKey)key);
                }
                catch (InvalidKeyException ike) {
                    InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot generate private key spec. " + ike.getMessage(), ike);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", ike);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", ikse);
                        debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
                    }
                    throw ikse;
                }
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", privateKeySpec);
                }
                return (T)((KeySpec)keySpec.cast(privateKeySpec));
            }
            InvalidKeySpecException ikse = new InvalidKeySpecException("Inappropriate key specification");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
            }
            throw ikse;
        }
        InvalidKeySpecException ikse = new InvalidKeySpecException("Inappropriate key specification");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", ikse);
            debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
        }
        throw ikse;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
        }
        if (key instanceof java.security.interfaces.ECPublicKey) {
            if (key instanceof ECPublicKey) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey", "key is an instance of com.ibm.crypto.hdwrCCA.provider.ECPublicKey");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
                }
                return key;
            }
            ECPublicKey publicKey = null;
            try {
                publicKey = new ECPublicKey(((java.security.interfaces.ECPublicKey)key).getW(), ((java.security.interfaces.ECPublicKey)key).getParams());
            }
            catch (InvalidParameterSpecException e) {
                InvalidKeyException ike = new InvalidKeyException("Cannot translate key. " + e.getMessage(), e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineTranslateKey");
                }
                throw ike;
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", publicKey);
            }
            return publicKey;
        }
        if (key instanceof ECPrivateKey) {
            if (key instanceof ECPrivateHWKey) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey", "key is an instance of com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
                }
                return key;
            }
            if (key instanceof PKCS11PrivateKey && Boolean.TRUE.equals(((PKCS11PrivateKey)key).getSensitive())) {
                InvalidKeyException ike = new InvalidKeyException("Private key value is sensitive and is not exportable");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineTranslateKey");
                }
                throw ike;
            }
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(((ECPrivateKey)key).getS(), ((ECPrivateKey)key).getParams());
            PrivateKey privateKey = null;
            try {
                privateKey = this.engineGeneratePrivate(privateKeySpec);
            }
            catch (InvalidKeySpecException e) {
                InvalidKeyException ike = new InvalidKeyException("Cannot translate key. " + e.getMessage(), e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineTranslateKey");
                }
                throw ike;
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", privateKey);
            }
            return privateKey;
        }
        InvalidKeyException ike = new InvalidKeyException("Cannot translate key. Inappropriate key specification");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", ike);
            debug.exit(Debug.TYPE_FINE, className, "engineTranslateKey");
        }
        throw ike;
    }
}

