/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPublicKey;
import com.ibm.crypto.hdwrCCA.provider.KDFParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.KeyAgreementUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class ECDHKeyAgreement
extends KeyAgreementSpi {
    private static final int DES_KEY_SIZE = 56;
    private static final int DESEDE_DOUBLE_LENGTH_KEY_SIZE = 112;
    private static final int DES_KEY_SIZE_PADDED = 64;
    private static final int DESEDE_DOUBLE_LENGTH_KEY_SIZE_PADDED = 128;
    private static final int DEFAULT_AES_KEY_SIZE = 128;
    private ECPublicKey publicKey = null;
    private ECPrivateHWKey privateKey = null;
    private KDFParameterSpec kdfParameterSpec = null;
    private State currentState = State.UNINITIALIZED;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECDHKeyAgreement";

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        this.publicKey = null;
        this.privateKey = null;
        this.kdfParameterSpec = null;
        this.currentState = State.UNINITIALIZED;
        if (key instanceof ECPrivateHWKey) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Key is instance of ECPrivateHWKey");
            }
            this.privateKey = (ECPrivateHWKey)key;
        } else if (key instanceof ECPrivateKey) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Key is instance of ECPrivateKey");
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Automatic migration of IBMJCE Elliptic Curve private key to IBMJCECCA");
            }
            KeyFactory hwKeyFactory = null;
            try {
                hwKeyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
            }
            catch (NoSuchProviderException e) {
                RuntimeException rte = new RuntimeException("Internal error, no IBMJCECCA provider", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw rte;
            }
            catch (NoSuchAlgorithmException e) {
                RuntimeException rte = new RuntimeException("Internal error, no EC algorithm", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw rte;
            }
            this.privateKey = (ECPrivateHWKey)hwKeyFactory.translateKey(key);
        } else {
            InvalidKeyException ike = new InvalidKeyException("This is not an Elliptic Curve private key: " + key);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        if (params != null) {
            if (params instanceof KDFParameterSpec) {
                this.kdfParameterSpec = (KDFParameterSpec)params;
            } else {
                InvalidAlgorithmParameterException ipe = new InvalidAlgorithmParameterException("The specified algorithm parameter specification is not supported");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw ipe;
            }
        }
        this.currentState = State.INITIALIZED;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", key, random);
        }
        try {
            this.engineInit(key, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            RuntimeException rte = new RuntimeException("Internal error", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineDoPhase", key, lastPhase);
        }
        if (!(key instanceof java.security.interfaces.ECPublicKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an Elliptic Curve public key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw ike;
        }
        if (!lastPhase) {
            IllegalStateException ise = new IllegalStateException("Only two party key agreement is supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw ise;
        }
        if (this.currentState == State.UNINITIALIZED) {
            IllegalStateException ise = new IllegalStateException("Key agreement engine not initialized");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw ise;
        }
        if (this.currentState == State.PHASE_COMPLETE) {
            IllegalStateException ise = new IllegalStateException("Key agreement phase already completed");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw ise;
        }
        java.security.interfaces.ECPublicKey hardwareKey = (java.security.interfaces.ECPublicKey)key;
        EllipticCurve pub_ec = hardwareKey.getParams().getCurve();
        ECPoint pub_generator = hardwareKey.getParams().getGenerator();
        BigInteger pub_order = hardwareKey.getParams().getOrder();
        int pub_cofactor = hardwareKey.getParams().getCofactor();
        EllipticCurve ec = this.privateKey.getParams().getCurve();
        ECPoint generator = this.privateKey.getParams().getGenerator();
        BigInteger order = this.privateKey.getParams().getOrder();
        int cofactor = this.privateKey.getParams().getCofactor();
        if (!ec.equals(pub_ec)) {
            InvalidKeyException ike = new InvalidKeyException("Incompatible Elliptic Curve domain parameters");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw ike;
        }
        if (!generator.equals(pub_generator)) {
            InvalidKeyException ike = new InvalidKeyException("Incompatible Elliptic Curve domain parameters");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw ike;
        }
        if (!order.equals(pub_order)) {
            InvalidKeyException ike = new InvalidKeyException("Incompatible Elliptic Curve domain parameters");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw ike;
        }
        if (cofactor != pub_cofactor) {
            InvalidKeyException ike = new InvalidKeyException("Incompatible Elliptic Curve domain parameters");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw ike;
        }
        KeyFactory hwKeyFactory = null;
        try {
            hwKeyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
        }
        catch (NoSuchProviderException e) {
            RuntimeException rte = new RuntimeException("Internal error, no IBMJCECCA provider", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw rte;
        }
        catch (NoSuchAlgorithmException e) {
            RuntimeException rte = new RuntimeException("Internal error, no EC algorithm", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoPhase", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineDoPhase");
            }
            throw rte;
        }
        this.publicKey = (ECPublicKey)hwKeyFactory.translateKey(hardwareKey);
        this.currentState = State.PHASE_COMPLETE;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoPhase", null);
        }
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGenerateSecret");
        }
        if (this.currentState != State.PHASE_COMPLETE) {
            IllegalStateException ise = new IllegalStateException("Key agreement wrong state");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw ise;
        }
        this.currentState = State.INITIALIZED;
        byte[] secret = KeyAgreementUtils.generateSharedSecretECDH(this.publicKey, this.privateKey);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", secret);
        }
        return secret;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGenerateSecret", sharedSecret, offset);
        }
        if (this.currentState != State.PHASE_COMPLETE) {
            IllegalStateException ise = new IllegalStateException("Key agreement wrong state");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw ise;
        }
        if (sharedSecret == null) {
            NullPointerException npe = new NullPointerException("Buffer not provided for the shared secret");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw npe;
        }
        if (offset < 0 || offset >= sharedSecret.length) {
            IndexOutOfBoundsException ibe = new IndexOutOfBoundsException("The offset value is not appropriate for the specified buffer");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", ibe);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw ibe;
        }
        this.currentState = State.INITIALIZED;
        byte[] secret = KeyAgreementUtils.generateSharedSecretECDH(this.publicKey, this.privateKey);
        if (secret.length > sharedSecret.length - offset) {
            ShortBufferException sbe = new ShortBufferException("Buffer too short to hold the shared secret");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "secret.length = " + secret.length);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", sbe);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw sbe;
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        Arrays.fill(secret, (byte)32);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", secret.length);
        }
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKey secret;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", algorithm);
        }
        if (algorithm == null) {
            NullPointerException npe = new NullPointerException("The algorithm must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw npe;
        }
        if (null != this.kdfParameterSpec && this.kdfParameterSpec.getNoCvKEK() && !algorithm.equalsIgnoreCase("DESede") && !algorithm.equalsIgnoreCase("TripleDES") && !algorithm.equalsIgnoreCase("3DES")) {
            InvalidKeyException ike = new InvalidKeyException("The NoCvKEK option is only allowed for a DESede, 3DES, or TripleDES key encrypting key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw ike;
        }
        if (algorithm.equalsIgnoreCase("TlsPremasterSecret")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "TlsPremasterSecret algorithm requested, generate raw Z value");
            }
            byte[] rawZ = this.engineGenerateSecret();
            SecretKeySpec tlsPremasterSecret = new SecretKeySpec(rawZ, "TlsPremasterSecret");
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", tlsPremasterSecret);
            }
            return tlsPremasterSecret;
        }
        if (this.currentState != State.PHASE_COMPLETE) {
            IllegalStateException ise = new IllegalStateException("Key agreement wrong state");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw ise;
        }
        this.currentState = State.INITIALIZED;
        if (algorithm.equalsIgnoreCase("DES")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "DES algorithm");
            }
            secret = this.generateSecretDES();
        } else if (algorithm.equalsIgnoreCase("DESede") || algorithm.equalsIgnoreCase("TripleDES") || algorithm.equalsIgnoreCase("3DES")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "DESede algorithm");
            }
            secret = this.generateSecretDESede();
        } else if (algorithm.equalsIgnoreCase("AES")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "AES algorithm");
            }
            secret = this.generateSecretAES();
        } else {
            NoSuchAlgorithmException nae = new NoSuchAlgorithmException("Unsupported secret key algorithm: " + algorithm);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", nae);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw nae;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", secret);
        }
        return secret;
    }

    private final byte[] buildSharedInfo() {
        byte[] sharedInfo = null;
        if (this.kdfParameterSpec != null) {
            sharedInfo = this.kdfParameterSpec.getSharedInfo();
        }
        if (sharedInfo == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "buildSharedInfo", "Using default sharedInfo");
            }
            String sharedInfoString = "AlgorithmID||PartyUInfo||PartyVInfo";
            sharedInfo = sharedInfoString.getBytes(StandardCharsets.ISO_8859_1);
        }
        return sharedInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DESKey generateSecretDES() throws InvalidKeyException {
        DESKey secret;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateSecretDES");
        }
        int keySize = 56;
        SymmetricKeyConstants.KeyType keyType = SymmetricKeyConstants.KeyType.SECURE_INTERNAL_TOKEN;
        String keyLabel = null;
        SymmetricKeyConstants.KeyUsage keyUsage = SymmetricKeyConstants.KeyUsage.OP_CIPHER;
        if (this.kdfParameterSpec != null) {
            keySize = this.kdfParameterSpec.getKeySize();
            if (keySize == 0) {
                keySize = 56;
            }
            if ((keyType = this.kdfParameterSpec.getKeyType()) == null) {
                keyType = SymmetricKeyConstants.KeyType.SECURE_INTERNAL_TOKEN;
            }
            keyLabel = this.kdfParameterSpec.getCKDSLabel();
            keyUsage = this.kdfParameterSpec.getKeyUsage();
            if (keyUsage == null) {
                keyUsage = SymmetricKeyConstants.KeyUsage.OP_CIPHER;
            }
        }
        if (keySize != 56 && keySize != 64) {
            InvalidKeyException ike = new InvalidKeyException("DES key must have key size of 56");
            if (debug != null) {
                debug.exception(8192L, className, "generateSecretDES", ike);
                debug.exit(Debug.TYPE_FINE, className, "generateSecretDES");
            }
            throw ike;
        }
        if (keyType == SymmetricKeyConstants.KeyType.CLEAR) {
            InvalidKeyException ike = new InvalidKeyException("Generating CLEAR DES keys not allowed");
            if (debug != null) {
                debug.exception(8192L, className, "generateSecretDES", ike);
                debug.exit(Debug.TYPE_FINE, className, "generateSecretDES");
            }
            throw ike;
        }
        if (keyUsage != SymmetricKeyConstants.KeyUsage.OP_CIPHER) {
            InvalidKeyException ike = new InvalidKeyException("DES keys must have key usage of " + (Object)((Object)SymmetricKeyConstants.KeyUsage.OP_CIPHER));
            if (debug != null) {
                debug.exception(8192L, className, "generateSecretDES", ike);
                debug.exit(Debug.TYPE_FINE, className, "generateSecretDES");
            }
            throw ike;
        }
        byte[] privateKeyIdentifier = this.privateKey.getExternalKeyToken();
        if (privateKeyIdentifier == null) {
            privateKeyIdentifier = this.privateKey.getToken();
        }
        if (PlatformUtilities.isZOS() && this.privateKey.getType() == 0) {
            privateKeyIdentifier = PlatformUtilities.convertBytesATOE(privateKeyIdentifier);
        }
        String keyTypeString = "CIPHER  ";
        int ruleArrayCount = 3;
        String ruleArrayString = "DES     INTERNALKEYLN8  ";
        byte[] skeletonToken = SymmetricKeyUtils.keyTokenBuild(keyTypeString, ruleArrayCount, ruleArrayString);
        ruleArrayCount = 2;
        ruleArrayString = "DERIV01 KEY-DES ";
        byte[] token = KeyAgreementUtils.eccDiffieHellman(ruleArrayString, ruleArrayCount, privateKeyIdentifier, this.publicKey.getToken(), this.buildSharedInfo(), 64, skeletonToken);
        Arrays.fill(skeletonToken, (byte)0);
        try {
            secret = new DESKey("ICSFToken", token);
            if (keyType == SymmetricKeyConstants.KeyType.CKDS) {
                String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(secret, keyLabel);
                secret = DESKey.newLabelKey(actualLabel);
            }
        }
        finally {
            Arrays.fill(token, (byte)0);
        }
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "generateSecretDES", secret);
        }
        return secret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DESedeKey generateSecretDESede() throws InvalidKeyException {
        DESedeKey secret;
        String keyTypeString;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateSecretDESede");
        }
        int keySize = 112;
        SymmetricKeyConstants.KeyType keyType = SymmetricKeyConstants.KeyType.SECURE_INTERNAL_TOKEN;
        String keyLabel = null;
        SymmetricKeyConstants.KeyUsage keyUsage = SymmetricKeyConstants.KeyUsage.OP_CIPHER;
        if (this.kdfParameterSpec != null) {
            keySize = this.kdfParameterSpec.getKeySize();
            if (keySize == 0) {
                keySize = 112;
            }
            if ((keyType = this.kdfParameterSpec.getKeyType()) == null) {
                keyType = SymmetricKeyConstants.KeyType.SECURE_INTERNAL_TOKEN;
            }
            keyLabel = this.kdfParameterSpec.getCKDSLabel();
            keyUsage = this.kdfParameterSpec.getKeyUsage();
            if (keyUsage == null) {
                keyUsage = SymmetricKeyConstants.KeyUsage.OP_CIPHER;
            }
        }
        if (keySize != 112 && keySize != 128) {
            InvalidKeyException ike = new InvalidKeyException("DESede key must have key size of 112");
            if (debug != null) {
                debug.exception(8192L, className, "generateSecretDESede", ike);
                debug.exit(Debug.TYPE_FINE, className, "generateSecretDESede");
            }
            throw ike;
        }
        if (keyType == SymmetricKeyConstants.KeyType.CLEAR) {
            InvalidKeyException ike = new InvalidKeyException("Generating CLEAR Triple-DES keys not allowed");
            if (debug != null) {
                debug.exception(8192L, className, "generateSecretDESede", ike);
                debug.exit(Debug.TYPE_FINE, className, "generateSecretDESede");
            }
            throw ike;
        }
        byte[] privateKeyIdentifier = this.privateKey.getExternalKeyToken();
        if (privateKeyIdentifier == null) {
            privateKeyIdentifier = this.privateKey.getToken();
        }
        if (PlatformUtilities.isZOS() && this.privateKey.getType() == 0) {
            privateKeyIdentifier = PlatformUtilities.convertBytesATOE(privateKeyIdentifier);
        }
        switch (keyUsage) {
            case OP_CIPHER: {
                keyTypeString = "CIPHER  ";
                break;
            }
            case OP_EXPORTER: {
                keyTypeString = "EXPORTER";
                break;
            }
            case OP_IMPORTER: {
                keyTypeString = "IMPORTER";
                break;
            }
            default: {
                InvalidKeyException ike = new InvalidKeyException("Key usage not supported for Triple-DES keys: " + (Object)((Object)keyUsage));
                if (debug != null) {
                    debug.exception(8192L, className, "generateSecretDESede", ike);
                    debug.exit(Debug.TYPE_FINE, className, "generateSecretDESede");
                }
                throw ike;
            }
        }
        int ruleArrayCount = 3;
        String ruleArrayString = "DES     INTERNALKEYLN16 ";
        if (null != this.kdfParameterSpec && this.kdfParameterSpec.getNoCvKEK()) {
            ruleArrayString = ruleArrayString + "NOCV-KEK";
            ++ruleArrayCount;
        }
        byte[] skeletonToken = SymmetricKeyUtils.keyTokenBuild(keyTypeString, ruleArrayCount, ruleArrayString);
        ruleArrayCount = 2;
        ruleArrayString = "DERIV01 KEY-DES ";
        byte[] token = KeyAgreementUtils.eccDiffieHellman(ruleArrayString, ruleArrayCount, privateKeyIdentifier, this.publicKey.getToken(), this.buildSharedInfo(), 128, skeletonToken);
        Arrays.fill(skeletonToken, (byte)0);
        try {
            secret = new DESedeKey("ICSFToken", token);
            if (keyType == SymmetricKeyConstants.KeyType.CKDS) {
                String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(secret, keyLabel);
                secret = DESedeKey.newLabelKey(actualLabel);
            }
        }
        finally {
            Arrays.fill(token, (byte)0);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "generateSecretDESede", secret);
        }
        return secret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AESKey generateSecretAES() throws InvalidKeyException {
        AESKey secret;
        byte[] skeletonToken;
        String ruleArrayString;
        int ruleArrayCount;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateSecretAES");
        }
        int keySize = 128;
        SymmetricKeyConstants.KeyType keyType = SymmetricKeyConstants.KeyType.SECURE_INTERNAL_TOKEN;
        String keyLabel = null;
        SymmetricKeyConstants.KeyUsage keyUsage = SymmetricKeyConstants.KeyUsage.OP_DATA;
        if (this.kdfParameterSpec != null) {
            keySize = this.kdfParameterSpec.getKeySize();
            if (keySize == 0) {
                keySize = 128;
            }
            if ((keyType = this.kdfParameterSpec.getKeyType()) == null) {
                keyType = SymmetricKeyConstants.KeyType.SECURE_INTERNAL_TOKEN;
            }
            keyLabel = this.kdfParameterSpec.getCKDSLabel();
            keyUsage = this.kdfParameterSpec.getKeyUsage();
            if (keyUsage == null) {
                keyUsage = SymmetricKeyConstants.KeyUsage.OP_DATA;
            }
        }
        if (keySize != 128 && keySize != 192 && keySize != 256) {
            InvalidKeyException ike = new InvalidKeyException("AES key must have key size of 128, 192, or 256");
            if (debug != null) {
                debug.exception(8192L, className, "generateSecretAES", ike);
                debug.exit(Debug.TYPE_FINE, className, "generateSecretAES");
            }
            throw ike;
        }
        if (keyType == SymmetricKeyConstants.KeyType.CLEAR) {
            InvalidKeyException ike = new InvalidKeyException("Generating CLEAR AES keys not allowed");
            if (debug != null) {
                debug.exception(8192L, className, "generateSecretAES", ike);
                debug.exit(Debug.TYPE_FINE, className, "generateSecretAES");
            }
            throw ike;
        }
        switch (keyUsage) {
            case OP_DATA: {
                String keyTypeString = "DATA    ";
                ruleArrayCount = 3;
                switch (keySize) {
                    case 256: {
                        ruleArrayString = "AES     INTERNALKEYLN32 ";
                        break;
                    }
                    case 192: {
                        ruleArrayString = "AES     INTERNALKEYLN24 ";
                        break;
                    }
                    default: {
                        ruleArrayString = "AES     INTERNALKEYLN16 ";
                    }
                }
                skeletonToken = SymmetricKeyUtils.keyTokenBuild(keyTypeString, ruleArrayCount, ruleArrayString);
                break;
            }
            case OP_EXPORTER: {
                ruleArrayCount = 3;
                ruleArrayString = "INTERNALAES     EXPORTER";
                byte[] exporterToken = SymmetricKeyUtils.keyTokenBuild2(ruleArrayCount, ruleArrayString);
                skeletonToken = new byte[900];
                System.arraycopy(exporterToken, 0, skeletonToken, 0, exporterToken.length);
                Arrays.fill(exporterToken, (byte)0);
                break;
            }
            case OP_IMPORTER: {
                ruleArrayCount = 3;
                ruleArrayString = "INTERNALAES     IMPORTER";
                byte[] importerToken = SymmetricKeyUtils.keyTokenBuild2(ruleArrayCount, ruleArrayString);
                skeletonToken = new byte[900];
                System.arraycopy(importerToken, 0, skeletonToken, 0, importerToken.length);
                Arrays.fill(importerToken, (byte)0);
                break;
            }
            default: {
                InvalidKeyException ike = new InvalidKeyException("Key usage not supported for AES keys: " + (Object)((Object)keyUsage));
                if (debug != null) {
                    debug.exception(8192L, className, "generateSecretAES", ike);
                    debug.exit(Debug.TYPE_FINE, className, "generateSecretAES");
                }
                throw ike;
            }
        }
        byte[] privateKeyIdentifier = this.privateKey.getExternalKeyToken();
        if (privateKeyIdentifier == null) {
            privateKeyIdentifier = this.privateKey.getToken();
        }
        if (PlatformUtilities.isZOS() && this.privateKey.getType() == 0) {
            privateKeyIdentifier = PlatformUtilities.convertBytesATOE(privateKeyIdentifier);
        }
        ruleArrayCount = 2;
        ruleArrayString = "DERIV01 KEY-AES ";
        byte[] token = KeyAgreementUtils.eccDiffieHellman(ruleArrayString, ruleArrayCount, privateKeyIdentifier, this.publicKey.getToken(), this.buildSharedInfo(), keySize, skeletonToken);
        Arrays.fill(skeletonToken, (byte)0);
        try {
            secret = new AESKey("ICSFToken", token);
            if (keyType == SymmetricKeyConstants.KeyType.CKDS) {
                String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(secret, keyLabel);
                secret = AESKey.newLabelKey(actualLabel);
            }
        }
        finally {
            Arrays.fill(token, (byte)0);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "generateSecretAES", secret);
        }
        return secret;
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZED,
        PHASE_COMPLETE;

    }
}

