/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Crypto;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPublicKey;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.PKCS11Utils;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;

public final class DatawithECDSA
extends SignatureSpi {
    private State currentState = State.UNINITIALIZED;
    private int dataSize = 0;
    private static final int DATA_SIZE_INCREMENT = 256;
    private byte[] data = new byte[256];
    private ECParameterSpec parameterSpec;
    private byte[] publicKeyToken = null;
    private byte[] internalPrivateKeyTokenOrLabel = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DatawithECDSA";
    private static HexDumpEncoder encoder = debug != null ? new HexDumpEncoder() : null;

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInitSign", privateKey);
        }
        if (privateKey instanceof ECPrivateHWKey) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitSign", "Elliptic Curve private key is instance of ECPrivateHWKey");
            }
            ECPrivateHWKey hwPrivateKey = (ECPrivateHWKey)privateKey;
            this.internalPrivateKeyTokenOrLabel = hwPrivateKey.getToken();
            this.parameterSpec = hwPrivateKey.getParams();
            if (this.parameterSpec == null) {
                InvalidKeyException ike = new InvalidKeyException("Unable to retrieve Elliptic Curve domain parameters");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw ike;
            }
        } else if (privateKey instanceof PKCS11ECPrivateKey && Boolean.TRUE.equals(((PKCS11ECPrivateKey)privateKey).getSensitive())) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitSign", "Elliptic Curve private key is instance of PKCS11ECPrivateKey and is a sensitive key");
            }
            if (!PKCS11Utils.isSecureKey((PKCS11Key)((PKCS11ECPrivateKey)privateKey))) {
                InvalidKeyException ike = new InvalidKeyException("Private key is a sensitive key, but not a secure key");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw ike;
            }
            String p11Label = PKCS11Utils.getSecureKeyLabel((PKCS11Key)((PKCS11ECPrivateKey)privateKey));
            if (p11Label == null) {
                InvalidKeyException ike = new InvalidKeyException("Unable to retrieve secure key label");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw ike;
            }
            this.internalPrivateKeyTokenOrLabel = p11Label.getBytes(StandardCharsets.ISO_8859_1);
            this.parameterSpec = ((PKCS11ECPrivateKey)privateKey).getParams();
            if (this.parameterSpec == null) {
                InvalidKeyException ike = new InvalidKeyException("Unable to retrieve Elliptic Curve domain parameters");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw ike;
            }
        } else if (privateKey instanceof ECPrivateKey) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitSign", "Automatic migration of IBMJCE Elliptic Curve private key to IBMJCECCA");
            }
            KeyFactory hwKeyFactory = null;
            try {
                hwKeyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
            }
            catch (NoSuchProviderException e) {
                RuntimeException rte = new RuntimeException("Internal error, no IBMJCECCA provider", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw rte;
            }
            catch (NoSuchAlgorithmException e) {
                RuntimeException rte = new RuntimeException("Internal error, no EC algorithm", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw rte;
            }
            ECPrivateHWKey hwPrivateKey = (ECPrivateHWKey)hwKeyFactory.translateKey(privateKey);
            this.internalPrivateKeyTokenOrLabel = hwPrivateKey.getToken();
            this.parameterSpec = hwPrivateKey.getParams();
            if (this.parameterSpec == null) {
                InvalidKeyException ike = new InvalidKeyException("Unable to retrieve Elliptic Curve domain parameters");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
                }
                throw ike;
            }
        } else {
            InvalidKeyException ike = new InvalidKeyException("This is not a valid Elliptic Curve private key: " + privateKey);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInitSign", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
            }
            throw ike;
        }
        this.dataSize = 0;
        this.currentState = State.SIGN;
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineInitSign", "dataSize = " + this.dataSize + ", data.length = " + this.data.length);
            debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInitVerify", publicKey);
        }
        if (publicKey instanceof ECPublicKey) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitVerify", "Elliptic Curve public key is instance of com.ibm.crypto.hdwrCCA.provider.ECPublicKey");
            }
            ECPublicKey hwPublicKey = (ECPublicKey)publicKey;
            this.publicKeyToken = hwPublicKey.getToken();
            this.parameterSpec = hwPublicKey.getParams();
            if (this.parameterSpec == null) {
                InvalidKeyException ike = new InvalidKeyException("Unable to retrieve Elliptic Curve domain parameters");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitVerify", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
                }
                throw ike;
            }
        } else if (publicKey instanceof java.security.interfaces.ECPublicKey) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInitVerify", "Automatic migration of IBMJCE Elliptic Curve public key to IBMJCECCA");
            }
            KeyFactory hwKeyFactory = null;
            try {
                hwKeyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
            }
            catch (NoSuchProviderException e) {
                RuntimeException rte = new RuntimeException("Internal error, no IBMJCECCA provider", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitVerify", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitVerify", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
                }
                throw rte;
            }
            catch (NoSuchAlgorithmException e) {
                RuntimeException rte = new RuntimeException("Internal error, no EC algorithm", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitVerify", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitVerify", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
                }
                throw rte;
            }
            ECPublicKey hwPublicKey = (ECPublicKey)hwKeyFactory.translateKey(publicKey);
            this.publicKeyToken = hwPublicKey.getToken();
            this.parameterSpec = hwPublicKey.getParams();
            if (this.parameterSpec == null) {
                InvalidKeyException ike = new InvalidKeyException("Unable to retrieve Elliptic Curve domain parameters");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInitVerify", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
                }
                throw ike;
            }
        } else {
            InvalidKeyException ike = new InvalidKeyException("This is not a valid Elliptic Curve public key: " + publicKey);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInitVerify", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
            }
            throw ike;
        }
        this.dataSize = 0;
        this.currentState = State.VERIFY;
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineInitVerify", "dataSize = " + this.dataSize + ", data.length = " + this.data.length);
            debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", new Byte(b));
        }
        this.engineUpdate(new byte[]{b}, 0, 1);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "dataSize = " + this.dataSize + ", data.length = " + this.data.length);
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{b, new Integer(off), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        if (this.currentState == State.UNINITIALIZED) {
            SignatureException se = new SignatureException("This signature engine has not been properly initialized");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", se);
                debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
            }
            throw se;
        }
        if (b == null) {
            NullPointerException npe = new NullPointerException("The array of bytes must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
            }
            throw npe;
        }
        if (off < 0 || off >= b.length || len < 0 || len > b.length - off) {
            IndexOutOfBoundsException ibe = new IndexOutOfBoundsException("Offset and length values are not appropriate for the specified byte array");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", ibe);
                debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
            }
            throw ibe;
        }
        if (this.dataSize + len >= this.data.length) {
            int newDataSize = this.dataSize + len + 256;
            byte[] newData = new byte[newDataSize];
            System.arraycopy(this.data, 0, newData, 0, this.dataSize);
            this.data = newData;
        }
        System.arraycopy(b, off, this.data, this.dataSize, len);
        this.dataSize += len;
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "dataSize = " + this.dataSize + ", data.length = " + this.data.length);
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSign");
        }
        if (this.currentState != State.SIGN) {
            SignatureException se = new SignatureException("This signature engine has not been properly initialized for signing");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSign", se);
                debug.exit(Debug.TYPE_FINE, className, "engineSign");
            }
            throw se;
        }
        if (this.dataSize <= 0) {
            SignatureException se = new SignatureException("This signature engine has no data to sign");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSign", se);
                debug.exit(Debug.TYPE_FINE, className, "engineSign");
            }
            throw se;
        }
        if (debug != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.dataSize; ++i) {
                sb.append(String.format("%02X ", this.data[i]));
            }
            debug.text(Debug.TYPE_PUBLIC, className, "engineSign", "Data = \n" + sb.toString());
        }
        Crypto crypto = new Crypto();
        byte[] signature = crypto.sign(this.internalPrivateKeyTokenOrLabel, this.data, 0, this.dataSize, Crypto.Algorithm.ECDSA, false, new String());
        byte[] encodedSignature = this.ecdsaToASN1(signature);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineSign", encodedSignature);
        }
        return encodedSignature;
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineVerify", (Object)sigBytes);
        }
        if (this.currentState != State.VERIFY) {
            SignatureException se = new SignatureException("This signature engine has not been properly initialized for verify");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineVerify", se);
                debug.exit(Debug.TYPE_FINE, className, "engineVerify");
            }
            throw se;
        }
        if (sigBytes == null) {
            NullPointerException npe = new NullPointerException("The signature bytes must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineVerify", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineVerify");
            }
            throw npe;
        }
        if (this.dataSize <= 0) {
            SignatureException se = new SignatureException("This signature engine has no data to verify the signature against");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineVerify", se);
                debug.exit(Debug.TYPE_FINE, className, "engineVerify");
            }
            throw se;
        }
        if (debug != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.dataSize; ++i) {
                sb.append(String.format("%02X ", this.data[i]));
            }
            debug.text(Debug.TYPE_PUBLIC, className, "engineVerify", "Data = \n" + sb.toString());
        }
        byte[] signature = this.asn1ToECDSA(sigBytes);
        Crypto crypto = new Crypto();
        boolean result = crypto.verify(this.publicKeyToken, this.data, 0, this.dataSize, signature, 0, signature.length, Crypto.Algorithm.ECDSA, false, new String());
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineVerify", result);
        }
        return result;
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        UnsupportedOperationException uoe = new UnsupportedOperationException("Function engineGetParameter has no meaning in hardware");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameter", param);
            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameter", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineGetParameter");
        }
        throw uoe;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        UnsupportedOperationException uoe = new UnsupportedOperationException("Function engineSetParameter has no meaning in hardware");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSetParameter", param, value);
            debug.exception(Debug.TYPE_PUBLIC, className, "engineSetParameter", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineSetParameter");
        }
        throw uoe;
    }

    private byte[] ecdsaToASN1(byte[] signature) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "ecdsaToASN1", (Object)signature);
        }
        if (debug != null) {
            debug.text(8192L, className, "ecdsaToASN1", "Signature:");
            debug.text(8192L, className, "ecdsaToASN1", encoder.encode(signature));
        }
        int length = signature.length / 2;
        byte[] r = new byte[length];
        byte[] s = new byte[length];
        System.arraycopy(signature, 0, r, 0, r.length);
        System.arraycopy(signature, r.length, s, 0, s.length);
        try {
            DerOutputStream out = new DerOutputStream(100);
            out.putInteger(new BigInteger(1, r));
            out.putInteger(new BigInteger(1, s));
            DerValue result = new DerValue(48, out.toByteArray());
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "ecdsaToASN1", result.toByteArray());
            }
            return result.toByteArray();
        }
        catch (IOException e) {
            SignatureException se = new SignatureException("Unable to encode signature", e);
            if (debug != null) {
                debug.exception(8192L, className, "ecdsaToASN1", e);
                debug.exception(8192L, className, "ecdsaToASN1", se);
                debug.exit(Debug.TYPE_FINE, className, "ecdsaToASN1");
            }
            throw se;
        }
    }

    private byte[] asn1ToECDSA(byte[] signature) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "asn1ToECDSA", (Object)signature);
        }
        try {
            DerInputStream in = new DerInputStream(signature);
            DerValue[] values = in.getSequence(2);
            BigInteger r = values[0].getPositiveBigInteger();
            BigInteger s = values[1].getPositiveBigInteger();
            byte[] rSignedBytes = r.toByteArray();
            byte[] sSignedBytes = s.toByteArray();
            int rSignedLength = rSignedBytes.length;
            int sSignedLength = sSignedBytes.length;
            int keySize = this.parameterSpec.getCurve().getField().getFieldSize();
            int length = (int)Math.ceil((float)keySize / 8.0f);
            if (debug != null) {
                debug.text(8192L, className, "asn1ToECDSA", "Elliptic Curve key size: " + keySize);
                debug.text(8192L, className, "asn1ToECDSA", "Expected length of r and s in bytes: " + length);
                debug.text(8192L, className, "asn1ToECDSA", "r length in bits: " + r.bitLength());
                debug.text(8192L, className, "asn1ToECDSA", "Signed r length in bytes: " + rSignedBytes.length);
                debug.text(8192L, className, "asn1ToECDSA", "Signed r:");
                debug.text(8192L, className, "asn1ToECDSA", encoder.encode(rSignedBytes));
                debug.text(8192L, className, "asn1ToECDSA", "s length in bits: " + s.bitLength());
                debug.text(8192L, className, "asn1ToECDSA", "Signed s length in bytes: " + sSignedBytes.length);
                debug.text(8192L, className, "asn1ToECDSA", "Signed s:");
                debug.text(8192L, className, "asn1ToECDSA", encoder.encode(sSignedBytes));
            }
            byte[] result = new byte[length * 2];
            if (rSignedLength > length) {
                System.arraycopy(rSignedBytes, rSignedLength - length, result, 0, length);
            } else {
                System.arraycopy(rSignedBytes, 0, result, length - rSignedLength, rSignedLength);
            }
            if (sSignedLength > length) {
                System.arraycopy(sSignedBytes, sSignedLength - length, result, result.length - length, length);
            } else {
                System.arraycopy(sSignedBytes, 0, result, result.length - sSignedLength, sSignedLength);
            }
            if (debug != null) {
                debug.text(8192L, className, "asn1ToECDSA", "ASN.1 DER encoded signature length: " + signature.length);
                debug.text(8192L, className, "asn1ToECDSA", "Signature length: " + result.length);
                debug.text(8192L, className, "asn1ToECDSA", "Signature:");
                debug.text(8192L, className, "asn1ToECDSA", encoder.encode(result));
                debug.exit(Debug.TYPE_FINE, (Object)className, "asn1ToECDSA", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "asn1ToECDSA", e);
                debug.exit(Debug.TYPE_FINE, (Object)className, "asn1ToECDSA", signature);
            }
            return signature;
        }
    }

    private static enum State {
        UNINITIALIZED,
        SIGN,
        VERIFY;

    }
}

