/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.spec.DSAParameterSpec;
import java.security.spec.KeySpec;

public class DSAPrivateHWKeySpec
implements KeySpec {
    private byte[] keyLabel;
    private DSAKeyHWAttributes keyAttribs = null;
    private DSAParameterSpec params;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKeySpec";

    public DSAPrivateHWKeySpec(byte[] keyLabel, DSAParameterSpec parms, byte type) {
        if (debug != null) {
            Object[] parmlist = new Object[]{keyLabel, parms, new Byte(type)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAPrivateHWKeySpec", parmlist);
        }
        this.keyLabel = (byte[])keyLabel.clone();
        this.keyAttribs = type != 0 ? new DSAKeyHWAttributes(0, 3) : new DSAKeyHWAttributes(type, 3);
        this.params = parms;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAPrivateHWKeySpec");
        }
    }

    public byte[] getLabel() {
        byte[] result = (byte[])this.keyLabel.clone();
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabel");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabel", result);
        }
        return result;
    }

    public DSAKeyHWAttributes getAttributes() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAttributes");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAttributes", this.keyAttribs);
        }
        return this.keyAttribs;
    }

    public DSAParameterSpec getDSAParamSpec() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getDSAParamSpec");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getDSAParamSpec", this.params);
        }
        return this.params;
    }
}

