/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Security;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.security.auth.DestroyFailedException;

public final class DSAPrivateHWKey
extends PrivateKeyInfo
implements Serializable {
    private boolean hasBeenDestroyed = false;
    private byte[] keyToken;
    private byte[] externalKeyToken = null;
    private DSAKeyHWAttributes attribs = null;
    static final long serialVersionUID = -8860382468882882467L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey";

    public DSAPrivateHWKey(byte[] token, BigInteger p, BigInteger q, BigInteger g, DSAKeyHWAttributes attribs) throws InvalidKeyException {
        if (attribs.getKeyType() == 2) {
            KeyPairUtils util = new KeyPairUtils();
            this.externalKeyToken = (byte[])token.clone();
            this.keyToken = util.importExternalToken(token, KeyPairUtils.KeyPairAlgorithm.DSA);
        } else {
            this.keyToken = (byte[])token.clone();
        }
        this.attribs = new DSAKeyHWAttributes(attribs.getKeyType(), attribs.getKeyUsage());
        this.algid = new AlgIdDSA(p, q, g);
        try {
            DerValue[] value = new DerValue[]{new DerValue(4, token)};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            this.encode();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "DSAPrivateHWKey", e);
            }
            throw new InvalidKeyException("Could not DER encode x: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAPrivateHWKey");
        }
    }

    public DSAPrivateHWKey(byte[] encoded) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAPrivateHWKey", (Object)encoded);
        }
        try {
            this.decode(encoded);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "DSAPrivateHWKey", e);
            }
            throw new InvalidKeyException(e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAPrivateHWKey");
        }
    }

    public DSAParams getParams() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getParams");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getParams", ise);
            }
            throw ise;
        }
        try {
            if (this.algid instanceof DSAParams) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams1", (DSAParams)this.algid);
                }
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algParams = this.algid.getAlgParameters();
            if (algParams == null) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", null);
                }
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", paramSpec);
            }
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getParams", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", null);
            }
            return null;
        }
    }

    public BigInteger getX() throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getX");
            debug.text(Debug.TYPE_PUBLIC, className, "getX", "getX has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getX has no meaning in hardware");
    }

    public byte[] getEncoded() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncoded");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getEncoded", ise);
            }
            throw ise;
        }
        byte[] result = this.getToken();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", result);
        }
        return result;
    }

    public byte[] getToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getToken");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getToken", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getToken", this.keyToken);
        }
        return this.keyToken;
    }

    public byte getType() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getType");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getType", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getType", this.attribs.getKeyType());
        }
        return this.attribs.getKeyType();
    }

    protected void parseKeyBits() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", ise);
            }
            throw ise;
        }
        try {
            DerValue in = new DerValue(this.key);
            this.keyToken = in.getData().getOctetString();
            if (in.getData().available() != 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "parseKeyBits", "Invalid DSAPrivateHWKey encoding, data overrun");
                }
                throw new IOException("Invalid DSAPrivateHWKey encoding, data overrun");
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKetBits", e);
            }
            throw new IOException(e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
    }

    public void deletePKDSEntry() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", ise);
            }
            throw ise;
        }
        if (this.getType() != 0) {
            InvalidKeyException newException = new InvalidKeyException("Error attempting to delete non-PKDS key from PKDS");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", newException);
                debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
            }
            throw newException;
        }
        byte[] pkdsLabel = this.getToken();
        if (pkdsLabel.length > 64) {
            RuntimeException newException = new RuntimeException("Invalid label length for PKDS key object");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", newException);
                debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
            }
            throw newException;
        }
        KeyPairUtils.deletePKDSEntry(pkdsLabel);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "toString");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "toString", ise);
            }
            throw ise;
        }
        HexDumpEncoder encoder = new HexDumpEncoder();
        String hexStringKeyToken = encoder.encodeBuffer(this.keyToken);
        if (Security.getProvider("IBMJCECCA") == null && Security.getProvider("IBMJCE4758") == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, "toString");
            }
            return "IBMJCA4758 DSA Private Key Label:\n" + hexStringKeyToken + "\n";
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "toString");
        }
        return "IBMJCECCA DSA Private Key Label:\n" + hexStringKeyToken + "\n";
    }

    public void destroy() throws DestroyFailedException {
        int idx;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "destroy");
        }
        if (null != this.keyToken) {
            for (idx = 0; idx < this.keyToken.length; ++idx) {
                this.keyToken[idx] = 0;
            }
            this.keyToken = null;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "destroy", "keyToken has been zeroed out and set to null.");
            }
        }
        if (null != this.externalKeyToken) {
            for (idx = 0; idx < this.externalKeyToken.length; ++idx) {
                this.externalKeyToken[idx] = 0;
            }
            this.externalKeyToken = null;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "destroy", "externalKeyToken has been zeroed out and set to null.");
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "destroy");
        }
        this.hasBeenDestroyed = true;
    }

    public boolean isDestroyed() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "destroy", "" + this.hasBeenDestroyed);
        }
        return this.hasBeenDestroyed;
    }
}

