/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameters
extends AlgorithmParametersSpi {
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger g;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DSAParameters";

    public DSAParameters() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DSAParameters");
            debug.exit(Debug.TYPE_FINE, className, "DSAParameters");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", paramSpec);
        }
        if (!(paramSpec instanceof DSAParameterSpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Inappropriate parameter specification");
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DSAParameterSpec)paramSpec).getP();
        this.q = ((DSAParameterSpec)paramSpec).getQ();
        this.g = ((DSAParameterSpec)paramSpec).getG();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        DerValue encoded = new DerValue(params);
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", (Object)params);
        }
        if (encoded.getTag() != 48) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "DSA params parsing error");
            }
            throw new IOException("DSA params parsing error");
        }
        encoded.getData().reset();
        this.p = encoded.getData().getInteger();
        this.q = encoded.getData().getInteger();
        this.g = encoded.getData().getInteger();
        if (encoded.getData().available() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Encoded params have " + encoded.getData().available() + " extra bytes");
            }
            throw new IOException("encoded params have " + encoded.getData().available() + " extra bytes");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] params, String decodingMethod) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{params, decodingMethod};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        this.engineInit(params);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        try {
            Class<?> dsaParamSpec;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", paramSpec);
            }
            if ((dsaParamSpec = Class.forName("java.security.spec.DSAParameterSpec")).isAssignableFrom(paramSpec)) {
                DSAParameterSpec result = new DSAParameterSpec(this.p, this.q, this.g);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", result);
                }
                return result;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", "Inappropriate parameter specification");
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", e);
            }
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetEncoded");
        }
        bytes.putInteger(this.p);
        bytes.putInteger(this.q);
        bytes.putInteger(this.g);
        out.write((byte)48, bytes);
        byte[] result = out.toByteArray();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", result);
        }
        return result;
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodingMethod);
        }
        byte[] result = this.engineGetEncoded();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", result);
        }
        return result;
    }

    @Override
    protected String engineToString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineToString");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineToString", "\n\tp: " + this.p.toString() + "\n\tq: " + this.q.toString() + "\n\tg: " + this.g.toString() + "\n");
        }
        return "\n\tp: " + this.p.toString() + "\n\tq: " + this.q.toString() + "\n\tg: " + this.g.toString() + "\n";
    }
}

