/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import java.security.InvalidParameterException;

public final class DSAKeyHWAttributes
implements KeyHWAttributes {
    byte keyType = 0;
    byte keyUsage = 0;
    static final long serialVersionUID = 8846210499809506552L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes";

    public DSAKeyHWAttributes(byte keyType, byte keyUsage) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "DSAKeyHwAttributes", new Byte(keyType), new Byte(keyUsage));
        }
        if (keyType != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAKeyHwAttributes", "Key Type must be KeyHWAttributeValues.PKDS for DSA keys.");
            }
            throw new InvalidParameterException("Key Type must be KeyHWAttributeValues.PKDS for DSA keys.");
        }
        if (keyUsage != 3) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAKeyHwAttributes", "Key Usage must be KeyHWAttributeValues.SIGNATURE for DSA keys.");
            }
            throw new InvalidParameterException("Key Usage must be KeyHWAttributeValues.SIGNATURE for DSA keys.");
        }
        this.keyType = keyType;
        this.keyUsage = keyUsage;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAKeyHwAttributes");
        }
    }

    @Override
    public byte getKeyType() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeyType");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyType", this.keyType);
        }
        return this.keyType;
    }

    @Override
    public byte getKeyUsage() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeyUsage");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyUsage", this.keyUsage);
        }
        return this.keyUsage;
    }
}

