/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.DSAParameterGenerator;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKeySpec;
import com.ibm.crypto.hdwrCCA.provider.DSAPublicKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAKeyFactory
extends KeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DSAKeyFactory";

    public DSAKeyFactory() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DSAKeyFactory");
            debug.exit(Debug.TYPE_FINE, className, "DSAKeyFactory");
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", keySpec);
        }
        try {
            if (keySpec instanceof DSAPrivateHWKeySpec) {
                DSAPrivateHWKey result = new DSAPrivateHWKey(((DSAPrivateHWKeySpec)keySpec).getLabel(), ((DSAPrivateHWKeySpec)keySpec).getDSAParamSpec().getP(), ((DSAPrivateHWKeySpec)keySpec).getDSAParamSpec().getQ(), ((DSAPrivateHWKeySpec)keySpec).getDSAParamSpec().getG(), ((DSAPrivateHWKeySpec)keySpec).getAttributes());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", result);
                }
                return result;
            }
            if (keySpec instanceof KeyLabelKeySpec) {
                byte[] pkdsLabel = null;
                Object tmp = null;
                int keySize = 512;
                DSAParameterSpec params = new DSAParameterSpec(DSAParameterGenerator.p_512, DSAParameterGenerator.q_512, DSAParameterGenerator.g_512);
                DSAKeyHWAttributes keyAttribs = new DSAKeyHWAttributes(0, 3);
                KeyPairUtils util = new KeyPairUtils();
                SecureRandom random = new SecureRandom();
                pkdsLabel = ((KeyLabelKeySpec)keySpec).getLabelBytes();
                try {
                    util.initializeDSA(keySize, random, keyAttribs, pkdsLabel, params);
                }
                catch (InvalidParameterException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", e);
                    }
                    throw new InvalidKeySpecException("Error in DSA initialization");
                }
                KeyPair result = util.generateKeyPairFromInternalToken(pkdsLabel);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", result.getPrivate());
                }
                return result.getPrivate();
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Hardware error invalid key spec");
            }
            throw new InvalidKeySpecException("Hardware error, Invalid key spec");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", e);
            }
            throw new InvalidKeySpecException("Hardware error, Invalid key spec: " + e);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        block13: {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", keySpec);
            }
            try {
                if (keySpec instanceof DSAPublicKeySpec) {
                    DSAPublicKeySpec publicKeySpec = (DSAPublicKeySpec)keySpec;
                    BigInteger p = publicKeySpec.getP();
                    BigInteger q = publicKeySpec.getQ();
                    BigInteger g = publicKeySpec.getG();
                    BigInteger y = publicKeySpec.getY();
                    try {
                        DSAPublicKey result = new DSAPublicKey(y, p, q, g);
                        if (debug != null) {
                            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic1", result);
                        }
                        return result;
                    }
                    catch (Exception e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", e);
                        }
                        break block13;
                    }
                }
                if (keySpec instanceof X509EncodedKeySpec) {
                    DSAPublicKey result = new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic2", result);
                    }
                    return result;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", "Invalid key spec ");
                }
                throw new InvalidKeySpecException("Invalid key spec");
            }
            catch (InvalidKeyException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", e);
                }
                throw new InvalidKeySpecException("Invalid key spec: " + e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic3", null);
        }
        return null;
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            Object[] parms = new Object[]{key, keySpec};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", parms);
        }
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                Class<?> dsaPubKeySpec = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<?> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (dsaPubKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.DSAPublicKey dsaPubKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams params = dsaPubKey.getParams();
                    DSAPublicKeySpec result = new DSAPublicKeySpec(dsaPubKey.getY(), params.getP(), params.getQ(), params.getG());
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", result);
                    }
                    return result;
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    X509EncodedKeySpec result = new X509EncodedKeySpec(key.getEncoded());
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec ", result);
                    }
                    return result;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key specification");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof DSAPrivateHWKey) {
                Class<?> dsaPrivHWKeySpec = Class.forName("com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKeySpec");
                if (dsaPrivHWKeySpec.isAssignableFrom(keySpec)) {
                    DSAPrivateHWKey dsaPrivHWKey = (DSAPrivateHWKey)((Object)key);
                    DSAParams params = dsaPrivHWKey.getParams();
                    DSAPrivateHWKeySpec result = new DSAPrivateHWKeySpec(dsaPrivHWKey.getToken(), new DSAParameterSpec(dsaPrivHWKey.getParams().getP(), dsaPrivHWKey.getParams().getQ(), dsaPrivHWKey.getParams().getG()), dsaPrivHWKey.getType());
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", result);
                    }
                    return result;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key specification");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Hardware error, inappropriate key specification");
            }
            throw new InvalidKeySpecException("Hardware error, Inappropriate key specification");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
            }
            throw new InvalidKeySpecException("Hardware error, Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
        }
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                if (key instanceof DSAPublicKey) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey1", key);
                    }
                    return key;
                }
                DSAPublicKeySpec dsaPubKeySpec = (DSAPublicKeySpec)this.engineGetKeySpec(key, DSAPublicKeySpec.class);
                PublicKey result = this.engineGeneratePublic(dsaPubKeySpec);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey2", result);
                }
                return result;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey", "hardware error, InvalidKeySpecException wrong algorithm type");
            }
            throw new InvalidKeySpecException("Hardware error, Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", e);
            }
            throw new InvalidKeyException("Hardware error, Cannot translate key: " + e.getMessage());
        }
    }
}

