/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DESKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESedeKeySpec
implements KeySpec {
    public static final int DES_EDE_KEY_LEN = 24;
    private byte[] key;
    private String type;

    public DESedeKeySpec(byte[] key) throws InvalidKeyException {
        this(key, 0, "RAW");
    }

    public DESedeKeySpec(byte[] key, String type) throws InvalidKeyException {
        this(key, 0, type);
    }

    public DESedeKeySpec(byte[] key, int offset) throws InvalidKeyException {
        this(key, offset, "RAW");
    }

    public DESedeKeySpec(byte[] key, int offset, String type) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Missing key");
        }
        if (key.length == 0) {
            throw new InvalidKeyException("Empty key");
        }
        if (!("RAW".equals(type) || "CKDSLabel".equals(type) || "ICSFToken".equals(type))) {
            throw new InvalidKeyException("Invalid type. Must be one of RAW, CKDSLabel, or ICSFToken.");
        }
        this.type = type;
        if ("RAW".equals(this.type)) {
            if (key.length - offset < 24) {
                throw new InvalidKeyException("Wrong key size");
            }
            this.key = new byte[24];
            System.arraycopy(key, offset, this.key, 0, 24);
        } else {
            this.key = new byte[key.length - offset];
            System.arraycopy(key, offset, this.key, 0, key.length - offset);
        }
    }

    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public String getType() {
        return this.type;
    }

    public static boolean isParityAdjusted(byte[] key, int offset) throws InvalidKeyException {
        if (key.length - offset < 24) {
            throw new InvalidKeyException("Wrong key size");
        }
        return DESKeySpec.isParityAdjusted(key, offset) && DESKeySpec.isParityAdjusted(key, offset + 8) && DESKeySpec.isParityAdjusted(key, offset + 16);
    }
}

