/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;

public final class DESKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private boolean genHWkeyToken = false;
    private boolean storeInCKDS = false;
    private String ckdsLabel = null;
    private byte keyTokenWrapMode = (byte)10;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DESKeyGenerator";
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};

    public DESKeyGenerator() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DESKeyGenerator");
        }
        IBMJCECCA.verifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "DESKeyGenerator");
        }
    }

    @Override
    protected void engineInit(SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", random);
        }
        this.random = random;
        this.genHWkeyToken = false;
        this.storeInCKDS = false;
        this.ckdsLabel = null;
        this.keyTokenWrapMode = (byte)10;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        int specSize;
        block35: {
            block37: {
                String labelInfo;
                byte specWrappingMode;
                block39: {
                    block38: {
                        byte keyType;
                        SymmetricKeyConstants.KeyUsage keyUsage;
                        CCAAlgorithmParameterSpec paramSpec;
                        block33: {
                            block36: {
                                block34: {
                                    if (debug != null) {
                                        debug.entry(Debug.TYPE_FINE, className, "engineInit", params, random);
                                    }
                                    if (!(params instanceof CCAAlgorithmParameterSpec)) {
                                        InvalidAlgorithmParameterException iae = new InvalidAlgorithmParameterException("DES key generation parameter spec must be a CCAAlgorithmParameterSpec.");
                                        if (debug != null) {
                                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iae);
                                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                        }
                                        throw iae;
                                    }
                                    paramSpec = (CCAAlgorithmParameterSpec)params;
                                    keyUsage = paramSpec.getKeyUsage();
                                    if (keyUsage == null) {
                                        keyUsage = SymmetricKeyConstants.KeyUsage.OP_DATA;
                                    }
                                    specSize = paramSpec.getKeySize();
                                    specWrappingMode = paramSpec.getTokenWrappingMode();
                                    keyType = paramSpec.getHwType();
                                    if (!paramSpec.isSecureInternalToken()) break block33;
                                    if (keyUsage != SymmetricKeyConstants.KeyUsage.OP_DATA) {
                                        InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Only DATA keys are supported for the specified key algorithm");
                                        if (debug != null) {
                                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                        }
                                        throw iape;
                                    }
                                    this.random = null;
                                    this.genHWkeyToken = true;
                                    this.storeInCKDS = false;
                                    this.ckdsLabel = null;
                                    this.keyTokenWrapMode = specWrappingMode;
                                    if (!(specWrappingMode != 11 && specWrappingMode != 12 || HardwareProfile.getIsEnhancedWrappingPresent())) {
                                        RuntimeException e = new RuntimeException("WRAPPING_MODE_ECB and WRAPPING_MODE_CBC wrapping modes not supported on this combination of ICSF and/or hardware.");
                                        if (null != debug) {
                                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                        }
                                        throw e;
                                    }
                                    if (specWrappingMode != 11) break block34;
                                    if (debug != null) {
                                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN and wrapping mode is ECB. The DES key will be generated as a secret hardware key using the WRAPPING_MODE_ECB token wrapping mode.");
                                    }
                                    break block35;
                                }
                                if (specWrappingMode != 12) break block36;
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN and wrapping mode is CBC. The DES key will be generated as a secret hardware key using the WRAPPING_MODE_CBC token wrapping mode.");
                                }
                                break block35;
                            }
                            if (specWrappingMode == 10) {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN. The DES key will be generated as a secret hardware key using the default token wrapping mode.");
                                }
                                break block35;
                            } else {
                                InvalidParameterException ipe = new InvalidParameterException("Wrapping mode value is not recognized: " + specWrappingMode);
                                if (debug != null) {
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                }
                                throw ipe;
                            }
                        }
                        if (keyType != 0) break block37;
                        if (keyUsage != SymmetricKeyConstants.KeyUsage.OP_DATA) {
                            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Only DATA keys are supported for the specified key algorithm");
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                                debug.exit(Debug.TYPE_FINE, className, "engineInit");
                            }
                            throw iape;
                        }
                        this.random = null;
                        this.genHWkeyToken = true;
                        this.storeInCKDS = true;
                        this.ckdsLabel = paramSpec.getLabel();
                        this.keyTokenWrapMode = specWrappingMode;
                        if (!(specWrappingMode != 11 && specWrappingMode != 12 || HardwareProfile.getIsEnhancedWrappingPresent())) {
                            RuntimeException e = new RuntimeException("WRAPPING_MODE_ECB and WRAPPING_MODE_CBC wrapping modes not supported on this combination of ICSF and/or hardware.");
                            if (null != debug) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                                debug.exit(Debug.TYPE_FINE, className, "engineInit");
                            }
                            throw e;
                        }
                        if (specWrappingMode != 11) break block38;
                        if (debug != null) {
                            labelInfo = "A CKDS label will be generated for the new entry.";
                            if (null != this.ckdsLabel && !"".equals(this.ckdsLabel)) {
                                labelInfo = "The following user-specified CKDS label will be used: " + this.ckdsLabel;
                            }
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. The DES key will be generated as a secret hardware key and stored in the CKDS. The CKDS entry will be wrapped using the WRAPPING_MODE_ECB wrapping mode. " + labelInfo);
                        }
                        break block35;
                    }
                    if (specWrappingMode != 12) break block39;
                    if (debug != null) {
                        labelInfo = "A CKDS label will be generated for the new entry.";
                        if (null != this.ckdsLabel && !"".equals(this.ckdsLabel)) {
                            labelInfo = "The following user-specified CKDS label will be used: " + this.ckdsLabel;
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. The DES key will be generated as a secret hardware key and stored in the CKDS. The CKDS entry will be wrapped using the WRAPPING_MODE_CBC wrapping mode. " + labelInfo);
                    }
                    break block35;
                }
                if (specWrappingMode == 10) {
                    if (debug != null) {
                        labelInfo = "A CKDS label will be generated for the new entry.";
                        if (null != this.ckdsLabel && !"".equals(this.ckdsLabel)) {
                            labelInfo = "The following user-specified CKDS label will be used: " + this.ckdsLabel;
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. The DES key will be generated as a secret hardware key and stored in the CKDS. The CKDS entry will be wrapped using the default wrapping mode. " + labelInfo);
                    }
                    break block35;
                } else {
                    InvalidParameterException ipe = new InvalidParameterException("Wrapping mode value is not recognized: " + specWrappingMode);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw ipe;
                }
            }
            this.random = random;
            this.genHWkeyToken = false;
            this.storeInCKDS = false;
            this.ckdsLabel = null;
            this.keyTokenWrapMode = (byte)10;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CLEAR. The DES key will be generated as a clear key.");
            }
        }
        if (specSize != 0 && specSize != 56) {
            InvalidParameterException ipe = new InvalidParameterException("Wrong keysize: must be equal to 56");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipe;
        }
        if (null != random && this.genHWkeyToken) {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("It is not valid to specify a source of randomness for a secret hardware DES key.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw iape;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", keysize, random);
        }
        if (keysize != 56) {
            InvalidParameterException ipe = new InvalidParameterException("Wrong keysize: must be equal to 56");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipe;
        }
        this.engineInit(random);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected SecretKey engineGenerateKey() {
        DESKey desKey;
        block18: {
            desKey = null;
            byte[] desKeyToken = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, className, "engineGenerateKey");
            }
            if (this.genHWkeyToken) {
                desKeyToken = this.generateHWKeyToken();
                try {
                    desKey = new DESKey("ICSFToken", desKeyToken);
                }
                catch (InvalidKeyException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", e);
                        debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                    }
                    throw new RuntimeException(new String("Key type: ICSFToken    " + e.getMessage()), e);
                }
                if (this.storeInCKDS) {
                    try {
                        String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(desKey, this.ckdsLabel);
                        desKey = DESKey.newLabelKey(actualLabel);
                    }
                    catch (Exception ex) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ex);
                            debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                        }
                        throw new RuntimeException("Error storing key " + this.ckdsLabel + " in the CKDS. " + ex.getMessage(), ex);
                    }
                }
            } else {
                if (this.random == null) {
                    try {
                        this.random = SecureRandom.getInstance("IBMSecureRandom", "IBMJCECCA");
                    }
                    catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", e);
                        }
                        this.random = new SecureRandom();
                    }
                }
                try {
                    byte[] key = new byte[8];
                    do {
                        this.random.nextBytes(key);
                        DESKeyGenerator.setParityBit(key, 0);
                    } while (DESKeySpec.isWeak(key, 0));
                    desKey = new DESKey(key);
                }
                catch (InvalidKeyException e) {
                    if (debug == null) break block18;
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", e);
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateKey", desKey);
        }
        return desKey;
    }

    private byte[] generateHWKeyToken() {
        String kekKeyId2String;
        String kekKeyId1String;
        String exitDataString;
        byte[] genKeyId2;
        byte[] genKeyId1;
        byte[] keyType1;
        HexDumpEncoder encoder = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateHWKeyToken");
            encoder = new HexDumpEncoder();
        }
        HIKM hikm = new HIKM();
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] kekKeyId1 = new byte[64];
        byte[] kekKeyId2 = new byte[64];
        byte[] keyForm = PlatformUtilities.getBytesPlatform("OP  ");
        byte[] keyLength = PlatformUtilities.getBytesPlatform("KEYLN8  ");
        byte[] keyType2 = new byte[8];
        if (this.keyTokenWrapMode != 10) {
            keyType1 = PlatformUtilities.getBytesPlatform("TOKEN   ");
            genKeyId1 = SymmetricKeyUtils.generateSymmetricDESSkeletonToken(56, this.keyTokenWrapMode);
            genKeyId2 = (byte[])genKeyId1.clone();
        } else {
            keyType1 = PlatformUtilities.getBytesPlatform("DATA    ");
            genKeyId1 = new byte[64];
            genKeyId2 = (byte[])genKeyId1.clone();
        }
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            kekKeyId1String = encoder.encodeBuffer(kekKeyId1);
            kekKeyId2String = encoder.encodeBuffer(kekKeyId2);
            String keyFormString = encoder.encodeBuffer(keyForm);
            String keyLengthString = encoder.encodeBuffer(keyLength);
            String keyType1String = encoder.encodeBuffer(keyType1);
            String keyType2String = encoder.encodeBuffer(keyType2);
            String genKeyId1String = encoder.encodeBuffer(genKeyId1);
            String genKeyId2String = encoder.encodeBuffer(genKeyId2);
            String parmsReport = "\nDESKeyGenerator: CSNBKGN INPUT PARAMETERS \n    exitDataLen: " + exitDataLength.getValue() + "\n    exitData   : " + exitDataString + "\n    kekKeyId1  :\n" + kekKeyId1String + "\n    kekKeyId2  :\n" + kekKeyId2String + "\n    keyForm    : " + keyFormString + "\n    keyLength  : " + keyLengthString + "\n    keyType1   : " + keyType1String + "\n    keyType2   : " + keyType2String + "\n    genKeyId1  :\n" + genKeyId1String + "\n    genKeyId2  :\n" + genKeyId2String + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateHWKeyToken", parmsReport);
        }
        try {
            hikm.CSNBKGNJ(returnCode, reasonCode, exitDataLength, exitData, keyForm, keyLength, keyType1, keyType2, kekKeyId1, kekKeyId2, genKeyId1, genKeyId2);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateHWKeyToken", e);
                debug.exit(Debug.TYPE_FINE, className, "generateHWKeyToken");
            }
            throw new RuntimeException("Hardware error from call CSNBKGN " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "generateHWKeyToken", "CSNBKGN: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (debug != null) {
            exitDataString = encoder.encodeBuffer(exitData);
            kekKeyId1String = encoder.encodeBuffer(kekKeyId1);
            kekKeyId2String = encoder.encodeBuffer(kekKeyId2);
            String genKeyId1String = encoder.encodeBuffer(genKeyId1);
            String genKeyId2String = encoder.encodeBuffer(genKeyId2);
            String parmsReport = "\nDESKeyGenerator: CSNBKGN RETURN PARAMETERS: \n    returnCode : " + returnCode.getValue() + "\n    reasonCode : " + reasonCode.getValue() + "\n    exitDataLen: " + exitDataLength.getValue() + "\n    exitData   : " + exitDataString + "\n    kekKeyId1  :\n" + kekKeyId1String + "\n    kekKeyId2  :\n" + kekKeyId2String + "\n    genKeyId1  :\n" + genKeyId1String + "\n    genKeyId2  :\n" + genKeyId2String + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateHWKeyToken", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "generateHWKeyToken", "Hardware error from call CSNBKGN returnCode=" + returnCode.getValue() + " reasonCode=" + reasonCode.getValue());
                debug.exit(Debug.TYPE_FINE, className, "generateHWKeyToken");
            }
            throw new JCECCARuntimeException(1, "CSNBKGN", "Hardware error from call CSNBKGN returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "generateHWKeyToken", genKeyId1);
        }
        return genKeyId1;
    }

    static void setParityBit(byte[] key, int offset) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "setParityBit", key, new Integer(offset));
        }
        if (key == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "setParityBit1");
            }
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int bitCount = 0;
            for (int maskIndex = 0; maskIndex < PARITY_BIT_MASK.length; ++maskIndex) {
                if ((key[i + offset] & PARITY_BIT_MASK[maskIndex]) != PARITY_BIT_MASK[maskIndex]) continue;
                ++bitCount;
            }
            key[i + offset] = bitCount & true ? (byte)(key[i + offset] & 0xFFFFFFFE) : (byte)(key[i + offset] | 1);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "setParityBit");
        }
    }
}

