/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DESConstants;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;

class DESCrypt
extends SymmetricCipher
implements DESConstants {
    protected int[] expandedKey = null;
    byte[] rawKey = null;
    protected boolean decrypting = false;
    private static Debug debug;
    private static String className;
    private static int[] SP0;
    private static int[] SP1;
    private static int[] PC;

    DESCrypt() {
    }

    @Override
    int getBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getBlockSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBlockSize", 8);
        }
        return 8;
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        if (key == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Key missing");
            }
            throw new InvalidKeyException("Key missing");
        }
        if (!key.getAlgorithm().equalsIgnoreCase("DES")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong algorithm: DES required");
            }
            throw new InvalidKeyException("Wrong algorithm: DES required");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong format: RAW bytes needed");
            }
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] rawKey = key.getEncoded();
        if (rawKey == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "RAW bytes missing");
            }
            throw new InvalidKeyException("RAW bytes missing");
        }
        if (rawKey.length != 8) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong key size");
            }
            throw new InvalidKeyException("Wrong key size");
        }
        this.rawKey = new byte[rawKey.length];
        System.arraycopy(rawKey, 0, this.rawKey, 0, rawKey.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        this.init(key);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        this.decrypting = false;
        if (debug != null) {
            Object[] parms = new Object[]{plain, new Integer(plainOffset), new Integer(plainLen), cipher, new Integer(cipherOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "encrypt", parms);
        }
        if (plainLen != 8) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "IBMJCECCA DES: " + plainLen);
            }
            throw new IllegalBlockSizeException("IBMJCECCA DES: " + plainLen);
        }
        this.des(!this.decrypting, plain, plainOffset, cipher, cipherOffset);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
        }
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        this.decrypting = true;
        if (debug != null) {
            Object[] parms = new Object[]{cipher, new Integer(cipherOffset), new Integer(cipherLen), plain, new Integer(plainOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "decrypt", parms);
        }
        if (cipherLen != 8) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "IBMJCECCA DES: " + cipherLen);
            }
            throw new IllegalBlockSizeException("IBMJCECCA DES: " + cipherLen);
        }
        this.des(!this.decrypting, cipher, cipherOffset, plain, plainOffset);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
        }
    }

    private void des(boolean encrypting, byte[] data, int off, byte[] to, int pos) {
        try {
            int[] sp0 = SP0;
            int[] sp1 = SP1;
            int[] k0 = this.expandedKey;
            int K = k0.length;
            int len = 8;
            if (debug != null) {
                Object[] parms = new Object[]{new Boolean(encrypting), data, new Integer(off), to, new Integer(pos)};
                debug.entry(8192L, (Object)className, "des", parms);
            }
            len += off;
            while (off < len) {
                int l = DESCrypt.lsbf(data, off);
                int r = DESCrypt.lsbf(data, off + 4);
                off += 8;
                int k = 32;
                do {
                    int t = (r >>> 4 ^ l) & 0xF0F0F0F;
                    l ^= t;
                    r ^= t << 4;
                    t = (l >>> 16 ^ r) & 0xFFFF;
                    r ^= t;
                    l ^= t << 16;
                    t = (r >>> 2 ^ l) & 0x33333333;
                    l ^= t;
                    r ^= t << 2;
                    t = (l >>> 8 ^ r) & 0xFF00FF;
                    r ^= t;
                    l ^= t << 8;
                    t = (r >>> 1 ^ l) & 0x55555555;
                    int u = (r ^= t << 1) << 1 | r >>> 31;
                    r = (l ^= t) << 1 | l >>> 31;
                    l = u;
                    int i = k - 32;
                    do {
                        u = r ^ k0[i + 1];
                        t = u >>> 4 | u << 28 | 0xC040C040;
                        u = r ^ k0[i] | 0x80008000;
                        l ^= sp0[t & 0x7F] | sp0[t >>> 8 & 0xFF] | sp1[t >>> 16 & 0x7F] | sp1[t >>> 24] | sp0[u & 0x3F] | sp0[u >>> 8 & 0xBF] | sp1[u >>> 16 & 0x3F] | sp1[u >>> 24 & 0xBF];
                        u = l ^ k0[i + 3];
                        t = u >>> 4 | u << 28 | 0xC040C040;
                        u = l ^ k0[i + 2] | 0x80008000;
                        r ^= sp0[t & 0x7F] | sp0[t >>> 8 & 0xFF] | sp1[t >>> 16 & 0x7F] | sp1[t >>> 24] | sp0[u & 0x3F] | sp0[u >>> 8 & 0xBF] | sp1[u >>> 16 & 0x3F] | sp1[u >>> 24 & 0xBF];
                    } while ((i += 4) < k);
                    l = l >>> 1 | l << 31;
                    r = r >>> 1 | r << 31;
                    t = (r >>> 1 ^ l) & 0x55555555;
                    l ^= t;
                    r ^= t << 1;
                    t = (l >>> 8 ^ r) & 0xFF00FF;
                    r ^= t;
                    l ^= t << 8;
                    t = (r >>> 2 ^ l) & 0x33333333;
                    l ^= t;
                    r ^= t << 2;
                    t = (l >>> 16 ^ r) & 0xFFFF;
                    r ^= t;
                    l ^= t << 16;
                    t = (r >>> 4 ^ l) & 0xF0F0F0F;
                    l ^= t;
                    r ^= t << 4;
                } while ((k += 32) <= K);
                if (to == null) continue;
                DESCrypt.lsbf(l, to, pos, 4);
                DESCrypt.lsbf(r, to, pos + 4, 4);
                pos += 8;
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "des", e);
            }
            throw new NullPointerException();
        }
        if (debug != null) {
            debug.exit(8192L, className, "des");
        }
    }

    protected void initDesKey(boolean encrypting) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initDesKey", new Boolean(encrypting));
        }
        this.expandedKey = this.initDes(encrypting);
        boolean bl = this.decrypting = !encrypting;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "initDesKey");
        }
    }

    private int[] initDes(boolean encrypting) {
        int[] pc = PC;
        int len = this.rawKey.length;
        int[] key = new int[len * 4];
        int n = 0;
        boolean e = encrypting;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "initDes", new Boolean(encrypting));
        }
        do {
            int c = DESCrypt.lsbf(this.rawKey, n);
            int d = DESCrypt.lsbf(this.rawKey, n + 4);
            int t = (d >>> 4 ^ c) & 0xF0F0F0F;
            c ^= t;
            d ^= t << 4;
            t = (c << 18 ^ c) & 0xCCCC0000;
            c ^= t ^ t >>> 18;
            t = (d << 18 ^ d) & 0xCCCC0000;
            d ^= t ^ t >>> 18;
            t = (d >>> 1 ^ c) & 0x55555555;
            c ^= t;
            d ^= t << 1;
            t = (c >>> 8 ^ d) & 0xFF00FF;
            d ^= t;
            c ^= t << 8;
            t = (d >>> 1 ^ c) & 0x55555555;
            d ^= t << 1;
            d = d << 16 & 0xFF0000 | d & 0xFF00 | d >> 16 & 0xFF | (c ^= t) >> 4 & 0xF000000;
            c &= 0xFFFFFFF;
            int i = 0;
            do {
                int a = (32508 >> i & 1) == 1 ? 2 : 1;
                c = (c >>> a | c << 28 - a) & 0xFFFFFFF;
                int s = pc[c & 0x3F] | pc[0x40 | c >> 6 & 3 | c >> 7 & 0x3C] | pc[0x80 | c >> 13 & 0xF | c >> 14 & 0x30] | pc[0xC0 | c >> 20 & 1 | c >> 21 & 6 | c >> 22 & 0x38];
                d = (d >>> a | d << 28 - a) & 0xFFFFFFF;
                t = pc[0x100 | d & 0x3F] | pc[0x140 | d >> 7 & 3 | d >> 8 & 0x3C] | pc[0x180 | d >> 15 & 0x3F] | pc[0x1C0 | d >> 21 & 0xF | d >> 22 & 0x30];
                int j = (encrypting ? n : len - n - 8) * 4 + (e ? i : 15 - i) * 2;
                key[j] = t << 16 | s & 0xFFFF;
                s = s >>> 16 | t & 0xFFFF0000;
                key[j + 1] = s << 4 | s >>> 28;
            } while (++i < 16);
            e ^= true;
        } while ((n += 8) < len);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "initDes", key);
        }
        return key;
    }

    private static byte getBits(String s, int pos, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{s.getBytes(), new Integer(pos), new Integer(len)};
            debug.entry(8192L, (Object)className, "getBits", parms);
        }
        int i = pos / 7;
        byte a = (byte)s.charAt(i);
        int j = pos % 7;
        a = (byte)(a & 127 >>> j);
        if ((j = len - (7 - j)) > 0) {
            byte result = (byte)(a << j | (byte)s.charAt(i + 1) >>> 7 - j);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getBits1", result);
            }
            return result;
        }
        if (j < 0) {
            byte result = (byte)(a >>> -j);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getBits1", result);
            }
            return result;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getBits1", a);
        }
        return a;
    }

    public static int lsbf(byte[] data, int i) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "lsbf", data, new Integer(i));
        }
        int result = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | (data[i + 3] & 0xFF) << 24;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "lsbf", result);
        }
        return result;
    }

    public static void lsbf(int v, byte[] data, int i, int n) {
        int j = 0;
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(v), data, new Integer(i), new Integer(n)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "lsbf", parms);
        }
        do {
            data[i + j] = (byte)(v >>> j * 8);
        } while (++j < n);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "lsbf");
        }
    }

    @Override
    public byte[] getIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", null);
        }
        return null;
    }

    static {
        int i;
        debug = Debug.getInstance("ibmjcecca");
        className = "com.ibm.crypto.hdwrCCA.provider.DESCrypt";
        SP0 = new int[256];
        SP1 = new int[256];
        String sp = "@\rs\u0014TY%\u001eK\u000b\"\tRYI95%2YW}\u0003\u0012\u0004A0\u0000\bI$(\u0000Q\u0014\u0002\u0002J\u0004D\u0012 (\u0000@Y\u0010!\u0016\u00020\u0001 \u0011-iC\u0007RX6(o\u007fA$\f\u0000`I\u0011\u0001P\u0005\u0000$4\u0006  \n\n\b(\f\u0000R\f\u0010A\u0004\u0011\u0010a@\u0004XSU\u0016.pe\u0007a@)\u0016K\u001as\u0016=&$Q\u0004V\rJ\u001bj\"gO\u0004\u0005\u0014l\u000emF[#(3\u0010)rEG\rpKc\u000e \u0000&J(mM\u0013\u00146Zd\u0000\u0004F\u001a-\u001d\u001cy&\u001cV\u0010\u000e8aqSI1%r`\u0015M9\u0014S4RFlh";
        String sp1 = "\u0001'%dK''$N\u0018d\t\u0012yGa4i\u0013GH\u0000\u0011K#G\u0016#'&fL\u0000\u0002\u000b\u0016\u001d\u000f\f\u001c\u001f9C\u0014\u0001c-\u0016RXpV\u001cxAG\u0014Z+)\fkRe\u007fP\t\u0018!\u000008\u0000B( \t\u0010\u0010\u0018#\u0010 ,\u0011A\u0002\u0012\t!\u0004\u0018\u0003 )\u0004\u0004\u0005]\u0014T^rFi-\u0002\bpYcltX\u0002k<\u0001R<lIK\u0016L9F\b\r\u001b\u0006_\u0013\u0018S\u001a.D\u0019,+\u00165\u0014\u0016fL\u007f|\u0001D\u0004\u0002H@BIB\b\u0001\n\u0002\u0004)!\u0004\f\u00004`!\u0006\fA\u0011\u0010`\u0012B\u0002\u0005\u0016<l\u0018N\u001ai5\u0014";
        int[] st = SP0;
        while (true) {
            int a = 0;
            int j = 63;
            int r = 0;
            int c = 0;
            long v = 0L;
            int n = 3;
            do {
                i = 0;
                do {
                    if (v == 0L) {
                        c = DESCrypt.getBits(sp, a, 8) & 0xFF;
                        if (c == 0) {
                            a += 8;
                            i += 64;
                            continue;
                        }
                        a += 8;
                        if (c == 255) {
                            r = 2;
                            continue;
                        }
                        v = 0L;
                        int t = 0;
                        do {
                            v <<= 8;
                            v |= (long)(DESCrypt.getBits(sp, a, 8) & 0xFF);
                            a += 8;
                        } while (++t < 8);
                    }
                    if ((v & 1L << j) != 0L) {
                        int n2 = i;
                        st[n2] = st[n2] | c << n * 8;
                    }
                    ++i;
                    if (--j >= 0) continue;
                    j = 63;
                    v = 0L;
                    if (r <= 0) continue;
                    --r;
                    i -= 64;
                } while (i < 256);
            } while (--n >= 0);
            if (st != SP0) break;
            st = SP1;
            sp = sp1;
        }
        PC = new int[512];
        String cd = "\bu\u00011)Y\u001b\u0001(\"N\u0000$`\f\u0002-T@ \u001c\u0003\r\u00118@\u0013U\u0006 6\u000e\u0001$ \u0019@!\u001b\u0001\nI4H\tX\u0002K";
        int n = 0;
        int o = 0;
        int c = 0;
        do {
            byte l;
            if ((l = DESCrypt.getBits(cd, c * 6, 6)) == 32) continue;
            i = 0;
            do {
                if ((1 << n & i) == 0) continue;
                int n3 = o + i;
                PC[n3] = PC[n3] | 1 << l;
            } while (++i < 64);
            if ((n = (n + 1) % 6) != 0) continue;
            o += 64;
        } while (++c < 56);
    }
}

