/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class CipherWithWrappingSpi
extends CipherSpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.CipherWithWrappingSpi";

    @Override
    protected final byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result;
        block6: {
            result = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineWrap", key);
            }
            try {
                byte[] encodedKey = key.getEncoded();
                if (encodedKey == null || encodedKey.length == 0) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Cannot get an encoding of the key to be wrapped");
                    }
                    throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
                }
                result = this.engineDoFinal(encodedKey, 0, encodedKey.length);
            }
            catch (BadPaddingException e) {
                if (debug == null) break block6;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineWrap", result);
        }
        return result;
    }

    @Override
    protected final Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        Key result = null;
        if (debug != null) {
            Object[] parms = new Object[]{wrappedKey, wrappedKeyAlgorithm, new Integer(wrappedKeyType)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineUnwrap", parms);
        }
        try {
            encodedKey = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException ePadding) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ePadding);
            }
            throw new InvalidKeyException();
        }
        catch (IllegalBlockSizeException eBlockSize) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", eBlockSize);
            }
            throw new InvalidKeyException();
        }
        switch (wrappedKeyType) {
            case 3: {
                result = this.constructSecretKey(encodedKey, wrappedKeyAlgorithm);
                break;
            }
            case 2: {
                result = this.constructPrivateKey(encodedKey, wrappedKeyAlgorithm);
                break;
            }
            case 1: {
                result = this.constructPublicKey(encodedKey, wrappedKeyAlgorithm);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineUnwrap", result);
        }
        return result;
    }

    private final PublicKey constructPublicKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey key;
        block13: {
            key = null;
            if (debug != null) {
                Object[] parms = new Object[]{encodedKey, encodedKeyAlgorithm};
                debug.entry(8192L, (Object)className, "constructPublicKey", parms);
            }
            try {
                KeyFactory keyFactory = null;
                keyFactory = Security.getProvider("IBMJCECCA") == null ? KeyFactory.getInstance(encodedKeyAlgorithm, "IBMJCE4758") : KeyFactory.getInstance(encodedKeyAlgorithm, "IBMJCECCA");
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
                key = keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.exception(8192L, className, "constructPublicKey", nsae);
                }
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                    X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
                    key = keyFactory.generatePublic(keySpec);
                }
                catch (NoSuchAlgorithmException nsae2) {
                    if (debug != null) {
                        debug.exception(8192L, className, "constructPublicKey", nsae2);
                    }
                    throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
                }
                catch (InvalidKeySpecException ikse2) {
                    if (debug != null) {
                        debug.exception(8192L, className, "constructPublicKey", ikse2);
                    }
                }
            }
            catch (InvalidKeySpecException ikse) {
                if (debug != null) {
                    debug.exception(8192L, className, "constructPublicKey", ikse);
                }
            }
            catch (NoSuchProviderException nspe) {
                if (debug == null) break block13;
                debug.exception(8192L, className, "constructPublicKey", nspe);
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "constructPublicKey", key);
        }
        return key;
    }

    private final PrivateKey constructPrivateKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey key;
        block13: {
            key = null;
            if (debug != null) {
                Object[] parms = new Object[]{encodedKey, encodedKeyAlgorithm};
                debug.entry(8192L, (Object)className, "constructPrivateKey", parms);
            }
            try {
                KeyFactory keyFactory = null;
                keyFactory = Security.getProvider("IMBJCECCA") == null ? KeyFactory.getInstance(encodedKeyAlgorithm, "IBMJCE4758") : KeyFactory.getInstance(encodedKeyAlgorithm, "IBMJCECCA");
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
                key = keyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.exception(8192L, className, "constructPrivateKey", nsae);
                }
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
                    key = keyFactory.generatePrivate(keySpec);
                }
                catch (NoSuchAlgorithmException nsae2) {
                    if (debug != null) {
                        debug.exception(8192L, className, "constructPrivateKey", nsae2);
                    }
                    throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
                }
                catch (InvalidKeySpecException ikse2) {
                    if (debug != null) {
                        debug.exception(8192L, className, "constructPrivateKey", ikse2);
                    }
                }
            }
            catch (InvalidKeySpecException ikse) {
                if (debug != null) {
                    debug.exception(8192L, className, "constructPrivateKey", ikse);
                }
            }
            catch (NoSuchProviderException nspe) {
                if (debug == null) break block13;
                debug.exception(8192L, className, "constructPrivateKey", nspe);
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "constructPrivateKey", key);
        }
        return key;
    }

    private final SecretKey constructSecretKey(byte[] encodedKey, String encodedKeyAlgorithm) {
        SecretKeySpec secretKey = new SecretKeySpec(encodedKey, encodedKeyAlgorithm);
        if (debug != null) {
            Object[] parms = new Object[]{encodedKey, encodedKeyAlgorithm};
            debug.entry(8192L, (Object)className, "constructSecretKey", parms);
            debug.exit(8192L, (Object)className, "constructSecretKey", secretKey);
        }
        return secretKey;
    }
}

