/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.FeedbackCipher;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

class CipherBlockChainingWithParams
extends SymmetricCipher
implements FeedbackCipher {
    private static final String MODE_NAME = "CBC";
    private byte[] iv = null;
    private byte[] r;
    private byte[] k;
    private SymmetricCipher embeddedCipher;
    private int blockSize = -1;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.CipherBlockChainingWithParams";

    CipherBlockChainingWithParams() {
    }

    @Override
    public String getFeedback() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFeedBack");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFeedBack", MODE_NAME);
        }
        return MODE_NAME;
    }

    void setEmbeddedCipher(SymmetricCipher embeddedCipher) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setEmbeddedCipher", embeddedCipher);
        }
        if (embeddedCipher == null || (this.blockSize = embeddedCipher.getBlockSize()) <= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher", "Incompatible algorithm type and mode");
            }
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = embeddedCipher;
        this.k = new byte[this.blockSize];
        this.r = new byte[this.blockSize];
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher");
        }
    }

    @Override
    int getBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getBlockSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBlockSize", new Integer(this.blockSize));
        }
        return this.blockSize;
    }

    @Override
    public byte[] getIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", this.iv);
        }
        return this.iv;
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        this.embeddedCipher.init(key);
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "init", e);
            }
            random = new SecureRandom();
        }
        this.iv = new byte[this.blockSize];
        random.nextBytes(this.iv);
        System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        if (params != null && params instanceof IvParameterSpec) {
            IvParameterSpec ivSpec = (IvParameterSpec)params;
            this.iv = ivSpec.getIV();
            if (this.iv == null || this.iv.length != 8 && this.iv.length != 16) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length: must be 8 or 16 bytes long");
                }
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 or 16 bytes long");
            }
            System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
            this.embeddedCipher.init(key);
        } else if (params != null && params instanceof RC5ParameterSpec) {
            this.iv = ((RC5ParameterSpec)params).getIV();
            if (this.iv == null || this.iv.length != 8) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length1: must be 8 bytes long");
                }
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 bytes long");
            }
            System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
            this.embeddedCipher.init(key, params);
        } else if (params != null && params instanceof RC2ParameterSpec) {
            this.iv = ((RC2ParameterSpec)params).getIV();
            if (this.iv == null || this.iv.length != 8) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length2: must be 8 bytes long");
                }
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 bytes long");
            }
            System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
            this.embeddedCipher.init(key, params);
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong parameter type: IV, RC5 or RC2 ParameterSpec expected");
            }
            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV, RC5 or RC2 ParameterSpec expected");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    public void reset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "reset");
        }
        System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "reset");
        }
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        int endIndex = plainOffset + plainLen;
        if (debug != null) {
            Object[] parms = new Object[]{plain, new Integer(plainOffset), new Integer(plainLen), cipher, new Integer(cipherOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "encrypt", parms);
        }
        while (plainOffset < endIndex) {
            for (int i = 0; i < this.blockSize; ++i) {
                this.k[i] = (byte)(plain[i + plainOffset] ^ this.r[i]);
            }
            this.embeddedCipher.encrypt(this.k, 0, this.blockSize, cipher, cipherOffset);
            System.arraycopy(cipher, cipherOffset, this.r, 0, this.blockSize);
            plainOffset += this.blockSize;
            cipherOffset += this.blockSize;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
        }
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        byte[] cipherOrig = null;
        int endIndex = cipherOffset + cipherLen;
        if (debug != null) {
            Object[] parms = new Object[]{cipher, new Integer(cipherOffset), new Integer(cipherLen), plain, new Integer(plainOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "decrypt", parms);
        }
        if (cipher == plain && cipherOffset >= plainOffset && cipherOffset - plainOffset < this.blockSize) {
            cipherOrig = (byte[])cipher.clone();
        }
        while (cipherOffset < endIndex) {
            this.embeddedCipher.decrypt(cipher, cipherOffset, this.blockSize, this.k, 0);
            for (int i = 0; i < this.blockSize; ++i) {
                plain[i + plainOffset] = (byte)(this.k[i] ^ this.r[i]);
            }
            if (cipherOrig == null) {
                System.arraycopy(cipher, cipherOffset, this.r, 0, this.blockSize);
            } else {
                System.arraycopy(cipherOrig, cipherOffset, this.r, 0, this.blockSize);
            }
            cipherOffset += this.blockSize;
            plainOffset += this.blockSize;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
        }
    }
}

