/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.jit.crypto.JITFullHardwareDigest;
import java.security.DigestException;
import java.security.MessageDigestSpi;

public abstract class AbstractFullHardwareSHA
extends MessageDigestSpi
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static final String className = "com.ibm.crypto.hdwrCCA.provider.AbstractFullHardwareSHA";
    private final int SHA_LENGTH;
    private final byte[] state;
    private static final int BUFFER_LENGTH = 3840;
    private byte[] buffer;
    private int bufferIndex;
    private long dataLen;
    private JITFullHardwareDigest hardwareDigest;
    protected String alg;
    private static final boolean doJITMethodsForCryptoExist;

    protected AbstractFullHardwareSHA(String algorithm, int sha_length, byte[] init_state) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "AbstractFullHardwareSHA", algorithm, sha_length);
        }
        this.SHA_LENGTH = sha_length;
        this.state = init_state;
        this.alg = algorithm;
        this.hardwareDigest = JITFullHardwareDigest.getDigest((String)algorithm);
        this.init();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "AbstractFullHardwareSHA");
        }
    }

    private void init() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "init");
        }
        this.hardwareDigest.init(this.state);
        this.dataLen = 0L;
        this.buffer = new byte[3840];
        this.bufferIndex = 0;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "init");
        }
    }

    @Override
    protected void engineReset() {
        this.init();
    }

    @Override
    protected int engineGetDigestLength() {
        return this.SHA_LENGTH;
    }

    protected abstract int engineGetDigestBlockSize();

    @Override
    protected synchronized void engineUpdate(byte b) {
        if (this.bufferIndex >= 3840) {
            this.hardwareDigest.update(this.buffer, 3840, 0);
            this.bufferIndex = 0;
        }
        this.buffer[this.bufferIndex++] = b;
        ++this.dataLen;
    }

    @Override
    protected synchronized void engineUpdate(byte[] input, int offset, int len) {
        if (len <= 0) {
            return;
        }
        int inputOffset = offset;
        int bufferNeeded = this.bufferIndex + len;
        int maxBlockSize = this.engineGetDigestBlockSize();
        while (bufferNeeded > 3840) {
            int canProcessLen = 3840;
            int canProcessOffset = 0;
            byte[] canProcessData = this.buffer;
            if (this.bufferIndex == 0) {
                canProcessLen = bufferNeeded / maxBlockSize * maxBlockSize;
                canProcessOffset = inputOffset;
                canProcessData = input;
            } else {
                System.arraycopy(input, inputOffset, this.buffer, this.bufferIndex, 3840 - this.bufferIndex);
            }
            this.hardwareDigest.update(canProcessData, canProcessLen, canProcessOffset);
            bufferNeeded -= canProcessLen;
            inputOffset += canProcessLen - this.bufferIndex;
            this.bufferIndex = 0;
        }
        System.arraycopy(input, inputOffset, this.buffer, this.bufferIndex, bufferNeeded - this.bufferIndex);
        this.bufferIndex = bufferNeeded;
        this.dataLen += (long)len;
    }

    @Override
    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINER, className, "engineDigest");
            debug.text(Debug.TYPE_FINER, className, "engineDigest", "dataLen = " + this.dataLen);
        }
        byte[] result = new byte[this.SHA_LENGTH];
        this.hardwareDigest.digestFinal(this.buffer, this.bufferIndex, 0, this.dataLen);
        this.hardwareDigest.getState(result, 0, this.SHA_LENGTH);
        this.init();
        if (debug != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            String exitDataString = "\n" + encoder.encodeBuffer(result);
            debug.text(Debug.TYPE_FINER, className, "engineDigest", "digest: " + exitDataString);
            debug.exit(Debug.TYPE_FINER, className, "engineDigest");
        }
        return result;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINER, className, "engineDigest");
            debug.text(Debug.TYPE_FINER, className, "engineDigest", "dataLen = " + this.dataLen);
        }
        if (len < this.SHA_LENGTH) {
            String errMsg = "partial digests not returned";
            DigestException de = new DigestException(errMsg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDigest", errMsg);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDigest", de);
                debug.exit(Debug.TYPE_FINE, className, "engineDigest");
            }
            throw de;
        }
        if (buf.length - offset < this.SHA_LENGTH) {
            String errMsg = "insufficient space in the output buffer to store the digest";
            DigestException de = new DigestException(errMsg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDigest", errMsg);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDigest", de);
                debug.exit(Debug.TYPE_FINE, className, "engineDigest");
            }
            throw de;
        }
        this.hardwareDigest.digestFinal(this.buffer, this.bufferIndex, 0, this.dataLen);
        this.hardwareDigest.getState(buf, offset, this.SHA_LENGTH);
        this.init();
        if (debug != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            String exitDataString = "\n" + encoder.encodeBuffer(buf);
            debug.text(Debug.TYPE_FINER, className, "engineDigest", "digest: " + exitDataString);
            debug.exit(Debug.TYPE_FINER, (Object)className, "engineDigest", this.SHA_LENGTH);
        }
        return this.SHA_LENGTH;
    }

    @Override
    public Object clone() {
        AbstractFullHardwareSHA that = null;
        try {
            that = (AbstractFullHardwareSHA)super.clone();
            that.buffer = (byte[])this.buffer.clone();
            that.bufferIndex = this.bufferIndex;
            that.hardwareDigest = JITFullHardwareDigest.getDigest((String)this.alg);
            byte[] state = new byte[this.state.length];
            this.hardwareDigest.getState(state, 0, state.length);
            that.hardwareDigest.init(state);
            return that;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return that;
        }
    }

    public static boolean isSupportedByHardware(String algorithm) {
        return doJITMethodsForCryptoExist && JITFullHardwareDigest.isSupportedByHardware((String)algorithm);
    }

    static {
        boolean exist = false;
        try {
            Class<?> api = Class.forName("com.ibm.jit.crypto.JITFullHardwareDigest");
            exist = api != null;
        }
        catch (Exception ex) {
            exist = false;
        }
        doJITMethodsForCryptoExist = exist;
    }
}

