/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.AESKeySpec;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public final class AESKeyFactory
extends SecretKeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.tools.AESKeyFactory";

    public AESKeyFactory() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "AESKeyFactory");
        }
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBMJCECCA provider may have been tampered.");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "AESKeyFactory");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        AESKey aesKey;
        block12: {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", keySpec);
            }
            aesKey = null;
            if (keySpec == null || !(keySpec instanceof AESKeySpec) && !(keySpec instanceof SecretKeySpec) && !(keySpec instanceof KeyLabelKeySpec)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "Inappropriate key specification");
                    debug.exit(Debug.TYPE_FINE, className, "AESKeyFactory");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            try {
                if (keySpec instanceof SecretKeySpec) {
                    SecretKeySpec skeySpec = (SecretKeySpec)keySpec;
                    byte[] keyBytes = skeySpec.getEncoded();
                    AESKeySpec aesKeySpec = new AESKeySpec(keyBytes);
                    aesKey = new AESKey(aesKeySpec.getKey());
                } else if (keySpec instanceof KeyLabelKeySpec) {
                    String ckdsLabel = ((KeyLabelKeySpec)keySpec).getLabelString();
                    aesKey = AESKey.newLabelKey(ckdsLabel);
                } else if (keySpec instanceof AESKeySpec) {
                    AESKeySpec aesKeySpec = (AESKeySpec)keySpec;
                    aesKey = new AESKey(aesKeySpec.getType(), aesKeySpec.getKey());
                } else {
                    AESKeySpec aesKeySpec = (AESKeySpec)keySpec;
                    aesKey = new AESKey(aesKeySpec.getKey());
                }
            }
            catch (InvalidKeyException e) {
                if (debug == null) break block12;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", aesKey);
        }
        return aesKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", keySpec);
        }
        try {
            if (key != null && key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("AES")) {
                String keyFormat = key.getFormat();
                Class<?> aesKeySpecCCA = Class.forName("com.ibm.crypto.hdwrCCA.provider.AESKeySpec");
                if (keySpec != null && aesKeySpecCCA.isAssignableFrom(keySpec)) {
                    if ("RAW".equalsIgnoreCase(keyFormat) || "ICSFToken".equalsIgnoreCase(keyFormat) || "CKDSLabel".equalsIgnoreCase(keyFormat)) {
                        if (debug != null) {
                            debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
                        }
                        return new AESKeySpec(key.getEncoded(), keyFormat);
                    }
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key format");
                    }
                    throw new InvalidKeySpecException("Inappropriate key format");
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key specification");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", key);
        }
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("AES") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof AESKey) {
                    return key;
                }
                AESKeySpec aesKeySpec = (AESKeySpec)this.engineGetKeySpec(key, (Class)AESKeySpec.class);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", aesKeySpec);
                }
                return this.engineGenerateSecret(aesKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

