/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkHttpRepEvent;
import com.ibm.security.certclient.base.PkHttpReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPollException;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.util.PkString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class PkHttpEventFormatter
extends PkEventFormatter
implements PkConstants {
    private static final String sccsid = "@(#) 83 1.1    src/com/ibm/security/certclient/fmt/PkHttpEventFormatter.java, keycertmanagement, kcm60 7/3/05 23:20:44";

    @Override
    public PkEvent readEvent(Object object, InputStream inputStream, PkReqEvent pkReqEvent) throws PkException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
        String string = bufferedReader.readLine();
        PkAttrs pkAttrs = new PkAttrs();
        int n = string.indexOf(32);
        String string2 = string.substring(0, n);
        string2 = string2.intern();
        pkAttrs.add("http.method", 0, string2);
        if (string2 == "GET" || string2 == "POST") {
            String string3;
            int n2;
            Object object2;
            Object object3;
            String string4;
            int n3 = string.lastIndexOf(32);
            if (n3 == n) {
                string4 = string.substring(n + 1);
            } else {
                string4 = string.substring(n + 1, n3);
                pkAttrs.add("http.version", 0, string.substring(n3 + 1));
            }
            while ((string = bufferedReader.readLine()) != null && !string.equals("")) {
                int n4 = string.indexOf(58);
                object3 = string.substring(0, n4).trim();
                String string5 = string.substring(n4 + 1).trim();
                if (!pkAttrs.has((String)object3)) {
                    pkAttrs.add((String)object3, 0, string5);
                    continue;
                }
                object2 = pkAttrs.getValue((String)object3);
                if (object2 instanceof Set) {
                    ((Set)object2).add(string5);
                    continue;
                }
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.add(string5);
                hashSet.add(object2);
                pkAttrs.get((String)object3).setValue(hashSet);
            }
            if (string2 == "POST") {
                int n5;
                n2 = Integer.parseInt(pkAttrs.getStringIgnoreCase("Content-Length"));
                object2 = new char[n2];
                string3 = string4;
                for (int i = 0; i < n2; i += n5) {
                    n5 = bufferedReader.read((char[])object2, i, n2 - i);
                    if (n5 != -1) continue;
                    throw new PkException(PkNLSConstants.HTTPEVENT_END_OF_INPUT);
                }
                object3 = this.getParams(new String((char[])object2));
            } else {
                n2 = string4.indexOf("?");
                if (n2 == -1) {
                    string3 = string4;
                    object3 = new PkAttrs();
                } else {
                    string3 = string4.substring(0, n2);
                    object3 = this.getParams(string4.substring(n2 + 1));
                }
            }
            pkAttrs.add("http.filename", 0, string3);
            n2 = string3.lastIndexOf(47);
            if (n2 == -1) {
                pkAttrs.add("http.basename", 0, string3);
            } else {
                pkAttrs.add("http.basename", 0, string3.substring(n2 + 1));
            }
            return new PkHttpReqEvent(object, null, pkAttrs, (PkAttrs)object3);
        }
        throw new UnsupportedOperationException(string2);
    }

    private PkAttrs getParams(String string) {
        PkAttrs pkAttrs = new PkAttrs();
        String[] stringArray = PkString.split(string, "&");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = PkString.split(stringArray[i], "=");
            stringArray2[0] = this.removeQuotes(stringArray2[0]);
            stringArray2[1] = this.removeQuotes(stringArray2[1]);
            if (!pkAttrs.has(stringArray2[0])) {
                pkAttrs.add(stringArray2[0], 0, stringArray2[1]);
                continue;
            }
            Object object = pkAttrs.getValue(stringArray2[0]);
            if (object instanceof Set) {
                ((Set)object).add(stringArray2[1]);
                continue;
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(stringArray2[1]);
            hashSet.add(object);
            pkAttrs.get(stringArray2[0]).setValue(hashSet);
        }
        return pkAttrs;
    }

    private String removeQuotes(String string) {
        if ((string = string.replace('+', ' ')).indexOf("%") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("%", n2)) != -1) {
            stringBuffer.append(cArray, n, n2 - n);
            char c = (char)(this.hexToChar(string.charAt(n2 + 1)) * 16);
            c = (char)(c + this.hexToChar(string.charAt(n2 + 2)));
            stringBuffer.append(c);
            n = n2 + 3;
            n2 += 3;
        }
        stringBuffer.append(cArray, n, cArray.length - n);
        return stringBuffer.toString();
    }

    private char hexToChar(char c) {
        switch (c) {
            case '0': {
                return '\u0000';
            }
            case '1': {
                return '\u0001';
            }
            case '2': {
                return '\u0002';
            }
            case '3': {
                return '\u0003';
            }
            case '4': {
                return '\u0004';
            }
            case '5': {
                return '\u0005';
            }
            case '6': {
                return '\u0006';
            }
            case '7': {
                return '\u0007';
            }
            case '8': {
                return '\b';
            }
            case '9': {
                return '\t';
            }
            case 'A': 
            case 'a': {
                return '\n';
            }
            case 'B': 
            case 'b': {
                return '\u000b';
            }
            case 'C': 
            case 'c': {
                return '\f';
            }
            case 'D': 
            case 'd': {
                return '\r';
            }
            case 'E': 
            case 'e': {
                return '\u000e';
            }
            case 'F': 
            case 'f': {
                return '\u000f';
            }
        }
        throw new IllegalArgumentException(PkNLSConstants.HTTPEVENT_BAD_HEX_CHAR + c);
    }

    @Override
    public void writeException(Exception exception, OutputStream outputStream) throws IOException {
        if (exception instanceof PkPollException) {
            this.writeHeader(outputStream, "text/html");
            PrintStream printStream = new PrintStream(outputStream);
            printStream.write("<html><body><h2>Please poll again in ".getBytes("UTF8"));
            int n = ((PkPollException)exception).getTimeToCheckBack();
            printStream.write((n + " seconds</h2></body></html>\n").getBytes("UTF8"));
            printStream.close();
        } else {
            this.writeHeader(outputStream, "text/html");
            PrintStream printStream = new PrintStream(outputStream);
            printStream.write("<html><title>Exception</title><body><pre>".getBytes("UTF8"));
            exception.printStackTrace(printStream);
            printStream.write("</pre></body></html>\n".getBytes("UTF8"));
            printStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHttpRep(PkHttpRepEvent pkHttpRepEvent, OutputStream outputStream) throws IOException {
        this.writeHeader(outputStream, pkHttpRepEvent.getContentType());
        InputStream inputStream = pkHttpRepEvent.getInputStream();
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    private void writeHeader(OutputStream outputStream, String string) throws IOException {
        String string2 = "HTTP/1.0 200 OK\r\nDate: " + new Date() + "\r\nServer: Tivoli PKI 1.0\r\nContent-type: " + string + "\r\n\r\n";
        outputStream.write(string2.getBytes("UTF8"));
    }
}

