/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.base;

import com.ibm.security.certclient.base.PkAttrKind;
import com.ibm.security.certclient.base.PkNLSConstants;
import java.io.Serializable;

public final class PkAttr
implements PkAttrKind,
Serializable,
Cloneable,
Comparable {
    private static final String sccsid = "@(#) 30 1.2    com/tivoli/pki/base/PkAttr.java, PkBase, javapki, 04302002 4/24/02 12:26:33";
    private static final long serialVersionUID = -5643396981708933860L;
    public static final PkAttr NULL = new PkAttr("null", 0, null, true);
    private final String name;
    private int kind;
    private Object value;
    private boolean readOnly;

    public PkAttr(String string) {
        this.name = string;
    }

    public PkAttr(String string, int n, Object object) {
        this.name = string;
        this.kind = n;
        this.value = object;
    }

    public PkAttr(String string, int n, Object object, boolean bl) {
        this.name = string;
        this.kind = n;
        this.value = object;
        this.readOnly = bl;
    }

    public int getKind() {
        return this.kind;
    }

    public boolean isApplied() {
        return (this.kind & 1) != 0;
    }

    public boolean isApproved() {
        return (this.kind & 2) != 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNameOid() {
        for (int i = 0; i < this.name.length(); ++i) {
            if (".0123456789".indexOf(this.name.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    public String getString() {
        return (String)this.value;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void setKind(int n) {
        if (this.readOnly) {
            throw new IllegalStateException(PkNLSConstants.ATTR_READ_ONLY + " " + this);
        }
        this.kind = n;
    }

    public void setApplied(boolean bl) {
        if (this.readOnly) {
            throw new IllegalStateException(PkNLSConstants.ATTR_READ_ONLY + " " + this);
        }
        this.kind |= bl ? 1 : -2;
    }

    public void setApproved(boolean bl) {
        if (this.readOnly) {
            throw new IllegalStateException(PkNLSConstants.ATTR_READ_ONLY + " " + this);
        }
        this.kind |= bl ? 2 : -3;
    }

    public void setValue(Object object) {
        if (this.readOnly) {
            throw new IllegalStateException(PkNLSConstants.ATTR_READ_ONLY + " " + this);
        }
        this.value = object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append(ATTR_NAMES[this.kind]);
        stringBuffer.append(" = ");
        stringBuffer.append(this.value);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode() + this.kind;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof PkAttr)) {
            return false;
        }
        PkAttr pkAttr = (PkAttr)object;
        return this.name.equals(pkAttr.name) && this.kind == pkAttr.kind && this.value.equals(pkAttr.value);
    }

    public int compareTo(PkAttr pkAttr) {
        int n = this.name.compareTo(pkAttr.name);
        if (n != 0) {
            return n;
        }
        n = this.kind - pkAttr.kind;
        if (n != 0) {
            return n;
        }
        if (this.value instanceof Comparable) {
            return ((Comparable)this.value).compareTo(pkAttr.value);
        }
        if (this.value.equals(pkAttr.value)) {
            return 0;
        }
        return this.value.hashCode() - pkAttr.value.hashCode();
    }

    public int compareTo(Object object) {
        return this.compareTo((PkAttr)object);
    }
}

