/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.PkEeTransaction;
import com.ibm.security.certclient.base.PkActiveSource;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.base.PkRevoReqEvent;
import com.ibm.security.certclient.beans.PkEeXMgr;
import com.ibm.security.certclient.beans.PkTcpClient;
import com.ibm.security.certclient.util.JPKI;
import com.ibm.security.certclient.util.PkConnector;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;

public final class PkEeRevokeFactory
extends PkEeFactory {
    private PkEeRevokeFactory() {
        throw new UnsupportedOperationException();
    }

    public static PkEeTransaction newRevoke(String string, String string2, String string3, String string4) throws PkException {
        return new RevokeImpl(string, string2, string3, string4);
    }

    static final class PkEe1
    extends PkActiveSource
    implements PkConstants {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();
        private X509CertImpl cert;
        private String revoPwd;
        private String caDn;
        private int caPort;
        private String reason = null;
        private KeyStore kstore = null;
        private String certAlias;
        private String certPwd;
        private Exception runException = null;
        private boolean runFailed = false;

        protected PkEe1() {
            if (debug != null) {
                debug.text(1L, this.className, "PkEe1", "Begin");
            }
        }

        protected boolean getRunFailed() {
            return this.runFailed;
        }

        protected Exception getRunException() {
            return this.runException;
        }

        protected void setcert(X509CertImpl x509CertImpl) {
            this.cert = x509CertImpl;
        }

        protected void setrevoReason(String string) throws PkException {
            if (string == null || string.length() == 0) {
                throw new PkException(PkNLSConstants.HTTP_INVALID_REVO_REASON);
            }
            this.reason = string;
        }

        protected void setrevoPwd(String string) {
            this.revoPwd = string;
        }

        protected void setCertAlias(String string) throws PkException {
            if (string == null || string.length() == 0) {
                throw new PkException(PkNLSConstants.EE_BAD_OR_MISSING_ALIAS);
            }
            this.certAlias = string;
        }

        protected void setCertPwd(String string) {
            if ((PkEeFactory.keystorePwd == null || PkEeFactory.keystorePwd.length == 0) && string != null && string.length() > 0) {
                PkEeFactory.keystorePwd = string.toCharArray();
            }
            this.certPwd = string;
        }

        protected void setCaDn(String string) {
            this.caDn = string != null ? string : PkEeFactory.caDn;
        }

        protected void setCaPort(int n) {
            this.caPort = n != 0 ? n : PkEeFactory.caPort;
        }

        protected String getCaDn() {
            return this.caDn;
        }

        protected int getCaPort() {
            return this.caPort;
        }

        protected void keyStore(String string, String string2, char[] cArray) throws PkException {
            FileInputStream fileInputStream = null;
            this.kstore = null;
            try {
                this.kstore = KeyStore.getInstance(string, PkEeFactory.provider);
                try {
                    fileInputStream = new FileInputStream(string2);
                    this.kstore.load(fileInputStream, cArray);
                    fileInputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "keyStore", (Throwable)fileNotFoundException);
                    }
                    throw new PkException(fileNotFoundException);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", (Throwable)generalSecurityException);
                }
                throw new PkException(generalSecurityException);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", (Throwable)iOException);
                }
                throw new PkException(iOException);
            }
        }

        private void setCert() throws PkRejectionException {
            try {
                this.cert = (X509CertImpl)this.kstore.getCertificate(this.certAlias);
                if (this.cert == null) {
                    throw new PkRejectionException(PkNLSConstants.EE_MISSING_CERTIFICATE);
                }
            }
            catch (KeyStoreException keyStoreException) {
                throw new PkRejectionException(PkNLSConstants.EE_BAD_OR_MISSING_ALIAS, keyStoreException);
            }
        }

        @Override
        public void run() {
            int n;
            this.runFailed = false;
            this.runException = null;
            if (this.reason.equalsIgnoreCase("unspecified")) {
                n = 0;
            } else if (this.reason.equalsIgnoreCase("key compromise")) {
                n = 1;
            } else if (this.reason.equalsIgnoreCase("ca compromise")) {
                n = 2;
            } else if (this.reason.equalsIgnoreCase("affiliation changed")) {
                n = 3;
            } else if (this.reason.equalsIgnoreCase("superseded")) {
                n = 4;
            } else if (this.reason.equalsIgnoreCase("cessation of operation")) {
                n = 5;
            } else if (this.reason.equalsIgnoreCase("certificate hold")) {
                n = 6;
            } else if (this.reason.equalsIgnoreCase("remove from crl")) {
                n = 8;
            } else {
                n = 0;
                if (debug != null) {
                    debug.text(1L, this.className, "PkEe1.run", "Invalid reason - defaults to unspecified");
                }
            }
            try {
                this.setCert();
            }
            catch (PkRejectionException pkRejectionException) {
                this.runFailed = true;
                this.runException = pkRejectionException;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe1.run", (Throwable)pkRejectionException);
                }
                return;
            }
            Object[] objectArray = new Object[]{this.cert, new Integer(n), null, this.revoPwd};
            JPKI jPKI = new JPKI();
            try {
                this.propagate(new PkRevoReqEvent(this, null, jPKI.revoRequest(objectArray)));
            }
            catch (Exception exception) {
                this.runFailed = true;
                this.runException = exception;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe1.run", (Throwable)exception);
                }
                return;
            }
            if (debug != null) {
                debug.text(1L, this.className, "PkEe1.run", "propagated revoke-request");
            }
        }
    }

    private static final class RevokeImpl
    implements PkEeTransaction {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();
        private PkEe1 ee = new PkEe1();

        RevokeImpl(String string, String string2, String string3, String string4) throws PkException {
            this.ee.keyStore(PkEeFactory.keyStoreType, PkEeFactory.keystoreFilename, PkEeFactory.keystorePwd);
            this.ee.setCertAlias(string);
            this.ee.setCertPwd(string2);
            this.ee.setrevoReason(string3);
            this.ee.setrevoPwd(string4);
            this.ee.setCaDn(PkEeFactory.caDn);
            this.ee.setCaPort(PkEeFactory.caPort);
        }

        @Override
        public void actionRequest() throws PkException {
            this.runRevoke();
        }

        private void runRevoke() throws PkException {
            try {
                String string = this.ee.getCaDn();
                int n = this.ee.getCaPort();
                if (debug != null) {
                    debug.text(1L, this.className, "runRevoke", "EE_CARA_HOST={0}", (Object)string);
                    debug.text(1L, this.className, "runRevoke", "EE_CARA_CMP_PORT={0}", (Object)new Integer(n));
                }
                PkTcpClient pkTcpClient = new PkTcpClient(string, n, PkEeFactory.cmpEvntFmt, 1);
                PkConnector.connect((PkActiveSource)this.ee, new PkPipe[]{new PkEeXMgr(), pkTcpClient}).run();
                if (this.ee.getRunFailed()) {
                    throw this.ee.getRunException();
                }
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "runRevoke()", (Throwable)exception);
                }
                throw new PkException(exception);
            }
        }
    }
}

